/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Summary;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionStats {
    private final String name;
    private final String dimensionSumLabel;
    private final String dimensionCountLabel;
    private final Summary summary;
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.99, 0.999, 0.9999};
    private static final String[] QUANTILE_LABEL = new String[]{"quantile"};
    private static final Logger log = LoggerFactory.getLogger(DimensionStats.class);

    public DimensionStats(String name, long updateDurationInSec) {
        this.name = name;
        this.dimensionSumLabel = name + "_sum";
        this.dimensionCountLabel = name + "_count";
        Summary.Builder summaryBuilder = (Summary.Builder)((Summary.Builder)Summary.build().name(name)).help("-");
        for (int i = 0; i < QUANTILES.length; ++i) {
            summaryBuilder.quantile(QUANTILES[i], 0.01);
        }
        this.summary = summaryBuilder.maxAgeSeconds(updateDurationInSec).create();
        try {
            CollectorRegistry.defaultRegistry.register((Collector)this.summary);
        }
        catch (IllegalArgumentException ie) {
            log.warn("{} is already registred {}", (Object)name, (Object)ie.getMessage());
        }
    }

    public void recordDimensionTimeValue(long latency, TimeUnit unit) {
        this.summary.observe((double)unit.toMillis(latency));
    }

    public double getMeanDimension() {
        double sum = this.getDimensionSum();
        double count = this.getDimensionCount();
        if (!Double.isNaN(sum) && !Double.isNaN(count)) {
            return sum / count;
        }
        return 0.0;
    }

    public double getMedianDimension() {
        return this.getQuantile(QUANTILES[0]);
    }

    public double getDimension75() {
        return this.getQuantile(QUANTILES[1]);
    }

    public double getDimension95() {
        return this.getQuantile(QUANTILES[2]);
    }

    public double getDimension99() {
        return this.getQuantile(QUANTILES[3]);
    }

    public double getDimension999() {
        return this.getQuantile(QUANTILES[4]);
    }

    public double getDimension9999() {
        return this.getQuantile(QUANTILES[5]);
    }

    public double getDimensionSum() {
        return CollectorRegistry.defaultRegistry.getSampleValue(this.dimensionSumLabel);
    }

    public double getDimensionCount() {
        return CollectorRegistry.defaultRegistry.getSampleValue(this.dimensionCountLabel);
    }

    public void reset() {
        this.summary.clear();
    }

    private double getQuantile(double q) {
        return CollectorRegistry.defaultRegistry.getSampleValue(this.name, QUANTILE_LABEL, new String[]{Collector.doubleToGoString((double)q)});
    }
}

