/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import com.google.common.collect.Lists;
import io.prometheus.client.jetty.JettyStatisticsCollector;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.broker.web.JsonMapperProvider;
import org.apache.pulsar.broker.web.PulsarServerConnector;
import org.apache.pulsar.broker.web.ResponseHandlerFilter;
import org.apache.pulsar.broker.web.WebExecutorThreadPool;
import org.apache.pulsar.common.util.SecurityUtility;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebService
implements AutoCloseable {
    private static final String MATCH_ALL = "/*";
    public static final String ATTRIBUTE_PULSAR_NAME = "pulsar";
    public static final String HANDLER_CACHE_CONTROL = "max-age=3600";
    public static final int MAX_CONCURRENT_REQUESTS = 1024;
    private final PulsarService pulsar;
    private final Server server;
    private final List<Handler> handlers = Lists.newArrayList();
    private final WebExecutorThreadPool webServiceExecutor;
    private static final Logger log = LoggerFactory.getLogger(WebService.class);

    public WebService(PulsarService pulsar) throws PulsarServerException {
        Optional tlsPort;
        this.pulsar = pulsar;
        this.webServiceExecutor = new WebExecutorThreadPool(pulsar.getConfiguration().getNumHttpServerThreads(), "pulsar-web");
        this.server = new Server((ThreadPool)this.webServiceExecutor);
        ArrayList<PulsarServerConnector> connectors = new ArrayList<PulsarServerConnector>();
        Optional port = pulsar.getConfiguration().getWebServicePort();
        if (port.isPresent()) {
            PulsarServerConnector connector = new PulsarServerConnector(this.server, 1, 1);
            connector.setPort((Integer)port.get());
            connector.setHost(pulsar.getBindAddress());
            connectors.add(connector);
        }
        if ((tlsPort = pulsar.getConfiguration().getWebServicePortTls()).isPresent()) {
            try {
                SslContextFactory sslCtxFactory = SecurityUtility.createSslContextFactory((boolean)pulsar.getConfiguration().isTlsAllowInsecureConnection(), (String)pulsar.getConfiguration().getTlsTrustCertsFilePath(), (String)pulsar.getConfiguration().getTlsCertificateFilePath(), (String)pulsar.getConfiguration().getTlsKeyFilePath(), (boolean)pulsar.getConfiguration().isTlsRequireTrustedClientCertOnConnect());
                PulsarServerConnector tlsConnector = new PulsarServerConnector(this.server, 1, 1, sslCtxFactory);
                tlsConnector.setPort((Integer)tlsPort.get());
                tlsConnector.setHost(pulsar.getBindAddress());
                connectors.add(tlsConnector);
            }
            catch (GeneralSecurityException e) {
                throw new PulsarServerException((Throwable)e);
            }
        }
        connectors.forEach(c -> c.setAcceptQueueSize(1024 / connectors.size()));
        this.server.setConnectors((Connector[])connectors.toArray(new ServerConnector[connectors.size()]));
    }

    public void addRestResources(String basePath, String javaPackages, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"jersey.config.server.provider.packages", javaPackages});
        config.register(JsonMapperProvider.class);
        config.register(MultiPartFeature.class);
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer(config));
        servletHolder.setAsyncSupported(true);
        this.addServlet(basePath, servletHolder, requiresAuthentication, attributeMap);
    }

    public void addServlet(String path, ServletHolder servletHolder, boolean requiresAuthentication, Map<String, Object> attributeMap) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(path);
        context.addServlet(servletHolder, MATCH_ALL);
        if (attributeMap != null) {
            attributeMap.forEach((key, value) -> context.setAttribute(key, value));
        }
        if (requiresAuthentication && this.pulsar.getConfiguration().isAuthenticationEnabled()) {
            FilterHolder filter = new FilterHolder((Filter)new AuthenticationFilter(this.pulsar.getBrokerService().getAuthenticationService()));
            context.addFilter(filter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        }
        FilterHolder responseFilter = new FilterHolder((Filter)new ResponseHandlerFilter(this.pulsar));
        context.addFilter(responseFilter, MATCH_ALL, EnumSet.allOf(DispatcherType.class));
        this.handlers.add((Handler)context);
    }

    public void addStaticResources(String basePath, String resourcePath) {
        ContextHandler capHandler = new ContextHandler();
        capHandler.setContextPath(basePath);
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setBaseResource(Resource.newClassPathResource((String)resourcePath));
        resHandler.setEtags(true);
        resHandler.setCacheControl(HANDLER_CACHE_CONTROL);
        capHandler.setHandler((Handler)resHandler);
        this.handlers.add((Handler)capHandler);
    }

    public void start() throws PulsarServerException {
        try {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            Slf4jRequestLog requestLog = new Slf4jRequestLog();
            requestLog.setExtended(true);
            requestLog.setLogTimeZone(TimeZone.getDefault().getID());
            requestLog.setLogLatency(true);
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            this.handlers.add(0, (Handler)new ContextHandlerCollection());
            this.handlers.add((Handler)requestLogHandler);
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            contexts.setHandlers(this.handlers.toArray(new Handler[this.handlers.size()]));
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler((Handler)handlerCollection);
            try {
                new JettyStatisticsCollector(stats).register();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.handlers.add((Handler)stats);
            this.server.setHandler((Handler)stats);
            this.server.start();
            log.info("Web Service started at {}", (Object)this.pulsar.getWebServiceAddress());
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public void close() throws PulsarServerException {
        try {
            this.server.stop();
            this.webServiceExecutor.join();
            log.info("Web service closed");
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }
}

