/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.api.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final PulsarService pulsar;
    private final SslContext sslCtx;

    public PulsarChannelInitializer(PulsarService pulsar, boolean enableTLS) throws Exception {
        this.pulsar = pulsar;
        if (enableTLS) {
            ServiceConfiguration serviceConfig = pulsar.getConfiguration();
            this.sslCtx = SecurityUtility.createNettySslContextForServer((boolean)serviceConfig.isTlsAllowInsecureConnection(), (String)serviceConfig.getTlsTrustCertsFilePath(), (String)serviceConfig.getTlsCertificateFilePath(), (String)serviceConfig.getTlsKeyFilePath(), (Set)serviceConfig.getTlsCiphers(), (Set)serviceConfig.getTlsProtocols(), (boolean)serviceConfig.isTlsRequireTrustedClientCertOnConnect());
        } else {
            this.sslCtx = null;
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslCtx != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerCnx(this.pulsar));
    }
}

