/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.validation.constraints.NotNull;
import org.apache.pulsar.broker.service.schema.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.SchemaStorage;
import org.apache.pulsar.broker.service.schema.proto.SchemaRegistryFormat;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.schema.SchemaVersion;
import org.apache.pulsar.common.util.FutureUtil;

public class SchemaRegistryServiceImpl
implements SchemaRegistryService {
    private static HashFunction hashFunction = Hashing.sha256();
    private final Map<SchemaType, SchemaCompatibilityCheck> compatibilityChecks;
    private final SchemaStorage schemaStorage;
    private final Clock clock;

    @VisibleForTesting
    SchemaRegistryServiceImpl(SchemaStorage schemaStorage, Map<SchemaType, SchemaCompatibilityCheck> compatibilityChecks, Clock clock) {
        this.schemaStorage = schemaStorage;
        this.compatibilityChecks = compatibilityChecks;
        this.clock = clock;
    }

    @VisibleForTesting
    SchemaRegistryServiceImpl(SchemaStorage schemaStorage, Map<SchemaType, SchemaCompatibilityCheck> compatibilityChecks) {
        this(schemaStorage, compatibilityChecks, Clock.systemUTC());
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchema(String schemaId) {
        return this.getSchema(schemaId, SchemaVersion.Latest);
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchema(String schemaId, SchemaVersion version) {
        return this.schemaStorage.get(schemaId, version).thenCompose(stored -> {
            if (Objects.isNull(stored)) {
                return CompletableFuture.completedFuture(null);
            }
            return ((CompletableFuture)Functions.bytesToSchemaInfo(stored.data).thenApply(Functions::schemaInfoToSchema)).thenApply(schema -> new SchemaRegistry.SchemaAndMetadata(schemaId, (SchemaData)schema, stored.version));
        });
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaVersion> putSchemaIfAbsent(String schemaId, SchemaData schema, SchemaCompatibilityStrategy strategy) {
        return ((CompletableFuture)this.getSchema(schemaId).thenApply(existingSchema -> existingSchema == null || existingSchema.schema.isDeleted() || this.isCompatible((SchemaRegistry.SchemaAndMetadata)existingSchema, schema, strategy))).thenCompose(isCompatible -> {
            if (isCompatible.booleanValue()) {
                byte[] context = hashFunction.hashBytes(schema.getData()).asBytes();
                SchemaRegistryFormat.SchemaInfo info = SchemaRegistryFormat.SchemaInfo.newBuilder().setType(Functions.convertFromDomainType(schema.getType())).setSchema(ByteString.copyFrom((byte[])schema.getData())).setSchemaId(schemaId).setUser(schema.getUser()).setDeleted(false).setTimestamp(this.clock.millis()).addAllProps(Functions.toPairs(schema.getProps())).build();
                return this.schemaStorage.put(schemaId, info.toByteArray(), context);
            }
            return FutureUtil.failedFuture((Throwable)new IncompatibleSchemaException());
        });
    }

    @Override
    @NotNull
    public CompletableFuture<SchemaVersion> deleteSchema(String schemaId, String user) {
        byte[] deletedEntry = this.deleted(schemaId, user).toByteArray();
        return this.schemaStorage.put(schemaId, deletedEntry, new byte[0]);
    }

    @Override
    public CompletableFuture<Boolean> isCompatibleWithLatestVersion(String schemaId, SchemaData schema, SchemaCompatibilityStrategy strategy) {
        return this.checkCompatibilityWithLatest(schemaId, schema, strategy);
    }

    @Override
    public SchemaVersion versionFromBytes(byte[] version) {
        return this.schemaStorage.versionFromBytes(version);
    }

    @Override
    public void close() throws Exception {
        this.schemaStorage.close();
    }

    private SchemaRegistryFormat.SchemaInfo deleted(String schemaId, String user) {
        return SchemaRegistryFormat.SchemaInfo.newBuilder().setSchemaId(schemaId).setType(SchemaRegistryFormat.SchemaInfo.SchemaType.NONE).setSchema(ByteString.EMPTY).setUser(user).setDeleted(true).setTimestamp(this.clock.millis()).build();
    }

    private boolean isCompatible(SchemaRegistry.SchemaAndMetadata existingSchema, SchemaData newSchema, SchemaCompatibilityStrategy strategy) {
        HashCode existingHash = hashFunction.hashBytes(existingSchema.schema.getData());
        HashCode newHash = hashFunction.hashBytes(newSchema.getData());
        return newHash.equals((Object)existingHash) || this.compatibilityChecks.getOrDefault(newSchema.getType(), SchemaCompatibilityCheck.DEFAULT).isCompatible(existingSchema.schema, newSchema, strategy);
    }

    private CompletableFuture<Boolean> checkCompatibilityWithLatest(String schemaId, SchemaData schema, SchemaCompatibilityStrategy strategy) {
        return this.getSchema(schemaId).thenApply(existingSchema -> existingSchema != null && !existingSchema.schema.isDeleted() && this.isCompatible((SchemaRegistry.SchemaAndMetadata)existingSchema, schema, strategy));
    }

    static interface Functions {
        public static SchemaType convertToDomainType(SchemaRegistryFormat.SchemaInfo.SchemaType type) {
            if (type.getNumber() < 0) {
                return SchemaType.NONE;
            }
            return SchemaType.valueOf((int)(type.getNumber() - 1));
        }

        public static SchemaRegistryFormat.SchemaInfo.SchemaType convertFromDomainType(SchemaType type) {
            if (type.getValue() < 0) {
                return SchemaRegistryFormat.SchemaInfo.SchemaType.NONE;
            }
            return SchemaRegistryFormat.SchemaInfo.SchemaType.valueOf(type.getValue() + 1);
        }

        public static Map<String, String> toMap(List<SchemaRegistryFormat.SchemaInfo.KeyValuePair> pairs) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (SchemaRegistryFormat.SchemaInfo.KeyValuePair pair : pairs) {
                map.put(pair.getKey(), pair.getValue());
            }
            return map;
        }

        public static List<SchemaRegistryFormat.SchemaInfo.KeyValuePair> toPairs(Map<String, String> map) {
            if (Objects.isNull(map)) {
                return Collections.emptyList();
            }
            ArrayList<SchemaRegistryFormat.SchemaInfo.KeyValuePair> pairs = new ArrayList<SchemaRegistryFormat.SchemaInfo.KeyValuePair>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                SchemaRegistryFormat.SchemaInfo.KeyValuePair.Builder builder = SchemaRegistryFormat.SchemaInfo.KeyValuePair.newBuilder();
                pairs.add(builder.setKey(entry.getKey()).setValue(entry.getValue()).build());
            }
            return pairs;
        }

        public static SchemaData schemaInfoToSchema(SchemaRegistryFormat.SchemaInfo info) {
            return SchemaData.builder().user(info.getUser()).type(Functions.convertToDomainType(info.getType())).data(info.getSchema().toByteArray()).isDeleted(info.getDeleted()).props(Functions.toMap(info.getPropsList())).build();
        }

        public static CompletableFuture<SchemaRegistryFormat.SchemaInfo> bytesToSchemaInfo(byte[] bytes) {
            CompletableFuture<SchemaRegistryFormat.SchemaInfo> future;
            try {
                future = CompletableFuture.completedFuture(SchemaRegistryFormat.SchemaInfo.parseFrom(bytes));
            }
            catch (InvalidProtocolBufferException e) {
                future = new CompletableFuture();
                future.completeExceptionally(e);
            }
            return future;
        }
    }
}

