/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.JCommander;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandaloneStarter
extends PulsarStandalone {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandaloneStarter.class);

    public PulsarStandaloneStarter(String[] args) throws Exception {
        JCommander jcommander = new JCommander();
        try {
            jcommander.addObject((Object)this);
            jcommander.parse(args);
            if (this.isHelp() || StringUtils.isBlank((CharSequence)this.getConfigFile())) {
                jcommander.usage();
                return;
            }
            if (this.isNoBroker() && this.isOnlyBroker()) {
                log.error("Only one option is allowed between '--no-broker' and '--only-broker'");
                jcommander.usage();
                return;
            }
        }
        catch (Exception e) {
            jcommander.usage();
            return;
        }
        this.config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)new FileInputStream(this.getConfigFile()), ServiceConfiguration.class);
        String zkServers = "127.0.0.1";
        if (this.getAdvertisedAddress() != null) {
            this.config.setAdvertisedAddress(this.getAdvertisedAddress());
            zkServers = this.getAdvertisedAddress();
        } else if (StringUtils.isBlank((CharSequence)this.config.getAdvertisedAddress())) {
            this.config.setAdvertisedAddress(ServiceConfigurationUtils.unsafeLocalhostResolve());
        }
        this.config.setZookeeperServers(zkServers + ":" + this.getZkPort());
        this.config.setConfigurationStoreServers(zkServers + ":" + this.getZkPort());
        this.config.setRunningStandalone(true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (PulsarStandaloneStarter.this.fnWorkerService != null) {
                        PulsarStandaloneStarter.this.fnWorkerService.stop();
                    }
                    if (PulsarStandaloneStarter.this.broker != null) {
                        PulsarStandaloneStarter.this.broker.close();
                    }
                    if (PulsarStandaloneStarter.this.bkEnsemble != null) {
                        PulsarStandaloneStarter.this.bkEnsemble.stop();
                    }
                }
                catch (Exception e) {
                    log.error("Shutdown failed: {}", (Object)e.getMessage());
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        PulsarStandaloneStarter standalone = new PulsarStandaloneStarter(args);
        standalone.start();
    }
}

