/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.SourceImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class SourceBase
extends AdminResource
implements Supplier<WorkerService> {
    private final SourceImpl source = new SourceImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Source in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function already exists, etc.)"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="Pulsar Function successfully created")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    @Consumes(value={"multipart/form-data"})
    public void registerSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sourceConfig") String sourceConfigJson) {
        this.source.registerFunction(tenant, namespace, sourceName, uploadedInputStream, fileDetail, functionPkgUrl, null, sourceConfigJson, this.clientAppId());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Source currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function doesn't exist, etc.)"), @ApiResponse(code=200, message="Pulsar Function successfully updated")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    @Consumes(value={"multipart/form-data"})
    public void updateSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sourceConfig") String sourceConfigJson) {
        this.source.updateFunction(tenant, namespace, sourceName, uploadedInputStream, fileDetail, functionPkgUrl, null, sourceConfigJson, this.clientAppId());
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Source currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function doesn't exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="The function was successfully deleted")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    public void deregisterSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) {
        this.source.deregisterFunction(tenant, namespace, sourceName, this.clientAppId());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Source currently running in cluster mode", response=SourceConfig.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    public SourceConfig getSourceInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) throws IOException {
        return this.source.getSourceInfo(tenant, namespace, sourceName);
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Source instance", response=SourceStatus.SourceInstanceStatus.SourceInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The source doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/status")
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.source.getSourceInstanceStatus(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Source running in cluster mode", response=SourceStatus.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The source doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sourceName}/status")
    public SourceStatus getSourceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) throws IOException {
        return this.source.getSourceStatus(tenant, namespace, sourceName, this.uri.getRequestUri());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Sources currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}")
    public List<String> listSources(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.source.listFunctions(tenant, namespace);
    }

    @POST
    @ApiOperation(value="Restart source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @PathParam(value="instanceId") String instanceId) {
        this.source.restartFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Restart all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/restart")
    @Consumes(value={"application/json"})
    public void restartSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) {
        this.source.restartFunctionInstances(tenant, namespace, sourceName);
    }

    @POST
    @ApiOperation(value="Stop source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @PathParam(value="instanceId") String instanceId) {
        this.source.stopFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Stop all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/stop")
    @Consumes(value={"application/json"})
    public void stopSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) {
        this.source.stopFunctionInstances(tenant, namespace, sourceName);
    }

    @POST
    @ApiOperation(value="Start source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName, @PathParam(value="instanceId") String instanceId) {
        this.source.startFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Start all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/start")
    @Consumes(value={"application/json"})
    public void startSource(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sourceName") String sourceName) {
        this.source.startFunctionInstances(tenant, namespace, sourceName);
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO source connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/builtinsources")
    public List<ConnectorDefinition> getSourceList() {
        List connectorDefinitions = this.source.getListOfConnectors();
        ArrayList<ConnectorDefinition> retval = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((String)connectorDefinition.getSourceClass())) continue;
            retval.add(connectorDefinition);
        }
        return retval;
    }
}

