/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.pulsar.broker.service.schema.AlwaysSchemaValidator;
import org.apache.pulsar.broker.service.schema.NeverSchemaValidator;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaCompatibilityCheck.class);

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.AVRO;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        Schema.Parser fromParser = new Schema.Parser();
        Schema fromSchema = fromParser.parse(new String(from.getData()));
        Schema.Parser toParser = new Schema.Parser();
        Schema toSchema = toParser.parse(new String(to.getData()));
        SchemaValidator schemaValidator = AvroSchemaCompatibilityCheck.createSchemaValidator(strategy, true);
        try {
            schemaValidator.validate(toSchema, Arrays.asList(fromSchema));
        }
        catch (SchemaValidationException e) {
            return false;
        }
        return true;
    }

    private static SchemaValidator createSchemaValidator(SchemaCompatibilityStrategy compatibilityStrategy, boolean onlyLatestValidator) {
        SchemaValidatorBuilder validatorBuilder = new SchemaValidatorBuilder();
        switch (compatibilityStrategy) {
            case BACKWARD: {
                return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canReadStrategy(), onlyLatestValidator);
            }
            case FORWARD: {
                return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.canBeReadStrategy(), onlyLatestValidator);
            }
            case FULL: {
                return AvroSchemaCompatibilityCheck.createLatestOrAllValidator(validatorBuilder.mutualReadStrategy(), onlyLatestValidator);
            }
            case ALWAYS_COMPATIBLE: {
                return AlwaysSchemaValidator.INSTANCE;
            }
        }
        return NeverSchemaValidator.INSTANCE;
    }

    private static SchemaValidator createLatestOrAllValidator(SchemaValidatorBuilder validatorBuilder, boolean onlyLatest) {
        return onlyLatest ? validatorBuilder.validateLatest() : validatorBuilder.validateAll();
    }
}

