/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;

public enum SchemaCompatibilityStrategy {
    ALWAYS_INCOMPATIBLE,
    ALWAYS_COMPATIBLE,
    BACKWARD,
    FORWARD,
    FULL;


    public static SchemaCompatibilityStrategy fromAutoUpdatePolicy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        if (strategy == null) {
            return ALWAYS_INCOMPATIBLE;
        }
        switch (strategy) {
            case Backward: {
                return BACKWARD;
            }
            case Forward: {
                return FORWARD;
            }
            case Full: {
                return FULL;
            }
            case AlwaysCompatible: {
                return ALWAYS_COMPATIBLE;
            }
        }
        return ALWAYS_INCOMPATIBLE;
    }
}

