/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.common.stats.Metrics;

public class NamespaceStats {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public double storageSize;
    public double msgBacklog;
    public double msgReplBacklog;
    public double maxMsgReplDelayInSeconds;
    public int consumerCount;
    public int producerCount;
    public int replicatorCount;
    public int subsCount;

    public NamespaceStats() {
        this.reset();
    }

    public void reset() {
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.storageSize = 0.0;
        this.msgBacklog = 0.0;
        this.msgReplBacklog = 0.0;
        this.maxMsgReplDelayInSeconds = 0.0;
        this.consumerCount = 0;
        this.producerCount = 0;
        this.replicatorCount = 0;
        this.subsCount = 0;
    }

    public Metrics add(String namespace) {
        HashMap dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        Metrics dMetrics = Metrics.create((Map)dimensionMap);
        dMetrics.put("brk_in_rate", (Object)this.msgRateIn);
        dMetrics.put("brk_in_tp_rate", (Object)this.msgThroughputIn);
        dMetrics.put("brk_out_rate", (Object)this.msgRateOut);
        dMetrics.put("brk_out_tp_rate", (Object)this.msgThroughputOut);
        dMetrics.put("brk_storage_size", (Object)this.storageSize);
        dMetrics.put("brk_no_of_producers", (Object)this.producerCount);
        dMetrics.put("brk_no_of_subscriptions", (Object)this.subsCount);
        dMetrics.put("brk_no_of_replicators", (Object)this.replicatorCount);
        dMetrics.put("brk_no_of_consumers", (Object)this.consumerCount);
        dMetrics.put("brk_msg_backlog", (Object)this.msgBacklog);
        dMetrics.put("brk_replication_backlog", (Object)this.msgReplBacklog);
        dMetrics.put("brk_max_replication_delay_second", (Object)this.maxMsgReplDelayInSeconds);
        return dMetrics;
    }
}

