/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdUtility {
    private static final Logger LOG = LoggerFactory.getLogger(CmdUtility.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static int exec(Writer writer, String ... command) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (String str : command) {
                sb.append(str).append(' ');
            }
            LOG.debug("command={}", (Object)sb);
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process proc = null;
        BufferedReader reader = null;
        try {
            proc = pb.start();
            reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (writer == null) continue;
                writer.write(line);
                writer.write(10);
            }
            LOG.debug("sending the command to the host");
            int exitValue = proc.waitFor();
            if (LOG.isDebugEnabled()) {
                LOG.debug("command exit value={}", (Object)exitValue);
            }
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (proc != null) {
                proc.destroy();
            }
        }
    }
}

