/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionState;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.FunctionStatus;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.FunctionsImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class FunctionsBase
extends AdminResource
implements Supplier<WorkerService> {
    private final FunctionsImpl functions = new FunctionsImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Function in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function already exists, etc.)"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="Pulsar Function successfully created")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public void registerFunction(@ApiParam(value="The functions tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The functions namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The functions name") @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @ApiParam(value="A JSON value presenting functions configuration payload. An example of the expected functions can be found here.  \nautoAck  \n  Whether or not the framework will automatically acknowledge messages.  \nruntime  \n  What is the runtime of the function. Possible Values: [JAVA, PYTHON, GO]  \nresources  \n  The size of the system resources allowed by the function runtime. The resources include: cpu, ram, disk.  \nclassName  \n  The class name of functions.  \ncustomSchemaInputs  \n  The map of input topics to Schema class names (specified as a JSON object).  \ncustomSerdeInputs  \n  The map of input topics to SerDe class names (specified as a JSON object).  \ndeadLetterTopic  \n  Messages that are not processed successfully are sent to `deadLetterTopic`.  \nruntimeFlags  \n  Any flags that you want to pass to the runtime. Note that in thread mode, these flags have no impact.  \nfqfn  \n  The Fully Qualified Function Name (FQFN) for the function.  \ninputSpecs  \n   The map of input topics to its consumer configuration, each configuration has schema of    {\"schemaType\": \"type-x\", \"serdeClassName\": \"name-x\", \"isRegexPattern\": true, \"receiverQueueSize\": 5}  \ninputs  \n  The input topic or topics (multiple topics can be specified as a comma-separated list) of functions.  \njar  \n  Path to the JAR file for the function (if the function is written in Java).   It also supports URL path [http/https/file (file protocol assumes that file   already exists on worker host)] from which worker can download the package.  \npy  \n  Path to the main Python file/Python Wheel file for the function (if the function is written in Python).  \ngo  \n  Path to the main Go executable binary for the function (if the function is written in Go).  \nlogTopic  \n  The topic to which the functions logs are produced.  \nmaxMessageRetries  \n  How many times should we try to process a message before giving up.  \noutput  \n  The functions output topic (If none is specified, no output is written).  \noutputSerdeClassName  \n  The SerDe class to be used for messages output by the function.  \nparallelism  \n  The functions parallelism factor (i.e. the number of function instances to run).  \nprocessingGuarantees  \n  The processing guarantees (that is, delivery semantics) applied to the function.  Possible Values: [ATLEAST_ONCE, ATMOST_ONCE, EFFECTIVELY_ONCE]  \nretainOrdering  \n  Function consumes and processes messages in order.  \noutputSchemaType  \n   Represents either a builtin schema type (for example: 'avro', 'json', ect) or the class name for a Schema implementation.subName  \n  Pulsar source subscription name. User can specify a subscription-name for the input-topic consumer.  \nwindowConfig  \n  The window functions configuration.  \ntimeoutMs  \n  The message timeout in milliseconds.  \ntopicsPattern  \n  The topic pattern to consume from a list of topics under a namespace that match the pattern.  [input] and [topic-pattern] are mutually exclusive. Add SerDe class name for a   pattern in customSerdeInputs (supported for java fun only)  \nuserConfig  \n  A map of user-defined configurations (specified as a JSON object).  \nsecrets  \n  This is a map of secretName(that is how the secret is going to be accessed in the function via context) to an object that  encapsulates how the secret is fetched by the underlying secrets provider. The type of an value here can be found by the  SecretProviderConfigurator.getSecretObjectType() method. \ncleanupSubscription  \n  Whether the subscriptions the functions created/used should be deleted when the functions are deleted.  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"inputs\": persistent://public/default/input-topic,\n  \"parallelism\": 4\n  \"output\": persistent://public/default/output-topic\n  \"log-topic\": persistent://public/default/log-topic\n  \"classname\": org.example.test.ExclamationFunction\n  \"jar\": java-function-1.0-SNAPSHOT.jar\n}\n")})) @FormDataParam(value="functionConfig") String functionConfigJson) {
        this.functions.registerFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfigJson, this.clientAppId(), this.clientAuthData());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (function doesn't exist, etc.)"), @ApiResponse(code=200, message="Pulsar Function successfully updated")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    @Consumes(value={"multipart/form-data"})
    public void updateFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @ApiParam(value="A JSON value presenting a functions config playload. An example of the expected functions can be found down here.  \nautoAck  \n  Whether or not the framework will automatically acknowledge messages.  \nruntime  \n  What is the runtime of the function. Possible Values: [JAVA, PYTHON, GO]  \nresources  \n  The size of the system resources allowed by the function runtime. The resources include: cpu, ram, disk.  \nclassName  \n  The class name of functions.  \ncustomSchemaInputs  \n  The map of input topics to Schema class names (specified as a JSON object).  \ncustomSerdeInputs  \n  The map of input topics to SerDe class names (specified as a JSON object).  \ndeadLetterTopic  \n  Messages that are not processed successfully are sent to `deadLetterTopic`.  \nruntimeFlags  \n  Any flags that you want to pass to the runtime. Note that in thread mode, these flags have no impact.  \nfqfn  \n  The Fully Qualified Function Name (FQFN) for the function.  \ninputSpecs  \n   The map of input topics to its consumer configuration, each configuration has schema of    {\"schemaType\": \"type-x\", \"serdeClassName\": \"name-x\", \"isRegexPattern\": true, \"receiverQueueSize\": 5}  \ninputs  \n  The input topic or topics (multiple topics can be specified as a comma-separated list) of functions.  \njar  \n  Path to the JAR file for the function (if the function is written in Java).   It also supports URL path [http/https/file (file protocol assumes that file   already exists on worker host)] from which worker can download the package.  \npy  \n  Path to the main Python file/Python Wheel file for the function (if the function is written in Python).  \ngo  \n  Path to the main Go executable binary for the function (if the function is written in Go).  \nlogTopic  \n  The topic to which the functions logs are produced.  \nmaxMessageRetries  \n  How many times should we try to process a message before giving up.  \noutput  \n  The functions output topic (If none is specified, no output is written).  \noutputSerdeClassName  \n  The SerDe class to be used for messages output by the function.  \nparallelism  \n  The functions parallelism factor (i.e. the number of function instances to run).  \nprocessingGuarantees  \n  The processing guarantees (that is, delivery semantics) applied to the function.  Possible Values: [ATLEAST_ONCE, ATMOST_ONCE, EFFECTIVELY_ONCE]  \nretainOrdering  \n  Function consumes and processes messages in order.  \noutputSchemaType  \n   Represents either a builtin schema type (for example: 'avro', 'json', ect) or the class name for a Schema implementation.subName  \n  Pulsar source subscription name. User can specify a subscription-name for the input-topic consumer.  \nwindowConfig  \n  The window functions configuration.  \ntimeoutMs  \n  The message timeout in milliseconds.  \ntopicsPattern  \n  The topic pattern to consume from a list of topics under a namespace that match the pattern.  [input] and [topicsPattern] are mutually exclusive. Add SerDe class name for a   pattern in customSerdeInputs (supported for java fun only)  \nuserConfig  \n  A map of user-defined configurations (specified as a JSON object).  \nsecrets  \n  This is a map of secretName(that is how the secret is going to be accessed in the function via context) to an object that  encapsulates how the secret is fetched by the underlying secrets provider. The type of an value here can be found by the  SecretProviderConfigurator.getSecretObjectType() method. \ncleanupSubscription  \n  Whether the subscriptions the functions created/used should be deleted when the functions are deleted.  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"inputs\": persistent://public/default/input-topic,\n  \"parallelism\": 4\n  \"output\": persistent://public/default/output-topic\n  \"log-topic\": persistent://public/default/log-topic\n  \"classname\": org.example.test.ExclamationFunction\n  \"jar\": java-function-1.0-SNAPSHOT.jar\n}\n")})) @FormDataParam(value="functionConfig") String functionConfigJson, @ApiParam(value="The update options is for the Pulsar Function that needs to be updated.") @FormDataParam(value="updateOptions") UpdateOptions updateOptions) throws IOException {
        this.functions.updateFunction(tenant, namespace, functionName, uploadedInputStream, fileDetail, functionPkgUrl, functionConfigJson, this.clientAppId(), this.clientAuthData(), updateOptions);
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Function currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function doesn't exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="The function was successfully deleted")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public void deregisterFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) {
        this.functions.deregisterFunction(tenant, namespace, functionName, this.clientAppId(), this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Function currently running in cluster mode", response=FunctionConfig.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Path(value="/{tenant}/{namespace}/{functionName}")
    public FunctionConfig getFunctionInfo(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionInfo(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function instance", response=FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/status")
    public FunctionStatus.FunctionInstanceStatus.FunctionInstanceStatusData getFunctionInstanceStatus(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The function instanceId (if instance-id is not provided, the stats of all instances is returned") @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions.getFunctionInstanceStatus(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Function", response=FunctionStatus.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/status")
    public FunctionStatus getFunctionStatus(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionStatus(tenant, namespace, functionName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the stats of a Pulsar Function", response=FunctionStats.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/stats")
    public FunctionStats getFunctionStats(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) throws IOException {
        return this.functions.getFunctionStats(tenant, namespace, functionName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the stats of a Pulsar Function instance", response=FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stats")
    public FunctionStats.FunctionInstanceStats.FunctionInstanceStatsData getFunctionInstanceStats(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The function instanceId (if instance-id is not provided, the stats of all instances is returned") @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.functions.getFunctionsInstanceStats(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Functions currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions")})
    @Path(value="/{tenant}/{namespace}")
    public List<String> listFunctions(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace) {
        return this.functions.listFunctions(tenant, namespace, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Triggers a Pulsar Function with a user-specified value or file data", response=Message.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/trigger")
    @Consumes(value={"multipart/form-data"})
    public String triggerFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The value with which you want to trigger the function") @FormDataParam(value="data") String triggerValue, @ApiParam(value="The path to the file that contains the data with which you'd like to trigger the function") @FormDataParam(value="dataStream") InputStream triggerStream, @ApiParam(value="The specific topic name that the function consumes from which you want to inject the data to") @FormDataParam(value="topic") String topic) {
        return this.functions.triggerFunction(tenant, namespace, functionName, triggerValue, triggerStream, topic, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetch the current state associated with a Pulsar Function", response=FunctionState.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The key does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    public FunctionState getFunctionState(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The stats key") @PathParam(value="key") String key) {
        return this.functions.getFunctionState(tenant, namespace, functionName, key, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Put the state associated with a Pulsar Function")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/state/{key}")
    @Consumes(value={"multipart/form-data"})
    public void putFunctionState(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="functionName") String functionName, @PathParam(value="key") String key, @FormDataParam(value="state") FunctionState stateJson) {
        this.functions.putFunctionState(tenant, namespace, functionName, key, stateJson, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The function instanceId (if instance-id is not provided, all instances are restarted") @PathParam(value="instanceId") String instanceId) {
        this.functions.restartFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/restart")
    @Consumes(value={"application/json"})
    public void restartFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) {
        this.functions.restartFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The function instanceId (if instance-id is not provided, all instances are stopped. ") @PathParam(value="instanceId") String instanceId) {
        this.functions.stopFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/stop")
    @Consumes(value={"application/json"})
    public void stopFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) {
        this.functions.stopFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start function instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName, @ApiParam(value="The function instanceId (if instance-id is not provided, all instances sre started. ") @PathParam(value="instanceId") String instanceId) {
        this.functions.startFunctionInstance(tenant, namespace, functionName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start all function instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{functionName}/start")
    @Consumes(value={"application/json"})
    public void startFunction(@ApiParam(value="The tenant of functions") @PathParam(value="tenant") String tenant, @ApiParam(value="The namespace of functions") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of functions") @PathParam(value="functionName") String functionName) {
        this.functions.startFunctionInstances(tenant, namespace, functionName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Uploads Pulsar Function file data", hidden=true)
    @Path(value="/upload")
    @Consumes(value={"multipart/form-data"})
    public void uploadFunction(@FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="path") String path) {
        this.functions.uploadFunction(uploadedInputStream, path);
    }

    @GET
    @ApiOperation(value="Downloads Pulsar Function file data", hidden=true)
    @Path(value="/download")
    public StreamingOutput downloadFunction(@QueryParam(value="path") String path) {
        return this.functions.downloadFunction(path);
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout")})
    @Path(value="/connectors")
    @Deprecated
    public List<ConnectorDefinition> getConnectorsList() throws IOException {
        return this.functions.getListOfConnectors();
    }
}

