/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.pulsar.broker.admin.impl.NamespacesBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/namespaces")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/namespaces", description="Namespaces admin apis", tags={"namespaces"})
public class Namespaces
extends NamespacesBase {
    private static final Logger log = LoggerFactory.getLogger(Namespaces.class);

    @GET
    @Path(value="/{tenant}")
    @ApiOperation(value="Get the list of all the namespaces for a certain tenant.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant doesn't exist")})
    public List<String> getTenantNamespaces(@PathParam(value="tenant") String tenant) {
        return this.internalGetTenantNamespaces(tenant);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/topics")
    @ApiOperation(value="Get the list of all the topics under a certain namespace.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public List<String> getTopics(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @QueryParam(value="mode") @DefaultValue(value="PERSISTENT") PulsarApi.CommandGetTopicsOfNamespace.Mode mode) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        this.getNamespacePolicies(this.namespaceName);
        try {
            return this.pulsar().getNamespaceService().getListOfTopics(this.namespaceName, mode);
        }
        catch (Exception e) {
            log.error("Failed to get topics list for namespace {}", (Object)this.namespaceName, (Object)e);
            throw new RestException(e);
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Get the dump all the policies specified for a namespace.", response=Policies.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public Policies getPolicies(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        return this.getNamespacePolicies(this.namespaceName);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Creates a new namespace with the specified policies")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster doesn't exist"), @ApiResponse(code=409, message="Namespace already exists"), @ApiResponse(code=412, message="Namespace name is not valid")})
    public void createNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, Policies policies) {
        this.validateNamespaceName(tenant, namespace);
        policies = this.getDefaultPolicesIfNull(policies);
        this.internalCreateNamespace(policies);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Delete a namespace and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public void deleteNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalDeleteNamespace(authoritative);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{bundle}")
    @ApiOperation(value="Delete a namespace bundle and all the topics under it.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace bundle is not empty")})
    public void deleteNamespaceBundle(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalDeleteNamespaceBundle(bundleRange, authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/permissions")
    @ApiOperation(value="Retrieve the permissions for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Namespace is not empty")})
    public Map<String, Set<AuthAction>> getPermissions(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.auth_policies.namespace_auth;
    }

    @POST
    @Path(value="/{tenant}/{namespace}/permissions/{role}")
    @ApiOperation(value="Grant a new permission to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role, Set<AuthAction> actions) {
        this.validateNamespaceName(tenant, namespace);
        this.internalGrantPermissionOnNamespace(role, actions);
    }

    @POST
    @Path(value="/{property}/{namespace}/permissions/subscription/{subscription}")
    @ApiOperation(hidden=true, value="Grant a new permission to roles for a subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=501, message="Authorization is not enabled")})
    public void grantPermissionOnSubscription(@PathParam(value="property") String property, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, Set<String> roles) {
        this.validateNamespaceName(property, namespace);
        this.internalGrantPermissionOnSubscription(subscription, roles);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/permissions/{role}")
    @ApiOperation(value="Revoke all permissions to a role on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void revokePermissionsOnNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="role") String role) {
        this.validateNamespaceName(tenant, namespace);
        this.internalRevokePermissionsOnNamespace(role);
    }

    @DELETE
    @Path(value="/{property}/{namespace}/permissions/{subscription}/{role}")
    @ApiOperation(hidden=true, value="Revoke subscription admin-api access permission for a role.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Property or cluster or namespace doesn't exist")})
    public void revokePermissionOnSubscription(@PathParam(value="property") String property, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="role") String role) {
        this.validateNamespaceName(property, namespace);
        this.internalRevokePermissionsOnSubscription(subscription, role);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/replication")
    @ApiOperation(value="Get the replication clusters for a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not global")})
    public Set<String> getNamespaceReplicationClusters(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetNamespaceReplicationClusters();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/replication")
    @ApiOperation(value="Set the replication clusters for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Peer-cluster can't be part of replication-cluster"), @ApiResponse(code=412, message="Namespace is not global or invalid cluster ids")})
    public void setNamespaceReplicationClusters(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, List<String> clusterIds) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetNamespaceReplicationClusters(clusterIds);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/messageTTL")
    @ApiOperation(value="Get the message TTL for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public int getNamespaceMessageTTL(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.message_ttl_in_seconds;
    }

    @POST
    @Path(value="/{tenant}/{namespace}/messageTTL")
    @ApiOperation(value="Set message TTL in seconds for namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid TTL")})
    public void setNamespaceMessageTTL(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, int messageTTL) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetNamespaceMessageTTL(messageTTL);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/deduplication")
    @ApiOperation(value="Enable or disable broker side deduplication for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public void modifyDeduplication(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, boolean enableDeduplication) {
        this.validateNamespaceName(tenant, namespace);
        this.internalModifyDeduplication(enableDeduplication);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/bundles")
    @ApiOperation(value="Get the bundles split data.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is not setup to split in bundles")})
    public BundlesData getBundlesData(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validatePoliciesReadOnlyAccess();
        this.validateNamespaceName(tenant, namespace);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.bundles;
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/unload")
    @ApiOperation(value="Unload namespace", notes="Unload an active namespace from the current broker serving it. Performing this operation will let the brokerremoves all producers, consumers, and connections using this namespace, and close all topics (includingtheir persistent store). During that operation, the namespace is marked as tentatively unavailable until thebroker completes the unloading action. This operation requires strictly super user privileges, since it wouldresult in non-persistent message loss and unexpected connection closure to the clients.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or namespace doesn't exist"), @ApiResponse(code=412, message="Namespace is already unloaded or Namespace has bundles activated")})
    public void unloadNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        this.internalUnloadNamespace();
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{bundle}/unload")
    @ApiOperation(value="Unload a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void unloadNamespaceBundle(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalUnloadNamespaceBundle(bundleRange, authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{bundle}/split")
    @ApiOperation(value="Split a namespace bundle")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void splitNamespaceBundle(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="unload") @DefaultValue(value="false") boolean unload) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSplitNamespaceBundle(bundleRange, authoritative, unload);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/dispatchRate")
    @ApiOperation(value="Set dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, DispatchRate dispatchRate) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetTopicDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/dispatchRate")
    @ApiOperation(value="Get dispatch-rate configured for the namespace, -1 represents not configured yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetTopicDispatchRate();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Set Subscription dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setSubscriptionDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, DispatchRate dispatchRate) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetSubscriptionDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/subscriptionDispatchRate")
    @ApiOperation(value="Get Subscription dispatch-rate configured for the namespace, -1 represents not configured yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getSubscriptionDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetSubscriptionDispatchRate();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/subscribeRate")
    @ApiOperation(value="Set subscribe-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setSubscribeRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, SubscribeRate subscribeRate) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetSubscribeRate(subscribeRate);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/subscribeRate")
    @ApiOperation(value="Get subscribe-rate configured for the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public SubscribeRate getSubscribeRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetSubscribeRate();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Set replicator dispatch-rate throttling for all topics of the namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public void setReplicatorDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, DispatchRate dispatchRate) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetReplicatorDispatchRate(dispatchRate);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/replicatorDispatchRate")
    @ApiOperation(value="Get replicator dispatch-rate configured for the namespace, -1 represents not configured yet")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public DispatchRate getReplicatorDispatchRate(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetReplicatorDispatchRate();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/backlogQuotaMap")
    @ApiOperation(value="Get backlog quota map on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateAdminAccessForTenant(tenant);
        this.validateNamespaceName(tenant, namespace);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.backlog_quota_map;
    }

    @POST
    @Path(value="/{tenant}/{namespace}/backlogQuota")
    @ApiOperation(value=" Set a backlog quota for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Specified backlog quota exceeds retention quota. Increase retention quota and retry request")})
    public void setBacklogQuota(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetBacklogQuota(backlogQuotaType, backlogQuota);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/backlogQuota")
    @ApiOperation(value="Remove a backlog quota policy from a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeBacklogQuota(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateNamespaceName(tenant, namespace);
        this.internalRemoveBacklogQuota(backlogQuotaType);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/retention")
    @ApiOperation(value="Get retention config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public RetentionPolicies getRetention(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetRetention();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/retention")
    @ApiOperation(value=" Set retention configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Retention Quota must exceed backlog quota")})
    public void setRetention(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, RetentionPolicies retention) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetRetention(retention);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/persistence")
    @ApiOperation(value="Set the persistence configuration for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=400, message="Invalid persistence policies")})
    public void setPersistence(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, PersistencePolicies persistence) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetPersistence(persistence);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(value="Set the bookie-affinity-group to namespace-persistent policy.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setBookieAffinityGroup(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, BookieAffinityGroupData bookieAffinityGroup) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetBookieAffinityGroup(bookieAffinityGroup);
    }

    @GET
    @Path(value="/{property}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(value="Get the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public BookieAffinityGroupData getBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, namespace);
        return this.internalGetBookieAffinityGroup();
    }

    @DELETE
    @Path(value="/{property}/{namespace}/persistence/bookieAffinity")
    @ApiOperation(value="Delete the bookie-affinity-group from namespace-local policy.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void deleteBookieAffinityGroup(@PathParam(value="property") String property, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, namespace);
        this.internalDeleteBookieAffinityGroup();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/persistence")
    @ApiOperation(value="Get the persistence configuration for a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public PersistencePolicies getPersistence(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetPersistence();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/clearBacklog")
    @ApiOperation(value="Clear backlog for all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklog(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalClearNamespaceBacklog(authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}/clearBacklog")
    @ApiOperation(value="Clear backlog for all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklog(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalClearNamespaceBundleBacklog(bundleRange, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/clearBacklog/{subscription}")
    @ApiOperation(value="Clear backlog for a given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBacklogForSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalClearNamespaceBacklogForSubscription(subscription, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}/clearBacklog/{subscription}")
    @ApiOperation(value="Clear backlog for a given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void clearNamespaceBundleBacklogForSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalClearNamespaceBundleBacklogForSubscription(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/unsubscribe/{subscription}")
    @ApiOperation(value="Unsubscribes the given subscription on all topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespace(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalUnsubscribeNamespace(subscription, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{bundle}/unsubscribe/{subscription}")
    @ApiOperation(value="Unsubscribes the given subscription on all topics on a namespace bundle.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public void unsubscribeNamespaceBundle(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="subscription") String subscription, @PathParam(value="bundle") String bundleRange, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateNamespaceName(tenant, namespace);
        this.internalUnsubscribeNamespaceBundle(subscription, bundleRange, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/subscriptionAuthMode")
    @ApiOperation(value=" Set a subscription auth mode for all the topics on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSubscriptionAuthMode(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetSubscriptionAuthMode(subscriptionAuthMode);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/encryptionRequired")
    @ApiOperation(value="Message encryption is required or not for all topics in a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void modifyEncryptionRequired(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, boolean encryptionRequired) {
        this.validateNamespaceName(tenant, namespace);
        this.internalModifyEncryptionRequired(encryptionRequired);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value="Get maxProducersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public int getMaxProducersPerTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetMaxProducersPerTopic();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/maxProducersPerTopic")
    @ApiOperation(value=" Set maxProducersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxProducersPerTopic value is not valid")})
    public void setMaxProducersPerTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, int maxProducersPerTopic) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetMaxProducersPerTopic(maxProducersPerTopic);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value="Get maxConsumersPerTopic config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public int getMaxConsumersPerTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetMaxConsumersPerTopic();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/maxConsumersPerTopic")
    @ApiOperation(value=" Set maxConsumersPerTopic configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerTopic value is not valid")})
    public void setMaxConsumersPerTopic(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, int maxConsumersPerTopic) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetMaxConsumersPerTopic(maxConsumersPerTopic);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value="Get maxConsumersPerSubscription config on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public int getMaxConsumersPerSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetMaxConsumersPerSubscription();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/maxConsumersPerSubscription")
    @ApiOperation(value=" Set maxConsumersPerSubscription configuration on a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="maxConsumersPerSubscription value is not valid")})
    public void setMaxConsumersPerSubscription(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, int maxConsumersPerSubscription) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetMaxConsumersPerSubscription(maxConsumersPerSubscription);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/antiAffinity")
    @ApiOperation(value="Set anti-affinity group for a namespace")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist"), @ApiResponse(code=412, message="Invalid antiAffinityGroup")})
    public void setNamespaceAntiAffinityGroup(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, String antiAffinityGroup) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetNamespaceAntiAffinityGroup(antiAffinityGroup);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/antiAffinity")
    @ApiOperation(value="Get anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace doesn't exist")})
    public String getNamespaceAntiAffinityGroup(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetNamespaceAntiAffinityGroup();
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/antiAffinity")
    @ApiOperation(value="Remove anti-affinity group of a namespace.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeNamespaceAntiAffinityGroup(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        this.internalRemoveNamespaceAntiAffinityGroup();
    }

    @GET
    @Path(value="{cluster}/antiAffinity/{group}")
    @ApiOperation(value="Get all namespaces that are grouped by given anti-affinity group in a given cluster. api can be only accessed by admin of any of the existing tenant")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=412, message="Cluster not exist/Anti-affinity group can't be empty.")})
    public List<String> getAntiAffinityNamespaces(@PathParam(value="cluster") String cluster, @PathParam(value="group") String antiAffinityGroup, @QueryParam(value="tenant") String tenant) {
        return this.internalGetAntiAffinityNamespaces(cluster, antiAffinityGroup, tenant);
    }

    private Policies getDefaultPolicesIfNull(Policies policies) {
        if (policies == null) {
            policies = new Policies();
        }
        int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
        if (policies.bundles == null) {
            policies.bundles = Namespaces.getBundles(defaultNumberOfBundles);
        }
        return policies;
    }

    @GET
    @Path(value="/{tenant}/{namespace}/compactionThreshold")
    @ApiOperation(value="Maximum number of uncompacted bytes in topics before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public long getCompactionThreshold(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetCompactionThreshold();
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/compactionThreshold")
    @ApiOperation(value="Set maximum number of uncompacted bytes in a topic before compaction is triggered.", notes="The backlog size is compared to the threshold periodically. A threshold of 0 disabled automatic compaction")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="compactionThreshold value is not valid")})
    public void setCompactionThreshold(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetCompactionThreshold(newThreshold);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/offloadThreshold")
    @ApiOperation(value="Maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public long getOffloadThreshold(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetOffloadThreshold();
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/offloadThreshold")
    @ApiOperation(value="Set maximum number of bytes stored on the pulsar cluster for a topic, before the broker will start offloading to longterm storage", notes="A negative value disables automatic offloading")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="offloadThreshold value is not valid")})
    public void setOffloadThreshold(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, long newThreshold) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetOffloadThreshold(newThreshold);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/offloadDeletionLagMs")
    @ApiOperation(value="Number of milliseconds to wait before deleting a ledger segment which has been offloaded from the Pulsar cluster's local storage (i.e. BookKeeper)", notes="A negative value denotes that deletion has been completely disabled. 'null' denotes that the topics in the namespace will fall back to the broker default for deletion lag.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public Long getOffloadDeletionLag(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetOffloadDeletionLag();
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/offloadDeletionLagMs")
    @ApiOperation(value="Set number of milliseconds to wait before deleting a ledger segment which has been offloaded from the Pulsar cluster's local storage (i.e. BookKeeper)", notes="A negative value disables the deletion completely.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="offloadDeletionLagMs value is not valid")})
    public void setOffloadDeletionLag(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, long newDeletionLagMs) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetOffloadDeletionLag(newDeletionLagMs);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/offloadDeletionLagMs")
    @ApiOperation(value="Clear the namespace configured offload deletion lag. The topics in the namespace will fallback to using the default configured deletion lag for the broker")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void clearOffloadDeletionLag(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetOffloadDeletionLag(null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="The strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public SchemaAutoUpdateCompatibilityStrategy getSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetSchemaAutoUpdateCompatibilityStrategy();
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/schemaAutoUpdateCompatibilityStrategy")
    @ApiOperation(value="Update the strategy used to check the compatibility of new schemas, provided by producers, before automatically updating the schema", notes="The value AutoUpdateDisabled prevents producers from updating the schema.  If set to AutoUpdateDisabled, schemas must be updated through the REST api")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSchemaAutoUpdateCompatibilityStrategy(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetSchemaAutoUpdateCompatibilityStrategy(strategy);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/schemaValidationEnforced")
    @ApiOperation(value="Get schema validation enforced flag for namespace.", notes="If the flag is set to true, when a producer without a schema attempts to produce to a topic with schema in this namespace, the producer will be failed to connect. PLEASE be carefully on using this, since non-java clients don't support schema.if you enable this setting, it will cause non-java clients failed to produce.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenants or Namespace doesn't exist")})
    public boolean getSchemaValidtionEnforced(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetSchemaValidationEnforced();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/schemaValidationEnforced")
    @ApiOperation(value="Set schema validation enforced flag on namespace.", notes="If the flag is set to true, when a producer without a schema attempts to produce to a topic with schema in this namespace, the producer will be failed to connect. PLEASE be carefully on using this, since non-java clients don't support schema.if you enable this setting, it will cause non-java clients failed to produce.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or Namespace doesn't exist"), @ApiResponse(code=412, message="schemaValidationEnforced value is not valid")})
    public void setSchemaValidtionEnforced(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, boolean schemaValidationEnforced) {
        this.validateNamespaceName(tenant, namespace);
        this.internalSetSchemaValidationEnforced(schemaValidationEnforced);
    }
}

