/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.LongSchemaVersion;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.exceptions.IncompatibleSchemaException;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/schemas")
@Api(value="/schemas", description="Schemas related admin APIs", tags={"schemas"})
public class SchemasResource
extends AdminResource {
    private static final Logger log = LoggerFactory.getLogger(SchemasResource.class);
    private final Clock clock;

    public SchemasResource() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResource(Clock clock) {
        this.clock = clock;
    }

    private static long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic, authoritative);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        this.pulsar().getSchemaRegistryService().getSchema(schemaId).handle((schema, error) -> {
            SchemasResource.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic at a given version", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @PathParam(value="version") @Encoded String version, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic, authoritative);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        ByteBuffer bbVersion = ByteBuffer.allocate(8);
        bbVersion.putLong(Long.parseLong(version));
        SchemaVersion v = this.pulsar().getSchemaRegistryService().versionFromBytes(bbVersion.array());
        this.pulsar().getSchemaRegistryService().getSchema(schemaId, v).handle((schema, error) -> {
            SchemasResource.handleGetSchemaResponse(response, schema, error);
            return null;
        });
    }

    private static void handleGetSchemaResponse(AsyncResponse response, SchemaRegistry.SchemaAndMetadata schema, Throwable error) {
        if (Objects.isNull(error)) {
            if (Objects.isNull(schema)) {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            } else if (schema.schema.isDeleted()) {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            } else {
                response.resume((Object)Response.ok().encoding("application/json").entity((Object)GetSchemaResponse.builder().version(SchemasResource.getLongSchemaVersion(schema.version)).type(schema.schema.getType()).timestamp(schema.schema.getTimestamp()).data(new String(schema.schema.getData(), StandardCharsets.UTF_8)).properties(schema.schema.getProps()).build()).build());
            }
        } else {
            response.resume(error);
        }
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the schema of a topic", response=DeleteSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic")})
    public void deleteSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic, authoritative);
        String schemaId = this.buildSchemaId(tenant, namespace, topic);
        this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).handle((version, error) -> {
            if (Objects.isNull(error)) {
                response.resume((Object)Response.ok().entity((Object)DeleteSchemaResponse.builder().version(SchemasResource.getLongSchemaVersion(version)).build()).build());
            } else {
                response.resume(error);
            }
            return null;
        });
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the schema of a topic", response=PostSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=409, message="Incompatible schema"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=422, message="Invalid schema data")})
    public void postSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateDestinationAndAdminOperation(tenant, namespace, topic, authoritative);
        ((CompletableFuture)this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.buildSchemaId(tenant, namespace, topic), SchemaData.builder().data(payload.getSchema().getBytes(Charsets.UTF_8)).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).build(), SchemaCompatibilityStrategy.FULL).thenAccept(version -> response.resume((Object)Response.accepted().entity((Object)PostSchemaResponse.builder().version(version).build()).build()))).exceptionally(error -> {
            if (error instanceof IncompatibleSchemaException) {
                response.resume((Object)Response.status((Response.Status)Response.Status.CONFLICT).build());
            } else if (error instanceof InvalidSchemaDataException) {
                response.resume((Object)Response.status((int)422, (String)error.getMessage()).build());
            } else {
                response.resume((Object)Response.serverError().build());
            }
            return null;
        });
    }

    private String buildSchemaId(String tenant, String namespace, String topic) {
        return TopicName.get((String)"persistent", (String)tenant, (String)namespace, (String)topic).getSchemaName();
    }

    private void validateDestinationAndAdminOperation(String tenant, String namespace, String topic, boolean authoritative) {
        TopicName destinationName = TopicName.get((String)"persistent", (String)tenant, (String)namespace, (String)Codec.decode((String)topic));
        try {
            this.validateAdminAccessForTenant(destinationName.getTenant());
            this.validateTopicOwnership(destinationName, authoritative);
        }
        catch (RestException e) {
            if (e.getResponse().getStatus() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new RestException(Response.Status.NOT_FOUND, "Not Found");
            }
            throw e;
        }
    }
}

