/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.utils.CopyOnWriteArrayList;

public interface Dispatcher {
    public void addConsumer(Consumer var1) throws BrokerServiceException;

    public void removeConsumer(Consumer var1) throws BrokerServiceException;

    public void consumerFlow(Consumer var1, int var2);

    public boolean isConsumerConnected();

    public CopyOnWriteArrayList<Consumer> getConsumers();

    public boolean canUnsubscribe(Consumer var1);

    public CompletableFuture<Void> close();

    public CompletableFuture<Void> disconnectAllConsumers();

    public void reset();

    public PulsarApi.CommandSubscribe.SubType getType();

    public void redeliverUnacknowledgedMessages(Consumer var1);

    public void redeliverUnacknowledgedMessages(Consumer var1, List<PositionImpl> var2);

    public void addUnAckedMessages(int var1);

    public RedeliveryTracker getRedeliveryTracker();

    default public Optional<DispatchRateLimiter> getRateLimiter() {
        return Optional.empty();
    }

    default public void initializeDispatchRateLimiterIfNeeded(Optional<Policies> policies) {
    }

    default public boolean trackDelayedDelivery(long ledgerId, long entryId, PulsarApi.MessageMetadata msgMetadata) {
        return false;
    }

    default public long getNumberOfDelayedMessages() {
        return 0L;
    }
}

