/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.FutureUtil;

public class SchemaRegistryServiceWithSchemaDataValidator
implements SchemaRegistryService {
    private final SchemaRegistryService service;

    public static SchemaRegistryServiceWithSchemaDataValidator of(SchemaRegistryService service) {
        return new SchemaRegistryServiceWithSchemaDataValidator(service);
    }

    private SchemaRegistryServiceWithSchemaDataValidator(SchemaRegistryService service) {
        this.service = service;
    }

    @Override
    public void close() throws Exception {
        this.service.close();
    }

    @Override
    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchema(String schemaId) {
        return this.service.getSchema(schemaId);
    }

    @Override
    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchema(String schemaId, SchemaVersion version) {
        return this.service.getSchema(schemaId, version);
    }

    @Override
    public CompletableFuture<List<CompletableFuture<SchemaRegistry.SchemaAndMetadata>>> getAllSchemas(String schemaId) {
        return this.service.getAllSchemas(schemaId);
    }

    @Override
    public CompletableFuture<SchemaVersion> putSchemaIfAbsent(String schemaId, SchemaData schema, SchemaCompatibilityStrategy strategy) {
        try {
            SchemaDataValidator.validateSchemaData(schema);
        }
        catch (InvalidSchemaDataException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
        return this.service.putSchemaIfAbsent(schemaId, schema, strategy);
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema(String schemaId, String user) {
        return this.service.deleteSchema(schemaId, user);
    }

    @Override
    public CompletableFuture<Boolean> isCompatible(String schemaId, SchemaData schema, SchemaCompatibilityStrategy strategy) {
        try {
            SchemaDataValidator.validateSchemaData(schema);
        }
        catch (InvalidSchemaDataException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
        return this.service.isCompatible(schemaId, schema, strategy);
    }

    @Override
    public SchemaVersion versionFromBytes(byte[] version) {
        return this.service.versionFromBytes(version);
    }
}

