/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.pulsar.common.stats.Metrics;

public class NamespaceStats {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public double storageSize;
    public double msgBacklog;
    public double msgReplBacklog;
    public double maxMsgReplDelayInSeconds;
    public int consumerCount;
    public int producerCount;
    public int replicatorCount;
    public int subsCount;
    public static final String BRK_ADD_ENTRY_LATENCY_PREFIX = "brk_AddEntryLatencyBuckets";
    public long[] addLatencyBucket = new long[ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1];
    public static final String[] ADD_LATENCY_BUCKET_KEYS = new String[ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1];

    public NamespaceStats() {
        this.reset();
    }

    public void reset() {
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.storageSize = 0.0;
        this.msgBacklog = 0.0;
        this.msgReplBacklog = 0.0;
        this.maxMsgReplDelayInSeconds = 0.0;
        this.consumerCount = 0;
        this.producerCount = 0;
        this.replicatorCount = 0;
        this.subsCount = 0;
        NamespaceStats.clear(this.addLatencyBucket);
    }

    public Metrics add(String namespace) {
        HashMap dimensionMap = Maps.newHashMap();
        dimensionMap.put("namespace", namespace);
        Metrics dMetrics = Metrics.create((Map)dimensionMap);
        dMetrics.put("brk_in_rate", (Object)this.msgRateIn);
        dMetrics.put("brk_in_tp_rate", (Object)this.msgThroughputIn);
        dMetrics.put("brk_out_rate", (Object)this.msgRateOut);
        dMetrics.put("brk_out_tp_rate", (Object)this.msgThroughputOut);
        dMetrics.put("brk_storage_size", (Object)this.storageSize);
        dMetrics.put("brk_no_of_producers", (Object)this.producerCount);
        dMetrics.put("brk_no_of_subscriptions", (Object)this.subsCount);
        dMetrics.put("brk_no_of_replicators", (Object)this.replicatorCount);
        dMetrics.put("brk_no_of_consumers", (Object)this.consumerCount);
        dMetrics.put("brk_msg_backlog", (Object)this.msgBacklog);
        dMetrics.put("brk_replication_backlog", (Object)this.msgReplBacklog);
        dMetrics.put("brk_max_replication_delay_second", (Object)this.maxMsgReplDelayInSeconds);
        for (int i = 0; i < this.addLatencyBucket.length; ++i) {
            dMetrics.put(ADD_LATENCY_BUCKET_KEYS[i], (Object)this.addLatencyBucket[i]);
        }
        return dMetrics;
    }

    public static void copy(long[] src, long[] dest) {
        if (src != null && dest != null && src.length == dest.length) {
            for (int i = 0; i < src.length; ++i) {
                dest[i] = src[i];
            }
        }
    }

    public static void clear(long[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                list[i] = 0L;
            }
        }
    }

    static {
        for (int i = 0; i < ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length + 1; ++i) {
            String key = i == 0 && ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length > 0 ? String.format("%s_0.0_%1.1f", BRK_ADD_ENTRY_LATENCY_PREFIX, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i] / 1000.0) : (i < ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC.length ? String.format("%s_%1.1f_%1.1f", BRK_ADD_ENTRY_LATENCY_PREFIX, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i - 1] / 1000.0, (double)ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC[i] / 1000.0) : String.format("%s_OVERFLOW", BRK_ADD_ENTRY_LATENCY_PREFIX));
            NamespaceStats.ADD_LATENCY_BUCKET_KEYS[i] = key;
        }
    }
}

