/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedSubscriptionStats;
import org.apache.pulsar.common.util.SimpleTextOutputStream;

class TopicStats {
    int subscriptionsCount;
    int producersCount;
    int consumersCount;
    double rateIn;
    double rateOut;
    double throughputIn;
    double throughputOut;
    long storageSize;
    public long msgBacklog;
    long backlogSize;
    long offloadedStorageUsed;
    long backlogQuotaLimit;
    StatsBuckets storageWriteLatencyBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    StatsBuckets entrySizeBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES);
    double storageWriteRate;
    double storageReadRate;
    Map<String, AggregatedReplicationStats> replicationStats = new HashMap<String, AggregatedReplicationStats>();
    Map<String, AggregatedSubscriptionStats> subscriptionStats = new HashMap<String, AggregatedSubscriptionStats>();

    TopicStats() {
    }

    public void reset() {
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.storageSize = 0L;
        this.msgBacklog = 0L;
        this.storageWriteRate = 0.0;
        this.storageReadRate = 0.0;
        this.backlogSize = 0L;
        this.offloadedStorageUsed = 0L;
        this.backlogQuotaLimit = 0L;
        this.replicationStats.clear();
        this.subscriptionStats.clear();
        this.storageWriteLatencyBuckets.reset();
        this.entrySizeBuckets.reset();
    }

    static void printTopicStats(SimpleTextOutputStream stream, String cluster, String namespace, String topic, TopicStats stats) {
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_subscriptions_count", stats.subscriptionsCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_producers_count", stats.producersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_consumers_count", stats.consumersCount);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_in", stats.rateIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_rate_out", stats.rateOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_in", stats.throughputIn);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_throughput_out", stats.throughputOut);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_size", stats.storageSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_msg_backlog", stats.msgBacklog);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_backlog_size", stats.backlogSize);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_offloaded_size", stats.offloadedStorageUsed);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_backlog_quota_limit", stats.backlogQuotaLimit);
        long[] latencyBuckets = stats.storageWriteLatencyBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_0_5", latencyBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1", latencyBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_5", latencyBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_10", latencyBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_20", latencyBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_50", latencyBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_100", latencyBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_200", latencyBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_le_1000", latencyBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_overflow", latencyBuckets[9]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_count", stats.storageWriteLatencyBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_storage_write_latency_sum", stats.storageWriteLatencyBuckets.getSum());
        long[] entrySizeBuckets = stats.entrySizeBuckets.getBuckets();
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_128", entrySizeBuckets[0]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_512", entrySizeBuckets[1]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_kb", entrySizeBuckets[2]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_2_kb", entrySizeBuckets[3]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_4_kb", entrySizeBuckets[4]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_16_kb", entrySizeBuckets[5]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_100_kb", entrySizeBuckets[6]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_1_mb", entrySizeBuckets[7]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_le_overflow", entrySizeBuckets[8]);
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_count", stats.entrySizeBuckets.getCount());
        TopicStats.metric(stream, cluster, namespace, topic, "pulsar_entry_size_sum", stats.entrySizeBuckets.getSum());
        stats.subscriptionStats.forEach((n, subsStats) -> {
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_back_log", subsStats.msgBacklog);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_delayed", subsStats.msgDelayed);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_rate_redeliver", subsStats.msgRateRedeliver);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_unacked_massages", subsStats.unackedMessages);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_blocked_on_unacked_messages", subsStats.blockedSubscriptionOnUnackedMsgs ? 1L : 0L);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_rate_out", subsStats.msgRateOut);
            TopicStats.metric(stream, cluster, namespace, topic, n, "pulsar_subscription_msg_throughput_out", subsStats.msgThroughputOut);
            subsStats.consumerStat.forEach((c, consumerStats) -> {
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_rate_redeliver", consumerStats.msgRateRedeliver);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_unacked_massages", consumerStats.unackedMessages);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_blocked_on_unacked_messages", consumerStats.blockedSubscriptionOnUnackedMsgs ? 1L : 0L);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_rate_out", consumerStats.msgRateOut);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_msg_throughput_out", consumerStats.msgThroughputOut);
                TopicStats.metric(stream, cluster, namespace, topic, n, c.consumerName(), c.consumerId(), "pulsar_consumer_available_permits", consumerStats.availablePermits);
            });
        });
        if (!stats.replicationStats.isEmpty()) {
            stats.replicationStats.forEach((remoteCluster, replStats) -> {
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_rate_in", remoteCluster, replStats.msgRateIn);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_rate_out", remoteCluster, replStats.msgRateOut);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_throughput_in", remoteCluster, replStats.msgThroughputIn);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_throughput_out", remoteCluster, replStats.msgThroughputOut);
                TopicStats.metricWithRemoteCluster(stream, cluster, namespace, topic, "pulsar_replication_backlog", remoteCluster, replStats.replicationBacklog);
            });
        }
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String name, double value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String name, long value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String name, double value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String consumerName, long consumerId, String name, long value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\", namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\",consumer_name=\"").write(consumerName).write("\",consumer_id=\"").write(consumerId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metric(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String subscription, String consumerName, long consumerId, String name, double value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace).write("\",topic=\"").write(topic).write("\",subscription=\"").write(subscription).write("\",consumer_name=\"").write(consumerName).write("\",consumer_id=\"").write(consumerId).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }

    private static void metricWithRemoteCluster(SimpleTextOutputStream stream, String cluster, String namespace, String topic, String name, String remoteCluster, double value) {
        stream.write(name).write("{cluster=\"").write(cluster).write("\",namespace=\"").write(namespace);
        stream.write("\",topic=\"").write(topic).write("\",remote_cluster=\"").write(remoteCluster).write("\"} ");
        stream.write(value).write(' ').write(System.currentTimeMillis()).write('\n');
    }
}

