/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.SinksImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class SinksBase
extends AdminResource
implements Supplier<WorkerService> {
    private final SinksImpl sink = new SinksImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Sink in cluster mode")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request (sink already exists, etc.)"), @ApiResponse(code=200, message="Pulsar Sink successfully created"), @ApiResponse(code=500, message="Internal server error (failed to authorize, failed to get tenant data, failed to process package, etc.)"), @ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void registerSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String sinkPkgUrl, @ApiParam(value="A JSON value presenting a sink config playload. All available configuration options are:  \nclassname  \n   The sink's class name if archive is file-url-path (file://)  \nsourceSubscriptionName  \n   Pulsar source subscription name if user wants a specific  \n   subscription-name for input-topic consumer  \ninputs  \n   The sink's input topic or topics (specified as a JSON array)  \ntopicsPattern  \n   TopicsPattern to consume from list of topics under a namespace that    match the pattern. [input] and [topicsPattern] are mutually    exclusive. Add SerDe class name for a pattern in customSerdeInputs    (supported for java fun only)topicToSerdeClassName  \n   The map of input topics to SerDe class names (specified as a JSON object)  \ntopicToSchemaType  \n   The map of input topics to Schema types or class names (specified as a JSON object)  \ninputSpecs  \n   The map of input topics to its consumer configuration, each configuration has schema of    {\"schemaType\": \"type-x\", \"serdeClassName\": \"name-x\", \"isRegexPattern\": true, \"receiverQueueSize\": 5}  \nconfigs  \n   The map of configs (specified as a JSON object)  \nsecrets  \n   a map of secretName(aka how the secret is going to be \n   accessed in the function via context) to an object that \n   encapsulates how the secret is fetched by the underlying \n   secrets provider. The type of an value here can be found by the \n   SecretProviderConfigurator.getSecretObjectType() method. (specified as a JSON object)  \nparallelism  \n   The sink's parallelism factor (i.e. the number of sink instances to run \nprocessingGuarantees  \n   The processing guarantees (aka delivery semantics) applied to the sink. Possible Values: \"ATLEAST_ONCE\", \"ATMOST_ONCE\", \"EFFECTIVELY_ONCE\"  \nretainOrdering  \n   Boolean denotes whether sink consumes and sinks messages in order  \nresources  \n   {\"cpu\": 1, \"ram\": 2, \"disk\": 3} The CPU (in cores), RAM (in bytes) and disk (in bytes) that needs to be allocated per sink instance (applicable only to Docker runtime)  \nautoAck  \n   Boolean denotes whether or not the framework will automatically acknowledge messages  \ntimeoutMs  \n   Long denotes the message timeout in milliseconds  \ncleanupSubscription  \n   Boolean denotes whether the subscriptions the functions created/used should be deleted when the functions is deleted  \nruntimeFlags  \n   Any flags that you want to pass to the runtime as a single string  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{  \n\t\"classname\": \"org.example.MySinkTest\",\n\t\"inputs\": [\"persistent://public/default/sink-input\"],\n\t\"processingGuarantees\": \"EFFECTIVELY_ONCE\",\n\t\"parallelism\": 10\n}")})) @FormDataParam(value="sinkConfig") SinkConfig sinkConfig) {
        this.sink.registerSink(tenant, namespace, sinkName, uploadedInputStream, fileDetail, sinkPkgUrl, sinkConfig, this.clientAppId(), this.clientAuthData());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Sink currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request (sink doesn't exist, update contains no change, etc.)"), @ApiResponse(code=200, message="Pulsar Sink successfully updated"), @ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to authorize, failed to process package, etc.)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void updateSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @ApiParam(value="URL of sink's archive") @FormDataParam(value="url") String sinkPkgUrl, @ApiParam(value="A JSON value presenting a sink config playload. All available configuration options are:  \nclassname  \n   The sink's class name if archive is file-url-path (file://)  \nsourceSubscriptionName  \n   Pulsar source subscription name if user wants a specific  \n   subscription-name for input-topic consumer  \ninputs  \n   The sink's input topic or topics (specified as a JSON array)  \ntopicsPattern  \n   TopicsPattern to consume from list of topics under a namespace that    match the pattern. [input] and [topicsPattern] are mutually    exclusive. Add SerDe class name for a pattern in customSerdeInputs    (supported for java fun only)topicToSerdeClassName  \n   The map of input topics to SerDe class names (specified as a JSON object)  \ntopicToSchemaType  \n   The map of input topics to Schema types or class names (specified as a JSON object)  \ninputSpecs  \n   The map of input topics to its consumer configuration, each configuration has schema of    {\"schemaType\": \"type-x\", \"serdeClassName\": \"name-x\", \"isRegexPattern\": true, \"receiverQueueSize\": 5}  \nconfigs  \n   The map of configs (specified as a JSON object)  \nsecrets  \n   a map of secretName(aka how the secret is going to be \n   accessed in the function via context) to an object that \n   encapsulates how the secret is fetched by the underlying \n   secrets provider. The type of an value here can be found by the \n   SecretProviderConfigurator.getSecretObjectType() method. (specified as a JSON object)  \nparallelism  \n   The sink's parallelism factor (i.e. the number of sink instances to run \nprocessingGuarantees  \n   The processing guarantees (aka delivery semantics) applied to the sink. Possible Values: \"ATLEAST_ONCE\", \"ATMOST_ONCE\", \"EFFECTIVELY_ONCE\"  \nretainOrdering  \n   Boolean denotes whether sink consumes and sinks messages in order  \nresources  \n   {\"cpu\": 1, \"ram\": 2, \"disk\": 3} The CPU (in cores), RAM (in bytes) and disk (in bytes) that needs to be allocated per sink instance (applicable only to Docker runtime)  \nautoAck  \n   Boolean denotes whether or not the framework will automatically acknowledge messages  \ntimeoutMs  \n   Long denotes the message timeout in milliseconds  \ncleanupSubscription  \n   Boolean denotes whether the subscriptions the functions created/used should be deleted when the functions is deleted  \nruntimeFlags  \n   Any flags that you want to pass to the runtime as a single string  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{  \n\t\"classname\": \"org.example.SinkStressTest\",  \n\t\"inputs\": [\"persistent://public/default/sink-input\"],\n\t\"processingGuarantees\": \"EFFECTIVELY_ONCE\",\n\t\"parallelism\": 5\n}")})) @FormDataParam(value="sinkConfig") SinkConfig sinkConfig, @ApiParam(value="Update options for sink") @FormDataParam(value="updateOptions") UpdateOptions updateOptions) {
        this.sink.updateSink(tenant, namespace, sinkName, uploadedInputStream, fileDetail, sinkPkgUrl, sinkConfig, this.clientAppId(), this.clientAuthData(), updateOptions);
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Sink currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid deregister request"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=200, message="The sink was successfully deleted"), @ApiResponse(code=401, message="Client is not authorized to perform operation"), @ApiResponse(code=500, message="Internal server error (failed to authorize, failed to deregister, etc.)"), @ApiResponse(code=408, message="Got InterruptedException while deregistering the sink"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public void deregisterSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) {
        this.sink.deregisterFunction(tenant, namespace, sinkName, this.clientAppId(), this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Sink currently running in cluster mode", response=SinkConfig.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public SinkConfig getSinkInfo(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sink.getSinkInfo(tenant, namespace, sinkName);
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink instance", response=SinkStatus.SinkInstanceStatus.SinkInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="The sink instance does not exist"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal Server Error (got exception while getting status, etc.)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/status")
    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkInstanceStatus(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @ApiParam(value="The sink instanceId") @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.sink.getSinkInstanceStatus(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink running in cluster mode", response=SinkStatus.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid get status request"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/status")
    public SinkStatus getSinkStatus(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sink.getSinkStatus(tenant, namespace, sinkName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Sinks currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid list request"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=500, message="Internal server error (failed to authorize, etc.)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}")
    public List<String> listSinks(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace) {
        return this.sink.listFunctions(tenant, namespace, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid restart request"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to restart the sink instance, failed to authorize, etc.)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @ApiParam(value="The sink instanceId") @PathParam(value="instanceId") String instanceId) {
        this.sink.restartFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid restart request"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to restart the sink, failed to authorize, etc.)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) {
        this.sink.restartFunctionInstances(tenant, namespace, sinkName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid stop request"), @ApiResponse(code=404, message="The sink instance does not exist"), @ApiResponse(code=500, message="Internal server error (failed to stop the sink, failed to authorize, etc.)"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @ApiParam(value="The sink instanceId") @PathParam(value="instanceId") String instanceId) {
        this.sink.stopFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid stop request"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to stop the sink, failed to authorize, etc.)"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) {
        this.sink.stopFunctionInstances(tenant, namespace, sinkName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid start request"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to start the sink, failed to authorize, etc.)"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName, @ApiParam(value="The sink instanceId") @PathParam(value="instanceId") String instanceId) {
        this.sink.startFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid start request"), @ApiResponse(code=404, message="The sink does not exist"), @ApiResponse(code=500, message="Internal server error (failed to start the sink, failed to authorize, etc.)"), @ApiResponse(code=401, message="The client is not authorized to perform this operation"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/start")
    @Consumes(value={"application/json"})
    public void startSink(@ApiParam(value="The sink's tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The sink's namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The sink's name") @PathParam(value="sinkName") String sinkName) {
        this.sink.startFunctionInstances(tenant, namespace, sinkName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO sink connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Get builtin sinks successfully.")})
    @Path(value="/builtinsinks")
    public List<ConnectorDefinition> getSinkList() {
        List connectorDefinitions = this.sink.getListOfConnectors();
        ArrayList<ConnectorDefinition> retval = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((String)connectorDefinition.getSinkClass())) continue;
            retval.add(connectorDefinition);
        }
        return retval;
    }
}

