/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.common.functions.UpdateOptions;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.SourceStatus;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.api.SourcesImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

public class SourcesBase
extends AdminResource
implements Supplier<WorkerService> {
    private final SourcesImpl source = new SourcesImpl((Supplier)this);

    @Override
    public WorkerService get() {
        return this.pulsar().getWorkerService();
    }

    @POST
    @ApiOperation(value="Creates a new Pulsar Source in cluster mode")
    @ApiResponses(value={@ApiResponse(code=200, message="Pulsar Function successfully created"), @ApiResponse(code=400, message="Invalid request (Function already exists or Tenant, Namespace or Name is not provided, etc.)"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    @Consumes(value={"multipart/form-data"})
    public void registerSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of source") @PathParam(value="sourceName") String sourceName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String sourcePkgUrl, @ApiParam(value="A JSON value presenting source configuration payload. An example of the expected functions can be found here.  \nclassname  \n  The source's class name if archive is file-url-path (file://).  \ntopicName  \n  The Pulsar topic to which data is sent.  \nserdeClassName  \n  The SerDe classname for the source.  \nschemaType  \n  The schema type (either a builtin schema like 'avro', 'json', etc.. or    custom Schema class name to be used to encode messages emitted from the source  \nconfigs  \n  Source config key/values  \nsecrets  \n  This is a map of secretName(that is how the secret is going to be accessed in the function via context) to an object that  encapsulates how the secret is fetched by the underlying secrets provider. The type of an value here can be found by the  SecretProviderConfigurator.getSecretObjectType() method. \nparallelism  \n  The source's parallelism factor (i.e. the number of source instances to run).  \nprocessingGuarantees  \n  The processing guarantees (aka delivery semantics) applied to the source    Possible Values: [ATLEAST_ONCE, ATMOST_ONCE, EFFECTIVELY_ONCE]  \nresources  \n  The size of the system resources allowed by the source runtime. The resources include: cpu, ram, disk.  \narchive  \n  The path to the NAR archive for the Source. It also supports url-path   [http/https/file (file protocol assumes that file already exists on worker host)]   from which worker can download the package.  \nruntimeFlags  \n  Any flags that you want to pass to the runtime.  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"tenant\": public\n  \"namespace\": default\n  \"name\": pulsar-io-mysql\n  \"className\": TestSourceMysql\n  \"topicName\": pulsar-io-mysql\n  \"parallelism\": 1\n  \"archive\": /connectors/pulsar-io-mysql-0.0.1.nar\n  \"schemaType\": avro\n}\n")})) @FormDataParam(value="sourceConfig") SourceConfig sourceConfig) {
        this.source.registerSource(tenant, namespace, sourceName, uploadedInputStream, fileDetail, sourcePkgUrl, sourceConfig, this.clientAppId(), this.clientAuthData());
    }

    @PUT
    @ApiOperation(value="Updates a Pulsar Source currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request (Function already exists or Tenant, Namespace or Name is not provided, etc.)"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=200, message="Pulsar Function successfully updated"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    @Consumes(value={"multipart/form-data"})
    public void updateSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of source") @PathParam(value="sourceName") String sourceName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @ApiParam(value="URL of sources' archive") @FormDataParam(value="url") String sourcePkgUrl, @ApiParam(value="A JSON value presenting source configuration payload. An example of the expected functions can be found here.  \nclassname  \n  The source's class name if archive is file-url-path (file://).  \ntopicName  \n  The Pulsar topic to which data is sent.  \nserdeClassName  \n  The SerDe classname for the source.  \nschemaType  \n  The schema type (either a builtin schema like 'avro', 'json', etc.. or    custom Schema class name to be used to encode messages emitted from the source  \nconfigs  \n  Source config key/values  \nsecrets  \n  This is a map of secretName(that is how the secret is going to be accessed in the function via context) to an object that  encapsulates how the secret is fetched by the underlying secrets provider. The type of an value here can be found by the  SecretProviderConfigurator.getSecretObjectType() method. \nparallelism  \n  The source's parallelism factor (i.e. the number of source instances to run).  \nprocessingGuarantees  \n  The processing guarantees (aka delivery semantics) applied to the source    Possible Values: [ATLEAST_ONCE, ATMOST_ONCE, EFFECTIVELY_ONCE]  \nresources  \n  The size of the system resources allowed by the source runtime. The resources include: cpu, ram, disk.  \narchive  \n  The path to the NAR archive for the Source. It also supports url-path   [http/https/file (file protocol assumes that file already exists on worker host)]   from which worker can download the package.  \nruntimeFlags  \n  Any flags that you want to pass to the runtime.  \n", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"tenant\": public\n  \"namespace\": default\n  \"name\": pulsar-io-mysql\n  \"className\": TestSourceMysql\n  \"topicName\": pulsar-io-mysql\n  \"parallelism\": 1\n  \"archive\": /connectors/pulsar-io-mysql-0.0.1.nar\n  \"schemaType\": avro\n}\n")})) @FormDataParam(value="sourceConfig") SourceConfig sourceConfig, @ApiParam(value="Update options for source") @FormDataParam(value="updateOptions") UpdateOptions updateOptions) {
        this.source.updateSource(tenant, namespace, sourceName, uploadedInputStream, fileDetail, sourcePkgUrl, sourceConfig, this.clientAppId(), this.clientAuthData(), updateOptions);
    }

    @DELETE
    @ApiOperation(value="Deletes a Pulsar Source currently running in cluster mode")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=200, message="The function was successfully deleted"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    public void deregisterSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) {
        this.source.deregisterFunction(tenant, namespace, sourceName, this.clientAppId(), this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetches information about a Pulsar Source currently running in cluster mode", response=SourceConfig.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}")
    public SourceConfig getSourceInfo(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) throws IOException {
        return this.source.getSourceInfo(tenant, namespace, sourceName);
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Source instance", response=SourceStatus.SourceInstanceStatus.SourceInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/status")
    public SourceStatus.SourceInstanceStatus.SourceInstanceStatusData getSourceInstanceStatus(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName, @ApiParam(value="The source instanceId (if instance-id is not provided, the stats of all instances is returned).") @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.source.getSourceInstanceStatus(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Source running in cluster mode", response=SourceStatus.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sourceName}/status")
    public SourceStatus getSourceStatus(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) throws IOException {
        return this.source.getSourceStatus(tenant, namespace, sourceName, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Lists all Pulsar Sources currently deployed in a given namespace", response=String.class, responseContainer="Collection")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Consumes(value={"application/json"})
    @Path(value="/{tenant}/{namespace}")
    public List<String> listSources(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace) {
        return this.source.listFunctions(tenant, namespace, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName, @ApiParam(value="The source instanceId (if instance-id is not provided, the stats of all instances is returned).") @PathParam(value="instanceId") String instanceId) {
        this.source.restartFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Restart all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/restart")
    @Consumes(value={"application/json"})
    public void restartSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) {
        this.source.restartFunctionInstances(tenant, namespace, sourceName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName, @ApiParam(value="The source instanceId (if instance-id is not provided, the stats of all instances is returned).") @PathParam(value="instanceId") String instanceId) {
        this.source.stopFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Stop all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/stop")
    @Consumes(value={"application/json"})
    public void stopSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) {
        this.source.stopFunctionInstances(tenant, namespace, sourceName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start source instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName, @ApiParam(value="The source instanceId (if instance-id is not provided, the stats of all instances is returned).") @PathParam(value="instanceId") String instanceId) {
        this.source.startFunctionInstance(tenant, namespace, sourceName, instanceId, this.uri.getRequestUri(), this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @POST
    @ApiOperation(value="Start all source instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=401, message="Client is not authorize to perform operation"), @ApiResponse(code=404, message="Not Found(The source doesn't exist)"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Path(value="/{tenant}/{namespace}/{sourceName}/start")
    @Consumes(value={"application/json"})
    public void startSource(@ApiParam(value="The name of tenant") @PathParam(value="tenant") String tenant, @ApiParam(value="The name of namespace") @PathParam(value="namespace") String namespace, @ApiParam(value="The name of name") @PathParam(value="sourceName") String sourceName) {
        this.source.startFunctionInstances(tenant, namespace, sourceName, this.clientAppId(), (AuthenticationDataSource)this.clientAuthData());
    }

    @GET
    @ApiOperation(value="Fetches a list of supported Pulsar IO source connectors currently running in cluster mode", response=List.class)
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=408, message="Request timeout"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/builtinsources")
    public List<ConnectorDefinition> getSourceList() {
        List connectorDefinitions = this.source.getListOfConnectors();
        ArrayList<ConnectorDefinition> retval = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((String)connectorDefinition.getSourceClass())) continue;
            retval.add(connectorDefinition);
        }
        return retval;
    }
}

