/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.PulsarStandaloneBuilder;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarStandalone
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PulsarStandalone.class);
    PulsarService broker;
    PulsarAdmin admin;
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    WorkerService fnWorkerService;
    @Parameter(names={"-c", "--config"}, description="Configuration file path", required=true)
    private String configFile;
    @Parameter(names={"--wipe-data"}, description="Clean up previous ZK/BK data")
    private boolean wipeData = false;
    @Parameter(names={"--num-bookies"}, description="Number of local Bookies")
    private int numOfBk = 1;
    @Parameter(names={"--zookeeper-port"}, description="Local zookeeper's port")
    private int zkPort = 2181;
    @Parameter(names={"--bookkeeper-port"}, description="Local bookies base port")
    private int bkPort = 3181;
    @Parameter(names={"--zookeeper-dir"}, description="Local zooKeeper's data directory")
    private String zkDir = "data/standalone/zookeeper";
    @Parameter(names={"--bookkeeper-dir"}, description="Local bookies base data directory")
    private String bkDir = "data/standalone/bookkeeper";
    @Parameter(names={"--no-broker"}, description="Only start ZK and BK services, no broker")
    private boolean noBroker = false;
    @Parameter(names={"--only-broker"}, description="Only start Pulsar broker service (no ZK, BK)")
    private boolean onlyBroker = false;
    @Parameter(names={"-nfw", "--no-functions-worker"}, description="Run functions worker with Broker")
    private boolean noFunctionsWorker = false;
    @Parameter(names={"-fwc", "--functions-worker-conf"}, description="Configuration file for Functions Worker")
    private String fnWorkerConfigFile = Paths.get("", new String[0]).toAbsolutePath().normalize().toString() + "/conf/functions_worker.yml";
    @Parameter(names={"-nss", "--no-stream-storage"}, description="Disable stream storage")
    private boolean noStreamStorage = false;
    @Parameter(names={"--stream-storage-port"}, description="Local bookies stream storage port")
    private int streamStoragePort = 4181;
    @Parameter(names={"-a", "--advertised-address"}, description="Standalone broker advertised address")
    private String advertisedAddress = null;
    @Parameter(names={"-h", "--help"}, description="Show this help message")
    private boolean help = false;

    public void setBroker(PulsarService broker) {
        this.broker = broker;
    }

    public void setAdmin(PulsarAdmin admin) {
        this.admin = admin;
    }

    public void setBkEnsemble(LocalBookkeeperEnsemble bkEnsemble) {
        this.bkEnsemble = bkEnsemble;
    }

    public void setBkPort(int bkPort) {
        this.bkPort = bkPort;
    }

    public void setBkDir(String bkDir) {
        this.bkDir = bkDir;
    }

    public void setAdvertisedAddress(String advertisedAddress) {
        this.advertisedAddress = advertisedAddress;
    }

    public void setConfig(ServiceConfiguration config) {
        this.config = config;
    }

    public void setFnWorkerService(WorkerService fnWorkerService) {
        this.fnWorkerService = fnWorkerService;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setWipeData(boolean wipeData) {
        this.wipeData = wipeData;
    }

    public void setNumOfBk(int numOfBk) {
        this.numOfBk = numOfBk;
    }

    public void setZkPort(int zkPort) {
        this.zkPort = zkPort;
    }

    public void setZkDir(String zkDir) {
        this.zkDir = zkDir;
    }

    public void setNoBroker(boolean noBroker) {
        this.noBroker = noBroker;
    }

    public void setOnlyBroker(boolean onlyBroker) {
        this.onlyBroker = onlyBroker;
    }

    public void setNoFunctionsWorker(boolean noFunctionsWorker) {
        this.noFunctionsWorker = noFunctionsWorker;
    }

    public void setFnWorkerConfigFile(String fnWorkerConfigFile) {
        this.fnWorkerConfigFile = fnWorkerConfigFile;
    }

    public void setNoStreamStorage(boolean noStreamStorage) {
        this.noStreamStorage = noStreamStorage;
    }

    public void setStreamStoragePort(int streamStoragePort) {
        this.streamStoragePort = streamStoragePort;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public ServiceConfiguration getConfig() {
        return this.config;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public boolean isWipeData() {
        return this.wipeData;
    }

    public int getNumOfBk() {
        return this.numOfBk;
    }

    public int getZkPort() {
        return this.zkPort;
    }

    public int getBkPort() {
        return this.bkPort;
    }

    public String getZkDir() {
        return this.zkDir;
    }

    public String getBkDir() {
        return this.bkDir;
    }

    public boolean isNoBroker() {
        return this.noBroker;
    }

    public boolean isOnlyBroker() {
        return this.onlyBroker;
    }

    public boolean isNoFunctionsWorker() {
        return this.noFunctionsWorker;
    }

    public String getFnWorkerConfigFile() {
        return this.fnWorkerConfigFile;
    }

    public boolean isNoStreamStorage() {
        return this.noStreamStorage;
    }

    public int getStreamStoragePort() {
        return this.streamStoragePort;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void start() throws Exception {
        if (this.config == null) {
            System.exit(1);
        }
        log.debug("--- setup PulsarStandaloneStarter ---");
        if (!this.isOnlyBroker()) {
            ServerConfiguration bkServerConf = new ServerConfiguration();
            bkServerConf.loadConf(new File(this.configFile).toURI().toURL());
            this.bkEnsemble = new LocalBookkeeperEnsemble(this.getNumOfBk(), this.getZkPort(), this.getBkPort(), this.getStreamStoragePort(), this.getZkDir(), this.getBkDir(), this.isWipeData(), "127.0.0.1");
            this.bkEnsemble.startStandalone(bkServerConf, !this.isNoStreamStorage());
        }
        if (this.isNoBroker()) {
            return;
        }
        if (!this.isNoFunctionsWorker()) {
            WorkerConfig workerConfig = StringUtils.isBlank((CharSequence)this.getFnWorkerConfigFile()) ? new WorkerConfig() : WorkerConfig.load((String)this.getFnWorkerConfigFile());
            boolean useTls = workerConfig.isUseTls();
            String pulsarServiceUrl = useTls ? PulsarService.brokerUrlTls(this.config) : PulsarService.brokerUrl(this.config);
            String webServiceUrl = useTls ? PulsarService.webAddressTls(this.config) : PulsarService.webAddress(this.config);
            workerConfig.setPulsarServiceUrl(pulsarServiceUrl);
            workerConfig.setPulsarWebServiceUrl(webServiceUrl);
            if (this.isNoStreamStorage()) {
                workerConfig.setStateStorageServiceUrl(null);
            } else if (workerConfig.getStateStorageServiceUrl() == null) {
                workerConfig.setStateStorageServiceUrl("bk://127.0.0.1:" + this.getStreamStoragePort());
            }
            String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)this.config.getAdvertisedAddress());
            workerConfig.setWorkerHostname(hostname);
            workerConfig.setWorkerPort((Integer)this.config.getWebServicePort().get());
            workerConfig.setWorkerId("c-" + this.config.getClusterName() + "-fw-" + hostname + "-" + workerConfig.getWorkerPort());
            workerConfig.setAuthenticationEnabled(this.config.isAuthenticationEnabled());
            workerConfig.setAuthenticationProviders(this.config.getAuthenticationProviders());
            workerConfig.setAuthorizationEnabled(this.config.isAuthorizationEnabled());
            workerConfig.setAuthorizationProvider(this.config.getAuthorizationProvider());
            workerConfig.setConfigurationStoreServers(this.config.getConfigurationStoreServers());
            workerConfig.setZooKeeperSessionTimeoutMillis(this.config.getZooKeeperSessionTimeoutMillis());
            workerConfig.setZooKeeperOperationTimeoutSeconds(this.config.getZooKeeperOperationTimeoutSeconds());
            workerConfig.setUseTls(useTls);
            workerConfig.setTlsHostnameVerificationEnable(false);
            workerConfig.setTlsAllowInsecureConnection(this.config.isTlsAllowInsecureConnection());
            workerConfig.setTlsTrustCertsFilePath(this.config.getTlsTrustCertsFilePath());
            workerConfig.setClientAuthenticationPlugin(this.config.getBrokerClientAuthenticationPlugin());
            workerConfig.setClientAuthenticationParameters(this.config.getBrokerClientAuthenticationParameters());
            workerConfig.setSuperUserRoles(this.config.getSuperUserRoles());
            this.fnWorkerService = new WorkerService(workerConfig);
        }
        this.broker = new PulsarService(this.config, Optional.ofNullable(this.fnWorkerService));
        this.broker.start();
        URL webServiceUrl = new URL(String.format("http://%s:%d", this.config.getAdvertisedAddress(), this.config.getWebServicePort().get()));
        String brokerServiceUrl = String.format("pulsar://%s:%d", this.config.getAdvertisedAddress(), this.config.getBrokerServicePort().get());
        this.admin = PulsarAdmin.builder().serviceHttpUrl(webServiceUrl.toString()).authentication(this.config.getBrokerClientAuthenticationPlugin(), this.config.getBrokerClientAuthenticationParameters()).build();
        String cluster = this.config.getClusterName();
        this.createSampleNameSpace(webServiceUrl, brokerServiceUrl, cluster);
        this.createDefaultNameSpace(cluster);
        log.debug("--- setup completed ---");
    }

    private void createDefaultNameSpace(String cluster) {
        String publicTenant = "public";
        String defaultNamespace = "public/default";
        try {
            if (!this.admin.tenants().getTenants().contains("public")) {
                this.admin.tenants().createTenant("public", new TenantInfo((Set)Sets.newHashSet((Iterable)this.config.getSuperUserRoles()), (Set)Sets.newHashSet((Object[])new String[]{cluster})));
            }
            if (!this.admin.namespaces().getNamespaces("public").contains("public/default")) {
                this.admin.namespaces().createNamespace("public/default");
                this.admin.namespaces().setNamespaceReplicationClusters("public/default", (Set)Sets.newHashSet((Object[])new String[]{this.config.getClusterName()}));
            }
        }
        catch (PulsarAdminException e) {
            log.info(e.getMessage());
        }
    }

    private void createSampleNameSpace(URL webServiceUrl, String brokerServiceUrl, String cluster) {
        String property = "sample";
        String globalCluster = "global";
        String namespace = "sample/" + cluster + "/ns1";
        try {
            ClusterData clusterData = new ClusterData(webServiceUrl.toString(), null, brokerServiceUrl, null);
            if (!this.admin.clusters().getClusters().contains(cluster)) {
                this.admin.clusters().createCluster(cluster, clusterData);
            } else {
                this.admin.clusters().updateCluster(cluster, clusterData);
            }
            if (!this.admin.clusters().getClusters().contains("global")) {
                this.admin.clusters().createCluster("global", new ClusterData(null, null));
            }
            if (!this.admin.tenants().getTenants().contains("sample")) {
                this.admin.tenants().createTenant("sample", new TenantInfo((Set)Sets.newHashSet((Iterable)this.config.getSuperUserRoles()), (Set)Sets.newHashSet((Object[])new String[]{cluster})));
            }
            if (!this.admin.namespaces().getNamespaces("sample").contains(namespace)) {
                this.admin.namespaces().createNamespace(namespace);
            }
        }
        catch (PulsarAdminException e) {
            log.info(e.getMessage());
        }
    }

    public static PulsarStandaloneBuilder builder() {
        return PulsarStandaloneBuilder.instance();
    }

    @Override
    public void close() {
        try {
            if (this.fnWorkerService != null) {
                this.fnWorkerService.stop();
            }
            if (this.broker != null) {
                this.broker.close();
            }
            if (this.bkEnsemble != null) {
                this.bkEnsemble.stop();
            }
        }
        catch (Exception e) {
            log.error("Shutdown failed: {}", (Object)e.getMessage());
        }
    }
}

