/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RegionAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.zookeeper.ZkBookieRackAffinityMapping;
import org.apache.pulsar.zookeeper.ZkIsolatedBookieEnsemblePlacementPolicy;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.ZooKeeper;

public class BookKeeperClientFactoryImpl
implements BookKeeperClientFactory {
    private final AtomicReference<ZooKeeperCache> rackawarePolicyZkCache = new AtomicReference();
    private final AtomicReference<ZooKeeperCache> clientIsolationZkCache = new AtomicReference();
    private final AtomicReference<ZooKeeperCache> zkCache = new AtomicReference();

    @Override
    public BookKeeper create(ServiceConfiguration conf, ZooKeeper zkClient, Optional<Class<? extends EnsemblePlacementPolicy>> ensemblePlacementPolicyClass, Map<String, Object> properties) throws IOException {
        ClientConfiguration bkConf = this.createBkClientConfiguration(conf);
        if (properties != null) {
            properties.forEach((key, value) -> bkConf.setProperty(key, value));
        }
        if (ensemblePlacementPolicyClass.isPresent()) {
            this.setEnsemblePlacementPolicy(bkConf, conf, zkClient, ensemblePlacementPolicyClass.get());
        } else {
            BookKeeperClientFactoryImpl.setDefaultEnsemblePlacementPolicy(this.rackawarePolicyZkCache, this.clientIsolationZkCache, bkConf, conf, zkClient);
        }
        try {
            return BookKeeper.forConfig((ClientConfiguration)bkConf).allocator(PulsarByteBufAllocator.DEFAULT).zk(zkClient).build();
        }
        catch (InterruptedException | BKException e) {
            throw new IOException(e);
        }
    }

    private ClientConfiguration createBkClientConfiguration(ServiceConfiguration conf) {
        ClientConfiguration bkConf = new ClientConfiguration();
        if (conf.getBookkeeperClientAuthenticationPlugin() != null && conf.getBookkeeperClientAuthenticationPlugin().trim().length() > 0) {
            bkConf.setClientAuthProviderFactoryClass(conf.getBookkeeperClientAuthenticationPlugin());
            bkConf.setProperty(conf.getBookkeeperClientAuthenticationParametersName(), (Object)conf.getBookkeeperClientAuthenticationParameters());
        }
        bkConf.setThrottleValue(0);
        bkConf.setAddEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setReadEntryTimeout((int)conf.getBookkeeperClientTimeoutInSeconds());
        bkConf.setSpeculativeReadTimeout(conf.getBookkeeperClientSpeculativeReadTimeoutInMillis());
        bkConf.setNumChannelsPerBookie(16);
        bkConf.setUseV2WireProtocol(conf.isBookkeeperUseV2WireProtocol());
        bkConf.setEnableDigestTypeAutodetection(true);
        bkConf.setStickyReadsEnabled(conf.isBookkeeperEnableStickyReads());
        bkConf.setNettyMaxFrameSizeBytes(conf.getMaxMessageSize() + 10240);
        if (conf.isBookkeeperClientHealthCheckEnabled()) {
            bkConf.enableBookieHealthCheck();
            bkConf.setBookieHealthCheckInterval(conf.getBookkeeperHealthCheckIntervalSec(), TimeUnit.SECONDS);
            bkConf.setBookieErrorThresholdPerInterval(conf.getBookkeeperClientHealthCheckErrorThresholdPerInterval());
            bkConf.setBookieQuarantineTime((int)conf.getBookkeeperClientHealthCheckQuarantineTimeInSeconds(), TimeUnit.SECONDS);
        }
        bkConf.setReorderReadSequenceEnabled(conf.isBookkeeperClientReorderReadSequenceEnabled());
        return bkConf;
    }

    public static void setDefaultEnsemblePlacementPolicy(AtomicReference<ZooKeeperCache> rackawarePolicyZkCache, AtomicReference<ZooKeeperCache> clientIsolationZkCache, ClientConfiguration bkConf, ServiceConfiguration conf, ZooKeeper zkClient) {
        ZooKeeperCache zkc;
        if (conf.isBookkeeperClientRackawarePolicyEnabled() || conf.isBookkeeperClientRegionawarePolicyEnabled()) {
            if (conf.isBookkeeperClientRegionawarePolicyEnabled()) {
                bkConf.setEnsemblePlacementPolicy(RegionAwareEnsemblePlacementPolicy.class);
                bkConf.setProperty("reppEnableValidation", (Object)conf.getProperties().getProperty("reppEnableValidation", "true"));
                bkConf.setProperty("reppRegionsToWrite", (Object)conf.getProperties().getProperty("reppRegionsToWrite", null));
                bkConf.setProperty("reppMinimumRegionsForDurability", (Object)conf.getProperties().getProperty("reppMinimumRegionsForDurability", "2"));
                bkConf.setProperty("reppEnableDurabilityEnforcementInReplace", (Object)conf.getProperties().getProperty("reppEnableDurabilityEnforcementInReplace", "true"));
            } else {
                bkConf.setEnsemblePlacementPolicy(RackawareEnsemblePlacementPolicy.class);
            }
            bkConf.setProperty("reppDnsResolverClass", (Object)conf.getProperties().getProperty("reppDnsResolverClass", ZkBookieRackAffinityMapping.class.getName()));
            zkc = new ZooKeeperCache(zkClient, conf.getZooKeeperOperationTimeoutSeconds()){};
            if (!rackawarePolicyZkCache.compareAndSet(null, zkc)) {
                zkc.stop();
            }
            bkConf.setProperty("zk_cache_instance", (Object)rackawarePolicyZkCache.get());
        }
        if (conf.getBookkeeperClientIsolationGroups() != null && !conf.getBookkeeperClientIsolationGroups().isEmpty()) {
            bkConf.setEnsemblePlacementPolicy(ZkIsolatedBookieEnsemblePlacementPolicy.class);
            bkConf.setProperty("isolationBookieGroups", (Object)conf.getBookkeeperClientIsolationGroups());
            bkConf.setProperty("secondaryIsolationBookieGroups", (Object)conf.getBookkeeperClientSecondaryIsolationGroups());
            if (bkConf.getProperty("zk_cache_instance") == null) {
                zkc = new ZooKeeperCache(zkClient, conf.getZooKeeperOperationTimeoutSeconds()){};
                if (!clientIsolationZkCache.compareAndSet(null, zkc)) {
                    zkc.stop();
                }
                bkConf.setProperty("zk_cache_instance", (Object)clientIsolationZkCache.get());
            }
        }
    }

    private void setEnsemblePlacementPolicy(ClientConfiguration bkConf, ServiceConfiguration conf, ZooKeeper zkClient, Class<? extends EnsemblePlacementPolicy> policyClass) {
        bkConf.setEnsemblePlacementPolicy(policyClass);
        if (bkConf.getProperty("zk_cache_instance") == null) {
            ZooKeeperCache zkc = new ZooKeeperCache(zkClient, conf.getZooKeeperOperationTimeoutSeconds()){};
            if (!this.zkCache.compareAndSet(null, zkc)) {
                zkc.stop();
            }
            bkConf.setProperty("zk_cache_instance", (Object)this.zkCache.get());
        }
    }

    @Override
    public void close() {
        if (this.rackawarePolicyZkCache.get() != null) {
            this.rackawarePolicyZkCache.get().stop();
        }
        if (this.clientIsolationZkCache.get() != null) {
            this.clientIsolationZkCache.get().stop();
        }
        if (this.zkCache.get() != null) {
            this.zkCache.get().stop();
        }
    }
}

