/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.Codec;

@Path(value="/persistent")
@Produces(value={"application/json"})
@Api(value="/persistent", description="Persistent topic admin apis", tags={"persistent topic"})
public class PersistentTopics
extends PersistentTopicsBase {
    @GET
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Get the list of topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void getList(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(tenant, namespace);
            asyncResponse.resume(this.internalGetList());
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/partitioned")
    @ApiOperation(value="Get the list of partitioned topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public List<String> getPartitionedTopicList(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetPartitionedTopicList();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/permissions")
    @ApiOperation(value="Get permissions on a topic.", notes="Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at thenamespace level combined (union) with any eventual specific permission set on the topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public Map<String, Set<AuthAction>> getPermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPermissionsOnTopic();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Grant a new permission to a role on a single topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void grantPermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Client role to which grant permissions", required=true) @PathParam(value="role") String role, @ApiParam(value="Actions to be granted (produce,functions,consume)", allowableValues="produce,functions,consume") Set<AuthAction> actions) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGrantPermissionsOnTopic(role, actions);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Revoke permissions on a topic.", notes="Revoke permissions to a role on a single topic. If the permission was not set at the topiclevel, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Permissions are not set at the topic level"), @ApiResponse(code=500, message="Internal server error")})
    public void revokePermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Client role to which grant permissions", required=true) @PathParam(value="role") String role) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalRevokePermissionsOnTopic(role);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Partitioned topic already exist"), @ApiResponse(code=412, message="Failed Reason : Name is invalid or Namespace does not have any clusters configured"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createPartitionedTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The number of partitions for the topic", required=true, type="int", defaultValue="0") int numPartitions) {
        this.validateGlobalNamespaceOwnership(tenant, namespace);
        this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
        this.internalCreatePartitionedTopic(numPartitions);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Create a non-partitioned topic.", notes="This is the only REST endpoint from which non-partitioned topics could be created.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic already exist"), @ApiResponse(code=412, message="Failed Reason : Name is invalid or Namespace does not have any clusters configured"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createNonPartitionedTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateGlobalNamespaceOwnership(tenant, namespace);
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalCreateNonPartitionedTopic(authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Increment partitons of an existing partitioned topic.", notes="It only increments partitions of existing non-global partitioned-topic")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to adminisActions to be grantedtrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=406, message="The number of partitions should be more than 0"), @ApiResponse(code=409, message="Partitioned topic does not exist"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public void updatePartitionedTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The number of partitions for the topic", required=true, type="int", defaultValue="0") int numPartitions) {
        this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
        this.internalUpdatePartitionedTopic(numPartitions);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Get partitioned topic metadata.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public PartitionedTopicMetadata getPartitionedMetadata(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="Is check configuration required to automatically create topic") @QueryParam(value="checkAllowAutoCreation") @DefaultValue(value="false") boolean checkAllowAutoCreation) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPartitionedMetadata(authoritative, checkAllowAutoCreation);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Delete a partitioned topic.", notes="It will also delete all the partitions of the topic if it exists.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Partitioned topic does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public void deletePartitionedTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Stop all producer/consumer/replicator and delete topic forcefully", defaultValue="false", type="boolean") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.internalDeletePartitionedTopic(asyncResponse, authoritative, force);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/unload")
    @ApiOperation(value="Unload a topic")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Topic name is not valid or can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void unloadTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalUnloadTopic(authoritative);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Delete a topic.", notes="The topic cannot be deleted if delete is not forcefully and there's any active subscription or producer connected to the it. Force delete ignores connected clients and deletes topic by explicitly closing them.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic has active producers/subscriptions"), @ApiResponse(code=500, message="Internal server error")})
    public void deleteTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Stop all producer/consumer/replicator and delete topic forcefully", defaultValue="false", type="boolean") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalDeleteTopic(authoritative, force);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptions")
    @ApiOperation(value="Get the list of persistent subscriptions for a given topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getSubscriptions(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetSubscriptions(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public TopicStats getStats(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetStats(authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internalStats")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public PersistentTopicInternalStats getInternalStats(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetInternalStats(authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internal-info")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getManagedLedgerInfo(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @Suspended AsyncResponse asyncResponse) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetManagedLedgerInfo(asyncResponse);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/partitioned-stats")
    @ApiOperation(value="Get the stats for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getPartitionedStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Get per partition stats") @QueryParam(value="perPartition") @DefaultValue(value="true") boolean perPartition, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.internalGetPartitionedStats(asyncResponse, authoritative, perPartition);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/partitioned-internalStats")
    @ApiOperation(hidden=true, value="Get the stats-internal for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getPartitionedStatsInternal(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetPartitionedStatsInternal(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}")
    @ApiOperation(value="Delete a subscription.", notes="There should not be any active consumers on the subscription.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Subscription has active consumers"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void deleteSubscription(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to be deleted") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalDeleteSubscription(asyncResponse, Codec.decode((String)encodedSubName), authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip_all")
    @ApiOperation(value="Skip all messages on a topic subscription.", notes="Completely clears the backlog on the subscription.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=412, message="Can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void skipAllMessages(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Name of subscription") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalSkipAllMessages(asyncResponse, Codec.decode((String)encodedSubName), authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip/{numMessages}")
    @ApiOperation(value="Skipping messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Skipping messages on a partitioned topic is not allowed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void skipMessages(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Name of subscription") @PathParam(value="subName") String encodedSubName, @ApiParam(value="The number of messages to skip", defaultValue="0") @PathParam(value="numMessages") int numMessages, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalSkipMessages(Codec.decode((String)encodedSubName), numMessages, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expiry messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Expiry messages on a non-persistent topic is not allowed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void expireTopicMessages(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to be Expiry messages on") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Expires beyond the specified number of seconds", defaultValue="0") @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalExpireMessages(asyncResponse, Codec.decode((String)encodedSubName), expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/all_subscription/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expiry messages on all subscriptions of topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Expiry messages on a non-persistent topic is not allowed"), @ApiResponse(code=412, message="Can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void expireMessagesForAllSubscriptions(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Expires beyond the specified number of seconds", defaultValue="0") @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalExpireMessagesForAllSubscriptions(asyncResponse, expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subscriptionName}")
    @ApiOperation(value="Reset subscription to message position closest to given position.", notes="Creates a subscription on the topic at the specified message id")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createSubscription(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String topic, @ApiParam(value="Subscription to create position on", required=true) @PathParam(value="subscriptionName") String encodedSubName, @ApiParam(value="messageId where to create the subscription. It can be 'latest', 'earliest' or (ledgerId:entryId)", defaultValue="latest", allowableValues="latest,earliest,ledgerId:entryId") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="replicated") boolean replicated) {
        try {
            this.validateTopicName(tenant, namespace, topic);
            this.internalCreateSubscription(asyncResponse, Codec.decode((String)encodedSubName), messageId, authoritative, replicated);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor/{timestamp}")
    @ApiOperation(value="Reset subscription to message position closest to absolute timestamp (in ms).", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Method Not Allowed"), @ApiResponse(code=412, message="Failed to reset cursor on subscription or Unable to find position for timestamp specified"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void resetCursor(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to reset position on", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="time in minutes to reset back to (or minutes, hours,days,weeks eg:100m, 3h, 2d, 5w)") @PathParam(value="timestamp") long timestamp, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalResetCursor(asyncResponse, Codec.decode((String)encodedSubName), timestamp, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor")
    @ApiOperation(value="Reset subscription to message position closest to given position.", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics"), @ApiResponse(code=412, message="Unable to find position for position specified"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void resetCursorOnPosition(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(name="subName", value="Subscription to reset position on", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(name="messageId", value="messageId to reset back to (ledgerId:entryId)") MessageIdImpl messageId) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalResetCursorOnPosition(Codec.decode((String)encodedSubName), authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/position/{messagePosition}")
    @ApiOperation(value="Peek nth message on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, subscription or the message position does not exist"), @ApiResponse(code=405, message="Skipping messages on a non-persistent topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public Response peekNthMessage(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(name="subName", value="Subscribed message expired", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="The number of messages (default 1)", defaultValue="1") @PathParam(value="messagePosition") int messagePosition, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalPeekNthMessage(Codec.decode((String)encodedSubName), messagePosition, authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/backlog")
    @ApiOperation(value="Get estimated backlog for offline topic.")
    @ApiResponses(value={@ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public PersistentOfflineTopicStats getBacklog(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetBacklog(authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/terminate")
    @ApiOperation(value="Terminate a topic. A topic that is terminated will not accept any more messages to be published and will let consumer to drain existing messages in backlog")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Termination of a partitioned topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public MessageId terminate(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalTerminate(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Trigger a compaction operation on a topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=409, message="Compaction already running"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void compact(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTriggerCompaction(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Get the status of a compaction operation for a topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist, or compaction hasn't run"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public LongRunningProcessStatus compactionStatus(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalCompactionStatus(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=409, message="Offload already running"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void triggerOffload(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTriggerOffload(authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public OffloadProcessStatus offloadStatus(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalOffloadStatus(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/lastMessageId")
    @ApiOperation(value="Return the last commit message id of topic")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public MessageId getLastMessageId(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetLastMessageId(authoritative);
    }
}

