/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectSet;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.service.AbstractBaseDispatcher;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.PersistentStickyKeyDispatcherMultipleConsumers;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.utils.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherMultipleConsumers
extends AbstractBaseDispatcher {
    protected final CopyOnWriteArrayList<Consumer> consumerList = new CopyOnWriteArrayList();
    protected final ObjectSet<Consumer> consumerSet = new ObjectHashSet();
    protected volatile int currentConsumerRoundRobinIndex = 0;
    protected static final int FALSE = 0;
    protected static final int TRUE = 1;
    protected static final AtomicIntegerFieldUpdater<AbstractDispatcherMultipleConsumers> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractDispatcherMultipleConsumers.class, "isClosed");
    private volatile int isClosed = 0;
    public static final String NONE_KEY = "NONE_KEY";
    private static final Logger log = LoggerFactory.getLogger(PersistentStickyKeyDispatcherMultipleConsumers.class);

    protected AbstractDispatcherMultipleConsumers(Subscription subscription) {
        super(subscription);
    }

    @Override
    public boolean isConsumerConnected() {
        return !this.consumerList.isEmpty();
    }

    @Override
    public CopyOnWriteArrayList<Consumer> getConsumers() {
        return this.consumerList;
    }

    @Override
    public synchronized boolean canUnsubscribe(Consumer consumer) {
        return this.consumerList.size() == 1 && this.consumerSet.contains((Object)consumer);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed == 1;
    }

    @Override
    public PulsarApi.CommandSubscribe.SubType getType() {
        return PulsarApi.CommandSubscribe.SubType.Shared;
    }

    public abstract boolean isConsumerAvailable(Consumer var1);

    public Consumer getNextConsumer() {
        int higherPriorityConsumerIndex;
        int currentRoundRobinConsumerPriority;
        if (this.consumerList.isEmpty() || IS_CLOSED_UPDATER.get(this) == 1) {
            return null;
        }
        if (this.currentConsumerRoundRobinIndex >= this.consumerList.size()) {
            this.currentConsumerRoundRobinIndex = 0;
        }
        if ((currentRoundRobinConsumerPriority = ((Consumer)this.consumerList.get(this.currentConsumerRoundRobinIndex)).getPriorityLevel()) != 0 && (higherPriorityConsumerIndex = this.getConsumerFromHigherPriority(currentRoundRobinConsumerPriority)) != -1) {
            this.currentConsumerRoundRobinIndex = higherPriorityConsumerIndex + 1;
            return (Consumer)this.consumerList.get(higherPriorityConsumerIndex);
        }
        int availableConsumerIndex = this.getNextConsumerFromSameOrLowerLevel(this.currentConsumerRoundRobinIndex);
        if (availableConsumerIndex != -1) {
            this.currentConsumerRoundRobinIndex = availableConsumerIndex + 1;
            return (Consumer)this.consumerList.get(availableConsumerIndex);
        }
        return null;
    }

    private int getConsumerFromHigherPriority(int targetPriority) {
        Consumer consumer;
        for (int i = 0; i < this.currentConsumerRoundRobinIndex && (consumer = (Consumer)this.consumerList.get(i)).getPriorityLevel() < targetPriority; ++i) {
            if (!this.isConsumerAvailable((Consumer)this.consumerList.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getNextConsumerFromSameOrLowerLevel(int currentRoundRobinIndex) {
        int targetPriority = ((Consumer)this.consumerList.get(currentRoundRobinIndex)).getPriorityLevel();
        int scanIndex = currentRoundRobinIndex;
        int endPriorityLevelIndex = currentRoundRobinIndex;
        do {
            Consumer scanConsumer;
            Consumer consumer = scanConsumer = scanIndex < this.consumerList.size() ? (Consumer)this.consumerList.get(scanIndex) : null;
            if (scanConsumer == null || scanConsumer.getPriorityLevel() != targetPriority) {
                endPriorityLevelIndex = scanIndex;
                scanIndex = this.getFirstConsumerIndexOfPriority(targetPriority);
                continue;
            }
            if (this.isConsumerAvailable(scanConsumer)) {
                return scanIndex;
            }
            ++scanIndex;
        } while (scanIndex != currentRoundRobinIndex);
        for (int i = endPriorityLevelIndex; i < this.consumerList.size(); ++i) {
            if (!this.isConsumerAvailable((Consumer)this.consumerList.get(i))) continue;
            return i;
        }
        return -1;
    }

    private int getFirstConsumerIndexOfPriority(int targetPriority) {
        for (int i = 0; i < this.consumerList.size(); ++i) {
            if (((Consumer)this.consumerList.get(i)).getPriorityLevel() != targetPriority) continue;
            return i;
        }
        return -1;
    }

    protected byte[] peekStickyKey(ByteBuf metadataAndPayload) {
        metadataAndPayload.markReaderIndex();
        PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)metadataAndPayload);
        metadataAndPayload.resetReaderIndex();
        String key = metadata.getPartitionKey();
        if (log.isDebugEnabled()) {
            log.debug("Parse message metadata, partition key is {}, ordering key is {}", (Object)key, (Object)metadata.getOrderingKey());
        }
        if (StringUtils.isNotBlank((CharSequence)key) || metadata.hasOrderingKey()) {
            return metadata.hasOrderingKey() ? metadata.getOrderingKey().toByteArray() : key.getBytes();
        }
        metadata.recycle();
        return NONE_KEY.getBytes();
    }
}

