/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTopic
implements Topic {
    private static final Logger log = LoggerFactory.getLogger(AbstractTopic.class);
    protected static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    protected final String topic;
    protected final ConcurrentOpenHashSet<Producer> producers;
    protected final BrokerService brokerService;
    protected final String replicatorPrefix;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean isFenced;
    protected volatile long lastActive;
    protected volatile boolean hasBatchMessagePublished = false;
    protected StatsBuckets addEntryLatencyStatsUsec = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    protected volatile boolean isEncryptionRequired = false;
    protected volatile SchemaCompatibilityStrategy schemaCompatibilityStrategy = SchemaCompatibilityStrategy.FULL;
    protected volatile boolean schemaValidationEnforced = false;

    public AbstractTopic(String topic, BrokerService brokerService) {
        this.topic = topic;
        this.brokerService = brokerService;
        this.producers = new ConcurrentOpenHashSet(16, 1);
        this.isFenced = false;
        this.replicatorPrefix = brokerService.pulsar().getConfiguration().getReplicatorPrefix();
        this.lastActive = System.nanoTime();
    }

    protected boolean isProducersExceeded() {
        int maxProducers;
        Policies policies;
        try {
            policies = this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topic).getNamespace())).orElseGet(() -> new Policies());
        }
        catch (Exception e) {
            policies = new Policies();
        }
        int n = maxProducers = policies.max_producers_per_topic > 0 ? policies.max_producers_per_topic : this.brokerService.pulsar().getConfiguration().getMaxProducersPerTopic();
        return maxProducers > 0 && (long)maxProducers <= this.producers.size();
    }

    protected boolean hasLocalProducers() {
        AtomicBoolean foundLocal = new AtomicBoolean(false);
        this.producers.forEach(producer -> {
            if (!producer.isRemote()) {
                foundLocal.set(true);
            }
        });
        return foundLocal.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).toString();
    }

    @Override
    public ConcurrentOpenHashSet<Producer> getProducers() {
        return this.producers;
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public String getName() {
        return this.topic;
    }

    @Override
    public boolean isEncryptionRequired() {
        return this.isEncryptionRequired;
    }

    @Override
    public boolean getSchemaValidationEnforced() {
        return this.schemaValidationEnforced;
    }

    public void markBatchMessagePublished() {
        this.hasBatchMessagePublished = true;
    }

    public String getReplicatorPrefix() {
        return this.replicatorPrefix;
    }

    @Override
    public CompletableFuture<Boolean> hasSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().getSchema(id).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<SchemaVersion> addSchema(SchemaData schema) {
        if (schema == null) {
            return CompletableFuture.completedFuture(SchemaVersion.Empty);
        }
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().putSchemaIfAbsent(id, schema, this.schemaCompatibilityStrategy);
    }

    @Override
    public CompletableFuture<SchemaVersion> deleteSchema() {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        SchemaRegistryService schemaRegistryService = this.brokerService.pulsar().getSchemaRegistryService();
        return schemaRegistryService.getSchema(id).thenCompose(schema -> {
            if (schema != null) {
                return schemaRegistryService.deleteSchema(id, "");
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public CompletableFuture<Boolean> isSchemaCompatible(SchemaData schema) {
        String base = TopicName.get((String)this.getName()).getPartitionedTopicName();
        String id = TopicName.get((String)base).getSchemaName();
        return this.brokerService.pulsar().getSchemaRegistryService().isCompatible(id, schema, this.schemaCompatibilityStrategy);
    }

    @Override
    public void recordAddLatency(long latencyUSec) {
        this.addEntryLatencyStatsUsec.addValue(latencyUSec);
    }
}

