/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.util.concurrent.FastThreadLocal;

public class SendMessageInfo {
    private int totalMessages;
    private long totalBytes;
    private static final FastThreadLocal<SendMessageInfo> THREAD_LOCAL = new FastThreadLocal<SendMessageInfo>(){

        protected SendMessageInfo initialValue() throws Exception {
            return new SendMessageInfo();
        }
    };

    private SendMessageInfo() {
    }

    public static SendMessageInfo getThreadLocal() {
        SendMessageInfo smi = (SendMessageInfo)THREAD_LOCAL.get();
        smi.totalMessages = 0;
        smi.totalBytes = 0L;
        return smi;
    }

    public int getTotalMessages() {
        return this.totalMessages;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalMessages(int totalMessages) {
        this.totalMessages = totalMessages;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessageInfo)) {
            return false;
        }
        SendMessageInfo other = (SendMessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalMessages() != other.getTotalMessages()) {
            return false;
        }
        return this.getTotalBytes() == other.getTotalBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMessageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalMessages();
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        return result;
    }

    public String toString() {
        return "SendMessageInfo(totalMessages=" + this.getTotalMessages() + ", totalBytes=" + this.getTotalBytes() + ")";
    }
}

