/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.pulsar.broker.service.schema.AvroSchemaBasedCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;

public class JsonSchemaCompatibilityCheck
extends AvroSchemaBasedCompatibilityCheck {
    private ObjectMapper objectMapper;

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.JSON;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        if (this.isAvroSchema(from)) {
            if (this.isAvroSchema(to)) {
                return super.isCompatible(from, to, strategy);
            }
            return this.isJsonSchema(to);
        }
        if (this.isJsonSchema(from)) {
            if (this.isAvroSchema(to)) {
                return true;
            }
            if (this.isJsonSchema(to)) {
                return this.isCompatibleJsonSchema(from, to);
            }
            return false;
        }
        return true;
    }

    private ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    private boolean isCompatibleJsonSchema(SchemaData from, SchemaData to) {
        try {
            ObjectMapper objectMapper = this.getObjectMapper();
            JsonSchema fromSchema = (JsonSchema)objectMapper.readValue(from.getData(), JsonSchema.class);
            JsonSchema toSchema = (JsonSchema)objectMapper.readValue(to.getData(), JsonSchema.class);
            return fromSchema.getId().equals(toSchema.getId());
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isAvroSchema(SchemaData schemaData) {
        try {
            Schema.Parser fromParser = new Schema.Parser();
            Schema fromSchema = fromParser.parse(new String(schemaData.getData(), StandardCharsets.UTF_8));
            return true;
        }
        catch (SchemaParseException e) {
            return false;
        }
    }

    private boolean isJsonSchema(SchemaData schemaData) {
        ObjectMapper objectMapper = this.getObjectMapper();
        try {
            JsonSchema fromSchema = (JsonSchema)objectMapper.readValue(schemaData.getData(), JsonSchema.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

