/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityCheck;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class KeyValueSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    private final Map<SchemaType, SchemaCompatibilityCheck> checkers;

    public KeyValueSchemaCompatibilityCheck(Map<SchemaType, SchemaCompatibilityCheck> checkers) {
        this.checkers = checkers;
    }

    public static KeyValue<SchemaData, SchemaData> decodeKeyValueSchemaData(SchemaData schemaData) {
        KeyValue schemaInfoKeyValue = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)schemaData.toSchemaInfo());
        return new KeyValue((Object)SchemaData.fromSchemaInfo((SchemaInfo)((SchemaInfo)schemaInfoKeyValue.getKey())), (Object)SchemaData.fromSchemaInfo((SchemaInfo)((SchemaInfo)schemaInfoKeyValue.getValue())));
    }

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.KEY_VALUE;
    }

    @Override
    public boolean isCompatible(SchemaData from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        return this.isCompatible(Collections.singletonList(from), to, strategy);
    }

    @Override
    public boolean isCompatible(Iterable<SchemaData> from, SchemaData to, SchemaCompatibilityStrategy strategy) {
        if (strategy == SchemaCompatibilityStrategy.ALWAYS_COMPATIBLE) {
            return true;
        }
        if (to.getType() != SchemaType.KEY_VALUE) {
            return false;
        }
        LinkedList<SchemaData> fromKeyList = new LinkedList<SchemaData>();
        LinkedList<SchemaData> fromValueList = new LinkedList<SchemaData>();
        KeyValue<SchemaData, SchemaData> toKeyValue = KeyValueSchemaCompatibilityCheck.decodeKeyValueSchemaData(to);
        SchemaType toKeyType = ((SchemaData)toKeyValue.getKey()).getType();
        SchemaType toValueType = ((SchemaData)toKeyValue.getValue()).getType();
        for (SchemaData schemaData : from) {
            if (schemaData.getType() != SchemaType.KEY_VALUE) {
                return false;
            }
            KeyValue<SchemaData, SchemaData> fromKeyValue = KeyValueSchemaCompatibilityCheck.decodeKeyValueSchemaData(schemaData);
            if (((SchemaData)fromKeyValue.getKey()).getType() != toKeyType || ((SchemaData)fromKeyValue.getValue()).getType() != toValueType) {
                return false;
            }
            fromKeyList.addFirst((SchemaData)fromKeyValue.getKey());
            fromValueList.addFirst((SchemaData)fromKeyValue.getValue());
        }
        SchemaCompatibilityCheck keyCheck = this.checkers.getOrDefault(toKeyType, SchemaCompatibilityCheck.DEFAULT);
        SchemaCompatibilityCheck valueCheck = this.checkers.getOrDefault(toValueType, SchemaCompatibilityCheck.DEFAULT);
        return keyCheck.isCompatible(fromKeyList, (SchemaData)toKeyValue.getKey(), strategy) && valueCheck.isCompatible(fromValueList, (SchemaData)toKeyValue.getValue(), strategy);
    }
}

