/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.schema.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;

public interface SchemaRegistry
extends AutoCloseable {
    public CompletableFuture<SchemaAndMetadata> getSchema(String var1);

    public CompletableFuture<SchemaAndMetadata> getSchema(String var1, SchemaVersion var2);

    public CompletableFuture<List<CompletableFuture<SchemaAndMetadata>>> getAllSchemas(String var1);

    public CompletableFuture<SchemaVersion> putSchemaIfAbsent(String var1, SchemaData var2, SchemaCompatibilityStrategy var3);

    public CompletableFuture<SchemaVersion> deleteSchema(String var1, String var2);

    public CompletableFuture<Boolean> isCompatible(String var1, SchemaData var2, SchemaCompatibilityStrategy var3);

    public CompletableFuture<List<SchemaAndMetadata>> trimDeletedSchemaAndGetList(String var1);

    public CompletableFuture<Long> findSchemaVersion(String var1, SchemaData var2);

    public SchemaVersion versionFromBytes(byte[] var1);

    public static class SchemaAndMetadata {
        public final String id;
        public final SchemaData schema;
        public final SchemaVersion version;

        SchemaAndMetadata(String id, SchemaData schema, SchemaVersion version) {
            this.id = id;
            this.schema = schema;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaAndMetadata that = (SchemaAndMetadata)o;
            return this.version == that.version && Objects.equals(this.id, that.id) && Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.schema, this.version);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("schema", (Object)this.schema).add("version", (Object)this.version).toString();
        }
    }
}

