/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.ZkAdminPaths;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminResource
extends PulsarWebResource {
    private static final Logger log = LoggerFactory.getLogger(AdminResource.class);
    private static final String POLICIES_READONLY_FLAG_PATH = "/admin/flags/policies-readonly";
    public static final String PARTITIONED_TOPIC_PATH_ZNODE = "partitioned-topics";
    protected NamespaceName namespaceName;
    protected TopicName topicName;

    protected ZooKeeper globalZk() {
        return this.pulsar().getGlobalZkCache().getZooKeeper();
    }

    protected ZooKeeperCache globalZkCache() {
        return this.pulsar().getGlobalZkCache();
    }

    protected ZooKeeper localZk() {
        return this.pulsar().getZkClient();
    }

    protected ZooKeeperCache localZkCache() {
        return this.pulsar().getLocalZkCache();
    }

    protected LocalZooKeeperCacheService localCacheService() {
        return this.pulsar().getLocalZkCacheService();
    }

    protected void zkCreate(String path, byte[] content) throws Exception {
        this.globalZk().create(path, content, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    protected void zkCreateOptimistic(String path, byte[] content) throws Exception {
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.globalZk(), (String)path, (byte[])content, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
    }

    protected boolean zkPathExists(String path) throws KeeperException, InterruptedException {
        Stat stat = this.globalZk().exists(path, false);
        return null != stat;
    }

    protected String domain() {
        if (this.uri.getPath().startsWith("persistent/")) {
            return "persistent";
        }
        if (this.uri.getPath().startsWith("non-persistent/")) {
            return "non-persistent";
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "domain() invoked from wrong resource");
    }

    @Override
    protected void validateSuperUserAccess() {
        super.validateSuperUserAccess();
    }

    @Override
    protected void validateAdminAccessForTenant(String property) {
        super.validateAdminAccessForTenant(property);
    }

    @Override
    protected void validateNamespaceOwnershipWithBundles(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, BundlesData bundleData) {
        super.validateNamespaceOwnershipWithBundles(property, cluster, namespace, authoritative, readOnly, bundleData);
    }

    @Override
    protected void validateBundleOwnership(String property, String cluster, String namespace, boolean authoritative, boolean readOnly, NamespaceBundle bundle) {
        super.validateBundleOwnership(property, cluster, namespace, authoritative, readOnly, bundle);
    }

    @Override
    protected boolean isLeaderBroker() {
        return super.isLeaderBroker();
    }

    public void validatePoliciesReadOnlyAccess() {
        boolean arePoliciesReadOnly = true;
        try {
            arePoliciesReadOnly = this.globalZkCache().exists(POLICIES_READONLY_FLAG_PATH);
        }
        catch (Exception e) {
            log.warn("Unable to fetch contents of [{}] from global zookeeper", (Object)POLICIES_READONLY_FLAG_PATH, (Object)e);
            throw new RestException(e);
        }
        if (arePoliciesReadOnly) {
            log.debug("Policies are read-only. Broker cannot do read-write operations");
            throw new RestException(Response.Status.FORBIDDEN, "Broker is forbidden to do read-write operations");
        }
        if (this.globalZkCache().getZooKeeper().getState() != ZooKeeper.States.CONNECTED) {
            log.debug("Broker is not connected to the global zookeeper");
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Broker needs to be connected to global zookeeper before making a read-write operation");
        }
        log.debug("Broker is allowed to make read-write operations");
    }

    protected List<String> getListOfNamespaces(String property) throws Exception {
        ArrayList namespaces = Lists.newArrayList();
        for (String clusterOrNamespace : this.globalZk().getChildren(AdminResource.path("policies", property), false)) {
            try {
                List children = this.globalZk().getChildren(AdminResource.path("policies", property, clusterOrNamespace), false);
                if (children == null || children.isEmpty()) {
                    String namespace = NamespaceName.get((String)property, (String)clusterOrNamespace).toString();
                    if (this.globalZk().getData(AdminResource.path("policies", namespace), false, null).length == 0) continue;
                    namespaces.add(namespace);
                    continue;
                }
                children.forEach(ns -> namespaces.add(NamespaceName.get((String)property, (String)clusterOrNamespace, (String)ns).toString()));
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
        namespaces.sort(null);
        return namespaces;
    }

    protected void validateNamespaceName(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create namespace with invalid name {}", new Object[]{this.clientAppId(), namespace, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateGlobalNamespaceOwnership(String property, String namespace) {
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        catch (IllegalArgumentException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name or namespace is not valid");
        }
        catch (RestException re) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace does not have any clusters configured");
        }
        catch (Exception e) {
            log.warn("Failed to validate global cluster configuration : ns={}  emsg={}", (Object)namespace, (Object)e.getMessage());
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Failed to validate global cluster configuration");
        }
    }

    @Deprecated
    protected void validateNamespaceName(String property, String cluster, String namespace) {
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)cluster, (String)namespace);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to create namespace with invalid name {}", new Object[]{this.clientAppId(), namespace, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Namespace name is not valid");
        }
    }

    protected void validateTopicName(String property, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)namespace);
            this.topicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
        this.topicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topic);
    }

    protected void validatePartitionedTopicName(String tenant, String namespace, String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        if (encodedTopic.contains("-partition-")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Partitioned Topic Name should not contain '-partition-'");
        }
    }

    @Deprecated
    protected void validateTopicName(String property, String cluster, String namespace, String encodedTopic) {
        String topic = Codec.decode((String)encodedTopic);
        try {
            this.namespaceName = NamespaceName.get((String)property, (String)cluster, (String)namespace);
            this.topicName = TopicName.get((String)this.domain(), (NamespaceName)this.namespaceName, (String)topic);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Failed to validate topic name {}://{}/{}/{}/{}", new Object[]{this.clientAppId(), this.domain(), property, cluster, namespace, topic, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Topic name is not valid");
        }
    }

    protected void validateBrokerName(String broker) throws MalformedURLException {
        String brokerUrl = String.format("http://%s", broker);
        String brokerUrlTls = String.format("https://%s", broker);
        if (!brokerUrl.equals(this.pulsar().getSafeWebServiceAddress()) && !brokerUrlTls.equals(this.pulsar().getWebServiceAddressTls())) {
            String[] parts = broker.split(":");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid broker url %s", (Object)broker);
            String host = parts[0];
            int port = Integer.parseInt(parts[1]);
            URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(host).port(port).build(new Object[0]);
            log.debug("[{}] Redirecting the rest call to {}: broker={}", new Object[]{this.clientAppId(), redirect, broker});
            throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
        }
    }

    protected Policies getNamespacePolicies(NamespaceName namespaceName) {
        try {
            String namespace = namespaceName.toString();
            String policyPath = AdminResource.path("policies", namespace);
            Policies policies = (Policies)this.policiesCache().get(policyPath).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(namespaceName);
            BundlesData bundleData = NamespaceBundleFactory.getBundlesData(bundles);
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            this.mergeNamespaceWithDefaults(policies, namespace, policyPath);
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected CompletableFuture<Policies> getNamespacePoliciesAsync(NamespaceName namespaceName) {
        String namespace = namespaceName.toString();
        String policyPath = AdminResource.path("policies", namespace);
        return this.policiesCache().getAsync(policyPath).thenCompose(policies -> {
            if (policies.isPresent()) {
                return this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundlesAsync(namespaceName).thenCompose(bundles -> {
                    BundlesData bundleData = null;
                    try {
                        bundleData = NamespaceBundleFactory.getBundlesData(bundles);
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
                        return FutureUtil.failedFuture((Throwable)((Object)new RestException(e)));
                    }
                    ((Policies)policies.get()).bundles = bundleData != null ? bundleData : ((Policies)policies.get()).bundles;
                    this.mergeNamespaceWithDefaults((Policies)policies.get(), namespace, policyPath);
                    return CompletableFuture.completedFuture(policies.get());
                });
            }
            return FutureUtil.failedFuture((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
        });
    }

    protected void mergeNamespaceWithDefaults(Policies policies, String namespace, String namespacePath) {
        if (policies.backlog_quota_map.isEmpty()) {
            Policies.setStorageQuota((Policies)policies, (BacklogQuota)this.namespaceBacklogQuota(namespace, namespacePath));
        }
        ServiceConfiguration config = this.pulsar().getConfiguration();
        if (policies.max_producers_per_topic < 1) {
            policies.max_producers_per_topic = config.getMaxProducersPerTopic();
        }
        if (policies.max_consumers_per_topic < 1) {
            policies.max_consumers_per_topic = config.getMaxConsumersPerTopic();
        }
        if (policies.max_consumers_per_subscription < 1) {
            policies.max_consumers_per_subscription = config.getMaxConsumersPerSubscription();
        }
        String cluster = config.getClusterName();
        if (policies.topicDispatchRate.isEmpty()) {
            policies.topicDispatchRate.put(cluster, this.dispatchRate());
        }
        if (policies.subscriptionDispatchRate.isEmpty()) {
            policies.subscriptionDispatchRate.put(cluster, this.subscriptionDispatchRate());
        }
        if (policies.clusterSubscribeRate.isEmpty()) {
            policies.clusterSubscribeRate.put(cluster, this.subscribeRate());
        }
    }

    protected BacklogQuota namespaceBacklogQuota(String namespace, String namespacePath) {
        return this.pulsar().getBrokerService().getBacklogQuotaManager().getBacklogQuota(namespace, namespacePath);
    }

    protected DispatchRate dispatchRate() {
        return new DispatchRate(this.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInMsg(), this.pulsar().getConfiguration().getDispatchThrottlingRatePerTopicInByte(), 1);
    }

    protected DispatchRate subscriptionDispatchRate() {
        return new DispatchRate(this.pulsar().getConfiguration().getDispatchThrottlingRatePerSubscriptionInMsg(), this.pulsar().getConfiguration().getDispatchThrottlingRatePerSubscriptionInByte(), 1);
    }

    protected SubscribeRate subscribeRate() {
        return new SubscribeRate(this.pulsar().getConfiguration().getSubscribeThrottlingRatePerConsumer(), this.pulsar().getConfiguration().getSubscribeRatePeriodPerConsumerInSecond());
    }

    public static ObjectMapper jsonMapper() {
        return ObjectMapperFactory.getThreadLocal();
    }

    public ZooKeeperDataCache<TenantInfo> tenantsCache() {
        return this.pulsar().getConfigurationCache().propertiesCache();
    }

    protected ZooKeeperDataCache<Policies> policiesCache() {
        return this.pulsar().getConfigurationCache().policiesCache();
    }

    protected ZooKeeperDataCache<LocalPolicies> localPoliciesCache() {
        return this.pulsar().getLocalZkCacheService().policiesCache();
    }

    protected ZooKeeperDataCache<ClusterData> clustersCache() {
        return this.pulsar().getConfigurationCache().clustersCache();
    }

    protected ZooKeeperChildrenCache managedLedgerListCache() {
        return this.pulsar().getLocalZkCacheService().managedLedgerListCache();
    }

    protected Set<String> clusters() {
        try {
            Set clusters = this.pulsar().getConfigurationCache().clustersListCache().get();
            clusters.remove("global");
            return clusters;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected ZooKeeperChildrenCache clustersListCache() {
        return this.pulsar().getConfigurationCache().clustersListCache();
    }

    protected void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected ZooKeeperDataCache<NamespaceIsolationPolicies> namespaceIsolationPoliciesCache() {
        return this.pulsar().getConfigurationCache().namespaceIsolationPoliciesCache();
    }

    protected ZooKeeperDataCache<FailureDomain> failureDomainCache() {
        return this.pulsar().getConfigurationCache().failureDomainCache();
    }

    protected ZooKeeperChildrenCache failureDomainListCache() {
        return this.pulsar().getConfigurationCache().failureDomainListCache();
    }

    protected PartitionedTopicMetadata getPartitionedTopicMetadata(TopicName topicName, boolean authoritative, boolean checkAllowAutoCreation) {
        this.validateClusterOwnership(topicName.getCluster());
        this.validateGlobalNamespaceOwnership(topicName.getNamespaceObject());
        try {
            this.checkConnect(topicName);
        }
        catch (WebApplicationException e) {
            this.validateAdminAccessForTenant(topicName.getTenant());
        }
        catch (Exception e) {
            log.warn("Unexpected error while authorizing lookup. topic={}, role={}. Error: {}", new Object[]{topicName, this.clientAppId(), e.getMessage(), e});
            throw new RestException(e);
        }
        PartitionedTopicMetadata partitionMetadata = checkAllowAutoCreation ? AdminResource.fetchPartitionedTopicMetadataCheckAllowAutoCreation(this.pulsar(), topicName) : AdminResource.fetchPartitionedTopicMetadata(this.pulsar(), topicName);
        if (log.isDebugEnabled()) {
            log.debug("[{}] Total number of partitions for topic {} is {}", new Object[]{this.clientAppId(), topicName, partitionMetadata.partitions});
        }
        return partitionMetadata;
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadata(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)((Object)e);
            }
            throw new RestException(e);
        }
    }

    protected static PartitionedTopicMetadata fetchPartitionedTopicMetadataCheckAllowAutoCreation(PulsarService pulsar, TopicName topicName) {
        try {
            return pulsar.getBrokerService().fetchPartitionedTopicMetadataCheckAllowAutoCreationAsync(topicName).get();
        }
        catch (Exception e) {
            if (e.getCause() instanceof RestException) {
                throw (RestException)((Object)e);
            }
            throw new RestException(e);
        }
    }

    protected void validateClusterExists(String cluster) {
        try {
            if (!this.clustersCache().get(AdminResource.path("clusters", cluster)).isPresent()) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cluster " + cluster + " does not exist.");
            }
        }
        catch (Exception e) {
            throw new RestException(e);
        }
    }

    protected Policies getNamespacePolicies(String property, String cluster, String namespace) {
        try {
            Policies policies = (Policies)this.policiesCache().get(AdminResource.path("policies", property, cluster, namespace)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(NamespaceName.get((String)property, (String)cluster, (String)namespace));
            BundlesData bundleData = NamespaceBundleFactory.getBundlesData(bundles);
            policies.bundles = bundleData != null ? bundleData : policies.bundles;
            return policies;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}/{}/{}", new Object[]{this.clientAppId(), property, cluster, namespace, e});
            throw new RestException(e);
        }
    }

    protected boolean isNamespaceReplicated(NamespaceName namespaceName) {
        return this.getNamespaceReplicatedClusters(namespaceName).size() > 1;
    }

    protected Set<String> getNamespaceReplicatedClusters(NamespaceName namespaceName) {
        try {
            Policies policies = (Policies)this.policiesCache().get(ZkAdminPaths.namespacePoliciesPath(namespaceName)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace does not exist"));
            return policies.replication_clusters;
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespace policies {}", new Object[]{this.clientAppId(), namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> getPartitionedTopicList(TopicDomain topicDomain) {
        List<Object> partitionedTopics = Lists.newArrayList();
        try {
            String partitionedTopicPath = AdminResource.path(PARTITIONED_TOPIC_PATH_ZNODE, this.namespaceName.toString(), topicDomain.value());
            List topics = this.globalZk().getChildren(partitionedTopicPath, false);
            partitionedTopics = topics.stream().map(s -> String.format("%s://%s/%s", topicDomain.value(), this.namespaceName.toString(), Codec.decode((String)s))).collect(Collectors.toList());
        }
        catch (KeeperException.NoNodeException partitionedTopicPath) {
        }
        catch (Exception e) {
            log.error("[{}] Failed to get partitioned topic list for namespace {}", new Object[]{this.clientAppId(), this.namespaceName.toString(), e});
            throw new RestException(e);
        }
        partitionedTopics.sort(null);
        return partitionedTopics;
    }
}

