/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup;

import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.common.lookup.data.LookupData;

public class LookupResult {
    private final Type type;
    private final LookupData lookupData;

    public LookupResult(NamespaceEphemeralData namespaceEphemeralData) {
        this.type = Type.BrokerUrl;
        this.lookupData = new LookupData(namespaceEphemeralData.getNativeUrl(), namespaceEphemeralData.getNativeUrlTls(), namespaceEphemeralData.getHttpUrl(), namespaceEphemeralData.getHttpUrlTls());
    }

    public LookupResult(String httpUrl, String httpUrlTls, String brokerServiceUrl, String brokerServiceUrlTls) {
        this.type = Type.RedirectUrl;
        this.lookupData = new LookupData(brokerServiceUrl, brokerServiceUrlTls, httpUrl, httpUrlTls);
    }

    public boolean isBrokerUrl() {
        return this.type == Type.BrokerUrl;
    }

    public boolean isRedirect() {
        return this.type == Type.RedirectUrl;
    }

    public LookupData getLookupData() {
        return this.lookupData;
    }

    public String toString() {
        return "LookupResult [type=" + (Object)((Object)this.type) + ", lookupData=" + this.lookupData + "]";
    }

    static enum Type {
        BrokerUrl,
        RedirectUrl;

    }
}

