/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.ssl.SslContext;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.util.NettySslContextBuilder;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final PulsarService pulsar;
    private final boolean enableTls;
    private final NettySslContextBuilder sslCtxRefresher;
    private final ServiceConfiguration brokerConf;

    public PulsarChannelInitializer(PulsarService pulsar, boolean enableTLS) throws Exception {
        this.pulsar = pulsar;
        this.enableTls = enableTLS;
        if (this.enableTls) {
            ServiceConfiguration serviceConfig = pulsar.getConfiguration();
            this.sslCtxRefresher = new NettySslContextBuilder(serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.isTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec());
        } else {
            this.sslCtxRefresher = null;
        }
        this.brokerConf = pulsar.getConfiguration();
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.enableTls) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)((SslContext)this.sslCtxRefresher.get()).newHandler(ch.alloc()));
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.brokerConf.getMaxMessageSize() + 10240, 0, 4, 0, 4));
        ch.pipeline().addLast("flowController", (ChannelHandler)new FlowControlHandler());
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerCnx(this.pulsar));
    }
}

