/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.stats.prometheus.AggregatedConsumerStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedReplicationStats;
import org.apache.pulsar.broker.stats.prometheus.AggregatedSubscriptionStats;
import org.apache.pulsar.broker.stats.prometheus.TopicStats;

public class AggregatedNamespaceStats {
    public int topicsCount;
    public int subscriptionsCount;
    public int producersCount;
    public int consumersCount;
    public double rateIn;
    public double rateOut;
    public double throughputIn;
    public double throughputOut;
    public long storageSize;
    public long msgBacklog;
    public long msgDelayed;
    long backlogSize;
    long offloadedStorageUsed;
    long backlogQuotaLimit;
    public StatsBuckets storageWriteLatencyBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_LATENCY_BUCKETS_USEC);
    public StatsBuckets entrySizeBuckets = new StatsBuckets(ManagedLedgerMBeanImpl.ENTRY_SIZE_BUCKETS_BYTES);
    public double storageWriteRate;
    public double storageReadRate;
    public Map<String, AggregatedReplicationStats> replicationStats = new HashMap<String, AggregatedReplicationStats>();
    public Map<String, AggregatedSubscriptionStats> subscriptionStats = new HashMap<String, AggregatedSubscriptionStats>();

    void updateStats(TopicStats stats) {
        ++this.topicsCount;
        this.subscriptionsCount += stats.subscriptionsCount;
        this.producersCount += stats.producersCount;
        this.consumersCount += stats.consumersCount;
        this.rateIn += stats.rateIn;
        this.rateOut += stats.rateOut;
        this.throughputIn += stats.throughputIn;
        this.throughputOut += stats.throughputOut;
        this.storageSize += stats.storageSize;
        this.backlogSize += stats.backlogSize;
        this.offloadedStorageUsed += stats.offloadedStorageUsed;
        this.storageWriteRate += stats.storageWriteRate;
        this.storageReadRate += stats.storageReadRate;
        this.msgBacklog += stats.msgBacklog;
        this.storageWriteLatencyBuckets.addAll(stats.storageWriteLatencyBuckets);
        this.entrySizeBuckets.addAll(stats.entrySizeBuckets);
        stats.replicationStats.forEach((n, as) -> {
            AggregatedReplicationStats replStats = this.replicationStats.computeIfAbsent((String)n, k -> new AggregatedReplicationStats());
            replStats.msgRateIn += as.msgRateIn;
            replStats.msgRateOut += as.msgRateOut;
            replStats.msgThroughputIn += as.msgThroughputIn;
            replStats.msgThroughputOut += as.msgThroughputOut;
            replStats.replicationBacklog += as.replicationBacklog;
        });
        stats.subscriptionStats.forEach((n, as) -> {
            AggregatedSubscriptionStats subsStats = this.subscriptionStats.computeIfAbsent((String)n, k -> new AggregatedSubscriptionStats());
            this.msgDelayed += as.msgDelayed;
            subsStats.blockedSubscriptionOnUnackedMsgs = as.blockedSubscriptionOnUnackedMsgs;
            subsStats.msgBacklog += as.msgBacklog;
            subsStats.msgDelayed += as.msgDelayed;
            subsStats.msgRateRedeliver += as.msgRateRedeliver;
            subsStats.unackedMessages += as.unackedMessages;
            as.consumerStat.forEach((c, v) -> {
                AggregatedConsumerStats consumerStats = subsStats.consumerStat.computeIfAbsent((Consumer)c, k -> new AggregatedConsumerStats());
                consumerStats.blockedSubscriptionOnUnackedMsgs = v.blockedSubscriptionOnUnackedMsgs;
                consumerStats.msgRateRedeliver += v.msgRateRedeliver;
                consumerStats.unackedMessages += v.unackedMessages;
            });
        });
    }

    public void reset() {
        this.topicsCount = 0;
        this.subscriptionsCount = 0;
        this.producersCount = 0;
        this.consumersCount = 0;
        this.rateIn = 0.0;
        this.rateOut = 0.0;
        this.throughputIn = 0.0;
        this.throughputOut = 0.0;
        this.storageSize = 0L;
        this.msgBacklog = 0L;
        this.msgDelayed = 0L;
        this.storageWriteRate = 0.0;
        this.storageReadRate = 0.0;
        this.replicationStats.clear();
        this.subscriptionStats.clear();
        this.storageWriteLatencyBuckets.reset();
        this.entrySizeBuckets.reset();
    }
}

