/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/persistent")
@Produces(value={"application/json"})
@Api(value="/persistent", description="Persistent topic admin apis", tags={"persistent topic"}, hidden=true)
public class PersistentTopics
extends PersistentTopicsBase {
    private static final Logger log = LoggerFactory.getLogger(PersistentTopics.class);

    @GET
    @Path(value="/{property}/{cluster}/{namespace}")
    @ApiOperation(hidden=true, value="Get the list of topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public void getList(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(property, cluster, namespace);
            asyncResponse.resume(this.internalGetList());
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/partitioned")
    @ApiOperation(hidden=true, value="Get the list of partitioned topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public List<String> getPartitionedTopicList(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(property, cluster, namespace);
        return this.internalGetPartitionedTopicList();
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/permissions")
    @ApiOperation(hidden=true, value="Get permissions on a topic.", notes="Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at thenamespace level combined (union) with any eventual specific permission set on the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist")})
    public Map<String, Set<AuthAction>> getPermissionsOnTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalGetPermissionsOnTopic();
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(hidden=true, value="Grant a new permission to a role on a single topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=409, message="Concurrent modification")})
    public void grantPermissionsOnTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="role") String role, Set<AuthAction> actions) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalGrantPermissionsOnTopic(role, actions);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(hidden=true, value="Revoke permissions on a topic.", notes="Revoke permissions to a role on a single topic. If the permission was not set at the topiclevel, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace doesn't exist"), @ApiResponse(code=412, message="Permissions are not set at the topic level")})
    public void revokePermissionsOnTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="role") String role) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalRevokePermissionsOnTopic(role);
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/partitions")
    @ApiOperation(hidden=true, value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic already exist")})
    public void createPartitionedTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, int numPartitions) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalCreatePartitionedTopic(asyncResponse, numPartitions);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/partitions")
    @ApiOperation(hidden=true, value="Increment partitons of an existing partitioned topic.", notes="It only increments partitions of existing non-global partitioned-topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic does not exist")})
    public void updatePartitionedTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="updateLocalTopicOnly") @DefaultValue(value="false") boolean updateLocalTopicOnly, int numPartitions) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalUpdatePartitionedTopic(numPartitions, updateLocalTopicOnly);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/partitions")
    @ApiOperation(hidden=true, value="Get partitioned topic metadata.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public PartitionedTopicMetadata getPartitionedMetadata(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="checkAllowAutoCreation") @DefaultValue(value="false") boolean checkAllowAutoCreation) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalGetPartitionedMetadata(authoritative, checkAllowAutoCreation);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/partitions")
    @ApiOperation(hidden=true, value="Delete a partitioned topic.", notes="It will also delete all the partitions of the topic if it exists.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Partitioned topic does not exist")})
    public void deletePartitionedTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalDeletePartitionedTopic(asyncResponse, authoritative, force);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/unload")
    @ApiOperation(hidden=true, value="Unload a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void unloadTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalUnloadTopic(asyncResponse, authoritative);
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{topic}")
    @ApiOperation(hidden=true, value="Delete a topic.", notes="The topic cannot be deleted if delete is not forcefully and there's any active subscription or producer connected to the it. Force delete ignores connected clients and deletes topic by explicitly closing them.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic has active producers/subscriptions")})
    public void deleteTopic(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="force") @DefaultValue(value="false") boolean force, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalDeleteTopic(authoritative, force);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscriptions")
    @ApiOperation(hidden=true, value="Get the list of persistent subscriptions for a given topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void getSubscriptions(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalGetSubscriptions(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/stats")
    @ApiOperation(hidden=true, value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public TopicStats getStats(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalGetStats(authoritative, false);
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/internalStats")
    @ApiOperation(hidden=true, value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public PersistentTopicInternalStats getInternalStats(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalGetInternalStats(authoritative);
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/internal-info")
    @ApiOperation(hidden=true, value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void getManagedLedgerInfo(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @Suspended AsyncResponse asyncResponse) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalGetManagedLedgerInfo(asyncResponse);
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/partitioned-stats")
    @ApiOperation(hidden=true, value="Get the stats for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void getPartitionedStats(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="perPartition") @DefaultValue(value="true") boolean perPartition, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalGetPartitionedStats(asyncResponse, authoritative, perPartition, false);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/partitioned-internalStats")
    @ApiOperation(hidden=true, value="Get the stats-internal for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist")})
    public void getPartitionedStatsInternal(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalGetPartitionedStatsInternal(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}")
    @ApiOperation(hidden=true, value="Delete a subscription.", notes="There should not be any active consumers on the subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Subscription has active consumers")})
    public void deleteSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalDeleteSubscription(asyncResponse, Codec.decode((String)encodedSubName), authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/skip_all")
    @ApiOperation(hidden=true, value="Skip all messages on a topic subscription.", notes="Completely clears the backlog on the subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void skipAllMessages(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalSkipAllMessages(asyncResponse, Codec.decode((String)encodedSubName), authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/skip/{numMessages}")
    @ApiOperation(hidden=true, value="Skip messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void skipMessages(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @PathParam(value="numMessages") int numMessages, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalSkipMessages(Codec.decode((String)encodedSubName), numMessages, authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(hidden=true, value="Expire messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void expireTopicMessages(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalExpireMessages(asyncResponse, Codec.decode((String)encodedSubName), expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/all_subscription/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(hidden=true, value="Expire messages on all subscriptions of topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist")})
    public void expireMessagesForAllSubscriptions(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalExpireMessagesForAllSubscriptions(asyncResponse, expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/resetcursor/{timestamp}")
    @ApiOperation(hidden=true, value="Reset subscription to message position closest to absolute timestamp (in ms).", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist")})
    public void resetCursor(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @PathParam(value="timestamp") long timestamp, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(property, cluster, namespace, encodedTopic);
            this.internalResetCursor(asyncResponse, Codec.decode((String)encodedSubName), timestamp, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/resetcursor")
    @ApiOperation(hidden=true, value="Reset subscription to message position closest to given position.", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics")})
    public void resetCursorOnPosition(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalResetCursorOnPosition(Codec.decode((String)encodedSubName), authoritative, messageId);
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subscriptionName}")
    @ApiOperation(value="Create a subscription on the topic.", notes="Creates a subscription on the topic at the specified message id")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics")})
    public void createSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String topic, @PathParam(value="subscriptionName") String encodedSubName, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId, @QueryParam(value="replicated") boolean replicated) {
        try {
            this.validateTopicName(property, cluster, namespace, topic);
            this.internalCreateSubscription(asyncResponse, Codec.decode((String)encodedSubName), messageId, authoritative, replicated);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/subscription/{subName}/position/{messagePosition}")
    @ApiOperation(hidden=true, value="Peek nth message on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, subscription or the message position does not exist")})
    public Response peekNthMessage(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @PathParam(value="subName") String encodedSubName, @PathParam(value="messagePosition") int messagePosition, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalPeekNthMessage(Codec.decode((String)encodedSubName), messagePosition, authoritative);
    }

    @GET
    @Path(value="{property}/{cluster}/{namespace}/{topic}/backlog")
    @ApiOperation(hidden=true, value="Get estimated backlog for offline topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Namespace does not exist")})
    public PersistentOfflineTopicStats getBacklog(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalGetBacklog(authoritative);
    }

    @POST
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/terminate")
    @ApiOperation(hidden=true, value="Terminate a topic. A topic that is terminated will not accept any more messages to be published and will let consumer to drain existing messages in backlog")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=404, message="Topic does not exist")})
    public MessageId terminate(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalTerminate(authoritative);
    }

    @PUT
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Trigger a compaction operation on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Compaction already running")})
    public void compact(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        this.internalTriggerCompaction(authoritative);
    }

    @GET
    @Path(value="/{property}/{cluster}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Get the status of a compaction operation for a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist, or compaction hasn't run")})
    public LongRunningProcessStatus compactionStatus(@PathParam(value="property") String property, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(property, cluster, namespace, encodedTopic);
        return this.internalCompactionStatus(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Offload already running")})
    public void triggerOffload(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        this.validateTopicName(tenant, cluster, namespace, encodedTopic);
        this.internalTriggerOffload(authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{cluster}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=405, message="Operation not allowed on persistent topic"), @ApiResponse(code=404, message="Topic does not exist")})
    public OffloadProcessStatus offloadStatus(@PathParam(value="tenant") String tenant, @PathParam(value="cluster") String cluster, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, cluster, namespace, encodedTopic);
        return this.internalOffloadStatus(authoritative);
    }
}

