/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.util.Rate;
import org.apache.pulsar.client.impl.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentMessageExpiryMonitor
implements AsyncCallbacks.FindEntryCallback {
    private final ManagedCursor cursor;
    private final String subName;
    private final String topicName;
    private final Rate msgExpired;
    private final boolean autoSkipNonRecoverableData;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private volatile int expirationCheckInProgress = 0;
    private static final AtomicIntegerFieldUpdater<PersistentMessageExpiryMonitor> expirationCheckInProgressUpdater = AtomicIntegerFieldUpdater.newUpdater(PersistentMessageExpiryMonitor.class, "expirationCheckInProgress");
    private static final Logger log = LoggerFactory.getLogger(PersistentMessageExpiryMonitor.class);
    private final AsyncCallbacks.MarkDeleteCallback markDeleteCallback = new AsyncCallbacks.MarkDeleteCallback(){

        public void markDeleteComplete(Object ctx) {
            long numMessagesExpired = (Long)ctx - PersistentMessageExpiryMonitor.this.cursor.getNumberOfEntriesInBacklog(false);
            PersistentMessageExpiryMonitor.this.msgExpired.recordMultipleEvents(numMessagesExpired, 0L);
            PersistentMessageExpiryMonitor.this.updateRates();
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Mark deleted {} messages", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, numMessagesExpired});
            }
        }

        public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
            log.warn("[{}][{}] Message expiry failed - mark delete failed", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, exception});
            PersistentMessageExpiryMonitor.this.updateRates();
        }
    };

    public PersistentMessageExpiryMonitor(String topicName, String subscriptionName, ManagedCursor cursor) {
        this.topicName = topicName;
        this.cursor = cursor;
        this.subName = subscriptionName;
        this.msgExpired = new Rate();
        this.autoSkipNonRecoverableData = cursor.getManagedLedger() != null ? cursor.getManagedLedger().getConfig().isAutoSkipNonRecoverableData() : false;
    }

    public void expireMessages(int messageTTLInSeconds) {
        if (expirationCheckInProgressUpdater.compareAndSet(this, 0, 1)) {
            log.info("[{}][{}] Starting message expiry check, ttl= {} seconds", new Object[]{this.topicName, this.subName, messageTTLInSeconds});
            this.cursor.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, entry -> {
                MessageImpl msg = null;
                try {
                    msg = MessageImpl.deserialize((ByteBuf)entry.getDataBuffer());
                    boolean bl = msg.isExpired(messageTTLInSeconds);
                    return bl;
                }
                catch (Exception e) {
                    log.error("[{}][{}] Error deserializing message for expiry check", new Object[]{this.topicName, this.subName, e});
                }
                finally {
                    entry.release();
                    if (msg != null) {
                        msg.recycle();
                    }
                }
                return false;
            }, (AsyncCallbacks.FindEntryCallback)this, null);
        } else if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Ignore expire-message scheduled task, last check is still running", (Object)this.topicName, (Object)this.subName);
        }
    }

    public void updateRates() {
        this.msgExpired.calculateRate();
    }

    public double getMessageExpiryRate() {
        return this.msgExpired.getRate();
    }

    public void findEntryComplete(Position position, Object ctx) {
        if (position != null) {
            log.info("[{}][{}] Expiring all messages until position {}", new Object[]{this.topicName, this.subName, position});
            this.cursor.asyncMarkDelete(position, this.markDeleteCallback, (Object)this.cursor.getNumberOfEntriesInBacklog(false));
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] No messages to expire", (Object)this.topicName, (Object)this.subName);
            }
            this.updateRates();
        }
        this.expirationCheckInProgress = 0;
    }

    public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Finding expired entry operation failed", new Object[]{this.topicName, this.subName, exception});
        }
        if (this.autoSkipNonRecoverableData && failedReadPosition.isPresent() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.topicName, this.subName, failedReadPosition, exception.getMessage()});
            this.findEntryComplete(failedReadPosition.get(), ctx);
        }
        this.expirationCheckInProgress = 0;
        this.updateRates();
    }
}

