/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.transaction.buffer.TransactionCursor;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.broker.transaction.buffer.exceptions.NoTxnsCommittedAtLedgerException;
import org.apache.pulsar.broker.transaction.buffer.exceptions.TransactionNotFoundException;
import org.apache.pulsar.broker.transaction.buffer.impl.TransactionMetaImpl;
import org.apache.pulsar.transaction.impl.common.TxnID;

public class TransactionCursorImpl
implements TransactionCursor {
    private final ConcurrentMap<TxnID, TransactionMetaImpl> txnIndex = new ConcurrentHashMap<TxnID, TransactionMetaImpl>();
    private final Map<Long, Set<TxnID>> committedLedgerTxnIndex = new TreeMap<Long, Set<TxnID>>();

    TransactionCursorImpl() {
    }

    @Override
    public CompletableFuture<TransactionMeta> getTxnMeta(TxnID txnID, boolean createIfNotExist) {
        CompletableFuture<TransactionMeta> getFuture = new CompletableFuture<TransactionMeta>();
        TransactionMeta meta = (TransactionMeta)this.txnIndex.get(txnID);
        if (null == meta) {
            if (!createIfNotExist) {
                getFuture.completeExceptionally(new TransactionNotFoundException("Transaction `" + txnID + "` doesn't exist"));
                return getFuture;
            }
            TransactionMetaImpl newMeta = new TransactionMetaImpl(txnID);
            TransactionMeta oldMeta = this.txnIndex.putIfAbsent(txnID, newMeta);
            meta = null != oldMeta ? oldMeta : newMeta;
        }
        getFuture.complete(meta);
        return getFuture;
    }

    @Override
    public CompletableFuture<Void> commitTxn(long committedLedgerId, long committedEntryId, TxnID txnID, Position position) {
        return ((CompletableFuture)this.getTxnMeta(txnID, false).thenCompose(meta -> meta.commitTxn(committedLedgerId, committedEntryId))).thenAccept(meta -> this.addTxnToCommittedIndex(txnID, committedLedgerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTxnToCommittedIndex(TxnID txnID, long committedAtLedgerId) {
        Map<Long, Set<TxnID>> map = this.committedLedgerTxnIndex;
        synchronized (map) {
            this.committedLedgerTxnIndex.computeIfAbsent(committedAtLedgerId, ledgerId -> new HashSet()).add(txnID);
        }
    }

    @Override
    public CompletableFuture<Void> abortTxn(TxnID txnID) {
        return ((CompletableFuture)this.getTxnMeta(txnID, false).thenCompose(meta -> meta.abortTxn())).thenApply(meta -> null);
    }

    @Override
    public CompletableFuture<Set<TxnID>> getAllTxnsCommittedAtLedger(long ledgerId) {
        CompletableFuture<Set<TxnID>> removeFuture = new CompletableFuture<Set<TxnID>>();
        Set<TxnID> txnIDS = this.committedLedgerTxnIndex.get(ledgerId);
        if (null == txnIDS) {
            removeFuture.completeExceptionally(new NoTxnsCommittedAtLedgerException("Transaction committed ledger id `" + ledgerId + "` doesn't exist"){});
            return removeFuture;
        }
        removeFuture.complete(txnIDS);
        return removeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeTxnsCommittedAtLedger(long ledgerId) {
        CompletableFuture<Void> removeFuture = new CompletableFuture<Void>();
        Map<Long, Set<TxnID>> map = this.committedLedgerTxnIndex;
        synchronized (map) {
            Set<TxnID> txnIDS = this.committedLedgerTxnIndex.remove(ledgerId);
            if (null == txnIDS) {
                removeFuture.completeExceptionally(new NoTxnsCommittedAtLedgerException("Transaction committed ledger id `" + ledgerId + "` doesn't exist"));
            } else {
                txnIDS.forEach(txnID -> this.txnIndex.remove(txnID));
                removeFuture.complete(null);
            }
        }
        return removeFuture;
    }
}

