/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.common.util.Murmur3_32Hash;

public class ConsistentHashingStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final NavigableMap<Integer, Consumer> hashRing = new TreeMap<Integer, Consumer>();
    private final int numberOfPoints;

    public ConsistentHashingStickyKeyConsumerSelector(int numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws BrokerServiceException.ConsumerAssignException {
        this.rwLock.writeLock().lock();
        try {
            for (int i = 0; i < this.numberOfPoints; ++i) {
                String key = consumer.consumerName() + i;
                int hash = Murmur3_32Hash.getInstance().makeHash(key.getBytes());
                this.hashRing.put(hash, consumer);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        this.rwLock.writeLock().lock();
        try {
            for (int i = 0; i < this.numberOfPoints; ++i) {
                String key = consumer.consumerName() + i;
                int hash = Murmur3_32Hash.getInstance().makeHash(key.getBytes());
                this.hashRing.remove(hash, consumer);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer select(byte[] stickyKey) {
        int hash = Murmur3_32Hash.getInstance().makeHash(stickyKey);
        this.rwLock.readLock().lock();
        try {
            if (this.hashRing.isEmpty()) {
                Consumer consumer = null;
                return consumer;
            }
            Map.Entry<Integer, Consumer> ceilingEntry = this.hashRing.ceilingEntry(hash);
            if (ceilingEntry != null) {
                Consumer consumer = ceilingEntry.getValue();
                return consumer;
            }
            Consumer consumer = this.hashRing.firstEntry().getValue();
            return consumer;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    Map<Integer, Consumer> getRangeConsumer() {
        return Collections.unmodifiableMap(this.hashRing);
    }
}

