/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.util.Recycler;
import java.util.BitSet;
import org.apache.commons.lang3.tuple.Pair;

public class EntryBatchIndexesAcks {
    Pair<Integer, long[]>[] indexesAcks = new Pair[100];
    private final Recycler.Handle<EntryBatchIndexesAcks> handle;
    private static final Recycler<EntryBatchIndexesAcks> RECYCLER = new Recycler<EntryBatchIndexesAcks>(){

        protected EntryBatchIndexesAcks newObject(Recycler.Handle<EntryBatchIndexesAcks> handle) {
            return new EntryBatchIndexesAcks(handle);
        }
    };

    public void setIndexesAcks(int entryIdx, Pair<Integer, long[]> indexesAcks) {
        this.indexesAcks[entryIdx] = indexesAcks;
    }

    public long[] getAckSet(int entryIdx) {
        Pair<Integer, long[]> pair = this.indexesAcks[entryIdx];
        return pair == null ? null : (long[])pair.getRight();
    }

    public int getTotalAckedIndexCount() {
        int count = 0;
        for (Pair<Integer, long[]> pair : this.indexesAcks) {
            if (pair == null) continue;
            count += (Integer)pair.getLeft() - BitSet.valueOf((long[])pair.getRight()).cardinality();
        }
        return count;
    }

    public void recycle() {
        this.handle.recycle((Object)this);
    }

    public static EntryBatchIndexesAcks get() {
        return (EntryBatchIndexesAcks)RECYCLER.get();
    }

    private EntryBatchIndexesAcks(Recycler.Handle<EntryBatchIndexesAcks> handle) {
        this.handle = handle;
    }
}

