/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.broker.transaction.buffer.exceptions.EndOfTransactionException;
import org.apache.pulsar.broker.transaction.buffer.exceptions.TransactionSealedException;
import org.apache.pulsar.broker.transaction.buffer.exceptions.UnexpectedTxnStatusException;
import org.apache.pulsar.transaction.impl.common.TxnID;
import org.apache.pulsar.transaction.impl.common.TxnStatus;

public class TransactionMetaImpl
implements TransactionMeta {
    private final TxnID txnID;
    private SortedMap<Long, Position> entries;
    private TxnStatus txnStatus;
    private long committedAtLedgerId = -1L;
    private long committedAtEntryId = -1L;

    TransactionMetaImpl(TxnID txnID) {
        this.txnID = txnID;
        this.entries = new TreeMap<Long, Position>();
        this.txnStatus = TxnStatus.OPEN;
    }

    @Override
    public TxnID id() {
        return this.txnID;
    }

    @Override
    public synchronized TxnStatus status() {
        return this.txnStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numEntries() {
        SortedMap<Long, Position> sortedMap = this.entries;
        synchronized (sortedMap) {
            return this.entries.size();
        }
    }

    @VisibleForTesting
    public SortedMap<Long, Position> getEntries() {
        return this.entries;
    }

    @Override
    public long committedAtLedgerId() {
        return this.committedAtLedgerId;
    }

    @Override
    public long committedAtEntryId() {
        return this.committedAtEntryId;
    }

    @Override
    public long lastSequenceId() {
        return this.entries.lastKey();
    }

    @Override
    public CompletableFuture<SortedMap<Long, Position>> readEntries(int num, long startSequenceId) {
        CompletableFuture<SortedMap<Long, Position>> readFuture = new CompletableFuture<SortedMap<Long, Position>>();
        TreeMap<Long, Position> result = new TreeMap<Long, Position>();
        SortedMap<Long, Position> readEntries = this.entries;
        if (startSequenceId != -1L) {
            readEntries = this.entries.tailMap(startSequenceId);
        }
        if (readEntries.isEmpty()) {
            readFuture.completeExceptionally(new EndOfTransactionException("No more entries found in transaction `" + this.txnID + "`"));
            return readFuture;
        }
        for (Map.Entry<Long, Position> longPositionEntry : readEntries.entrySet()) {
            result.put(longPositionEntry.getKey(), longPositionEntry.getValue());
        }
        readFuture.complete(result);
        return readFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> appendEntry(long sequenceId, Position position) {
        CompletableFuture<Void> appendFuture = new CompletableFuture<Void>();
        Object object = this;
        synchronized (object) {
            if (TxnStatus.OPEN != this.txnStatus) {
                appendFuture.completeExceptionally(new TransactionSealedException("Transaction `" + this.txnID + "` is already sealed"));
                return appendFuture;
            }
        }
        object = this.entries;
        synchronized (object) {
            this.entries.put(sequenceId, position);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<TransactionMeta> commitTxn(long committedAtLedgerId, long committedAtEntryId) {
        CompletableFuture<TransactionMeta> commitFuture = new CompletableFuture<TransactionMeta>();
        if (!this.checkOpened(this.txnID, commitFuture)) {
            return commitFuture;
        }
        this.committedAtLedgerId = committedAtLedgerId;
        this.committedAtEntryId = committedAtEntryId;
        this.txnStatus = TxnStatus.COMMITTED;
        TransactionMetaImpl meta = this;
        commitFuture.complete(meta);
        return commitFuture;
    }

    @Override
    public synchronized CompletableFuture<TransactionMeta> abortTxn() {
        CompletableFuture<TransactionMeta> abortFuture = new CompletableFuture<TransactionMeta>();
        if (!this.checkOpened(this.txnID, abortFuture)) {
            return abortFuture;
        }
        this.txnStatus = TxnStatus.ABORTED;
        abortFuture.complete(this);
        return abortFuture;
    }

    private boolean checkOpened(TxnID txnID, CompletableFuture<TransactionMeta> future) {
        if (TxnStatus.OPEN != this.txnStatus) {
            future.completeExceptionally(new UnexpectedTxnStatusException(txnID, TxnStatus.OPEN, this.txnStatus));
            return false;
        }
        return true;
    }
}

