/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamedEntity;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BookieAffinityGroupData;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamespacesBase
extends AdminResource {
    private static final long MAX_BUNDLES = 0x100000000L;
    private static final Logger log = LoggerFactory.getLogger(NamespacesBase.class);

    protected List<String> internalGetTenantNamespaces(String tenant) {
        Preconditions.checkNotNull((Object)tenant, (Object)"Tenant should not be null");
        try {
            NamedEntity.checkName((String)tenant);
        }
        catch (IllegalArgumentException e) {
            log.warn("[{}] Tenant name is invalid {}", new Object[]{this.clientAppId(), tenant, e});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Tenant name is not valid");
        }
        this.validateTenantOperation(tenant, TenantOperation.LIST_NAMESPACES);
        try {
            return this.getListOfNamespaces(tenant);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to get namespace list for tenant: {} - Does not exist", (Object)this.clientAppId(), (Object)tenant);
            throw new RestException(Response.Status.NOT_FOUND, "Property does not exist");
        }
        catch (Exception e) {
            log.error("[{}] Failed to get namespaces list: {}", (Object)this.clientAppId(), (Object)e);
            throw new RestException(e);
        }
    }

    protected void internalCreateNamespace(Policies policies) {
        this.validateTenantOperation(this.namespaceName.getTenant(), TenantOperation.CREATE_NAMESPACE);
        this.validatePoliciesReadOnlyAccess();
        this.validatePolicies(this.namespaceName, policies);
        try {
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            this.zkCreateOptimistic(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies));
            log.info("[{}] Created namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NodeExistsException e) {
            log.warn("[{}] Failed to create namespace {} - already exists", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Namespace already exists");
        }
        catch (Exception e) {
            log.error("[{}] Failed to create namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteNamespace(AsyncResponse asyncResponse, boolean authoritative) {
        boolean isEmpty;
        List<String> topics;
        this.validateTenantOperation(this.namespaceName.getTenant(), TenantOperation.DELETE_NAMESPACE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Map.Entry policiesNode = null;
        Policies policies = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist."));
            policies = (Policies)policiesNode.getKey();
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = (String)Lists.newArrayList((Iterable)policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clustersCache().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluster " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        try {
            topics = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).join();
            topics.addAll(this.getPartitionedTopicList(TopicDomain.persistent));
            topics.addAll(this.getPartitionedTopicList(TopicDomain.non_persistent));
            isEmpty = topics.isEmpty();
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        if (!isEmpty) {
            if (log.isDebugEnabled()) {
                log.debug("Found topics on namespace {}", (Object)this.namespaceName);
            }
            boolean hasNonSystemTopic = false;
            for (String topic : topics) {
                if (SystemTopicClient.isSystemTopic(TopicName.get((String)topic))) continue;
                hasNonSystemTopic = true;
                break;
            }
            if (hasNonSystemTopic) {
                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Cannot delete non empty namespace")));
                return;
            }
        }
        try {
            policies.deleted = true;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
        }
        catch (Exception e) {
            log.error("[{}] Failed to delete namespace on global ZK {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        ArrayList futures = Lists.newArrayList();
        try {
            if (!topics.isEmpty()) {
                for (String topic : topics) {
                    this.pulsar().getBrokerService().getTopicIfExists(topic).whenComplete((topicOptional, ex) -> topicOptional.ifPresent(systemTopic -> futures.add(systemTopic.deleteForcefully())));
                }
            }
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle bundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(bundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().deleteNamespaceBundleAsync(this.namespaceName.toString(), bundle.getBundleRange()));
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                log.error("[{}] Failed to remove owned namespace {}", new Object[]{this.clientAppId(), this.namespaceName, exception});
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            try {
                String globalZkPolicyPath = NamespacesBase.path("policies", this.namespaceName.toString());
                String lcaolZkPolicyPath = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
                this.globalZk().delete(globalZkPolicyPath, -1);
                try {
                    this.localZk().delete(lcaolZkPolicyPath, -1);
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                this.policiesCache().invalidate(globalZkPolicyPath);
                this.localCacheService().policiesCache().invalidate(lcaolZkPolicyPath);
            }
            catch (Exception e) {
                log.error("[{}] Failed to remove owned namespace {} from ZK", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                return null;
            }
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalDeleteNamespaceBundle(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.DELETE_BUNDLE);
        this.validatePoliciesReadOnlyAccess();
        if (!this.namespaceName.isGlobal()) {
            this.validateClusterOwnership(this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        try {
            if (this.namespaceName.isGlobal()) {
                if (policies.replication_clusters.size() > 1) {
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot delete the global namespace " + this.namespaceName + ". There are still more than one replication clusters configured.");
                }
                if (policies.replication_clusters.size() == 1 && !policies.replication_clusters.contains(this.config().getClusterName())) {
                    URL replClusterUrl;
                    String replCluster = (String)Lists.newArrayList((Iterable)policies.replication_clusters).get(0);
                    ClusterData replClusterData = (ClusterData)this.clustersCache().get(AdminResource.path("clusters", replCluster)).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Cluser " + replCluster + " does not exist"));
                    if (!this.config().isTlsEnabled() || !this.isRequestHttps()) {
                        replClusterUrl = new URL(replClusterData.getServiceUrl());
                    } else if (StringUtils.isNotBlank((CharSequence)replClusterData.getServiceUrlTls())) {
                        replClusterUrl = new URL(replClusterData.getServiceUrlTls());
                    } else {
                        throw new RestException(Response.Status.PRECONDITION_FAILED, "The replication cluster does not provide TLS encrypted service");
                    }
                    URI redirect = UriBuilder.fromUri((URI)this.uri.getRequestUri()).host(replClusterUrl.getHost()).port(replClusterUrl.getPort()).replaceQueryParam("authoritative", new Object[]{false}).build(new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Redirecting the rest call to {}: cluster={}", new Object[]{this.clientAppId(), redirect, replCluster});
                    }
                    throw new WebApplicationException(Response.temporaryRedirect((URI)redirect).build());
                }
            }
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            throw new RestException(e);
        }
        NamespaceBundle bundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        try {
            List<String> topics = this.pulsar().getNamespaceService().getListOfPersistentTopics(this.namespaceName).join();
            for (String topic : topics) {
                NamespaceBundle topicBundle = this.pulsar().getNamespaceService().getBundle(TopicName.get((String)topic));
                if (!bundle.equals(topicBundle)) continue;
                throw new RestException(Response.Status.CONFLICT, "Cannot delete non empty bundle");
            }
            this.pulsar().getNamespaceService().removeOwnedServiceUnit(bundle);
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName.toString(), bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnNamespace(String role, Set<AuthAction> actions) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.GRANT_PERMISSION);
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantPermissionAsync(this.namespaceName, actions, role, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", new Object[]{this.clientAppId(), this.namespaceName, e});
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, e.getCause().getMessage(), e});
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalGrantPermissionOnSubscription(String subscription, Set<String> roles) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.GRANT_PERMISSION);
        try {
            AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
            if (null == authService) {
                throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
            }
            authService.grantSubscriptionPermissionAsync(this.namespaceName, subscription, roles, null).get();
        }
        catch (InterruptedException e) {
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.warn("[{}] Failed to set permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
            }
            if (e.getCause() instanceof IllegalStateException) {
                log.warn("[{}] Failed to set permissions for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
            }
            log.error("[{}] Failed to get permissions for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnNamespace(String role) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            byte[] content = this.globalZk().getData(NamespacesBase.path("policies", this.namespaceName.toString()), null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.auth_policies.namespace_auth.remove(role);
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully revoked access for role {} - namespace {}", new Object[]{this.clientAppId(), role, this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to revoke permissions for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to revoke permissions on namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to revoke permissions on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRevokePermissionsOnSubscription(String subscriptionName, String role) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.REVOKE_PERMISSION);
        this.validatePoliciesReadOnlyAccess();
        AuthorizationService authService = this.pulsar().getBrokerService().getAuthorizationService();
        if (null == authService) {
            throw new RestException(Response.Status.NOT_IMPLEMENTED, "Authorization is not enabled");
        }
        authService.revokeSubscriptionPermissionAsync(this.namespaceName, subscriptionName, role, null);
    }

    protected Set<String> internalGetNamespaceReplicationClusters() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.READ);
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot get the replication clusters for a non-global namespace");
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.replication_clusters;
    }

    protected void internalSetNamespaceReplicationClusters(List<String> clusterIds) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        HashSet replicationClusterSet = Sets.newHashSet(clusterIds);
        if (!this.namespaceName.isGlobal()) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot set replication on a non-global namespace");
        }
        if (replicationClusterSet.contains("global")) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot specify global in the list of replication clusters");
        }
        Set<String> clusters = this.clusters();
        for (String clusterId : replicationClusterSet) {
            if (!clusters.contains(clusterId)) {
                throw new RestException(Response.Status.FORBIDDEN, "Invalid cluster id: " + clusterId);
            }
            this.validatePeerClusterConflict(clusterId, replicationClusterSet);
        }
        for (String clusterId : replicationClusterSet) {
            this.validateClusterForTenant(this.namespaceName.getTenant(), clusterId);
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).replication_clusters = replicationClusterSet;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the replication clusters on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the replication clusters for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the replication clusters on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the replication clusters on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetNamespaceMessageTTL(int messageTTL) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.TTL, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (messageTTL < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).message_ttl_in_seconds = messageTTL;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the message TTL on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the message TTL for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the message TTL on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the message TTL on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetSubscriptionExpirationTime(int expirationTime) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (expirationTime < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for subscription expiration time");
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).subscription_expiration_time_minutes = expirationTime;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the subscription expiration time on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the subscription expiration time for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the subscription expiration time on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscription expiration time on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetAutoTopicCreation(AsyncResponse asyncResponse, AutoTopicCreationOverride autoTopicCreationOverride) {
        int maxPartitions = this.pulsar().getConfig().getMaxNumPartitionsPerPartitionedTopic();
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        if (!AutoTopicCreationOverride.isValidOverride((AutoTopicCreationOverride)autoTopicCreationOverride)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid configuration for autoTopicCreationOverride");
        }
        if (maxPartitions > 0 && autoTopicCreationOverride.defaultNumPartitions > maxPartitions) {
            throw new RestException(Response.Status.NOT_ACCEPTABLE, "Number of partitions should be less than or equal to " + maxPartitions);
        }
        ((CompletableFuture)this.policiesCache().getWithStatAsync(NamespacesBase.path("policies", this.namespaceName.toString())).thenApply(policies -> {
            if (policies.isPresent()) {
                Map.Entry policiesNode = (Map.Entry)policies.get();
                ((Policies)policiesNode.getKey()).autoTopicCreationOverride = autoTopicCreationOverride;
                try {
                    this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion(), (rc, path1, ctx, stat) -> {
                        if (rc == KeeperException.Code.OK.intValue()) {
                            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
                            String autoOverride = autoTopicCreationOverride.allowAutoTopicCreation ? "enabled" : "disabled";
                            log.info("[{}] Successfully {} autoTopicCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride, this.namespaceName});
                            asyncResponse.resume((Object)Response.noContent().build());
                        } else {
                            String errorMsg = String.format("[%s] Failed to modify autoTopicCreation status for namespace %s", this.clientAppId(), this.namespaceName);
                            if (rc == KeeperException.Code.NONODE.intValue()) {
                                log.warn("{} : does not exist", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
                            } else if (rc == KeeperException.Code.BADVERSION.intValue()) {
                                log.warn("{} : concurrent modification", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                            } else {
                                asyncResponse.resume((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)errorMsg));
                            }
                        }
                    }, null);
                    return null;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to modify autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return null;
                }
            }
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist")));
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
            return null;
        });
    }

    protected void internalRemoveAutoTopicCreation(AsyncResponse asyncResponse) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        ((CompletableFuture)this.policiesCache().getWithStatAsync(NamespacesBase.path("policies", this.namespaceName.toString())).thenApply(policies -> {
            if (policies.isPresent()) {
                Map.Entry policiesNode = (Map.Entry)policies.get();
                ((Policies)policiesNode.getKey()).autoTopicCreationOverride = null;
                try {
                    this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion(), (rc, path1, ctx, stat) -> {
                        if (rc == KeeperException.Code.OK.intValue()) {
                            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
                            log.info("[{}] Successfully removed autoTopicCreation override on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
                            asyncResponse.resume((Object)Response.noContent().build());
                        } else {
                            String errorMsg = String.format("[%s] Failed to modify autoTopicCreation status for namespace %s", this.clientAppId(), this.namespaceName);
                            if (rc == KeeperException.Code.NONODE.intValue()) {
                                log.warn("{} : does not exist", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
                            } else if (rc == KeeperException.Code.BADVERSION.intValue()) {
                                log.warn("{} : concurrent modification", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                            } else {
                                asyncResponse.resume((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)errorMsg));
                            }
                        }
                    }, null);
                    return null;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to modify autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return null;
                }
            }
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist")));
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoTopicCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
            return null;
        });
    }

    protected void internalSetAutoSubscriptionCreation(AsyncResponse asyncResponse, AutoSubscriptionCreationOverride autoSubscriptionCreationOverride) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        ((CompletableFuture)this.policiesCache().getWithStatAsync(NamespacesBase.path("policies", this.namespaceName.toString())).thenApply(policies -> {
            if (policies.isPresent()) {
                Map.Entry policiesNode = (Map.Entry)policies.get();
                ((Policies)policiesNode.getKey()).autoSubscriptionCreationOverride = autoSubscriptionCreationOverride;
                try {
                    this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion(), (rc, path1, ctx, stat) -> {
                        if (rc == KeeperException.Code.OK.intValue()) {
                            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
                            String autoOverride = autoSubscriptionCreationOverride.allowAutoSubscriptionCreation ? "enabled" : "disabled";
                            log.info("[{}] Successfully {} autoSubscriptionCreation on namespace {}", new Object[]{this.clientAppId(), autoOverride, this.namespaceName});
                            asyncResponse.resume((Object)Response.noContent().build());
                        } else {
                            String errorMsg = String.format("[%s] Failed to modify autoSubscriptionCreation status for namespace %s", this.clientAppId(), this.namespaceName);
                            if (rc == KeeperException.Code.NONODE.intValue()) {
                                log.warn("{} : does not exist", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
                            } else if (rc == KeeperException.Code.BADVERSION.intValue()) {
                                log.warn("{} : concurrent modification", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                            } else {
                                asyncResponse.resume((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)errorMsg));
                            }
                        }
                    }, null);
                    return null;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to modify autoSubscriptionCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return null;
                }
            }
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist")));
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoSubscriptionCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
            return null;
        });
    }

    protected void internalRemoveAutoSubscriptionCreation(AsyncResponse asyncResponse) {
        this.validateAdminAccessForTenant(this.namespaceName.getTenant());
        this.validatePoliciesReadOnlyAccess();
        ((CompletableFuture)this.policiesCache().getWithStatAsync(NamespacesBase.path("policies", this.namespaceName.toString())).thenApply(policies -> {
            if (policies.isPresent()) {
                Map.Entry policiesNode = (Map.Entry)policies.get();
                ((Policies)policiesNode.getKey()).autoSubscriptionCreationOverride = null;
                try {
                    this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion(), (rc, path1, ctx, stat) -> {
                        if (rc == KeeperException.Code.OK.intValue()) {
                            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
                            log.info("[{}] Successfully removed autoSubscriptionCreation override on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
                            asyncResponse.resume((Object)Response.noContent().build());
                        } else {
                            String errorMsg = String.format("[%s] Failed to modify autoSubscriptionCreation status for namespace %s", this.clientAppId(), this.namespaceName);
                            if (rc == KeeperException.Code.NONODE.intValue()) {
                                log.warn("{} : does not exist", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
                            } else if (rc == KeeperException.Code.BADVERSION.intValue()) {
                                log.warn("{} : concurrent modification", (Object)errorMsg);
                                asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                            } else {
                                asyncResponse.resume((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)errorMsg));
                            }
                        }
                    }, null);
                    return null;
                }
                catch (Exception e) {
                    log.error("[{}] Failed to modify autoSubscriptionCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                    asyncResponse.resume((Throwable)((Object)new RestException(e)));
                    return null;
                }
            }
            asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist")));
            return null;
        })).exceptionally(e -> {
            log.error("[{}] Failed to modify autoSubscriptionCreation status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException((Throwable)e)));
            return null;
        });
    }

    protected void internalModifyDeduplication(boolean enableDeduplication) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DEDUPLICATION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).deduplicationEnabled = enableDeduplication;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), enableDeduplication ? "enabled" : "disabled", this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to modify deduplication status for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to modify deduplication status on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify deduplication status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalUnloadNamespace(AsyncResponse asyncResponse) {
        this.validateSuperUserAccess();
        log.info("[{}] Unloading namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        ArrayList futures = Lists.newArrayList();
        List boundaries = policies.bundles.getBoundaries();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            String bundle = String.format("%s_%s", boundaries.get(i), boundaries.get(i + 1));
            try {
                futures.add(this.pulsar().getAdminClient().namespaces().unloadNamespaceBundleAsync(this.namespaceName.toString(), bundle));
                continue;
            }
            catch (PulsarServerException e) {
                log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
                asyncResponse.resume((Throwable)((Object)new RestException(e)));
                return;
            }
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                log.error("[{}] Failed to unload namespace {}", new Object[]{this.clientAppId(), this.namespaceName, exception});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully unloaded all the bundles in namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalSetBookieAffinityGroup(BookieAffinityGroupData bookieAffinityGroup) {
        this.validateSuperUserAccess();
        log.info("[{}] Setting bookie-affinity-group {} for namespace {}", new Object[]{this.clientAppId(), bookieAffinityGroup, this.namespaceName});
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        try {
            String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
            Stat nodeStat = new Stat();
            LocalPolicies localPolicies = null;
            int version = -1;
            try {
                byte[] content = this.pulsar().getLocalZkCache().getZooKeeper().getData(path, false, nodeStat);
                localPolicies = (LocalPolicies)NamespacesBase.jsonMapper().readValue(content, LocalPolicies.class);
                version = nodeStat.getVersion();
            }
            catch (KeeperException.NoNodeException e) {
                log.info("local-policies for {} is not setup at path {}", (Object)this.namespaceName, (Object)path);
                this.pulsar().getLocalZkCacheService().createPolicies(path, false).get(this.pulsar().getConfiguration().getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
                localPolicies = new LocalPolicies();
            }
            localPolicies.bookieAffinityGroup = bookieAffinityGroup;
            byte[] data = ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)localPolicies);
            this.pulsar().getLocalZkCache().getZooKeeper().setData(path, data, Math.toIntExact(version));
            this.pulsar().getLocalZkCacheService().policiesCache().invalidate(path);
            log.info("[{}] Successfully updated local-policies configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)localPolicies)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update persistence configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update local-policy configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalDeleteBookieAffinityGroup() {
        this.internalSetBookieAffinityGroup(null);
    }

    protected BookieAffinityGroupData internalGetBookieAffinityGroup() {
        this.validateSuperUserAccess();
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        String path = NamespacesBase.joinPath("/admin/local-policies", this.namespaceName.toString());
        try {
            Optional policies = this.pulsar().getLocalZkCacheService().policiesCache().get(path);
            BookieAffinityGroupData bookkeeperAffinityGroup = ((LocalPolicies)policies.orElseThrow((Supplier<RestException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$internalGetBookieAffinityGroup$23(), ()Lorg/apache/pulsar/broker/web/RestException;)())).bookieAffinityGroup;
            if (bookkeeperAffinityGroup == null) {
                throw new RestException(Response.Status.NOT_FOUND, "bookie-affinity group does not exist");
            }
            return bookkeeperAffinityGroup;
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update local-policy configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace policies does not exist");
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to get local-policy configuration for namespace {} at path {}", new Object[]{this.clientAppId(), this.namespaceName, path, e});
            throw new RestException(e);
        }
    }

    public void internalUnloadNamespaceBundle(String bundleRange, boolean authoritative) {
        boolean isOwnedByLocalCluster;
        Policies policies;
        block8: {
            this.validateSuperUserAccess();
            log.info("[{}] Unloading namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
            policies = this.getNamespacePolicies(this.namespaceName);
            NamespaceBundle bundle = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundle(this.namespaceName.toString(), bundleRange);
            isOwnedByLocalCluster = false;
            try {
                isOwnedByLocalCluster = this.pulsar().getNamespaceService().isNamespaceBundleOwned(bundle).get();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug("Failed to validate cluster ownership for {}-{}, {}", new Object[]{this.namespaceName.toString(), bundleRange, e.getMessage(), e});
            }
        }
        if (!isOwnedByLocalCluster) {
            if (this.namespaceName.isGlobal()) {
                this.validateGlobalNamespaceOwnership(this.namespaceName);
            } else {
                this.validateClusterOwnership(this.namespaceName.getCluster());
                this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
            }
        }
        this.validatePoliciesReadOnlyAccess();
        if (!this.isBundleOwnedByAnyBroker(this.namespaceName, policies.bundles, bundleRange)) {
            log.info("[{}] Namespace bundle is not owned by any broker {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
            return;
        }
        NamespaceBundle nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        try {
            this.pulsar().getNamespaceService().unloadNamespaceBundle(nsBundle);
            log.info("[{}] Successfully unloaded namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (Exception e) {
            log.error("[{}] Failed to unload namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e});
            throw new RestException(e);
        }
    }

    protected void internalSplitNamespaceBundle(String bundleRange, boolean authoritative, boolean unload, String splitAlgorithmName) {
        this.validateSuperUserAccess();
        log.info("[{}] Split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validatePoliciesReadOnlyAccess();
        NamespaceBundle nsBundle = this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        List supportedNamespaceBundleSplitAlgorithms = this.pulsar().getConfig().getSupportedNamespaceBundleSplitAlgorithms();
        if (StringUtils.isNotBlank((CharSequence)splitAlgorithmName) && !supportedNamespaceBundleSplitAlgorithms.contains(splitAlgorithmName)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Unsupported namespace bundle split algorithm, supported algorithms are " + supportedNamespaceBundleSplitAlgorithms);
        }
        try {
            this.pulsar().getNamespaceService().splitAndOwnBundle(nsBundle, unload, this.getNamespaceBundleSplitAlgorithmByName(splitAlgorithmName)).get();
            log.info("[{}] Successfully split namespace bundle {}", (Object)this.clientAppId(), (Object)nsBundle.toString());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                log.error("[{}] Failed to split namespace bundle {}/{} due to {}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e.getMessage()});
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Split bundle failed due to invalid request");
            }
            log.error("[{}] Failed to split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e});
            throw new RestException(e.getCause());
        }
        catch (Exception e) {
            log.error("[{}] Failed to split namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange, e});
            throw new RestException(e);
        }
    }

    private NamespaceBundleSplitAlgorithm getNamespaceBundleSplitAlgorithmByName(String algorithmName) {
        NamespaceBundleSplitAlgorithm algorithm = NamespaceBundleSplitAlgorithm.of(algorithmName);
        if (algorithm == null) {
            algorithm = NamespaceBundleSplitAlgorithm.of(this.pulsar().getConfig().getDefaultNamespaceBundleSplitAlgorithm());
        }
        if (algorithm == null) {
            algorithm = NamespaceBundleSplitAlgorithm.rangeEquallyDivide;
        }
        return algorithm;
    }

    protected void internalSetPublishRate(PublishRate maxPublishMessageRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace publish-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, maxPublishMessageRate});
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).publishMaxMessageRate.put(this.pulsar().getConfiguration().getClusterName(), maxPublishMessageRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the publish_max_message_rate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the publish_max_message_rate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the publish_max_message_rate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the publish_max_message_rate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected PublishRate internalGetPublishRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        PublishRate publishRate = (PublishRate)policies.publishMaxMessageRate.get(this.pulsar().getConfiguration().getClusterName());
        if (publishRate != null) {
            return publishRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Publish-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetTopicDispatchRate(DispatchRate dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).topicDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            ((Policies)policiesNode.getKey()).clusterDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the dispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the dispatchRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the dispatchRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the dispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetTopicDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        DispatchRate dispatchRate = (DispatchRate)policies.topicDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        if (dispatchRate == null) {
            dispatchRate = (DispatchRate)policies.clusterDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        }
        if (dispatchRate != null) {
            return dispatchRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Dispatch-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscriptionDispatchRate(DispatchRate dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace subscription dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).subscriptionDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the subscriptionDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscriptionDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetSubscriptionDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        DispatchRate dispatchRate = (DispatchRate)policies.subscriptionDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        if (dispatchRate != null) {
            return dispatchRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Subscription-Dispatch-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetSubscribeRate(SubscribeRate subscribeRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace subscribe-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, subscribeRate});
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).clusterSubscribeRate.put(this.pulsar().getConfiguration().getClusterName(), subscribeRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the subscribeRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the subscribeRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the subscribeRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the subscribeRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected SubscribeRate internalGetSubscribeRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        SubscribeRate subscribeRate = (SubscribeRate)policies.clusterSubscribeRate.get(this.pulsar().getConfiguration().getClusterName());
        if (subscribeRate != null) {
            return subscribeRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "Subscribe-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetReplicatorDispatchRate(DispatchRate dispatchRate) {
        this.validateSuperUserAccess();
        log.info("[{}] Set namespace replicator dispatch-rate {}/{}", new Object[]{this.clientAppId(), this.namespaceName, dispatchRate});
        Map.Entry policiesNode = null;
        try {
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(path).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).replicatorDispatchRate.put(this.pulsar().getConfiguration().getClusterName(), dispatchRate);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(path);
            log.info("[{}] Successfully updated the replicatorDispatchRate for cluster on namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the replicatorDispatchRate for cluster on namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the replicatorDispatchRate for cluster on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the replicatorDispatchRate for cluster on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DispatchRate internalGetReplicatorDispatchRate() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.REPLICATION_RATE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        DispatchRate dispatchRate = (DispatchRate)policies.replicatorDispatchRate.get(this.pulsar().getConfiguration().getClusterName());
        if (dispatchRate != null) {
            return dispatchRate;
        }
        throw new RestException(Response.Status.NOT_FOUND, "replicator-Dispatch-rate is not configured for cluster " + this.pulsar().getConfiguration().getClusterName());
    }

    protected void internalSetBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (backlogQuotaType == null) {
            backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            RetentionPolicies r = policies.retention_policies;
            if (r != null) {
                Policies p = new Policies();
                p.backlog_quota_map.put(backlogQuotaType, backlogQuota);
                if (!this.checkQuotas(p, r)) {
                    log.warn("[{}] Failed to update backlog configuration for namespace {}: conflicts with retention quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                    throw new RestException(Response.Status.PRECONDITION_FAILED, "Backlog Quota exceeds configured retention quota for namespace. Please increase retention quota and retry");
                }
            }
            policies.backlog_quota_map.put(backlogQuotaType, backlogQuota);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated backlog quota map: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.backlog_quota_map)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalRemoveBacklogQuota(BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.BACKLOG, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (backlogQuotaType == null) {
            backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.backlog_quota_map.remove(backlogQuotaType);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully removed backlog namespace={}, quota={}", new Object[]{this.clientAppId(), this.namespaceName, backlogQuotaType});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update backlog quota map for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update backlog quota map for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetRetention(RetentionPolicies retention) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RETENTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (!this.checkQuotas(policies, retention)) {
                log.warn("[{}] Failed to update retention configuration for namespace {}: conflicts with backlog quota", (Object)this.clientAppId(), (Object)this.namespaceName);
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Retention Quota must exceed configured backlog quota for namespace.");
            }
            policies.retention_policies = retention;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated retention configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.retention_policies)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update retention configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update retention configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update retention configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetPersistence(PersistencePolicies persistence) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.validatePersistencePolicies(persistence);
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.persistence = persistence;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated persistence configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.persistence)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update persistence configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update persistence configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update persistence configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected PersistencePolicies internalGetPersistence() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.PERSISTENCE, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.persistence == null) {
            return new PersistencePolicies(this.config().getManagedLedgerDefaultEnsembleSize(), this.config().getManagedLedgerDefaultWriteQuorum(), this.config().getManagedLedgerDefaultAckQuorum(), 0.0);
        }
        return policies.persistence;
    }

    protected void internalClearNamespaceBacklog(AsyncResponse asyncResponse, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        ArrayList futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogAsync(this.namespaceName.toString(), nsBundle.getBundleRange()));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully cleared backlog on all the bundles for namespace {}", (Object)this.clientAppId(), (Object)this.namespaceName);
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklog(String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, null);
        log.info("[{}] Successfully cleared backlog on namespace bundle {}/{}", new Object[]{this.clientAppId(), this.namespaceName, bundleRange});
    }

    protected void internalClearNamespaceBacklogForSubscription(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        ArrayList futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().clearNamespaceBundleBacklogForSubscriptionAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to clear backlog for subscription {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully cleared backlog for subscription {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalClearNamespaceBundleBacklogForSubscription(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.CLEAR_BACKLOG);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.clearBacklog(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully cleared backlog for subscription {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalUnsubscribeNamespace(AsyncResponse asyncResponse, String subscription, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        ArrayList futures = Lists.newArrayList();
        try {
            NamespaceBundles bundles = this.pulsar().getNamespaceService().getNamespaceBundleFactory().getBundles(this.namespaceName);
            for (NamespaceBundle nsBundle : bundles.getBundles()) {
                if (!this.pulsar().getNamespaceService().getOwner(nsBundle).isPresent()) continue;
                futures.add(this.pulsar().getAdminClient().namespaces().unsubscribeNamespaceBundleAsync(this.namespaceName.toString(), nsBundle.getBundleRange(), subscription));
            }
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
            return;
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
            return;
        }
        FutureUtil.waitForAll((List)futures).handle((result, exception) -> {
            if (exception != null) {
                log.warn("[{}] Failed to unsubscribe {} on the bundles for namespace {}: {}", new Object[]{this.clientAppId(), subscription, this.namespaceName, exception.getCause().getMessage()});
                if (exception.getCause() instanceof PulsarAdminException) {
                    asyncResponse.resume((Throwable)((Object)new RestException((PulsarAdminException)exception.getCause())));
                    return null;
                }
                asyncResponse.resume((Throwable)((Object)new RestException(exception.getCause())));
                return null;
            }
            log.info("[{}] Successfully unsubscribed {} on all the bundles for namespace {}", new Object[]{this.clientAppId(), subscription, this.namespaceName});
            asyncResponse.resume((Object)Response.noContent().build());
            return null;
        });
    }

    protected void internalUnsubscribeNamespaceBundle(String subscription, String bundleRange, boolean authoritative) {
        this.validateNamespaceOperation(this.namespaceName, NamespaceOperation.UNSUBSCRIBE);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (this.namespaceName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        } else {
            this.validateClusterOwnership(this.namespaceName.getCluster());
            this.validateClusterForTenant(this.namespaceName.getTenant(), this.namespaceName.getCluster());
        }
        this.validateNamespaceBundleOwnership(this.namespaceName, policies.bundles, bundleRange, authoritative, true);
        this.unsubscribe(this.namespaceName, bundleRange, subscription);
        log.info("[{}] Successfully unsubscribed {} on namespace bundle {}/{}", new Object[]{this.clientAppId(), subscription, this.namespaceName, bundleRange});
    }

    protected void internalSetSubscriptionAuthMode(SubscriptionAuthMode subscriptionAuthMode) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SUBSCRIPTION_AUTH_MODE, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        if (subscriptionAuthMode == null) {
            subscriptionAuthMode = SubscriptionAuthMode.None;
        }
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.subscription_auth_mode = subscriptionAuthMode;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated subscription auth mode: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString((Object)policies.backlog_quota_map)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update subscription auth mode for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update subscription auth mode for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update subscription auth mode for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalModifyEncryptionRequired(boolean encryptionRequired) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ENCRYPTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).encryption_required = encryptionRequired;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully {} on namespace {}", new Object[]{this.clientAppId(), encryptionRequired ? "true" : "false", this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to modify encryption required status for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to modify encryption required status on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to modify encryption required status on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected DelayedDeliveryPolicies internalGetDelayedDelivery() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.DELAYED_DELIVERY, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.delayed_delivery_policies == null) {
            return new DelayedDeliveryPolicies(this.config().getDelayedDeliveryTickTimeMillis(), this.config().isDelayedDeliveryEnabled());
        }
        return policies.delayed_delivery_policies;
    }

    protected InactiveTopicPolicies internalGetInactiveTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.INACTIVE_TOPIC, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.inactive_topic_policies == null) {
            return new InactiveTopicPolicies(this.config().getBrokerDeleteInactiveTopicsMode(), this.config().getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), this.config().isBrokerDeleteInactiveTopicsEnabled());
        }
        return policies.inactive_topic_policies;
    }

    protected void internalSetInactiveTopic(InactiveTopicPolicies inactiveTopicPolicies) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("inactive_topic_policies", inactiveTopicPolicies);
    }

    protected void internalSetPolicies(String fieldName, Object value) {
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            Field field = Policies.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(policies, value);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, NamespacesBase.jsonMapper().writeValueAsString(value)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: does not exist", new Object[]{this.clientAppId(), fieldName, this.namespaceName});
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: concurrent modification", new Object[]{this.clientAppId(), fieldName, this.namespaceName});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), fieldName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetDelayedDelivery(DelayedDeliveryPolicies delayedDeliveryPolicies) {
        this.validateSuperUserAccess();
        this.validatePoliciesReadOnlyAccess();
        this.internalSetPolicies("delayed_delivery_policies", delayedDeliveryPolicies);
    }

    protected void internalSetNamespaceAntiAffinityGroup(String antiAffinityGroup) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Setting anti-affinity group {} for {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "antiAffinityGroup can't be empty");
        }
        Map.Entry policiesNode = null;
        try {
            policiesNode = (Map.Entry)this.policiesCache().getWithStat(NamespacesBase.path("policies", this.namespaceName.toString())).orElseThrow(() -> new RestException(Response.Status.NOT_FOUND, "Namespace " + this.namespaceName + " does not exist"));
            ((Policies)policiesNode.getKey()).antiAffinityGroup = antiAffinityGroup;
            this.globalZk().setData(NamespacesBase.path("policies", this.namespaceName.toString()), NamespacesBase.jsonMapper().writeValueAsBytes(policiesNode.getKey()), ((Stat)policiesNode.getValue()).getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated the antiAffinityGroup {} on namespace {}", new Object[]{this.clientAppId(), antiAffinityGroup, this.namespaceName});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update the antiAffinityGroup for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update the antiAffinityGroup on namespace {} expected policy node version={} : concurrent modification", new Object[]{this.clientAppId(), this.namespaceName, ((Stat)policiesNode.getValue()).getVersion()});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to update the antiAffinityGroup on namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected String internalGetNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).antiAffinityGroup;
    }

    protected void internalRemoveNamespaceAntiAffinityGroup() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        log.info("[{}] Deleting anti-affinity group for {}", (Object)this.clientAppId(), (Object)this.namespaceName);
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies.antiAffinityGroup = null;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully removed anti-affinity group for a namespace={}", (Object)this.clientAppId(), (Object)this.namespaceName);
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to remove anti-affinity group for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to remove anti-affinity group for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (Exception e) {
            log.error("[{}] Failed to remove anti-affinity group for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected List<String> internalGetAntiAffinityNamespaces(String cluster, String antiAffinityGroup, String tenant) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.ANTI_AFFINITY, PolicyOperation.READ);
        log.info("[{}]-{} Finding namespaces for {} in {}", new Object[]{this.clientAppId(), tenant, antiAffinityGroup, cluster});
        if (StringUtils.isBlank((CharSequence)antiAffinityGroup)) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "anti-affinity group can't be empty.");
        }
        this.validateClusterExists(cluster);
        try {
            List<String> namespaces = this.getListOfNamespaces(tenant);
            return namespaces.stream().filter(ns -> {
                Optional policies;
                try {
                    policies = this.policiesCache().get(AdminResource.path("policies", ns));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                String storedAntiAffinityGroup = policies.orElse(new Policies()).antiAffinityGroup;
                return antiAffinityGroup.equalsIgnoreCase(storedAntiAffinityGroup);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.warn("Failed to list of properties/namespace from global-zk", (Throwable)e);
            throw new RestException(e);
        }
    }

    private void validatePersistencePolicies(PersistencePolicies persistence) {
        try {
            Preconditions.checkNotNull((Object)persistence);
            ServiceConfiguration config = this.pulsar().getConfiguration();
            Preconditions.checkArgument((persistence.getBookkeeperEnsemble() <= config.getManagedLedgerMaxEnsembleSize() ? 1 : 0) != 0, (String)"Bookkeeper-Ensemble must be <= %s", (int)config.getManagedLedgerMaxEnsembleSize());
            Preconditions.checkArgument((persistence.getBookkeeperWriteQuorum() <= config.getManagedLedgerMaxWriteQuorum() ? 1 : 0) != 0, (String)"Bookkeeper-WriteQuorum must be <= %s", (int)config.getManagedLedgerMaxWriteQuorum());
            Preconditions.checkArgument((persistence.getBookkeeperAckQuorum() <= config.getManagedLedgerMaxAckQuorum() ? 1 : 0) != 0, (String)"Bookkeeper-AckQuorum must be <= %s", (int)config.getManagedLedgerMaxAckQuorum());
            Preconditions.checkArgument((persistence.getBookkeeperEnsemble() >= persistence.getBookkeeperWriteQuorum() && persistence.getBookkeeperWriteQuorum() >= persistence.getBookkeeperAckQuorum() ? 1 : 0) != 0, (String)"Bookkeeper Ensemble (%s) >= WriteQuorum (%s) >= AckQuoru (%s)", (Object)persistence.getBookkeeperEnsemble(), (Object)persistence.getBookkeeperWriteQuorum(), (Object)persistence.getBookkeeperAckQuorum());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, e.getMessage());
        }
    }

    protected RetentionPolicies internalGetRetention() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.RETENTION, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.retention_policies == null) {
            return new RetentionPolicies(this.config().getDefaultRetentionTimeInMinutes(), this.config().getDefaultRetentionSizeInMB());
        }
        return policies.retention_policies;
    }

    private boolean checkQuotas(Policies policies, RetentionPolicies retention) {
        Map backlog_quota_map = policies.backlog_quota_map;
        if (backlog_quota_map.isEmpty() || retention.getRetentionSizeInMB() == 0L || retention.getRetentionSizeInMB() == -1L) {
            return true;
        }
        BacklogQuota quota = (BacklogQuota)backlog_quota_map.get(BacklogQuota.BacklogQuotaType.destination_storage);
        if (quota == null) {
            quota = this.pulsar().getBrokerService().getBacklogQuotaManager().getDefaultQuota();
        }
        if (quota.getLimit() < 0L && (retention.getRetentionSizeInMB() > 0L || retention.getRetentionTimeInMinutes() > 0)) {
            return false;
        }
        return quota.getLimit() < retention.getRetentionSizeInMB() * 1024L * 1024L;
    }

    private void clearBacklog(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList futures = Lists.newArrayList();
            if (subscription != null) {
                if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                    subscription = PersistentReplicator.getRemoteCluster(subscription);
                }
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || SystemTopicClient.isSystemTopic(TopicName.get((String)topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog(subscription));
                }
            } else {
                for (Topic topic : topicList) {
                    if (!(topic instanceof PersistentTopic) || SystemTopicClient.isSystemTopic(TopicName.get((String)topic.getName()))) continue;
                    futures.add(((PersistentTopic)topic).clearBacklog());
                }
            }
            FutureUtil.waitForAll((List)futures).get();
        }
        catch (Exception e) {
            log.error("[{}] Failed to clear backlog for namespace {}/{}, subscription: {}", new Object[]{this.clientAppId(), nsName.toString(), bundleRange, subscription, e});
            throw new RestException(e);
        }
    }

    private void unsubscribe(NamespaceName nsName, String bundleRange, String subscription) {
        try {
            List<Topic> topicList = this.pulsar().getBrokerService().getAllTopicsFromNamespaceBundle(nsName.toString(), nsName.toString() + "/" + bundleRange);
            ArrayList futures = Lists.newArrayList();
            if (subscription.startsWith(this.pulsar().getConfiguration().getReplicatorPrefix())) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Cannot unsubscribe a replication cursor");
            }
            for (Topic topic : topicList) {
                Subscription sub = topic.getSubscription(subscription);
                if (sub == null) continue;
                futures.add(sub.delete());
            }
            FutureUtil.waitForAll((List)futures).get();
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.error("[{}] Failed to unsubscribe {} for namespace {}/{}", new Object[]{this.clientAppId(), subscription, nsName.toString(), bundleRange, e});
            if (e.getCause() instanceof BrokerServiceException.SubscriptionBusyException) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "Subscription has active connected consumers");
            }
            throw new RestException(e.getCause());
        }
    }

    private void validatePeerClusterConflict(String clusterName, Set<String> replicationClusters) {
        try {
            Sets.SetView conflictPeerClusters;
            ClusterData clusterData = (ClusterData)this.clustersCache().get(NamespacesBase.path("clusters", clusterName)).orElseThrow(() -> new RestException(Response.Status.PRECONDITION_FAILED, "Invalid replication cluster " + clusterName));
            LinkedHashSet peerClusters = clusterData.getPeerClusterNames();
            if (peerClusters != null && !peerClusters.isEmpty() && !(conflictPeerClusters = Sets.intersection((Set)peerClusters, replicationClusters)).isEmpty()) {
                log.warn("[{}] {}'s peer cluster can't be part of replication clusters {}", new Object[]{this.clientAppId(), clusterName, conflictPeerClusters});
                throw new RestException(Response.Status.CONFLICT, String.format("%s's peer-clusters %s can't be part of replication-clusters %s", clusterName, conflictPeerClusters, replicationClusters));
            }
        }
        catch (RestException re) {
            throw re;
        }
        catch (Exception e) {
            log.warn("[{}] Failed to get cluster-data for {}", new Object[]{this.clientAppId(), clusterName, e});
        }
    }

    protected BundlesData validateBundlesData(BundlesData initialBundles) {
        TreeSet<String> partitions = new TreeSet<String>();
        for (String partition : initialBundles.getBoundaries()) {
            Long partBoundary = Long.decode(partition);
            partitions.add(String.format("0x%08x", partBoundary));
        }
        if (partitions.size() != initialBundles.getBoundaries().size() && log.isDebugEnabled()) {
            log.debug("Input bundles included repeated partition points. Ignored.");
        }
        try {
            NamespaceBundleFactory.validateFullRange(partitions);
        }
        catch (IllegalArgumentException iae) {
            throw new RestException(Response.Status.BAD_REQUEST, "Input bundles do not cover the whole hash range. first:" + (String)partitions.first() + ", last:" + (String)partitions.last());
        }
        ArrayList bundles = Lists.newArrayList();
        bundles.addAll(partitions);
        return new BundlesData((List)bundles);
    }

    public static BundlesData getBundles(int numBundles) {
        if (numBundles <= 0 || (long)numBundles > 0x100000000L) {
            throw new RestException(Response.Status.BAD_REQUEST, "Invalid number of bundles. Number of numbles has to be in the range of (0, 2^32].");
        }
        Long maxVal = 0x100000000L;
        Long segSize = maxVal / (long)numBundles;
        ArrayList partitions = Lists.newArrayList();
        partitions.add(String.format("0x%08x", 0L));
        Long curPartition = segSize;
        for (int i = 0; i < numBundles; ++i) {
            if (i != numBundles - 1) {
                partitions.add(String.format("0x%08x", curPartition));
            } else {
                partitions.add(String.format("0x%08x", maxVal - 1L));
            }
            curPartition = curPartition + segSize;
        }
        return new BundlesData((List)partitions);
    }

    private void validatePolicies(NamespaceName ns, Policies policies) {
        if (ns.isV2() && policies.replication_clusters.isEmpty()) {
            policies.replication_clusters = Collections.singleton(this.config().getClusterName());
        }
        policies.replication_clusters.forEach(cluster -> this.validateClusterForTenant(ns.getTenant(), (String)cluster));
        if (policies.message_ttl_in_seconds < 0) {
            throw new RestException(Response.Status.PRECONDITION_FAILED, "Invalid value for message TTL");
        }
        if (policies.bundles != null && policies.bundles.getNumBundles() > 0) {
            policies.bundles = policies.bundles.getBoundaries() == null || policies.bundles.getBoundaries().size() == 0 ? NamespacesBase.getBundles(policies.bundles.getNumBundles()) : this.validateBundlesData(policies.bundles);
        } else {
            int defaultNumberOfBundles = this.config().getDefaultNumberOfNamespaceBundles();
            policies.bundles = NamespacesBase.getBundles(defaultNumberOfBundles);
        }
        if (policies.persistence != null) {
            this.validatePersistencePolicies(policies.persistence);
        }
    }

    protected int internalGetMaxProducersPerTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_producers_per_topic;
    }

    protected void internalSetMaxProducersPerTopic(int maxProducersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_PRODUCERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxProducersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxProducersPerTopic must be 0 or more");
            }
            policies.max_producers_per_topic = maxProducersPerTopic;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxProducersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_producers_per_topic});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxProducersPerTopic configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxProducersPerTopic configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxProducersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxConsumersPerTopic() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_topic;
    }

    protected void internalSetMaxConsumersPerTopic(int maxConsumersPerTopic) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxConsumersPerTopic < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerTopic must be 0 or more");
            }
            policies.max_consumers_per_topic = maxConsumersPerTopic;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxConsumersPerTopic configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_consumers_per_topic});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerTopic configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxConsumersPerSubscription() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_consumers_per_subscription;
    }

    protected void internalSetMaxConsumersPerSubscription(int maxConsumersPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_CONSUMERS, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxConsumersPerSubscription < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxConsumersPerSubscription must be 0 or more");
            }
            policies.max_consumers_per_subscription = maxConsumersPerSubscription;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxConsumersPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_consumers_per_subscription});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxConsumersPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxUnackedMessagesPerConsumer() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_consumer;
    }

    protected void internalSetMaxUnackedMessagesPerConsumer(int maxUnackedMessagesPerConsumer) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxUnackedMessagesPerConsumer < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerConsumer must be 0 or more");
            }
            policies.max_unacked_messages_per_consumer = maxUnackedMessagesPerConsumer;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxUnackedMessagesPerConsumer configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_unacked_messages_per_consumer});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxUnackedMessagesPerConsumer configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxUnackedMessagesPerConsumer configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerConsumer configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected int internalGetMaxUnackedMessagesPerSubscription() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).max_unacked_messages_per_subscription;
    }

    protected void internalSetMaxUnackedMessagesPerSubscription(int maxUnackedMessagesPerSubscription) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.MAX_UNACKED, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (maxUnackedMessagesPerSubscription < 0) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "maxUnackedMessagesPerSubscription must be 0 or more");
            }
            policies.max_unacked_messages_per_subscription = maxUnackedMessagesPerSubscription;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated maxUnackedMessagesPerSubscription configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.max_unacked_messages_per_subscription});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update maxUnackedMessagesPerSubscription configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update maxUnackedMessagesPerSubscription configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update maxUnackedMessagesPerSubscription configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected long internalGetCompactionThreshold() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).compaction_threshold;
    }

    protected void internalSetCompactionThreshold(long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.COMPACTION, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (newThreshold < 0L) {
                throw new RestException(Response.Status.PRECONDITION_FAILED, "compactionThreshold must be 0 or more");
            }
            policies.compaction_threshold = newThreshold;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated compactionThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.compaction_threshold});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update compactionThreshold configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update compactionThreshold configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update compactionThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected long internalGetOffloadThreshold() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.offload_policies == null) {
            return policies.offload_threshold;
        }
        return policies.offload_policies.getManagedLedgerOffloadThresholdInBytes();
    }

    protected void internalSetOffloadThreshold(long newThreshold) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (policies.offload_policies == null) {
                OffloadPolicies defaultPolicy = this.pulsar().getDefaultOffloader().getOffloadPolicies();
                OffloadPolicies offloadPolicies = policies.offload_policies = defaultPolicy == null ? new OffloadPolicies() : defaultPolicy;
                if (policies.offload_deletion_lag_ms != null) {
                    policies.offload_policies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
                }
            }
            policies.offload_policies.setManagedLedgerOffloadThresholdInBytes(newThreshold);
            policies.offload_threshold = newThreshold;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated offloadThreshold configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.offload_threshold});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update offloadThreshold configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update offloadThreshold configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadThreshold configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected Long internalGetOffloadDeletionLag() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        if (policies.offload_policies == null) {
            return policies.offload_deletion_lag_ms;
        }
        return policies.offload_policies.getManagedLedgerOffloadDeletionLagInMillis();
    }

    protected void internalSetOffloadDeletionLag(Long newDeletionLagMs) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (policies.offload_policies == null) {
                OffloadPolicies defaultPolicy = this.pulsar().getDefaultOffloader().getOffloadPolicies();
                OffloadPolicies offloadPolicies = policies.offload_policies = defaultPolicy == null ? new OffloadPolicies() : defaultPolicy;
                if (policies.offload_threshold != -1L) {
                    policies.offload_policies.setManagedLedgerOffloadThresholdInBytes(policies.offload_threshold);
                }
            }
            policies.offload_policies.setManagedLedgerOffloadDeletionLagInMillis(newDeletionLagMs);
            policies.offload_deletion_lag_ms = newDeletionLagMs;
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated offloadDeletionLagMs configuration: namespace={}, value={}", new Object[]{this.clientAppId(), this.namespaceName, policies.offload_deletion_lag_ms});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update offloadDeletionLagMs configuration for namespace {}: does not exist", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update offloadDeletionLagMs configuration for namespace {}: concurrent modification", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offloadDeletionLag configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            throw new RestException(e);
        }
    }

    @Deprecated
    protected SchemaAutoUpdateCompatibilityStrategy internalGetSchemaAutoUpdateCompatibilityStrategy() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_auto_update_compatibility_strategy;
    }

    protected SchemaCompatibilityStrategy internalGetSchemaCompatibilityStrategy() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        SchemaCompatibilityStrategy schemaCompatibilityStrategy = policies.schema_compatibility_strategy;
        if (schemaCompatibilityStrategy == SchemaCompatibilityStrategy.UNDEFINED) {
            schemaCompatibilityStrategy = SchemaCompatibilityStrategy.fromAutoUpdatePolicy((SchemaAutoUpdateCompatibilityStrategy)policies.schema_auto_update_compatibility_strategy);
        }
        return schemaCompatibilityStrategy;
    }

    @Deprecated
    protected void internalSetSchemaAutoUpdateCompatibilityStrategy(SchemaAutoUpdateCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_auto_update_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_auto_update_compatibility_strategy, "schemaAutoUpdateCompatibilityStrategy");
    }

    protected void internalSetSchemaCompatibilityStrategy(SchemaCompatibilityStrategy strategy) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_compatibility_strategy = strategy;
            return policies;
        }, policies -> policies.schema_compatibility_strategy, "schemaCompatibilityStrategy");
    }

    protected boolean internalGetSchemaValidationEnforced() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).schema_validation_enforced;
    }

    protected void internalSetSchemaValidationEnforced(boolean schemaValidationEnforced) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.schema_validation_enforced = schemaValidationEnforced;
            return policies;
        }, policies -> policies.schema_validation_enforced, "schemaValidationEnforced");
    }

    protected boolean internalGetIsAllowAutoUpdateSchema() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.READ);
        return this.getNamespacePolicies((NamespaceName)this.namespaceName).is_allow_auto_update_schema;
    }

    protected void internalSetIsAllowAutoUpdateSchema(boolean isAllowAutoUpdateSchema) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.SCHEMA_COMPATIBILITY_STRATEGY, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.mutatePolicy(policies -> {
            policies.is_allow_auto_update_schema = isAllowAutoUpdateSchema;
            return policies;
        }, policies -> policies.is_allow_auto_update_schema, "isAllowAutoUpdateSchema");
    }

    private <T> void mutatePolicy(Function<Policies, Policies> policyTransformation, Function<Policies, T> getter, String policyName) {
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            policies = policyTransformation.apply(policies);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion());
            this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
            log.info("[{}] Successfully updated {} configuration: namespace={}, value={}", new Object[]{this.clientAppId(), policyName, this.namespaceName, getter.apply(policies)});
        }
        catch (KeeperException.NoNodeException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: does not exist", new Object[]{this.clientAppId(), policyName, this.namespaceName});
            throw new RestException(Response.Status.NOT_FOUND, "Namespace does not exist");
        }
        catch (KeeperException.BadVersionException e) {
            log.warn("[{}] Failed to update {} configuration for namespace {}: concurrent modification", new Object[]{this.clientAppId(), policyName, this.namespaceName});
            throw new RestException(Response.Status.CONFLICT, "Concurrent modification");
        }
        catch (RestException pfe) {
            throw pfe;
        }
        catch (Exception e) {
            log.error("[{}] Failed to update {} configuration for namespace {}", new Object[]{this.clientAppId(), policyName, this.namespaceName, e});
            throw new RestException(e);
        }
    }

    protected void internalSetOffloadPolicies(AsyncResponse asyncResponse, OffloadPolicies offloadPolicies) {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.WRITE);
        this.validatePoliciesReadOnlyAccess();
        this.validateOffloadPolicies(offloadPolicies);
        try {
            Stat nodeStat = new Stat();
            String path = NamespacesBase.path("policies", this.namespaceName.toString());
            byte[] content = this.globalZk().getData(path, null, nodeStat);
            Policies policies = (Policies)NamespacesBase.jsonMapper().readValue(content, Policies.class);
            if (offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis() == null && OffloadPolicies.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS == null || offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis() != null && offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis().equals(OffloadPolicies.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS)) {
                offloadPolicies.setManagedLedgerOffloadDeletionLagInMillis(policies.offload_deletion_lag_ms);
            } else {
                policies.offload_deletion_lag_ms = offloadPolicies.getManagedLedgerOffloadDeletionLagInMillis();
            }
            if (offloadPolicies.getManagedLedgerOffloadThresholdInBytes() == -1L) {
                offloadPolicies.setManagedLedgerOffloadThresholdInBytes(policies.offload_threshold);
            } else {
                policies.offload_threshold = offloadPolicies.getManagedLedgerOffloadThresholdInBytes();
            }
            policies.offload_policies = offloadPolicies;
            String updatedOffloadPolicies = NamespacesBase.jsonMapper().writeValueAsString((Object)policies.offload_policies);
            this.globalZk().setData(path, NamespacesBase.jsonMapper().writeValueAsBytes((Object)policies), nodeStat.getVersion(), (rc, path1, ctx, stat) -> {
                if (rc == KeeperException.Code.OK.intValue()) {
                    this.policiesCache().invalidate(NamespacesBase.path("policies", this.namespaceName.toString()));
                    log.info("[{}] Successfully updated offload configuration: namespace={}, map={}", new Object[]{this.clientAppId(), this.namespaceName, updatedOffloadPolicies});
                    asyncResponse.resume((Object)Response.noContent().build());
                } else {
                    String errorMsg = String.format("[%s] Failed to update offload configuration for namespace %s", this.clientAppId(), this.namespaceName);
                    if (rc == KeeperException.Code.NONODE.intValue()) {
                        log.warn("{} : does not exist", (Object)errorMsg);
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.NOT_FOUND, "Namespace does not exist")));
                    } else if (rc == KeeperException.Code.BADVERSION.intValue()) {
                        log.warn("{} : concurrent modification", (Object)errorMsg);
                        asyncResponse.resume((Throwable)((Object)new RestException(Response.Status.CONFLICT, "Concurrent modification")));
                    } else {
                        asyncResponse.resume((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)errorMsg));
                    }
                }
            }, null);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update offload configuration for namespace {}", new Object[]{this.clientAppId(), this.namespaceName, e});
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    private void validateOffloadPolicies(OffloadPolicies offloadPolicies) {
        if (offloadPolicies == null) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: offloadPolicies is null", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The offloadPolicies must be specified for namespace offload.");
        }
        if (!offloadPolicies.driverSupported()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: driver is not supported, support value: {}", new Object[]{this.clientAppId(), this.namespaceName, OffloadPolicies.getSupportedDriverNames()});
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The driver is not supported, support value: " + OffloadPolicies.getSupportedDriverNames());
        }
        if (!offloadPolicies.bucketValid()) {
            log.warn("[{}] Failed to update offload configuration for namespace {}: bucket must be specified", (Object)this.clientAppId(), (Object)this.namespaceName);
            throw new RestException(Response.Status.PRECONDITION_FAILED, "The bucket must be specified for namespace offload.");
        }
    }

    protected OffloadPolicies internalGetOffloadPolicies() {
        this.validateNamespacePolicyOperation(this.namespaceName, PolicyName.OFFLOAD, PolicyOperation.READ);
        Policies policies = this.getNamespacePolicies(this.namespaceName);
        return policies.offload_policies;
    }

    private static /* synthetic */ RestException lambda$internalGetBookieAffinityGroup$23() {
        return new RestException(Response.Status.NOT_FOUND, "Namespace local-policies does not exist");
    }
}

