/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorDefinitions;
import org.apache.pulsar.broker.intercept.BrokerInterceptorMetadata;
import org.apache.pulsar.broker.intercept.BrokerInterceptorUtils;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerInterceptors
implements BrokerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BrokerInterceptors.class);
    private final Map<String, BrokerInterceptorWithClassLoader> interceptors;

    public BrokerInterceptors(Map<String, BrokerInterceptorWithClassLoader> interceptors) {
        this.interceptors = interceptors;
    }

    public static BrokerInterceptor load(ServiceConfiguration conf) throws IOException {
        BrokerInterceptorDefinitions definitions = BrokerInterceptorUtils.searchForInterceptors(conf.getBrokerInterceptorsDirectory(), conf.getNarExtractionDirectory());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        conf.getBrokerInterceptors().forEach(interceptorName -> {
            BrokerInterceptorMetadata definition = definitions.interceptors().get(interceptorName);
            if (null == definition) {
                throw new RuntimeException("No broker interceptor is found for name `" + interceptorName + "`. Available broker interceptors are : " + definitions.interceptors());
            }
            try {
                BrokerInterceptorWithClassLoader interceptor = BrokerInterceptorUtils.load(definition, conf.getNarExtractionDirectory());
                if (interceptor != null) {
                    builder.put(interceptorName, (Object)interceptor);
                }
                log.info("Successfully loaded broker interceptor for name `{}`", interceptorName);
            }
            catch (IOException e) {
                log.error("Failed to load the broker interceptor for name `" + interceptorName + "`", (Throwable)e);
                throw new RuntimeException("Failed to load the broker interceptor for name `" + interceptorName + "`");
            }
        });
        ImmutableMap interceptors = builder.build();
        if (interceptors != null && !interceptors.isEmpty()) {
            return new BrokerInterceptors((Map<String, BrokerInterceptorWithClassLoader>)interceptors);
        }
        return DISABLED;
    }

    @Override
    public void onPulsarCommand(PulsarApi.BaseCommand command, ServerCnx cnx) throws Exception {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onPulsarCommand(command, cnx);
        }
    }

    @Override
    public void onWebServiceRequest(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        for (BrokerInterceptorWithClassLoader value : this.interceptors.values()) {
            value.onWebServiceRequest(request, response, chain);
        }
    }

    @Override
    public void initialize(ServiceConfiguration conf) throws Exception {
        for (BrokerInterceptorWithClassLoader v : this.interceptors.values()) {
            v.initialize(conf);
        }
    }

    @Override
    public void close() {
        this.interceptors.values().forEach(BrokerInterceptorWithClassLoader::close);
    }
}

