/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.RedeliveryTrackerDisabled;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcher;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.Rate;

public final class NonPersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements NonPersistentDispatcher {
    private final NonPersistentTopic topic;
    private final Rate msgDrop;
    private final Subscription subscription;
    private final ServiceConfiguration serviceConfig;
    private final RedeliveryTracker redeliveryTracker;

    public NonPersistentDispatcherSingleActiveConsumer(PulsarApi.CommandSubscribe.SubType subscriptionType, int partitionIndex, NonPersistentTopic topic, Subscription subscription) {
        super(subscriptionType, partitionIndex, topic.getName(), subscription);
        this.topic = topic;
        this.subscription = subscription;
        this.msgDrop = new Rate();
        this.serviceConfig = topic.getBrokerService().pulsar().getConfiguration();
        this.redeliveryTracker = RedeliveryTrackerDisabled.REDELIVERY_TRACKER_DISABLED;
    }

    @Override
    public void sendMessages(List<Entry> entries) {
        Consumer currentConsumer = (Consumer)ACTIVE_CONSUMER_UPDATER.get(this);
        if (currentConsumer != null && currentConsumer.getAvailablePermits() > 0 && currentConsumer.isWritable()) {
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entries.size());
            this.filterEntriesForConsumer(entries, batchSizes, sendMessageInfo, null, null);
            currentConsumer.sendMessages(entries, batchSizes, null, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker());
        } else {
            entries.forEach(entry -> {
                int totalMsgs = Commands.getNumberOfMessagesInBatch((ByteBuf)entry.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent((long)totalMsgs);
                }
                entry.release();
            });
        }
    }

    @Override
    protected boolean isConsumersExceededOnTopic() {
        int maxConsumersPerTopic;
        Policies policies;
        try {
            policies = (Policies)this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().getDataIfPresent(AdminResource.path("policies", TopicName.get((String)this.topic.getName()).getNamespace()));
            if (policies == null) {
                policies = new Policies();
            }
        }
        catch (Exception e) {
            policies = new Policies();
        }
        int n = maxConsumersPerTopic = policies.max_consumers_per_topic > 0 ? policies.max_consumers_per_topic : this.serviceConfig.getMaxConsumersPerTopic();
        return maxConsumersPerTopic > 0 && maxConsumersPerTopic <= this.topic.getNumberOfConsumers();
    }

    @Override
    protected boolean isConsumersExceededOnSubscription() {
        int maxConsumersPerSubscription;
        Policies policies;
        try {
            policies = (Policies)this.topic.getBrokerService().pulsar().getConfigurationCache().policiesCache().getDataIfPresent(AdminResource.path("policies", TopicName.get((String)this.topic.getName()).getNamespace()));
            if (policies == null) {
                policies = new Policies();
            }
        }
        catch (Exception e) {
            policies = new Policies();
        }
        int n = maxConsumersPerSubscription = policies.max_consumers_per_subscription > 0 ? policies.max_consumers_per_subscription : this.serviceConfig.getMaxConsumersPerSubscription();
        return maxConsumersPerSubscription > 0 && maxConsumersPerSubscription <= this.consumers.size();
    }

    @Override
    public Rate getMessageDropRate() {
        return this.msgDrop;
    }

    @Override
    public boolean hasPermits() {
        return ACTIVE_CONSUMER_UPDATER.get(this) != null && ((Consumer)ACTIVE_CONSUMER_UPDATER.get(this)).getAvailablePermits() > 0;
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
    }

    @Override
    public RedeliveryTracker getRedeliveryTracker() {
        return this.redeliveryTracker;
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
    }

    @Override
    protected void readMoreEntries(Consumer consumer) {
    }

    @Override
    protected void cancelPendingRead() {
    }
}

