/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.PulsarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHandlerFilter.class);
    private final String brokerAddress;

    public ResponseHandlerFilter(PulsarService pulsar) {
        this.brokerAddress = pulsar.getAdvertisedAddress();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        ((HttpServletResponse)response).addHeader("broker-address", this.brokerAddress);
        if (((HttpServletResponse)response).getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            try {
                ((HttpServletRequest)request).getSession(false).invalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init(FilterConfig arg) throws ServletException {
    }

    public void destroy() {
    }
}

