/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.web.RequestWrapper;
import org.apache.pulsar.common.intercept.InterceptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInterceptFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PreInterceptFilter.class);
    private final BrokerInterceptor interceptor;

    public PreInterceptFilter(BrokerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("PreInterceptFilter: path {}, type {}", (Object)servletRequest.getServletContext().getContextPath(), (Object)servletRequest.getContentType());
        }
        if ("multipart/form-data".equalsIgnoreCase(servletRequest.getContentType())) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        try {
            RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest)servletRequest);
            this.interceptor.onWebserviceRequest((ServletRequest)requestWrapper);
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        }
        catch (InterceptException e) {
            ((HttpServletResponse)servletResponse).sendError(e.getErrorCode(), e.getMessage());
        }
    }

    public void destroy() {
    }
}

