/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.api.proto.PulsarMarkers;

public interface Subscription {
    public BrokerInterceptor interceptor();

    public Topic getTopic();

    public String getName();

    public void addConsumer(Consumer var1) throws BrokerServiceException;

    default public void removeConsumer(Consumer consumer) throws BrokerServiceException {
        this.removeConsumer(consumer, false);
    }

    public void removeConsumer(Consumer var1, boolean var2) throws BrokerServiceException;

    public void consumerFlow(Consumer var1, int var2);

    public void acknowledgeMessage(List<Position> var1, PulsarApi.CommandAck.AckType var2, Map<String, Long> var3);

    public String getTopicName();

    public boolean isReplicated();

    public Dispatcher getDispatcher();

    public long getNumberOfEntriesInBacklog(boolean var1);

    default public long getNumberOfEntriesDelayed() {
        return 0L;
    }

    public List<Consumer> getConsumers();

    public CompletableFuture<Void> close();

    public CompletableFuture<Void> delete();

    public CompletableFuture<Void> deleteForcefully();

    public CompletableFuture<Void> disconnect();

    public CompletableFuture<Void> doUnsubscribe(Consumer var1);

    public CompletableFuture<Void> clearBacklog();

    public CompletableFuture<Void> skipMessages(int var1);

    public CompletableFuture<Void> resetCursor(long var1);

    public CompletableFuture<Void> resetCursor(Position var1);

    public CompletableFuture<Entry> peekNthMessage(int var1);

    public void expireMessages(int var1);

    public void redeliverUnacknowledgedMessages(Consumer var1);

    public void redeliverUnacknowledgedMessages(Consumer var1, List<PositionImpl> var2);

    public void markTopicWithBatchMessagePublished();

    public double getExpiredMessageRate();

    public PulsarApi.CommandSubscribe.SubType getType();

    public String getTypeString();

    public void addUnAckedMessages(int var1);

    default public void processReplicatedSubscriptionSnapshot(PulsarMarkers.ReplicatedSubscriptionsSnapshot snapshot) {
    }

    public static boolean isCumulativeAckMode(PulsarApi.CommandSubscribe.SubType subType) {
        return PulsarApi.CommandSubscribe.SubType.Exclusive.equals((Object)subType) || PulsarApi.CommandSubscribe.SubType.Failover.equals((Object)subType);
    }

    public static boolean isIndividualAckMode(PulsarApi.CommandSubscribe.SubType subType) {
        return PulsarApi.CommandSubscribe.SubType.Shared.equals((Object)subType) || PulsarApi.CommandSubscribe.SubType.Key_Shared.equals((Object)subType);
    }
}

