/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorDefinition;
import org.apache.pulsar.broker.intercept.BrokerInterceptorDefinitions;
import org.apache.pulsar.broker.intercept.BrokerInterceptorMetadata;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerInterceptorUtils {
    private static final Logger log = LoggerFactory.getLogger(BrokerInterceptorUtils.class);
    static final String BROKER_INTERCEPTOR_DEFINITION_FILE = "broker_interceptor.yml";

    public static BrokerInterceptorDefinition getBrokerInterceptorDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoader.getFromArchive((File)new File(narPath), Collections.emptySet(), (String)narExtractionDirectory);){
            BrokerInterceptorDefinition brokerInterceptorDefinition = BrokerInterceptorUtils.getBrokerInterceptorDefinition(ncl);
            return brokerInterceptorDefinition;
        }
    }

    private static BrokerInterceptorDefinition getBrokerInterceptorDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(BROKER_INTERCEPTOR_DEFINITION_FILE);
        return (BrokerInterceptorDefinition)ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, BrokerInterceptorDefinition.class);
    }

    public static BrokerInterceptorDefinitions searchForInterceptors(String interceptorsDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(interceptorsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for broker interceptors in {}", (Object)path);
        BrokerInterceptorDefinitions interceptors = new BrokerInterceptorDefinitions();
        if (!path.toFile().exists()) {
            log.warn("Pulsar broker interceptors directory not found");
            return interceptors;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    BrokerInterceptorDefinition def = BrokerInterceptorUtils.getBrokerInterceptorDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found broker interceptors from {} : {}", (Object)archive, (Object)def);
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getName()));
                    Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)def.getInterceptorClass()));
                    BrokerInterceptorMetadata metadata = new BrokerInterceptorMetadata();
                    metadata.setDefinition(def);
                    metadata.setArchivePath(archive);
                    interceptors.interceptors().put(def.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load broker interceptor from {}. It is OK however if you want to use this broker interceptor, please make sure you put the correct broker interceptor NAR package in the broker interceptors directory.", (Object)archive, (Object)t);
                }
            }
        }
        return interceptors;
    }

    static BrokerInterceptorWithClassLoader load(BrokerInterceptorMetadata metadata, String narExtractionDirectory) throws IOException {
        NarClassLoader ncl = NarClassLoader.getFromArchive((File)metadata.getArchivePath().toAbsolutePath().toFile(), Collections.emptySet(), (ClassLoader)BrokerInterceptor.class.getClassLoader(), (String)narExtractionDirectory);
        BrokerInterceptorDefinition def = BrokerInterceptorUtils.getBrokerInterceptorDefinition(ncl);
        if (StringUtils.isBlank((CharSequence)def.getInterceptorClass())) {
            throw new IOException("Broker interceptors `" + def.getName() + "` does NOT provide a broker interceptors implementation");
        }
        try {
            Class interceptorClass = ncl.loadClass(def.getInterceptorClass());
            Object interceptor = interceptorClass.newInstance();
            if (!(interceptor instanceof BrokerInterceptor)) {
                throw new IOException("Class " + def.getInterceptorClass() + " does not implement broker interceptor interface");
            }
            BrokerInterceptor pi = (BrokerInterceptor)interceptor;
            return new BrokerInterceptorWithClassLoader(pi, ncl);
        }
        catch (Throwable t) {
            BrokerInterceptorUtils.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    private BrokerInterceptorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

