/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.admin.impl.PersistentTopicsBase;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.ResetCursorData;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentOfflineTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/persistent")
@Produces(value={"application/json"})
@Api(value="/persistent", description="Persistent topic admin apis", tags={"persistent topic"})
public class PersistentTopics
extends PersistentTopicsBase {
    private static final Logger log = LoggerFactory.getLogger(PersistentTopics.class);

    @GET
    @Path(value="/{tenant}/{namespace}")
    @ApiOperation(value="Get the list of topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void getList(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace) {
        try {
            this.validateNamespaceName(tenant, namespace);
            asyncResponse.resume(this.internalGetList());
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/partitioned")
    @ApiOperation(value="Get the list of partitioned topics under a namespace.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Namespace name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public List<String> getPartitionedTopicList(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace) {
        this.validateNamespaceName(tenant, namespace);
        return this.internalGetPartitionedTopicList();
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/permissions")
    @ApiOperation(value="Get permissions on a topic.", notes="Retrieve the effective permissions for a topic. These permissions are defined by the permissions set at thenamespace level combined (union) with any eventual specific permission set on the topic.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public Map<String, Set<AuthAction>> getPermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetPermissionsOnTopic();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Grant a new permission to a role on a single topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public void grantPermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Client role to which grant permissions", required=true) @PathParam(value="role") String role, @ApiParam(value="Actions to be granted (produce,functions,consume)", allowableValues="produce,functions,consume") Set<AuthAction> actions) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGrantPermissionsOnTopic(role, actions);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/permissions/{role}")
    @ApiOperation(value="Revoke permissions on a topic.", notes="Revoke permissions to a role on a single topic. If the permission was not set at the topiclevel, but rather at the namespace level, this operation will return an error (HTTP status code 412).")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="tenant/namespace/topic doesn't exit"), @ApiResponse(code=412, message="Permissions are not set at the topic level"), @ApiResponse(code=500, message="Internal server error")})
    public void revokePermissionsOnTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Client role to which grant permissions", required=true) @PathParam(value="role") String role) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalRevokePermissionsOnTopic(role);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Create a partitioned topic.", notes="It needs to be called before creating a producer on a partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=406, message="The number of partitions should be more than 0 and less than or equal to maxNumPartitionsPerPartitionedTopic"), @ApiResponse(code=409, message="Partitioned topic already exist"), @ApiResponse(code=412, message="Failed Reason : Name is invalid or Namespace does not have any clusters configured"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createPartitionedTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The number of partitions for the topic", required=true, type="int", defaultValue="0") int numPartitions) {
        try {
            this.validateGlobalNamespaceOwnership(tenant, namespace);
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.validateAdminAccessForTenant(this.topicName.getTenant());
            this.internalCreatePartitionedTopic(asyncResponse, numPartitions);
        }
        catch (Exception e) {
            log.error("[{}] Failed to create partitioned topic {}", new Object[]{this.clientAppId(), this.topicName, e});
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Create a non-partitioned topic.", notes="This is the only REST endpoint from which non-partitioned topics could be created.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=409, message="Partitioned topic already exist"), @ApiResponse(code=412, message="Failed Reason : Name is invalid or Namespace does not have any clusters configured"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createNonPartitionedTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateGlobalNamespaceOwnership(tenant, namespace);
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalCreateNonPartitionedTopic(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/offloadPolicies")
    @ApiOperation(value="Get offload policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getOffloadPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isOffloadPoliciesSet()) {
            asyncResponse.resume((Object)topicPolicies.getOffloadPolicies());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/offloadPolicies")
    @ApiOperation(value="Set offload policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setOffloadPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Offload policies for the specified topic") OffloadPolicies offloadPolicies) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetOffloadPolicies(offloadPolicies).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed set offloadPolicies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed set offloadPolicies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/offloadPolicies")
    @ApiOperation(value="Delete offload policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void removeOffloadPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.setOffloadPolicies(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnConsumer")
    @ApiOperation(value="Get max unacked messages per consumer config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getMaxUnackedMessagesOnConsumer(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isMaxUnackedMessagesOnConsumerSet()) {
            asyncResponse.resume((Object)topicPolicies.getMaxUnackedMessagesOnConsumer());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnConsumer")
    @ApiOperation(value="Set max unacked messages per consumer config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setMaxUnackedMessagesOnConsumer(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Max unacked messages on consumer policies for the specified topic") Integer maxUnackedNum) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxUnackedMessagesOnConsumer(maxUnackedNum).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed set MaxUnackedMessagesOnConsumer", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed set MaxUnackedMessagesOnConsumer", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationSnapshotInterval")
    @ApiOperation(value="Get deduplicationSnapshotInterval config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getDeduplicationSnapshotInterval(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isDeduplicationSnapshotIntervalSecondsSet()) {
            asyncResponse.resume((Object)topicPolicies.getDeduplicationSnapshotIntervalSeconds());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationSnapshotInterval")
    @ApiOperation(value="Set deduplicationSnapshotInterval config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setDeduplicationSnapshotInterval(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Interval to take deduplication snapshot for the specified topic") Integer interval) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        if (this.topicName.isGlobal()) {
            this.validateGlobalNamespaceOwnership(this.namespaceName);
        }
        this.internalSetDeduplicationSnapshotInterval(interval).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed set deduplicationSnapshotInterval", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed set deduplicationSnapshotInterval", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationSnapshotInterval")
    @ApiOperation(value="Delete deduplicationSnapshotInterval config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void deleteDeduplicationSnapshotInterval(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetDeduplicationSnapshotInterval(null).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed delete deduplicationSnapshotInterval", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed delete deduplicationSnapshotInterval", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnConsumer")
    @ApiOperation(value="Delete max unacked messages per consumer config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void deleteMaxUnackedMessagesOnConsumer(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.setMaxUnackedMessagesOnConsumer(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/inactiveTopicPolicies")
    @ApiOperation(value="Get inactive topic policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getInactiveTopicPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isInactiveTopicPoliciesSet()) {
            asyncResponse.resume((Object)topicPolicies.getInactiveTopicPolicies());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/inactiveTopicPolicies")
    @ApiOperation(value="Set inactive topic policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setInactiveTopicPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="inactive topic policies for the specified topic") InactiveTopicPolicies inactiveTopicPolicies) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetInactiveTopicPolicies(inactiveTopicPolicies).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed set InactiveTopicPolicies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed set InactiveTopicPolicies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/inactiveTopicPolicies")
    @ApiOperation(value="Delete inactive topic policies on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void deleteInactiveTopicPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.setInactiveTopicPolicies(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnSubscription")
    @ApiOperation(value="Get max unacked messages per subscription config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getMaxUnackedMessagesOnSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isMaxUnackedMessagesOnSubscriptionSet()) {
            asyncResponse.resume((Object)topicPolicies.getMaxUnackedMessagesOnSubscription());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnSubscription")
    @ApiOperation(value="Set max unacked messages per subscription config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setMaxUnackedMessagesOnSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Max unacked messages on subscription policies for the specified topic") Integer maxUnackedNum) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxUnackedMessagesOnSubscription(maxUnackedNum).whenComplete((res, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed set MaxUnackedMessagesOnSubscription", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed set MaxUnackedMessagesOnSubscription", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxUnackedMessagesOnSubscription")
    @ApiOperation(value="Delete max unacked messages per subscription config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void deleteMaxUnackedMessagesOnSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.setMaxUnackedMessagesOnSubscription(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/delayedDelivery")
    @ApiOperation(value="Get delayed delivery messages config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=500, message="Internal server error")})
    public void getDelayedDeliveryPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isDelayedDeliveryEnabledSet() && topicPolicies.isDelayedDeliveryTickTimeMillisSet()) {
            asyncResponse.resume((Object)new DelayedDeliveryPolicies(topicPolicies.getDelayedDeliveryTickTimeMillis().longValue(), topicPolicies.getDelayedDeliveryEnabled().booleanValue()));
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/delayedDelivery")
    @ApiOperation(value="Set delayed delivery messages config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void setDelayedDeliveryPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Delayed delivery policies for the specified topic") DelayedDeliveryPolicies deliveryPolicies) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetDelayedDeliveryPolicies(asyncResponse, deliveryPolicies);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/delayedDelivery")
    @ApiOperation(value="Set delayed delivery messages config on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist")})
    public void deleteDelayedDeliveryPolicies(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.setDelayedDeliveryPolicies(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Increment partitions of an existing partitioned topic.", notes="It only increments partitions of existing non-global partitioned-topic")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to adminisActions to be grantedtrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=406, message="The number of partitions should be more than 0 and less than or equal to maxNumPartitionsPerPartitionedTopic"), @ApiResponse(code=409, message="Partitioned topic does not exist"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public void updatePartitionedTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="updateLocalTopicOnly") @DefaultValue(value="false") boolean updateLocalTopicOnly, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="The number of partitions for the topic", required=true, type="int", defaultValue="0") int numPartitions) {
        this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
        this.validatePartitionedTopicMetadata(tenant, namespace, encodedTopic);
        this.internalUpdatePartitionedTopic(numPartitions, updateLocalTopicOnly, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/createMissedPartitions")
    @ApiOperation(value="Create missed partitions of an existing partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to adminisActions to be grantedtrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Partitioned topic does not exist"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public void createMissedPartitions(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic) {
        try {
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.internalCreateMissedPartitions(asyncResponse);
        }
        catch (Exception e) {
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Get partitioned topic metadata.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public PartitionedTopicMetadata getPartitionedMetadata(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="Is check configuration required to automatically create topic") @QueryParam(value="checkAllowAutoCreation") @DefaultValue(value="false") boolean checkAllowAutoCreation) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.validateTopicExistedAndCheckAllowAutoCreation(tenant, namespace, encodedTopic, checkAllowAutoCreation);
        return this.internalGetPartitionedMetadata(authoritative, checkAllowAutoCreation);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/partitions")
    @ApiOperation(value="Delete a partitioned topic.", notes="It will also delete all the partitions of the topic if it exists.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Partitioned topic does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error")})
    public void deletePartitionedTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Stop all producer/consumer/replicator and delete topic forcefully", defaultValue="false", type="boolean") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="Delete the topic's schema storage") @QueryParam(value="deleteSchema") @DefaultValue(value="false") boolean deleteSchema) {
        try {
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.internalDeletePartitionedTopic(asyncResponse, authoritative, force, deleteSchema);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/unload")
    @ApiOperation(value="Unload a topic")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Topic name is not valid or can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void unloadTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalUnloadTopic(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}")
    @ApiOperation(value="Delete a topic.", notes="The topic cannot be deleted if delete is not forcefully and there's any active subscription or producer connected to the it. Force delete ignores connected clients and deletes topic by explicitly closing them.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic has active producers/subscriptions"), @ApiResponse(code=500, message="Internal server error")})
    public void deleteTopic(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Stop all producer/consumer/replicator and delete topic forcefully", defaultValue="false", type="boolean") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="Delete the topic's schema storage") @QueryParam(value="deleteSchema") @DefaultValue(value="false") boolean deleteSchema) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalDeleteTopic(authoritative, force, deleteSchema);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptions")
    @ApiOperation(value="Get the list of persistent subscriptions for a given topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getSubscriptions(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetSubscriptions(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/stats")
    @ApiOperation(value="Get the stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public TopicStats getStats(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="If return precise backlog or imprecise backlog") @QueryParam(value="getPreciseBacklog") @DefaultValue(value="false") boolean getPreciseBacklog, @ApiParam(value="If return backlog size for each subscription, require locking on ledger so be careful not to use when there's heavy traffic.") @QueryParam(value="subscriptionBacklogSize") @DefaultValue(value="false") boolean subscriptionBacklogSize) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetStats(authoritative, getPreciseBacklog, subscriptionBacklogSize);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internalStats")
    @ApiOperation(value="Get the internal stats for the topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public PersistentTopicInternalStats getInternalStats(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @QueryParam(value="metadata") @DefaultValue(value="false") boolean metadata) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetInternalStats(authoritative, metadata);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/internal-info")
    @ApiOperation(value="Get the stored topic metadata.")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getManagedLedgerInfo(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @Suspended AsyncResponse asyncResponse) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalGetManagedLedgerInfo(asyncResponse, authoritative);
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/partitioned-stats")
    @ApiOperation(value="Get the stats for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Partitioned topic name is invalid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getPartitionedStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Get per partition stats") @QueryParam(value="perPartition") @DefaultValue(value="true") boolean perPartition, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(value="If return precise backlog or imprecise backlog") @QueryParam(value="getPreciseBacklog") @DefaultValue(value="false") boolean getPreciseBacklog, @ApiParam(value="If return backlog size for each subscription, require locking on ledger so be careful not to use when there's heavy traffic.") @QueryParam(value="subscriptionBacklogSize") @DefaultValue(value="false") boolean subscriptionBacklogSize) {
        try {
            this.validatePartitionedTopicName(tenant, namespace, encodedTopic);
            this.internalGetPartitionedStats(asyncResponse, authoritative, perPartition, getPreciseBacklog, subscriptionBacklogSize);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/partitioned-internalStats")
    @ApiOperation(hidden=true, value="Get the stats-internal for the partitioned topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getPartitionedStatsInternal(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetPartitionedStatsInternal(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}")
    @ApiOperation(value="Delete a subscription.", notes="The subscription cannot be deleted if delete is not forcefully and there are any active consumers attached to it. Force delete ignores connected consumers and deletes subscription by explicitly closing them.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=412, message="Subscription has active consumers"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void deleteSubscription(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to be deleted") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Disconnect and close all consumers and delete subscription forcefully", defaultValue="false", type="boolean") @QueryParam(value="force") @DefaultValue(value="false") boolean force, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalDeleteSubscription(asyncResponse, Codec.decode((String)encodedSubName), authoritative, force);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip_all")
    @ApiOperation(value="Skip all messages on a topic subscription.", notes="Completely clears the backlog on the subscription.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Operation not allowed on non-persistent topic"), @ApiResponse(code=412, message="Can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void skipAllMessages(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Name of subscription") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalSkipAllMessages(asyncResponse, Codec.decode((String)encodedSubName), authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/skip/{numMessages}")
    @ApiOperation(value="Skipping messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Skipping messages on a partitioned topic is not allowed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void skipMessages(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Name of subscription") @PathParam(value="subName") String encodedSubName, @ApiParam(value="The number of messages to skip", defaultValue="0") @PathParam(value="numMessages") int numMessages, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalSkipMessages(Codec.decode((String)encodedSubName), numMessages, authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expiry messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Expiry messages on a non-persistent topic is not allowed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void expireTopicMessages(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to be Expiry messages on") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Expires beyond the specified number of seconds", defaultValue="0") @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalExpireMessagesByTimestamp(asyncResponse, Codec.decode((String)encodedSubName), expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/expireMessages")
    @ApiOperation(value="Expiry messages on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Expiry messages on a non-persistent topic is not allowed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void expireTopicMessages(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to be Expiry messages on") @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(name="messageId", value="messageId to reset back to (ledgerId:entryId)") ResetCursorData resetCursorData) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalExpireMessagesByPosition(asyncResponse, Codec.decode((String)encodedSubName), authoritative, new MessageIdImpl(resetCursorData.getLedgerId(), resetCursorData.getEntryId(), resetCursorData.getPartitionIndex()), resetCursorData.isExcluded(), resetCursorData.getBatchIndex());
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/all_subscription/expireMessages/{expireTimeInSeconds}")
    @ApiOperation(value="Expiry messages on all subscriptions of topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic or subscription does not exist"), @ApiResponse(code=405, message="Expiry messages on a non-persistent topic is not allowed"), @ApiResponse(code=412, message="Can't find owner for topic"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void expireMessagesForAllSubscriptions(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Expires beyond the specified number of seconds", defaultValue="0") @PathParam(value="expireTimeInSeconds") int expireTimeInSeconds, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalExpireMessagesForAllSubscriptions(asyncResponse, expireTimeInSeconds, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subscriptionName}")
    @ApiOperation(value="Create a subscription on the topic.", notes="Creates a subscription on the topic at the specified message id")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=400, message="Create subscription on non persistent topic is not supported"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void createSubscription(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String topic, @ApiParam(value="Subscription to create position on", required=true) @PathParam(value="subscriptionName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(name="messageId", value="messageId where to create the subscription. It can be 'latest', 'earliest' or (ledgerId:entryId)", defaultValue="latest", allowableValues="latest,earliest,ledgerId:entryId") MessageIdImpl messageId, @ApiParam(value="Is replicated required to perform this operation") @QueryParam(value="replicated") boolean replicated) {
        try {
            this.validateTopicName(tenant, namespace, topic);
            if (!this.topicName.isPersistent()) {
                throw new RestException(Response.Status.BAD_REQUEST, "Create subscription on non-persistent topiccan only be done through client");
            }
            this.internalCreateSubscription(asyncResponse, Codec.decode((String)encodedSubName), messageId, authoritative, replicated);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor/{timestamp}")
    @ApiOperation(value="Reset subscription to message position closest to absolute timestamp (in ms).", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Method Not Allowed"), @ApiResponse(code=412, message="Failed to reset cursor on subscription or Unable to find position for timestamp specified"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void resetCursor(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription to reset position on", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="time in minutes to reset back to (or minutes, hours,days,weeks eg:100m, 3h, 2d, 5w)") @PathParam(value="timestamp") long timestamp, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalResetCursor(asyncResponse, Codec.decode((String)encodedSubName), timestamp, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/resetcursor")
    @ApiOperation(value="Reset subscription to message position closest to given position.", notes="It fence cursor and disconnects all active consumers before reseting cursor.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic/Subscription does not exist"), @ApiResponse(code=405, message="Not supported for partitioned topics"), @ApiResponse(code=412, message="Unable to find position for position specified"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void resetCursorOnPosition(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(name="subName", value="Subscription to reset position on", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @ApiParam(name="messageId", value="messageId to reset back to (ledgerId:entryId)") ResetCursorData resetCursorData) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalResetCursorOnPosition(asyncResponse, Codec.decode((String)encodedSubName), authoritative, new MessageIdImpl(resetCursorData.getLedgerId(), resetCursorData.getEntryId(), resetCursorData.getPartitionIndex()), resetCursorData.isExcluded(), resetCursorData.getBatchIndex());
        }
        catch (Exception e) {
            this.resumeAsyncResponseExceptionally(asyncResponse, e);
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscription/{subName}/position/{messagePosition}")
    @ApiOperation(value="Peek nth message on a topic subscription.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, subscription or the message position does not exist"), @ApiResponse(code=405, message="Skipping messages on a non-persistent topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public Response peekNthMessage(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(name="subName", value="Subscribed message expired", required=true) @PathParam(value="subName") String encodedSubName, @ApiParam(value="The number of messages (default 1)", defaultValue="1") @PathParam(value="messagePosition") int messagePosition, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalPeekNthMessage(Codec.decode((String)encodedSubName), messagePosition, authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/examinemessage")
    @ApiOperation(value="Examine a specific message on a topic by position relative to the earliest or the latest message.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, the message position does not exist"), @ApiResponse(code=405, message="If given partitioned topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error")})
    public Response examineMessage(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(name="initialPosition", value="Relative start position to examine message.It can be 'latest' or 'earliest'", defaultValue="latest", allowableValues="latest, earliest") @QueryParam(value="initialPosition") String initialPosition, @ApiParam(value="The position of messages (default 1)", defaultValue="1") @QueryParam(value="messagePosition") long messagePosition, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalExamineMessage(initialPosition, messagePosition, authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/ledger/{ledgerId}/entry/{entryId}")
    @ApiOperation(value="Get message by its messageId.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic, subscription or the message position does not exist"), @ApiResponse(code=405, message="Skipping messages on a non-persistent topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getMessageById(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The ledger id", required=true) @PathParam(value="ledgerId") long ledgerId, @ApiParam(value="The entry id", required=true) @PathParam(value="entryId") long entryId, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetMessageById(asyncResponse, ledgerId, entryId, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="{tenant}/{namespace}/{topic}/backlog")
    @ApiOperation(value="Get estimated backlog for offline topic.")
    @ApiResponses(value={@ApiResponse(code=404, message="Namespace does not exist"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public PersistentOfflineTopicStats getBacklog(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalGetBacklog(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/backlogQuotaMap")
    @ApiOperation(value="Get backlog quota map on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic policy does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry")})
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        return this.getTopicPolicies(this.topicName).map(TopicPolicies::getBackLogQuotaMap).map(map -> {
            HashMap hashMap = Maps.newHashMap();
            map.forEach((key, value) -> hashMap.put(BacklogQuota.BacklogQuotaType.valueOf((String)key), value));
            return hashMap;
        }).orElse(Maps.newHashMap());
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/backlogQuota")
    @ApiOperation(value="Set a backlog quota for a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=412, message="Specified backlog quota exceeds retention quota. Increase retention quota and retry request")})
    public void setBacklogQuota(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType, BacklogQuota backlogQuota) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetBacklogQuota(asyncResponse, backlogQuotaType, backlogQuota);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/backlogQuota")
    @ApiOperation(value="Remove a backlog quota policy from a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeBacklogQuota(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @QueryParam(value="backlogQuotaType") BacklogQuota.BacklogQuotaType backlogQuotaType) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveBacklogQuota(asyncResponse, backlogQuotaType);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/messageTTL")
    @ApiOperation(value="Get message TTL in seconds for a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, enable the topic level policy and retry")})
    public int getMessageTTL(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        return this.getTopicPolicies(this.topicName).map(TopicPolicies::getMessageTTLInSeconds).orElse(0);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/messageTTL")
    @ApiOperation(value="Set message TTL in seconds for a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Not authenticate to perform the request or policy is read only"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, enable the topic level policy and retry"), @ApiResponse(code=412, message="Invalid message TTL value")})
    public void setMessageTTL(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="TTL in seconds for the specified namespace", required=true) @QueryParam(value="messageTTL") int messageTTL) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMessageTTL(asyncResponse, messageTTL);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/messageTTL")
    @ApiOperation(value="Remove message TTL in seconds for a topic")
    @ApiResponses(value={@ApiResponse(code=403, message="Not authenticate to perform the request or policy is read only"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, enable the topic level policy and retry"), @ApiResponse(code=412, message="Invalid message TTL value")})
    public void removeMessageTTL(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMessageTTL(asyncResponse, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationEnabled")
    @ApiOperation(value="Get deduplication configuration of a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry")})
    public void getDeduplicationEnabled(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        TopicPolicies topicPolicies = this.getTopicPolicies(this.topicName).orElse(new TopicPolicies());
        if (topicPolicies.isDeduplicationSet()) {
            asyncResponse.resume((Object)topicPolicies.getDeduplicationEnabled());
        } else {
            asyncResponse.resume((Object)Response.noContent().build());
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationEnabled")
    @ApiOperation(value="Set deduplication enabled on a topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry")})
    public void setDeduplicationEnabled(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="DeduplicationEnabled policies for the specified topic") Boolean enabled) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetDeduplicationEnabled(enabled).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated deduplication", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated deduplication", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/deduplicationEnabled")
    @ApiOperation(value="Remove deduplication configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Tenant or cluster or namespace or topic doesn't exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeDeduplicationEnabled(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.setDeduplicationEnabled(asyncResponse, tenant, namespace, encodedTopic, null);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/retention")
    @ApiOperation(value="Get retention configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getRetention(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            this.internalGetRetention(asyncResponse);
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/retention")
    @ApiOperation(value="Set retention configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Retention Quota must exceed backlog quota")})
    public void setRetention(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Retention policies for the specified namespace") RetentionPolicies retention) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetRetention(retention).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated retention", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated retention", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully updated retention: namespace={}, topic={}, retention={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)retention)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/retention")
    @ApiOperation(value="Remove retention configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Retention Quota must exceed backlog quota")})
    public void removeRetention(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveRetention().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed updated retention", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove retention: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/persistence")
    @ApiOperation(value="Get configuration of persistence policies for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getPersistence(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<PersistencePolicies> persistencePolicies = this.internalGetPersistence();
            if (!persistencePolicies.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)persistencePolicies.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/persistence")
    @ApiOperation(value="Set configuration of persistence policies for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=400, message="Invalid persistence policies")})
    public void setPersistence(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Bookkeeper persistence policies for specified topic") PersistencePolicies persistencePolicies) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetPersistence(persistencePolicies).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully updated persistence policies: namespace={}, topic={}, persistencePolicies={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)persistencePolicies)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/persistence")
    @ApiOperation(value="Remove configuration of persistence policies for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removePersistence(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemovePersistence().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed updated retention", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove persistence policies: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxSubscriptionsPerTopic")
    @ApiOperation(value="Get maxSubscriptionsPerTopic config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getMaxSubscriptionsPerTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Integer> maxSubscriptionsPerTopic = this.internalGetMaxSubscriptionsPerTopic();
            if (!maxSubscriptionsPerTopic.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)maxSubscriptionsPerTopic.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxSubscriptionsPerTopic")
    @ApiOperation(value="Set maxSubscriptionsPerTopic config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Invalid value of maxSubscriptionsPerTopic")})
    public void setMaxSubscriptionsPerTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The max subscriptions of the topic") int maxSubscriptionsPerTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxSubscriptionsPerTopic(maxSubscriptionsPerTopic).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Updating maxSubscriptionsPerTopic failed", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Updating maxSubscriptionsPerTopic failed", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully updated maxSubscriptionsPerTopic: namespace={}, topic={}, maxSubscriptions={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), maxSubscriptionsPerTopic});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxSubscriptionsPerTopic")
    @ApiOperation(value="Remove maxSubscriptionsPerTopic config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxSubscriptionsPerTopic(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxSubscriptionsPerTopic(null).whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove maxSubscriptionsPerTopic", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove maximum subscription limit: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxProducers")
    @ApiOperation(value="Get maxProducers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getMaxProducers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Integer> maxProducers = this.internalGetMaxProducers();
            if (!maxProducers.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)maxProducers.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxProducers")
    @ApiOperation(value="Set maxProducers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Invalid value of maxProducers")})
    public void setMaxProducers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The max producers of the topic") int maxProducers) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxProducers(maxProducers).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully updated max producers: namespace={}, topic={}, maxProducers={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), maxProducers});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxProducers")
    @ApiOperation(value="Remove maxProducers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxProducers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveMaxProducers().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove maxProducers", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove max producers: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumers")
    @ApiOperation(value="Get maxConsumers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getMaxConsumers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Integer> maxConsumers = this.internalGetMaxConsumers();
            if (!maxConsumers.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)maxConsumers.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumers")
    @ApiOperation(value="Set maxConsumers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Invalid value of maxConsumers")})
    public void setMaxConsumers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The max consumers of the topic") int maxConsumers) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxConsumers(maxConsumers).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully updated max consumers: namespace={}, topic={}, maxConsumers={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), maxConsumers});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumers")
    @ApiOperation(value="Remove maxConsumers config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxConsumers(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveMaxConsumers().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove maxConsumers", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove max consumers: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxMessageSize")
    @ApiOperation(value="Get maxMessageSize config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getMaxMessageSize(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Integer> policies = this.internalGetMaxMessageSize();
            if (policies.isPresent()) {
                asyncResponse.resume((Object)policies.get());
            } else {
                asyncResponse.resume((Object)Response.noContent().build());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxMessageSize")
    @ApiOperation(value="Set maxMessageSize config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification"), @ApiResponse(code=412, message="Invalid value of maxConsumers")})
    public void setMaxMessageSize(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="The max message size of the topic") int maxMessageSize) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxMessageSize(maxMessageSize).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed updated persistence policies", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully set max message size: namespace={}, topic={}, maxMessageSiz={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName(), maxMessageSize});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxMessageSize")
    @ApiOperation(value="Remove maxMessageSize config for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, to enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxMessageSize(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxMessageSize(null).whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove maxMessageSize", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove max message size: namespace={}, topic={}", new Object[]{this.clientAppId(), this.namespaceName, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/terminate")
    @ApiOperation(value="Terminate a topic. A topic that is terminated will not accept any more messages to be published and will let consumer to drain existing messages in backlog")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Termination of a partitioned topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public MessageId terminate(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalTerminate(authoritative);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/terminate/partitions")
    @ApiOperation(value="Terminate all partitioned topic. A topic that is terminated will not accept any more messages to be published and will let consumer to drain existing messages in backlog")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Termination of a partitioned topic is not allowed"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void terminatePartitionedTopic(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTerminatePartitionedTopic(asyncResponse, authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Trigger a compaction operation on a topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=409, message="Compaction already running"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void compact(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalTriggerCompaction(asyncResponse, authoritative);
        }
        catch (WebApplicationException wae) {
            asyncResponse.resume((Throwable)wae);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/compaction")
    @ApiOperation(value="Get the status of a compaction operation for a topic.")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist, or compaction hasn't run"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public LongRunningProcessStatus compactionStatus(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalCompactionStatus(authoritative);
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=400, message="Message ID is null"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=409, message="Offload already running"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void triggerOffload(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, MessageIdImpl messageId) {
        if (messageId == null) {
            throw new RestException(Response.Status.BAD_REQUEST, "messageId is null");
        }
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.internalTriggerOffload(authoritative, messageId);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/offload")
    @ApiOperation(value="Offload a prefix of a topic to long term storage")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public OffloadProcessStatus offloadStatus(@ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        return this.internalOffloadStatus(authoritative);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/lastMessageId")
    @ApiOperation(value="Return the last commit message id of topic")
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Don't have permission to administrate resources on this tenant orsubscriber is not authorized to access this operation"), @ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Operation is not allowed on the persistent topic"), @ApiResponse(code=412, message="Topic name is not valid"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Failed to validate global cluster configuration")})
    public void getLastMessageId(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Specify the tenant", required=true) @PathParam(value="tenant") String tenant, @ApiParam(value="Specify the namespace", required=true) @PathParam(value="namespace") String namespace, @ApiParam(value="Specify topic name", required=true) @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Is authentication required to perform this operation") @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative) {
        try {
            this.validateTopicName(tenant, namespace, encodedTopic);
            this.internalGetLastMessageId(asyncResponse, authoritative);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/dispatchRate")
    @ApiOperation(value="Get dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<DispatchRate> dispatchRate = this.internalGetDispatchRate();
            if (!dispatchRate.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)dispatchRate.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/dispatchRate")
    @ApiOperation(value="Set message dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Dispatch rate for the specified topic") DispatchRate dispatchRate) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetDispatchRate(dispatchRate).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic dispatch rate", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic dispatch rate");
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic dispatch rate: tenant={}, namespace={}, topic={}, dispatchRate={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)dispatchRate)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/dispatchRate")
    @ApiOperation(value="Remove message dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveDispatchRate().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic dispatch rate", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic dispatch rate: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptionDispatchRate")
    @ApiOperation(value="Get subscription message dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<DispatchRate> dispatchRate = this.internalGetSubscriptionDispatchRate();
            if (!dispatchRate.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)dispatchRate.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptionDispatchRate")
    @ApiOperation(value="Set subscription message dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscription message dispatch rate for the specified topic") DispatchRate dispatchRate) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetSubscriptionDispatchRate(dispatchRate).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic: {} subscription dispatch rate", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic: {} subscription dispatch rate", (Object)this.topicName.getLocalName());
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic subscription dispatch rate: tenant={}, namespace={}, topic={}, dispatchRate={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)dispatchRate)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/subscriptionDispatchRate")
    @ApiOperation(value="Remove subscription message dispatch rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeSubscriptionDispatchRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveSubscriptionDispatchRate().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic: {} subscription dispatch rate", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic subscription dispatch rate: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/compactionThreshold")
    @ApiOperation(value="Get compaction threshold configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getCompactionThreshold(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Long> compactionThreshold = this.internalGetCompactionThreshold();
            if (!compactionThreshold.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)compactionThreshold.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/compactionThreshold")
    @ApiOperation(value="Set compaction threshold configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setCompactionThreshold(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Dispatch rate for the specified topic") long compactionThreshold) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetCompactionThreshold(compactionThreshold).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic dispatch rate", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic dispatch rate");
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic compaction threshold: tenant={}, namespace={}, topic={}, compactionThreshold={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)compactionThreshold)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/compactionThreshold")
    @ApiOperation(value="Remove compaction threshold configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeCompactionThreshold(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveCompactionThreshold().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic dispatch rate", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic compaction threshold: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumersPerSubscription")
    @ApiOperation(value="Get max consumers per subscription configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getMaxConsumersPerSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<Integer> maxConsumersPerSubscription = this.internalGetMaxConsumersPerSubscription();
            if (!maxConsumersPerSubscription.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)maxConsumersPerSubscription.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumersPerSubscription")
    @ApiOperation(value="Set max consumers per subscription configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setMaxConsumersPerSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Dispatch rate for the specified topic") int maxConsumersPerSubscription) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetMaxConsumersPerSubscription(maxConsumersPerSubscription).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic {} max consumers per subscription ", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic max consumers per subscription");
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic max consumers per subscription: tenant={}, namespace={}, topic={}, maxConsumersPerSubscription={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)maxConsumersPerSubscription)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/maxConsumersPerSubscription")
    @ApiOperation(value="Remove max consumers per subscription configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeMaxConsumersPerSubscription(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveMaxConsumersPerSubscription().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic {} max consuners per subscription", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic max consumers per subscription: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/publishRate")
    @ApiOperation(value="Get publish rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getPublishRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<PublishRate> publishRate = this.internalGetPublishRate();
            if (!publishRate.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)publishRate.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/publishRate")
    @ApiOperation(value="Set message publish rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setPublishRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Dispatch rate for the specified topic") PublishRate publishRate) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetPublishRate(publishRate).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic dispatch rate", ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic dispatch rate");
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic publish rate: tenant={}, namespace={}, topic={}, publishRate={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)publishRate)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/publishRate")
    @ApiOperation(value="Remove message publish rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removePublishRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemovePublishRate().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic publish rate", ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic publish rate: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/subscribeRate")
    @ApiOperation(value="Get subscribe rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void getSubscribeRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        try {
            Optional<SubscribeRate> subscribeRate = this.internalGetSubscribeRate();
            if (!subscribeRate.isPresent()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)subscribeRate.get());
            }
        }
        catch (RestException e) {
            asyncResponse.resume((Throwable)((Object)e));
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)((Object)new RestException(e)));
        }
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/subscribeRate")
    @ApiOperation(value="Set subscribe rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void setSubscribeRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic, @ApiParam(value="Subscribe rate for the specified topic") SubscribeRate subscribeRate) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalSetSubscribeRate(subscribeRate).whenComplete((r, ex) -> {
            if (ex instanceof RestException) {
                log.error("Failed to set topic {} subscribe rate", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume(ex);
            } else if (ex != null) {
                log.error("Failed to set topic subscribe rate");
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                try {
                    log.info("[{}] Successfully set topic subscribe rate: tenant={}, namespace={}, topic={}, subscribeRate={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName(), PersistentTopics.jsonMapper().writeValueAsString((Object)subscribeRate)});
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/subscribeRate")
    @ApiOperation(value="Remove subscribe rate configuration for specified topic.")
    @ApiResponses(value={@ApiResponse(code=403, message="Topic does not exist"), @ApiResponse(code=404, message="Topic does not exist"), @ApiResponse(code=405, message="Topic level policy is disabled, please enable the topic level policy and retry"), @ApiResponse(code=409, message="Concurrent modification")})
    public void removeSubscribeRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") @Encoded String encodedTopic) {
        this.validateTopicName(tenant, namespace, encodedTopic);
        this.preValidation();
        this.internalRemoveSubscribeRate().whenComplete((r, ex) -> {
            if (ex != null) {
                log.error("Failed to remove topic {} subscribe rate ", (Object)this.topicName.getLocalName(), ex);
                asyncResponse.resume((Throwable)((Object)new RestException((Throwable)ex)));
            } else {
                log.info("[{}] Successfully remove topic subscribe rate: tenant={}, namespace={}, topic={}", new Object[]{this.clientAppId(), tenant, namespace, this.topicName.getLocalName()});
                asyncResponse.resume((Object)Response.noContent().build());
            }
        });
    }
}

