/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.EntryCacheManager;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.StreamingStats;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentReplicator;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentSubscription;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.NonPersistentPublisherStats;
import org.apache.pulsar.common.policies.data.NonPersistentReplicatorStats;
import org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPersistentTopic
extends AbstractTopic
implements Topic {
    private final ConcurrentOpenHashMap<String, NonPersistentSubscription> subscriptions = new ConcurrentOpenHashMap(16, 1);
    private final ConcurrentOpenHashMap<String, NonPersistentReplicator> replicators = new ConcurrentOpenHashMap(16, 1);
    protected static final AtomicLongFieldUpdater<NonPersistentTopic> USAGE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(NonPersistentTopic.class, "usageCount");
    private volatile long usageCount = 0L;
    private static final AtomicLongFieldUpdater<NonPersistentTopic> ENTRIES_ADDED_COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(NonPersistentTopic.class, "entriesAddedCounter");
    private volatile long entriesAddedCounter = 0L;
    private static final FastThreadLocal<TopicStats> threadLocalTopicStats = new FastThreadLocal<TopicStats>(){

        protected TopicStats initialValue() {
            return new TopicStats();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(NonPersistentTopic.class);

    public NonPersistentTopic(String topic, BrokerService brokerService) {
        super(topic, brokerService);
        this.isFenced = false;
        USAGE_COUNT_UPDATER.set(this, 0L);
        try {
            Policies policies = (Policies)brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)topic).getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
            this.isEncryptionRequired = policies.encryption_required;
            this.isAllowAutoUpdateSchema = policies.is_allow_auto_update_schema;
            if (policies.inactive_topic_policies != null) {
                this.inactiveTopicPolicies = policies.inactive_topic_policies;
            }
            this.setSchemaCompatibilityStrategy(policies);
            this.schemaValidationEnforced = policies.schema_validation_enforced;
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and isEncryptionRequired will be set to false", (Object)topic, (Object)e.getMessage());
            this.isEncryptionRequired = false;
        }
    }

    @Override
    public void publishMessage(ByteBuf data, Topic.PublishContext callback) {
        if (this.isExceedMaximumMessageSize(data.readableBytes())) {
            callback.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            return;
        }
        callback.completed(null, 0L, 0L);
        ENTRIES_ADDED_COUNTER_UPDATER.incrementAndGet(this);
        this.subscriptions.forEach((name, subscription) -> {
            ByteBuf duplicateBuffer = data.retainedDuplicate();
            Entry entry = EntryCacheManager.create((long)0L, (long)0L, (ByteBuf)duplicateBuffer);
            duplicateBuffer.release();
            if (subscription.getDispatcher() != null) {
                subscription.getDispatcher().sendMessages(Collections.singletonList(entry));
            } else {
                entry.release();
            }
        });
        if (!this.replicators.isEmpty()) {
            this.replicators.forEach((name, replicator) -> {
                ByteBuf duplicateBuffer = data.retainedDuplicate();
                Entry entry = EntryCacheManager.create((long)0L, (long)0L, (ByteBuf)duplicateBuffer);
                duplicateBuffer.release();
                replicator.sendMessage(entry);
            });
        }
    }

    @Override
    public void addProducer(Producer producer) throws BrokerServiceException {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        this.lock.readLock().lock();
        try {
            this.brokerService.checkTopicNsOwnership(this.getName());
            this.checkTopicFenced();
            this.internalAddProducer(producer);
            USAGE_COUNT_UPDATER.incrementAndGet(this);
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Added producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void checkMessageDeduplicationInfo() {
    }

    @Override
    public void removeProducer(Producer producer) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        if (this.producers.remove(producer.getProducerName(), producer)) {
            this.handleProducerRemoved(producer);
        }
    }

    @Override
    public void handleProducerRemoved(Producer producer) {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Removed producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
        }
        this.lastActive = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Consumer> subscribe(TransportCnx cnx, String subscriptionName, long consumerId, PulsarApi.CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, PulsarApi.CommandSubscribe.InitialPosition initialPosition, long resetStartMessageBackInSec, boolean replicateSubscriptionState, PulsarApi.KeySharedMeta keySharedMeta) {
        CompletableFuture<Consumer> future = new CompletableFuture<Consumer>();
        try {
            this.brokerService.checkTopicNsOwnership(this.getName());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        if (this.hasBatchMessagePublished && !cnx.isBatchMessageCompatibleVersion()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Consumer doesn't support batch-message {}", (Object)this.topic, (Object)subscriptionName);
            }
            future.completeExceptionally(new BrokerServiceException.UnsupportedVersionException("Consumer doesn't support batch-message"));
            return future;
        }
        if (subscriptionName.startsWith(this.replicatorPrefix)) {
            log.warn("[{}] Failed to create subscription for {}", (Object)this.topic, (Object)subscriptionName);
            future.completeExceptionally(new BrokerServiceException.NamingException("Subscription with reserved subscription name attempted"));
            return future;
        }
        if (readCompacted) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("readCompacted only valid on persistent topics"));
            return future;
        }
        this.lock.readLock().lock();
        try {
            if (this.isFenced) {
                log.warn("[{}] Attempting to subscribe to a fenced topic", (Object)this.topic);
                future.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable"));
                CompletableFuture<Consumer> e = future;
                return e;
            }
            USAGE_COUNT_UPDATER.incrementAndGet(this);
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Added consumer -- count: {}", new Object[]{this.topic, subscriptionName, consumerName, USAGE_COUNT_UPDATER.get(this)});
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        NonPersistentSubscription subscription = (NonPersistentSubscription)this.subscriptions.computeIfAbsent((Object)subscriptionName, name -> new NonPersistentSubscription(this, subscriptionName));
        try {
            Consumer consumer = new Consumer(subscription, subType, this.topic, consumerId, priorityLevel, consumerName, 0, cnx, cnx.getAuthRole(), metadata, readCompacted, initialPosition, keySharedMeta);
            this.addConsumerToSubscription(subscription, consumer);
            if (!cnx.isActive()) {
                consumer.close();
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] [{}] Subscribe failed -- count: {}", new Object[]{this.topic, subscriptionName, consumer.consumerName(), USAGE_COUNT_UPDATER.get(this)});
                }
                future.completeExceptionally(new BrokerServiceException("Connection was closed while the opening the cursor "));
            } else {
                log.info("[{}][{}] Created new subscription for {}", new Object[]{this.topic, subscriptionName, consumerId});
                future.complete(consumer);
            }
        }
        catch (BrokerServiceException e) {
            if (e instanceof BrokerServiceException.ConsumerBusyException) {
                log.warn("[{}][{}] Consumer {} {} already connected", new Object[]{this.topic, subscriptionName, consumerId, consumerName});
            } else if (e instanceof BrokerServiceException.SubscriptionBusyException) {
                log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, e.getMessage()});
            }
            USAGE_COUNT_UPDATER.decrementAndGet(this);
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Subscription> createSubscription(String subscriptionName, PulsarApi.CommandSubscribe.InitialPosition initialPosition, boolean replicateSubscriptionState) {
        return CompletableFuture.completedFuture(new NonPersistentSubscription(this, subscriptionName));
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.delete(false, false, false);
    }

    @Override
    public CompletableFuture<Void> deleteForcefully() {
        return this.delete(false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean closeIfClientsConnected, boolean deleteSchema) {
        CompletableFuture<Void> deleteFuture = new CompletableFuture<Void>();
        this.lock.writeLock().lock();
        try {
            if (this.isFenced) {
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                deleteFuture.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                CompletableFuture<Void> completableFuture = deleteFuture;
                return completableFuture;
            }
            CompletableFuture closeClientFuture = new CompletableFuture();
            if (closeIfClientsConnected) {
                ArrayList futures = Lists.newArrayList();
                this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
                this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
                this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
                ((CompletableFuture)FutureUtil.waitForAll((List)futures).thenRun(() -> closeClientFuture.complete(null))).exceptionally(ex -> {
                    log.error("[{}] Error closing clients", (Object)this.topic, ex);
                    this.isFenced = false;
                    closeClientFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else {
                closeClientFuture.complete(null);
            }
            ((CompletableFuture)closeClientFuture.thenAccept(delete -> {
                if (USAGE_COUNT_UPDATER.get(this) == 0L) {
                    this.isFenced = true;
                    ArrayList futures = Lists.newArrayList();
                    if (failIfHasSubscriptions) {
                        if (!this.subscriptions.isEmpty()) {
                            this.isFenced = false;
                            deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has subscriptions"));
                            return;
                        }
                    } else {
                        this.subscriptions.forEach((s, sub) -> futures.add(sub.delete()));
                    }
                    if (deleteSchema) {
                        futures.add(this.deleteSchema().thenApply(schemaVersion -> null));
                    }
                    FutureUtil.waitForAll((List)futures).whenComplete((v, ex) -> {
                        if (ex != null) {
                            log.error("[{}] Error deleting topic", (Object)this.topic, ex);
                            this.isFenced = false;
                            deleteFuture.completeExceptionally((Throwable)ex);
                        } else {
                            this.brokerService.executor().execute(() -> {
                                this.brokerService.removeTopicFromCache(this.topic);
                                log.info("[{}] Topic deleted", (Object)this.topic);
                                deleteFuture.complete(null);
                            });
                        }
                    });
                } else {
                    deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has " + USAGE_COUNT_UPDATER.get(this) + " connected producers/consumers"));
                }
            })).exceptionally(ex -> {
                deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Failed to close clients before deleting topic."));
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return deleteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(boolean closeWithoutWaitingClientDisconnect) {
        CompletableFuture<Void> closeFuture;
        block4: {
            closeFuture = new CompletableFuture<Void>();
            this.lock.writeLock().lock();
            try {
                if (!this.isFenced || closeWithoutWaitingClientDisconnect) {
                    this.isFenced = true;
                    break block4;
                }
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                closeFuture.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                CompletableFuture<Void> completableFuture = closeFuture;
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ArrayList futures = Lists.newArrayList();
        this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
        this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
        this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
        CompletableFuture clientCloseFuture = closeWithoutWaitingClientDisconnect ? CompletableFuture.completedFuture(null) : FutureUtil.waitForAll((List)futures);
        ((CompletableFuture)clientCloseFuture.thenRun(() -> {
            log.info("[{}] Topic closed", (Object)this.topic);
            this.brokerService.executor().execute(() -> {
                this.brokerService.removeTopicFromCache(this.topic);
                closeFuture.complete(null);
            });
        })).exceptionally(exception -> {
            log.error("[{}] Error closing topic", (Object)this.topic, exception);
            this.isFenced = false;
            closeFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return closeFuture;
    }

    public CompletableFuture<Void> stopReplProducers() {
        ArrayList closeFutures = Lists.newArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect()));
        return FutureUtil.waitForAll((List)closeFutures);
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        TopicName name = TopicName.get((String)this.topic);
        if (!name.isGlobal()) {
            return CompletableFuture.completedFuture(null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Checking replication status", (Object)name);
        }
        Policies policies = null;
        try {
            policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
        }
        catch (Exception e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new BrokerServiceException.ServerMetadataException(e));
            return future;
        }
        Set configuredClusters = policies.replication_clusters != null ? policies.replication_clusters : Collections.emptySet();
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        ArrayList futures = Lists.newArrayList();
        for (String cluster2 : configuredClusters) {
            if (cluster2.equals(localCluster) || this.replicators.containsKey((Object)cluster2) || this.startReplicator(cluster2)) continue;
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NamingException(this.topic + " failed to start replicator for " + cluster2));
        }
        this.replicators.forEach((cluster, replicator) -> {
            if (!cluster.equals(localCluster) && !configuredClusters.contains(cluster)) {
                futures.add(this.removeReplicator((String)cluster));
            }
        });
        return FutureUtil.waitForAll((List)futures);
    }

    boolean startReplicator(String remoteCluster) {
        log.info("[{}] Starting replicator to remote: {}", (Object)this.topic, (Object)remoteCluster);
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        return this.addReplicationCluster(remoteCluster, this, localCluster);
    }

    protected boolean addReplicationCluster(String remoteCluster, NonPersistentTopic nonPersistentTopic, String localCluster) {
        AtomicBoolean isReplicatorStarted = new AtomicBoolean(true);
        this.replicators.computeIfAbsent((Object)remoteCluster, r -> {
            try {
                return new NonPersistentReplicator(this, localCluster, remoteCluster, this.brokerService);
            }
            catch (BrokerServiceException.NamingException e) {
                isReplicatorStarted.set(false);
                log.error("[{}] Replicator startup failed due to partitioned-topic {}", (Object)this.topic, (Object)remoteCluster);
                return null;
            }
        });
        if (!isReplicatorStarted.get()) {
            this.replicators.remove((Object)remoteCluster);
        }
        return isReplicatorStarted.get();
    }

    CompletableFuture<Void> removeReplicator(String remoteCluster) {
        log.info("[{}] Removing replicator to {}", (Object)this.topic, (Object)remoteCluster);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        String name = NonPersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        ((CompletableFuture)((NonPersistentReplicator)this.replicators.get((Object)remoteCluster)).disconnect().thenRun(() -> log.info("[{}] Successfully removed replicator {}", (Object)name, (Object)remoteCluster))).exceptionally(e -> {
            log.error("[{}] Failed to close replication producer {} {}", new Object[]{this.topic, name, e.getMessage(), e});
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    private CompletableFuture<Void> checkReplicationAndRetryOnFailure() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.checkReplication().thenAccept(res -> {
            log.info("[{}] Policies updated successfully", (Object)this.topic);
            result.complete(null);
        })).exceptionally(th -> {
            log.error("[{}] Policies update failed {}, scheduled retry in {} seconds", new Object[]{this.topic, th.getMessage(), 60L, th});
            this.brokerService.executor().schedule(this::checkReplicationAndRetryOnFailure, 60L, TimeUnit.SECONDS);
            result.completeExceptionally((Throwable)th);
            return null;
        });
        return result;
    }

    @Override
    public void checkMessageExpiry() {
    }

    @Override
    public int getNumberOfConsumers() {
        int count = 0;
        for (NonPersistentSubscription subscription : this.subscriptions.values()) {
            count += subscription.getConsumers().size();
        }
        return count;
    }

    public ConcurrentOpenHashMap<String, NonPersistentSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public ConcurrentOpenHashMap<String, NonPersistentReplicator> getReplicators() {
        return this.replicators;
    }

    @Override
    public Subscription getSubscription(String subscription) {
        return (Subscription)this.subscriptions.get((Object)subscription);
    }

    public Replicator getPersistentReplicator(String remoteCluster) {
        return (Replicator)this.replicators.get((Object)remoteCluster);
    }

    @Override
    public void updateRates(NamespaceStats nsStats, NamespaceBundleStats bundleStats, StatsOutputStream topicStatsStream, ClusterReplicationMetrics replStats, String namespace, boolean hydratePublishers) {
        TopicStats topicStats = (TopicStats)threadLocalTopicStats.get();
        topicStats.reset();
        this.replicators.forEach((region, replicator) -> replicator.updateRates());
        nsStats.producerCount += this.producers.size();
        bundleStats.producerCount += this.producers.size();
        topicStatsStream.startObject(this.topic);
        topicStatsStream.startList("publishers");
        this.producers.values().forEach(producer -> {
            producer.updateRates();
            PublisherStats publisherStats = producer.getStats();
            topicStats.aggMsgRateIn += publisherStats.msgRateIn;
            topicStats.aggMsgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                topicStats.remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            }
            if (hydratePublishers) {
                StreamingStats.writePublisherStats(topicStatsStream, publisherStats);
            }
        });
        topicStatsStream.endList();
        topicStatsStream.startObject("replication");
        nsStats.replicatorCount += topicStats.remotePublishersStats.size();
        topicStatsStream.endObject();
        topicStatsStream.startObject("subscriptions");
        nsStats.subsCount = (int)((long)nsStats.subsCount + this.subscriptions.size());
        this.subscriptions.forEach((subscriptionName, subscription) -> {
            double subMsgRateOut = 0.0;
            double subMsgThroughputOut = 0.0;
            double subMsgRateRedeliver = 0.0;
            try {
                topicStatsStream.startObject((String)subscriptionName);
                topicStatsStream.startList("consumers");
                for (Consumer consumer : subscription.getConsumers()) {
                    ++nsStats.consumerCount;
                    ++bundleStats.consumerCount;
                    consumer.updateRates();
                    ConsumerStats consumerStats = consumer.getStats();
                    subMsgRateOut += consumerStats.msgRateOut;
                    subMsgThroughputOut += consumerStats.msgThroughputOut;
                    subMsgRateRedeliver += consumerStats.msgRateRedeliver;
                    StreamingStats.writeConsumerStats(topicStatsStream, subscription.getType(), consumerStats);
                }
                topicStatsStream.endList();
                topicStatsStream.writePair("msgBacklog", subscription.getNumberOfEntriesInBacklog(false));
                topicStatsStream.writePair("msgRateExpired", subscription.getExpiredMessageRate());
                topicStatsStream.writePair("msgRateOut", subMsgRateOut);
                topicStatsStream.writePair("msgThroughputOut", subMsgThroughputOut);
                topicStatsStream.writePair("msgRateRedeliver", subMsgRateRedeliver);
                topicStatsStream.writePair("type", subscription.getTypeString());
                if (subscription.getDispatcher() != null) {
                    subscription.getDispatcher().getMessageDropRate().calculateRate();
                    topicStatsStream.writePair("msgDropRate", subscription.getDispatcher().getMessageDropRate().getValueRate());
                }
                topicStatsStream.endObject();
                topicStats.aggMsgRateOut += subMsgRateOut;
                topicStats.aggMsgThroughputOut += subMsgThroughputOut;
                nsStats.msgBacklog += (double)subscription.getNumberOfEntriesInBacklog(false);
            }
            catch (Exception e) {
                log.error("Got exception when creating consumer stats for subscription {}: {}", new Object[]{subscriptionName, e.getMessage(), e});
            }
        });
        topicStatsStream.endObject();
        topicStats.averageMsgSize = topicStats.aggMsgRateIn == 0.0 ? 0.0 : topicStats.aggMsgThroughputIn / topicStats.aggMsgRateIn;
        topicStatsStream.writePair("producerCount", this.producers.size());
        topicStatsStream.writePair("averageMsgSize", topicStats.averageMsgSize);
        topicStatsStream.writePair("msgRateIn", topicStats.aggMsgRateIn);
        topicStatsStream.writePair("msgRateOut", topicStats.aggMsgRateOut);
        topicStatsStream.writePair("msgThroughputIn", topicStats.aggMsgThroughputIn);
        topicStatsStream.writePair("msgThroughputOut", topicStats.aggMsgThroughputOut);
        topicStatsStream.writePair("msgInCount", this.getMsgInCounter());
        topicStatsStream.writePair("bytesInCount", this.getBytesInCounter());
        topicStatsStream.writePair("msgOutCount", this.getMsgOutCounter());
        topicStatsStream.writePair("bytesOutCount", this.getBytesOutCounter());
        nsStats.msgRateIn += topicStats.aggMsgRateIn;
        nsStats.msgRateOut += topicStats.aggMsgRateOut;
        nsStats.msgThroughputIn += topicStats.aggMsgThroughputIn;
        nsStats.msgThroughputOut += topicStats.aggMsgThroughputOut;
        bundleStats.msgRateIn += topicStats.aggMsgRateIn;
        bundleStats.msgRateOut += topicStats.aggMsgRateOut;
        bundleStats.msgThroughputIn += topicStats.aggMsgThroughputIn;
        bundleStats.msgThroughputOut += topicStats.aggMsgThroughputOut;
        this.addEntryLatencyStatsUsec.refresh();
        NamespaceStats.add(this.addEntryLatencyStatsUsec.getBuckets(), nsStats.addLatencyBucket);
        this.addEntryLatencyStatsUsec.reset();
        topicStatsStream.endObject();
    }

    public NonPersistentTopicStats getStats(boolean getPreciseBacklog, boolean subscriptionBacklogSize) {
        NonPersistentTopicStats stats = new NonPersistentTopicStats();
        ObjectObjectHashMap remotePublishersStats = new ObjectObjectHashMap();
        this.producers.values().forEach(producer -> {
            NonPersistentPublisherStats publisherStats = (NonPersistentPublisherStats)producer.getStats();
            stats.msgRateIn += publisherStats.msgRateIn;
            stats.msgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            } else {
                stats.getPublishers().add(publisherStats);
            }
        });
        stats.averageMsgSize = stats.msgRateIn == 0.0 ? 0.0 : stats.msgThroughputIn / stats.msgRateIn;
        stats.msgInCounter = this.getMsgInCounter();
        stats.bytesInCounter = this.getBytesInCounter();
        this.subscriptions.forEach((name, subscription) -> {
            NonPersistentSubscriptionStats subStats = subscription.getStats();
            stats.msgRateOut += subStats.msgRateOut;
            stats.msgThroughputOut += subStats.msgThroughputOut;
            stats.bytesOutCounter += subStats.bytesOutCounter;
            stats.msgOutCounter += subStats.msgOutCounter;
            stats.getSubscriptions().put(name, subStats);
        });
        this.replicators.forEach((cluster, replicator) -> {
            NonPersistentReplicatorStats replicatorStats = replicator.getStats();
            PublisherStats pubStats = (PublisherStats)remotePublishersStats.get((Object)replicator.getRemoteCluster());
            if (pubStats != null) {
                replicatorStats.msgRateIn = pubStats.msgRateIn;
                replicatorStats.msgThroughputIn = pubStats.msgThroughputIn;
                replicatorStats.inboundConnection = pubStats.getAddress();
                replicatorStats.inboundConnectedSince = pubStats.getConnectedSince();
            }
            stats.msgRateOut += replicatorStats.msgRateOut;
            stats.msgThroughputOut += replicatorStats.msgThroughputOut;
            stats.getReplication().put(replicator.getRemoteCluster(), replicatorStats);
        });
        return stats;
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStats(boolean includeLedgerMetadata) {
        PersistentTopicInternalStats stats = new PersistentTopicInternalStats();
        stats.entriesAddedCounter = ENTRIES_ADDED_COUNTER_UPDATER.get(this);
        stats.cursors = Maps.newTreeMap();
        this.subscriptions.forEach((name, subs) -> stats.cursors.put(name, new PersistentTopicInternalStats.CursorStats()));
        this.replicators.forEach((name, subs) -> stats.cursors.put(name, new PersistentTopicInternalStats.CursorStats()));
        return CompletableFuture.completedFuture(stats);
    }

    public boolean isActive() {
        if (TopicName.get((String)this.topic).isGlobal()) {
            return !this.subscriptions.isEmpty() || this.hasLocalProducers();
        }
        return USAGE_COUNT_UPDATER.get(this) != 0L || !this.subscriptions.isEmpty();
    }

    @Override
    public void checkGC() {
        if (!this.isDeleteWhileInactive()) {
            return;
        }
        int maxInactiveDurationInSec = this.inactiveTopicPolicies.getMaxInactiveDurationSeconds();
        if (this.isActive()) {
            this.lastActive = System.nanoTime();
        } else if (System.nanoTime() - this.lastActive > TimeUnit.SECONDS.toNanos(maxInactiveDurationInSec) && TopicName.get((String)this.topic).isGlobal()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Global topic inactive for {} seconds, closing repl producers.", (Object)this.topic, (Object)maxInactiveDurationInSec);
            }
            ((CompletableFuture)((CompletableFuture)this.stopReplProducers().thenCompose(v -> this.delete(true, false, true))).thenRun(() -> log.info("[{}] Topic deleted successfully due to inactivity", (Object)this.topic))).exceptionally(e -> {
                if (e.getCause() instanceof BrokerServiceException.TopicBusyException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Did not delete busy topic: {}", (Object)this.topic, (Object)e.getCause().getMessage());
                    }
                    this.replicators.forEach((region, replicator) -> replicator.startProducer());
                } else {
                    log.warn("[{}] Inactive topic deletion failed", (Object)this.topic, e);
                }
                return null;
            });
        }
    }

    @Override
    public void checkInactiveSubscriptions() {
        block3: {
            TopicName name = TopicName.get((String)this.topic);
            try {
                Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(KeeperException.NoNodeException::new);
                int defaultExpirationTime = this.brokerService.pulsar().getConfiguration().getSubscriptionExpirationTimeMinutes();
                long expirationTimeMillis = TimeUnit.MINUTES.toMillis(policies.subscription_expiration_time_minutes <= 0 && defaultExpirationTime > 0 ? (long)defaultExpirationTime : (long)policies.subscription_expiration_time_minutes);
                if (expirationTimeMillis > 0L) {
                    this.subscriptions.forEach((subName, sub) -> {
                        if (sub.getDispatcher() != null && sub.getDispatcher().isConsumerConnected() || sub.isReplicated()) {
                            return;
                        }
                        if (System.currentTimeMillis() - sub.getLastActive() > expirationTimeMillis) {
                            sub.delete().thenAccept(v -> log.info("[{}][{}] The subscription was deleted due to expiration", (Object)this.topic, subName));
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @Override
    public void checkBackloggedCursors() {
    }

    @Override
    public void checkDeduplicationSnapshot() {
    }

    @Override
    public CompletableFuture<Void> onPoliciesUpdate(Policies data) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] isEncryptionRequired changes: {} -> {}", new Object[]{this.topic, this.isEncryptionRequired, data.encryption_required});
        }
        this.isEncryptionRequired = data.encryption_required;
        this.setSchemaCompatibilityStrategy(data);
        this.isAllowAutoUpdateSchema = data.is_allow_auto_update_schema;
        this.schemaValidationEnforced = data.schema_validation_enforced;
        this.producers.values().forEach(producer -> {
            producer.checkPermissions();
            producer.checkEncryption();
        });
        this.subscriptions.forEach((subName, sub) -> sub.getConsumers().forEach(Consumer::checkPermissions));
        if (data.inactive_topic_policies != null) {
            this.inactiveTopicPolicies = data.inactive_topic_policies;
        } else {
            ServiceConfiguration cfg = this.brokerService.getPulsar().getConfiguration();
            this.resetInactiveTopicPolicies(cfg.getBrokerDeleteInactiveTopicsMode(), cfg.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), cfg.isBrokerDeleteInactiveTopicsEnabled());
        }
        return this.checkReplicationAndRetryOnFailure();
    }

    @Override
    public BacklogQuota getBacklogQuota() {
        throw new UnsupportedOperationException("getBacklogQuota method is not supported on non-persistent topic");
    }

    @Override
    public boolean isBacklogQuotaExceeded(String producerName) {
        return false;
    }

    @Override
    public boolean isReplicated() {
        return this.replicators.size() > 1L;
    }

    @Override
    public CompletableFuture<Void> unsubscribe(String subscriptionName) {
        return CompletableFuture.runAsync(() -> {
            NonPersistentSubscription cfr_ignored_0 = (NonPersistentSubscription)this.subscriptions.remove((Object)subscriptionName);
        }, this.brokerService.executor());
    }

    @Override
    public Position getLastPosition() {
        throw new UnsupportedOperationException("getLastPosition is not supported on non-persistent topic");
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageId() {
        throw new UnsupportedOperationException("getLastMessageId is not supported on non-persistent topic");
    }

    @Override
    public CompletableFuture<Void> addSchemaIfIdleOrCheckCompatible(SchemaData schema) {
        return this.hasSchema().thenCompose(hasSchema -> {
            if (hasSchema.booleanValue() || this.isActive() || ENTRIES_ADDED_COUNTER_UPDATER.get(this) != 0L) {
                return this.checkSchemaCompatibleForConsumer(schema);
            }
            return this.addSchema(schema).thenCompose(schemaVersion -> CompletableFuture.completedFuture(null));
        });
    }

    @Override
    public CompletableFuture<TransactionBuffer> getTransactionBuffer(boolean createIfMissing) {
        return FutureUtil.failedFuture((Throwable)new Exception("Unsupported operation getTransactionBuffer in non-persistent topic."));
    }

    @Override
    public void publishTxnMessage(TxnID txnID, ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        throw new UnsupportedOperationException("PublishTxnMessage is not supported by non-persistent topic");
    }

    @Override
    public CompletableFuture<Void> endTxn(TxnID txnID, int txnAction, List<PulsarApi.MessageIdData> sendMessageIdList) {
        return FutureUtil.failedFuture((Throwable)new Exception("Unsupported operation endTxn in non-persistent topic."));
    }

    private static class TopicStats {
        public double averageMsgSize;
        public double aggMsgRateIn;
        public double aggMsgThroughputIn;
        public double aggMsgRateOut;
        public double aggMsgThroughputOut;
        public final ObjectObjectHashMap<String, PublisherStats> remotePublishersStats = new ObjectObjectHashMap();

        public TopicStats() {
            this.reset();
        }

        public void reset() {
            this.averageMsgSize = 0.0;
            this.aggMsgRateIn = 0.0;
            this.aggMsgThroughputIn = 0.0;
            this.aggMsgRateOut = 0.0;
            this.aggMsgThroughputOut = 0.0;
            this.remotePublishersStats.clear();
        }
    }
}

