/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.pulsar.policies.data.loadbalancer.ServiceLookupData;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class NoopLoadManager
implements LoadManager {
    private PulsarService pulsar;
    private String lookupServiceAddress;
    private ResourceUnit localResourceUnit;
    private ZooKeeper zkClient;
    LocalBrokerData localData;
    private static final ZooKeeperCache.Deserializer<LocalBrokerData> loadReportDeserializer = (key, content) -> (LocalBrokerData)ObjectMapperFactory.getThreadLocal().readValue(content, LocalBrokerData.class);

    @Override
    public void initialize(PulsarService pulsar) {
        this.pulsar = pulsar;
    }

    @Override
    public void start() throws PulsarServerException {
        this.lookupServiceAddress = this.pulsar.getAdvertisedAddress() + ":" + this.pulsar.getConfiguration().getWebServicePort().get();
        this.localResourceUnit = new SimpleResourceUnit(String.format("http://%s", this.lookupServiceAddress), new PulsarResourceDescription());
        this.zkClient = this.pulsar.getZkClient();
        this.localData = new LocalBrokerData(this.pulsar.getSafeWebServiceAddress(), this.pulsar.getWebServiceAddressTls(), this.pulsar.getSafeBrokerServiceUrl(), this.pulsar.getBrokerServiceUrlTls());
        this.localData.setProtocols(this.pulsar.getProtocolDataToAdvertise());
        String brokerZnodePath = "/loadbalance/brokers/" + this.lookupServiceAddress;
        try {
            try {
                if (this.zkClient.exists(brokerZnodePath, null) != null) {
                    this.zkClient.delete(brokerZnodePath, -1);
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.zkClient, (String)brokerZnodePath, (byte[])this.localData.getJsonBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public boolean isCentralized() {
        return false;
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId su) throws Exception {
        return Optional.of(this.localResourceUnit);
    }

    @Override
    public LoadManagerReport generateLoadReport() throws Exception {
        return null;
    }

    @Override
    public ZooKeeperCache.Deserializer<? extends ServiceLookupData> getLoadReportDeserializer() {
        return loadReportDeserializer;
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
    }

    @Override
    public void writeLoadReportOnZookeeper() throws Exception {
    }

    @Override
    public void writeResourceQuotasToZooKeeper() throws Exception {
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        return Collections.emptyList();
    }

    @Override
    public void doLoadShedding() {
    }

    @Override
    public void doNamespaceBundleSplit() throws Exception {
    }

    @Override
    public void disableBroker() throws Exception {
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return Collections.singleton(this.lookupServiceAddress);
    }

    @Override
    public void stop() throws PulsarServerException {
    }
}

