/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerCacheMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.common.stats.JvmMetrics;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.functions.worker.FunctionsStatsGenerator;
import org.apache.pulsar.functions.worker.WorkerService;

public class PrometheusMetricsGenerator {
    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, OutputStream out) throws IOException {
        PrometheusMetricsGenerator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, OutputStream out, List<PrometheusRawMetricsProvider> metricsProviders) throws IOException {
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGenerator.generateSystemMetrics(stream, pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(pulsar, includeTopicMetrics, includeConsumerMetrics, stream);
            FunctionsStatsGenerator.generate((WorkerService)pulsar.getWorkerService(), (String)pulsar.getConfiguration().getClusterName(), (SimpleTextOutputStream)stream);
            PrometheusMetricsGenerator.generateBrokerBasicMetrics(pulsar, stream);
            PrometheusMetricsGenerator.generateManagedLedgerBookieClientMetrics(pulsar, stream);
            if (metricsProviders != null) {
                for (PrometheusRawMetricsProvider metricsProvider : metricsProviders) {
                    metricsProvider.generate(stream);
                }
            }
            out.write(buf.array(), buf.arrayOffset(), buf.readableBytes());
        }
        finally {
            buf.release();
        }
    }

    private static void generateBrokerBasicMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        String clusterName = pulsar.getConfiguration().getClusterName();
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerCacheMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        if (pulsar.getConfiguration().isExposeManagedCursorMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedCursorMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(pulsar.getLoadManager().get().getLoadBalancingMetrics(), clusterName, Collector.Type.GAUGE, stream);
    }

    private static void parseMetricsToPrometheusMetrics(Collection<Metrics> metrics, String cluster, Collector.Type metricType, SimpleTextOutputStream stream) {
        HashSet<String> names = new HashSet<String>();
        for (Metrics metrics1 : metrics) {
            for (Map.Entry entry : metrics1.getMetrics().entrySet()) {
                String value;
                block8: {
                    value = null;
                    if (((String)entry.getKey()).contains(".")) {
                        try {
                            String key = (String)entry.getKey();
                            int dotIndex = key.indexOf(".");
                            int nameIndex = key.substring(0, dotIndex).lastIndexOf("_");
                            if (nameIndex == -1) continue;
                            String name = key.substring(0, nameIndex);
                            value = key.substring(nameIndex + 1);
                            if (!names.contains(name)) {
                                stream.write("# TYPE ").write(name.replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGenerator.getTypeStr(metricType)).write("\n");
                                names.add(name);
                            }
                            stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                            break block8;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    String name = (String)entry.getKey();
                    if (!names.contains(name)) {
                        stream.write("# TYPE ").write(((String)entry.getKey()).replace("brk_", "pulsar_")).write(' ').write(PrometheusMetricsGenerator.getTypeStr(metricType)).write('\n');
                        names.add(name);
                    }
                    stream.write(name.replace("brk_", "pulsar_")).write("{cluster=\"").write(cluster).write('\"');
                }
                for (Map.Entry metric : metrics1.getDimensions().entrySet()) {
                    if (((String)metric.getKey()).isEmpty() || "cluster".equals(metric.getKey())) continue;
                    stream.write(", ").write((String)metric.getKey()).write("=\"").write((String)metric.getValue()).write('\"');
                    if (value == null || value.isEmpty()) continue;
                    stream.write(", ").write("quantile=\"").write(value).write('\"');
                }
                stream.write("} ").write(String.valueOf(entry.getValue())).write(' ').write(System.currentTimeMillis()).write("\n");
            }
        }
    }

    private static void generateManagedLedgerBookieClientMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        StatsProvider statsProvider = pulsar.getManagedLedgerClientFactory().getStatsProvider();
        if (statsProvider instanceof NullStatsProvider) {
            return;
        }
        try {
            StringWriter writer = new StringWriter();
            statsProvider.writeAllMetrics((Writer)writer);
            stream.write(((Object)writer).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void generateSystemMetrics(SimpleTextOutputStream stream, String cluster) {
        Enumeration metricFamilySamples = CollectorRegistry.defaultRegistry.metricFamilySamples();
        while (metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamily = (Collector.MetricFamilySamples)metricFamilySamples.nextElement();
            stream.write("# TYPE ").write(metricFamily.name).write(' ').write(PrometheusMetricsGenerator.getTypeStr(metricFamily.type)).write('\n');
            for (int i = 0; i < metricFamily.samples.size(); ++i) {
                Collector.MetricFamilySamples.Sample sample = (Collector.MetricFamilySamples.Sample)metricFamily.samples.get(i);
                stream.write(sample.name);
                stream.write("{cluster=\"").write(cluster).write('\"');
                for (int j = 0; j < sample.labelNames.size(); ++j) {
                    String labelValue = (String)sample.labelValues.get(j);
                    if (labelValue != null) {
                        labelValue = labelValue.replace("\"", "\\\"");
                    }
                    stream.write(",");
                    stream.write((String)sample.labelNames.get(j));
                    stream.write("=\"");
                    stream.write(labelValue);
                    stream.write('\"');
                }
                stream.write("} ");
                stream.write(Collector.doubleToGoString((double)sample.value));
                stream.write('\n');
            }
        }
    }

    static String getTypeStr(Collector.Type type) {
        switch (type) {
            case COUNTER: {
                return "counter";
            }
            case GAUGE: {
                return "gauge";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }

    static {
        DefaultExports.initialize();
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return JvmMetrics.getJvmDirectMemoryUsed();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return PlatformDependent.maxDirectMemory();
            }
        }, new String[0]).register(CollectorRegistry.defaultRegistry);
        ((Gauge.Builder)Gauge.build((String)"pulsar_version_info", (String)"-").labelNames(new String[]{"version", "commit"})).create().setChild((Object)new Gauge.Child(){

            public double get() {
                return 1.0;
            }
        }, new String[]{PulsarVersion.getVersion(), PulsarVersion.getGitSha()}).register(CollectorRegistry.defaultRegistry);
    }
}

