/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Collectors;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.net.BookieId;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.Producer;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.StreamingStats;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.CompactorSubscription;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.MessageDeduplication;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionsController;
import org.apache.pulsar.broker.service.persistent.SubscribeRateLimiter;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.stats.ClusterReplicationMetrics;
import org.apache.pulsar.broker.stats.NamespaceStats;
import org.apache.pulsar.broker.stats.ReplicationMetrics;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.ReplicatorStats;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.compaction.CompactedTopic;
import org.apache.pulsar.compaction.CompactedTopicImpl;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.utils.StatsOutputStream;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopic
extends AbstractTopic
implements Topic,
AsyncCallbacks.AddEntryCallback,
TopicPolicyListener<TopicPolicies> {
    protected final ManagedLedger ledger;
    private final ConcurrentOpenHashMap<String, PersistentSubscription> subscriptions;
    private final ConcurrentOpenHashMap<String, Replicator> replicators;
    protected static final AtomicLongFieldUpdater<PersistentTopic> USAGE_COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(PersistentTopic.class, "usageCount");
    private volatile long usageCount = 0L;
    static final String DEDUPLICATION_CURSOR_NAME = "pulsar.dedup";
    private static final double MESSAGE_EXPIRY_THRESHOLD = 1.5;
    private static final long POLICY_UPDATE_FAILURE_RETRY_TIME_SECONDS = 60L;
    public boolean msgChunkPublished;
    private Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private Optional<SubscribeRateLimiter> subscribeRateLimiter = Optional.empty();
    public volatile long delayedDeliveryTickTimeMillis = 1000L;
    private final long backloggedCursorThresholdEntries;
    public volatile boolean delayedDeliveryEnabled = false;
    public static final int MESSAGE_RATE_BACKOFF_MS = 1000;
    protected final MessageDeduplication messageDeduplication;
    private static final long COMPACTION_NEVER_RUN = -4273917950L;
    private CompletableFuture<Long> currentCompaction = CompletableFuture.completedFuture(-4273917950L);
    private final CompactedTopic compactedTopic;
    private CompletableFuture<MessageIdImpl> currentOffload = CompletableFuture.completedFuture((MessageIdImpl)MessageId.earliest);
    private volatile Optional<ReplicatedSubscriptionsController> replicatedSubscriptionsController = Optional.empty();
    private static final FastThreadLocal<TopicStatsHelper> threadLocalTopicStats = new FastThreadLocal<TopicStatsHelper>(){

        protected TopicStatsHelper initialValue() {
            return new TopicStatsHelper();
        }
    };
    private final AtomicLong pendingWriteOps = new AtomicLong(0L);
    private volatile double lastUpdatedAvgPublishRateInMsg = 0.0;
    private volatile double lastUpdatedAvgPublishRateInByte = 0.0;
    private volatile int maxUnackedMessagesOnSubscription = -1;
    private volatile boolean isClosingOrDeleting = false;
    private ScheduledFuture<?> fencedTopicMonitoringTask = null;
    private static final Logger log = LoggerFactory.getLogger(PersistentTopic.class);

    public PersistentTopic(String topic, ManagedLedger ledger, BrokerService brokerService) throws BrokerServiceException.NamingException {
        super(topic, brokerService);
        this.ledger = ledger;
        this.subscriptions = new ConcurrentOpenHashMap(16, 1);
        this.replicators = new ConcurrentOpenHashMap(16, 1);
        USAGE_COUNT_UPDATER.set(this, 0L);
        this.delayedDeliveryEnabled = brokerService.pulsar().getConfiguration().isDelayedDeliveryEnabled();
        this.delayedDeliveryTickTimeMillis = brokerService.pulsar().getConfiguration().getDelayedDeliveryTickTimeMillis();
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
        this.initializeDispatchRateLimiterIfNeeded(Optional.empty());
        this.registerTopicPolicyListener();
        this.compactedTopic = new CompactedTopicImpl(brokerService.pulsar().getBookKeeperClient());
        for (ManagedCursor cursor : ledger.getCursors()) {
            if (cursor.getName().startsWith(this.replicatorPrefix)) {
                String localCluster = brokerService.pulsar().getConfiguration().getClusterName();
                String remoteCluster = PersistentReplicator.getRemoteCluster(cursor.getName());
                boolean isReplicatorStarted = false;
                try {
                    isReplicatorStarted = this.addReplicationCluster(remoteCluster, cursor, localCluster);
                }
                catch (Exception e) {
                    log.warn("[{}] failed to start replication", (Object)topic, (Object)e);
                }
                if (isReplicatorStarted) continue;
                throw new BrokerServiceException.NamingException(this.getName() + " Failed to start replicator " + remoteCluster);
            }
            if (cursor.getName().equals(DEDUPLICATION_CURSOR_NAME)) continue;
            String subscriptionName = Codec.decode((String)cursor.getName());
            this.subscriptions.put((Object)subscriptionName, (Object)this.createPersistentSubscription(subscriptionName, cursor, PersistentSubscription.isCursorFromReplicatedSubscription(cursor)));
            ((PersistentSubscription)this.subscriptions.get((Object)subscriptionName)).deactivateCursor();
        }
        this.messageDeduplication = new MessageDeduplication(brokerService.pulsar(), this, ledger);
        try {
            Policies policies = (Policies)brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)topic).getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
            this.isEncryptionRequired = policies.encryption_required;
            this.setSchemaCompatibilityStrategy(policies);
            this.isAllowAutoUpdateSchema = policies.is_allow_auto_update_schema;
            this.schemaValidationEnforced = policies.schema_validation_enforced;
            if (policies.inactive_topic_policies != null) {
                this.inactiveTopicPolicies = policies.inactive_topic_policies;
            }
            this.maxUnackedMessagesOnConsumer = this.unackedMessagesExceededOnConsumer(policies);
            this.maxUnackedMessagesOnSubscription = this.unackedMessagesExceededOnSubscription(policies);
        }
        catch (Exception e) {
            log.warn("[{}] Error getting policies {} and isEncryptionRequired will be set to false", (Object)topic, (Object)e.getMessage());
            this.isEncryptionRequired = false;
        }
        this.checkReplicatedSubscriptionControllerState();
    }

    @VisibleForTesting
    PersistentTopic(String topic, BrokerService brokerService, ManagedLedger ledger, MessageDeduplication messageDeduplication) {
        super(topic, brokerService);
        this.ledger = ledger;
        this.messageDeduplication = messageDeduplication;
        this.subscriptions = new ConcurrentOpenHashMap(16, 1);
        this.replicators = new ConcurrentOpenHashMap(16, 1);
        this.compactedTopic = new CompactedTopicImpl(brokerService.pulsar().getBookKeeperClient());
        this.backloggedCursorThresholdEntries = brokerService.pulsar().getConfiguration().getManagedLedgerCursorBackloggedThreshold();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDispatchRateLimiterIfNeeded(Optional<Policies> policies) {
        Optional<DispatchRateLimiter> optional = this.dispatchRateLimiter;
        synchronized (optional) {
            if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateNeeded(this.brokerService, policies, this.topic, DispatchRateLimiter.Type.TOPIC)) {
                this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this, DispatchRateLimiter.Type.TOPIC));
            }
            if (!this.subscribeRateLimiter.isPresent() && SubscribeRateLimiter.isDispatchRateNeeded(this.brokerService, policies, this.topic)) {
                this.subscribeRateLimiter = Optional.of(new SubscribeRateLimiter(this));
            }
            this.subscriptions.forEach((name, subscription) -> {
                Dispatcher dispatcher = subscription.getDispatcher();
                if (dispatcher != null) {
                    dispatcher.initializeDispatchRateLimiterIfNeeded(policies);
                }
            });
            this.replicators.forEach((name, replicator) -> replicator.initializeDispatchRateLimiterIfNeeded(policies));
        }
    }

    private PersistentSubscription createPersistentSubscription(String subscriptionName, ManagedCursor cursor, boolean replicated) {
        Preconditions.checkNotNull((Object)this.compactedTopic);
        if (subscriptionName.equals("__compaction")) {
            return new CompactorSubscription(this, this.compactedTopic, subscriptionName, cursor);
        }
        return new PersistentSubscription(this, subscriptionName, cursor, replicated);
    }

    @Override
    public void publishMessage(ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        if (this.isFenced) {
            publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes())) {
            publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
        switch (status) {
            case NotDup: {
                this.ledger.asyncAddEntry(headersAndPayload, (AsyncCallbacks.AddEntryCallback)this, (Object)publishContext);
                break;
            }
            case Dup: {
                publishContext.completed(null, -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
                break;
            }
            default: {
                publishContext.completed(new MessageDeduplication.MessageDupUnknownException(), -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
            }
        }
    }

    public void asyncReadEntry(PositionImpl position, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        if (this.ledger instanceof ManagedLedgerImpl) {
            ((ManagedLedgerImpl)this.ledger).asyncReadEntry(position, callback, ctx);
        } else {
            callback.readEntryFailed(new ManagedLedgerException("Unexpected managedledger implementation, doesn't support direct read entry operation."), ctx);
        }
    }

    public PositionImpl getPositionAfterN(PositionImpl startPosition, long n) throws ManagedLedgerException {
        if (this.ledger instanceof ManagedLedgerImpl) {
            return ((ManagedLedgerImpl)this.ledger).getPositionAfterN(startPosition, n, ManagedLedgerImpl.PositionBound.startExcluded);
        }
        throw new ManagedLedgerException("Unexpected managedledger implementation, doesn't support getPositionAfterN operation.");
    }

    public PositionImpl getFirstPosition() throws ManagedLedgerException {
        if (this.ledger instanceof ManagedLedgerImpl) {
            return ((ManagedLedgerImpl)this.ledger).getFirstPosition();
        }
        throw new ManagedLedgerException("Unexpected managedledger implementation, doesn't support getFirstPosition operation.");
    }

    public long getNumberOfEntries() {
        return this.ledger.getNumberOfEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementPendingWriteOpsAndCheck() {
        long pending = this.pendingWriteOps.decrementAndGet();
        if (pending == 0L && this.isFenced && !this.isClosingOrDeleting) {
            PersistentTopic persistentTopic = this;
            synchronized (persistentTopic) {
                if (this.isFenced && !this.isClosingOrDeleting) {
                    this.messageDeduplication.resetHighestSequenceIdPushed();
                    log.info("[{}] Un-fencing topic...", (Object)this.topic);
                    this.ledger.readyToCreateNewLedger();
                    this.unfence();
                }
            }
        }
    }

    public void addComplete(Position pos, Object ctx) {
        Topic.PublishContext publishContext = (Topic.PublishContext)ctx;
        PositionImpl position = (PositionImpl)pos;
        this.messageDeduplication.recordMessagePersisted(publishContext, position);
        publishContext.completed(null, position.getLedgerId(), position.getEntryId());
        this.decrementPendingWriteOpsAndCheck();
    }

    public synchronized void addFailed(ManagedLedgerException exception, Object ctx) {
        if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
            this.close();
        } else {
            this.fence();
            ArrayList futures = Lists.newArrayList();
            this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
            FutureUtil.waitForAll((List)futures).handle((aVoid, throwable) -> {
                this.decrementPendingWriteOpsAndCheck();
                return null;
            });
            Topic.PublishContext callback = (Topic.PublishContext)ctx;
            if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
                }
                callback.completed(new BrokerServiceException.TopicClosedException(exception), -1L, -1L);
                return;
            }
            log.warn("[{}] Failed to persist msg in store: {}", (Object)this.topic, (Object)exception.getMessage());
            if (exception instanceof ManagedLedgerException.ManagedLedgerTerminatedException) {
                callback.completed(new BrokerServiceException.TopicTerminatedException(exception), -1L, -1L);
            } else {
                callback.completed(new BrokerServiceException.PersistenceException(exception), -1L, -1L);
            }
        }
    }

    @Override
    public void addProducer(Producer producer) throws BrokerServiceException {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        this.lock.readLock().lock();
        try {
            this.brokerService.checkTopicNsOwnership(this.getName());
            this.checkTopicFenced();
            if (this.ledger.isTerminated()) {
                log.warn("[{}] Attempting to add producer to a terminated topic", (Object)this.topic);
                throw new BrokerServiceException.TopicTerminatedException("Topic was already terminated");
            }
            this.internalAddProducer(producer);
            USAGE_COUNT_UPDATER.incrementAndGet(this);
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Added producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
            }
            this.messageDeduplication.producerAdded(producer.getProducerName());
            this.startReplProducers();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean hasRemoteProducers() {
        AtomicBoolean foundRemote = new AtomicBoolean(false);
        this.producers.values().forEach(producer -> {
            if (producer.isRemote()) {
                foundRemote.set(true);
            }
        });
        return foundRemote.get();
    }

    public void startReplProducers() {
        try {
            Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", TopicName.get((String)this.topic).getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
            if (policies.replication_clusters != null) {
                TreeSet configuredClusters = Sets.newTreeSet((Iterable)policies.replication_clusters);
                this.replicators.forEach((region, replicator) -> {
                    if (configuredClusters.contains(region)) {
                        replicator.startProducer();
                    }
                });
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error getting policies while starting repl-producers {}", (Object)this.topic, (Object)e.getMessage());
            }
            this.replicators.forEach((region, replicator) -> replicator.startProducer());
        }
    }

    public CompletableFuture<Void> stopReplProducers() {
        ArrayList closeFutures = Lists.newArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect()));
        return FutureUtil.waitForAll((List)closeFutures);
    }

    private synchronized CompletableFuture<Void> closeReplProducersIfNoBacklog() {
        ArrayList closeFutures = Lists.newArrayList();
        this.replicators.forEach((region, replicator) -> closeFutures.add(replicator.disconnect(true)));
        return FutureUtil.waitForAll((List)closeFutures);
    }

    @Override
    public void removeProducer(Producer producer) {
        Preconditions.checkArgument((producer.getTopic() == this ? 1 : 0) != 0);
        if (this.producers.remove(producer.getProducerName(), producer)) {
            this.handleProducerRemoved(producer);
        }
    }

    @Override
    protected void handleProducerRemoved(Producer producer) {
        USAGE_COUNT_UPDATER.decrementAndGet(this);
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] Removed producer -- count: {}", new Object[]{this.topic, producer.getProducerName(), USAGE_COUNT_UPDATER.get(this)});
        }
        this.lastActive = System.nanoTime();
        this.messageDeduplication.producerRemoved(producer.getProducerName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Consumer> subscribe(TransportCnx cnx, String subscriptionName, long consumerId, PulsarApi.CommandSubscribe.SubType subType, int priorityLevel, String consumerName, boolean isDurable, MessageId startMessageId, Map<String, String> metadata, boolean readCompacted, PulsarApi.CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, boolean replicatedSubscriptionState, PulsarApi.KeySharedMeta keySharedMeta) {
        Object consumer;
        CompletableFuture<Consumer> future = new CompletableFuture<Consumer>();
        try {
            this.brokerService.checkTopicNsOwnership(this.getName());
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            return future;
        }
        if (readCompacted && subType != PulsarApi.CommandSubscribe.SubType.Failover && subType != PulsarApi.CommandSubscribe.SubType.Exclusive) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("readCompacted only allowed on failover or exclusive subscriptions"));
            return future;
        }
        if (replicatedSubscriptionState && !this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions()) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("Replicated Subscriptions is disabled by broker."));
            return future;
        }
        if (subType == PulsarApi.CommandSubscribe.SubType.Key_Shared && !this.brokerService.pulsar().getConfiguration().isSubscriptionKeySharedEnable()) {
            future.completeExceptionally(new BrokerServiceException.NotAllowedException("Key_Shared subscription is disabled by broker."));
            return future;
        }
        if (StringUtils.isBlank((CharSequence)subscriptionName)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Empty subscription name", (Object)this.topic);
            }
            future.completeExceptionally(new BrokerServiceException.NamingException("Empty subscription name"));
            return future;
        }
        if (this.hasBatchMessagePublished && !cnx.isBatchMessageCompatibleVersion()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Consumer doesn't support batch-message {}", (Object)this.topic, (Object)subscriptionName);
            }
            future.completeExceptionally(new BrokerServiceException.UnsupportedVersionException("Consumer doesn't support batch-message"));
            return future;
        }
        if (subscriptionName.startsWith(this.replicatorPrefix) || subscriptionName.equals(DEDUPLICATION_CURSOR_NAME)) {
            log.warn("[{}] Failed to create subscription for {}", (Object)this.topic, (Object)subscriptionName);
            future.completeExceptionally(new BrokerServiceException.NamingException("Subscription with reserved subscription name attempted"));
            return future;
        }
        if (cnx.clientAddress() != null && cnx.clientAddress().toString().contains(":")) {
            consumer = new SubscribeRateLimiter.ConsumerIdentifier(cnx.clientAddress().toString().split(":")[0], consumerName, consumerId);
            if (this.subscribeRateLimiter.isPresent() && !this.subscribeRateLimiter.get().subscribeAvailable((SubscribeRateLimiter.ConsumerIdentifier)consumer) || !this.subscribeRateLimiter.get().tryAcquire((SubscribeRateLimiter.ConsumerIdentifier)consumer)) {
                log.warn("[{}] Failed to create subscription for {} {} limited by {}, available {}", new Object[]{this.topic, subscriptionName, consumer, this.subscribeRateLimiter.get().getSubscribeRate(), this.subscribeRateLimiter.get().getAvailableSubscribeRateLimit((SubscribeRateLimiter.ConsumerIdentifier)consumer)});
                future.completeExceptionally(new BrokerServiceException.NotAllowedException("Subscribe limited by subscribe rate limit per consumer."));
                return future;
            }
        }
        this.lock.readLock().lock();
        try {
            if (this.isFenced) {
                log.warn("[{}] Attempting to subscribe to a fenced topic", (Object)this.topic);
                future.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is temporarily unavailable"));
                consumer = future;
                return consumer;
            }
            USAGE_COUNT_UPDATER.incrementAndGet(this);
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Added consumer -- count: {}", new Object[]{this.topic, subscriptionName, consumerName, USAGE_COUNT_UPDATER.get(this)});
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        CompletableFuture<Subscription> subscriptionFuture = isDurable ? this.getDurableSubscription(subscriptionName, initialPosition, startMessageRollbackDurationSec, replicatedSubscriptionState) : this.getNonDurableSubscription(subscriptionName, startMessageId, initialPosition, startMessageRollbackDurationSec);
        int maxUnackedMessages = isDurable ? this.getMaxUnackedMessagesOnConsumer() : 0;
        ((CompletableFuture)subscriptionFuture.thenAccept(subscription -> {
            try {
                Consumer consumer = new Consumer((Subscription)subscription, subType, this.topic, consumerId, priorityLevel, consumerName, maxUnackedMessages, cnx, cnx.getAuthRole(), metadata, readCompacted, initialPosition, keySharedMeta);
                this.addConsumerToSubscription((Subscription)subscription, consumer);
                this.checkBackloggedCursors();
                if (!cnx.isActive()) {
                    consumer.close();
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] [{}] Subscribe failed -- count: {}", new Object[]{this.topic, subscriptionName, consumer.consumerName(), USAGE_COUNT_UPDATER.get(this)});
                    }
                    USAGE_COUNT_UPDATER.decrementAndGet(this);
                    future.completeExceptionally(new BrokerServiceException("Connection was closed while the opening the cursor "));
                } else {
                    this.checkReplicatedSubscriptionControllerState();
                    log.info("[{}][{}] Created new subscription for {}", new Object[]{this.topic, subscriptionName, consumerId});
                    future.complete(consumer);
                }
            }
            catch (BrokerServiceException e) {
                if (e instanceof BrokerServiceException.ConsumerBusyException) {
                    log.warn("[{}][{}] Consumer {} {} already connected", new Object[]{this.topic, subscriptionName, consumerId, consumerName});
                } else if (e instanceof BrokerServiceException.SubscriptionBusyException) {
                    log.warn("[{}][{}] {}", new Object[]{this.topic, subscriptionName, e.getMessage()});
                }
                USAGE_COUNT_UPDATER.decrementAndGet(this);
                future.completeExceptionally(e);
            }
        })).exceptionally(ex -> {
            log.error("[{}] Failed to create subscription: {} error: {}", new Object[]{this.topic, subscriptionName, ex});
            USAGE_COUNT_UPDATER.decrementAndGet(this);
            if (ex.getCause() instanceof BrokerServiceException.NotAllowedException) {
                future.completeExceptionally(ex.getCause());
            } else {
                future.completeExceptionally(new BrokerServiceException.PersistenceException((Throwable)ex));
            }
            return null;
        });
        return future;
    }

    private int unackedMessagesExceededOnSubscription(Policies data) {
        int maxUnackedMessages = data.max_unacked_messages_per_subscription > -1 ? data.max_unacked_messages_per_subscription : this.brokerService.pulsar().getConfiguration().getMaxUnackedMessagesPerSubscription();
        return maxUnackedMessages;
    }

    private int unackedMessagesExceededOnConsumer(Policies data) {
        int maxUnackedMessages = data.max_unacked_messages_per_consumer > -1 ? data.max_unacked_messages_per_consumer : this.brokerService.pulsar().getConfiguration().getMaxUnackedMessagesPerConsumer();
        return maxUnackedMessages;
    }

    private CompletableFuture<Subscription> getDurableSubscription(final String subscriptionName, PulsarApi.CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec, final boolean replicated) {
        final CompletableFuture<Subscription> subscriptionFuture = new CompletableFuture<Subscription>();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        Map<String, Long> properties = PersistentSubscription.getBaseCursorProperties(replicated);
        this.ledger.asyncOpenCursor(Codec.encode((String)subscriptionName), initialPosition, properties, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Opened cursor", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                PersistentSubscription subscription = (PersistentSubscription)PersistentTopic.this.subscriptions.computeIfAbsent((Object)subscriptionName, name -> PersistentTopic.this.createPersistentSubscription(subscriptionName, cursor, replicated));
                if (replicated && !subscription.isReplicated()) {
                    subscription.setReplicated(replicated);
                }
                subscriptionFuture.complete(subscription);
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed to create subscription for {}: {}", new Object[]{PersistentTopic.this.topic, subscriptionName, exception.getMessage()});
                USAGE_COUNT_UPDATER.decrementAndGet(PersistentTopic.this);
                subscriptionFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                if (exception instanceof ManagedLedgerException.ManagedLedgerFencedException) {
                    PersistentTopic.this.close();
                }
            }
        }, null);
        return subscriptionFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<? extends Subscription> getNonDurableSubscription(String subscriptionName, MessageId startMessageId, PulsarApi.CommandSubscribe.InitialPosition initialPosition, long startMessageRollbackDurationSec) {
        log.info("[{}][{}] Creating non-durable subscription at msg id {}", new Object[]{this.topic, subscriptionName, startMessageId});
        CompletableFuture subscriptionFuture = new CompletableFuture();
        if (this.checkMaxSubscriptionsPerTopicExceed(subscriptionName)) {
            subscriptionFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Exceed the maximum number of subscriptions of the topic: " + this.topic));
            return subscriptionFuture;
        }
        ManagedLedger managedLedger = this.ledger;
        synchronized (managedLedger) {
            PersistentSubscription subscription = (PersistentSubscription)this.subscriptions.get((Object)subscriptionName);
            if (subscription == null) {
                MessageIdImpl msgId = startMessageId != null ? (MessageIdImpl)startMessageId : (MessageIdImpl)MessageId.latest;
                long ledgerId = msgId.getLedgerId();
                long entryId = msgId.getEntryId();
                if (ledgerId >= 0L && entryId >= 0L && msgId instanceof BatchMessageIdImpl) {
                    entryId = msgId.getEntryId() - 1L;
                }
                PositionImpl startPosition = new PositionImpl(ledgerId, entryId);
                ManagedCursor cursor = null;
                try {
                    cursor = this.ledger.newNonDurableCursor((Position)startPosition, subscriptionName, initialPosition);
                }
                catch (ManagedLedgerException e) {
                    return FutureUtil.failedFuture((Throwable)e);
                }
                subscription = new PersistentSubscription(this, subscriptionName, cursor, false);
                this.subscriptions.put((Object)subscriptionName, (Object)subscription);
            }
            if (startMessageRollbackDurationSec > 0L) {
                long timestamp = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(startMessageRollbackDurationSec);
                PersistentSubscription finalSubscription = subscription;
                subscription.resetCursor(timestamp).handle((s, ex) -> {
                    if (ex != null) {
                        log.warn("[{}] Failed to reset cursor {} position at timestamp {}", new Object[]{this.topic, subscriptionName, startMessageRollbackDurationSec});
                    }
                    subscriptionFuture.complete(finalSubscription);
                    return null;
                });
                return subscriptionFuture;
            }
            return CompletableFuture.completedFuture(subscription);
        }
    }

    @Override
    public CompletableFuture<Subscription> createSubscription(String subscriptionName, PulsarApi.CommandSubscribe.InitialPosition initialPosition, boolean replicateSubscriptionState) {
        return this.getDurableSubscription(subscriptionName, initialPosition, 0L, replicateSubscriptionState);
    }

    @Override
    public CompletableFuture<Void> unsubscribe(final String subscriptionName) {
        final CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        this.ledger.asyncDeleteCursor(Codec.encode((String)subscriptionName), new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Cursor deleted successfully", (Object)PersistentTopic.this.topic, (Object)subscriptionName);
                }
                PersistentTopic.this.subscriptions.remove((Object)subscriptionName);
                unsubscribeFuture.complete(null);
                PersistentTopic.this.lastActive = System.nanoTime();
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Error deleting cursor for subscription", new Object[]{PersistentTopic.this.topic, subscriptionName, exception});
                }
                unsubscribeFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return unsubscribeFuture;
    }

    void removeSubscription(String subscriptionName) {
        this.subscriptions.remove((Object)subscriptionName);
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.delete(false, false, false);
    }

    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean failIfHasBacklogs, boolean deleteSchema) {
        return this.delete(failIfHasSubscriptions, failIfHasBacklogs, false, deleteSchema);
    }

    @Override
    public CompletableFuture<Void> deleteForcefully() {
        return this.delete(false, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> delete(boolean failIfHasSubscriptions, boolean failIfHasBacklogs, boolean closeIfClientsConnected, boolean deleteSchema) {
        final CompletableFuture<Void> deleteFuture = new CompletableFuture<Void>();
        this.lock.writeLock().lock();
        try {
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                return completableFuture;
            }
            if (failIfHasSubscriptions && !this.subscriptions.isEmpty()) {
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions"));
                return completableFuture;
            }
            if (failIfHasBacklogs && this.hasBacklogs()) {
                CompletableFuture completableFuture = FutureUtil.failedFuture((Throwable)new BrokerServiceException.TopicBusyException("Topic has subscriptions did not catch up"));
                return completableFuture;
            }
            this.fenceTopicToCloseOrDelete();
            CompletableFuture closeClientFuture = new CompletableFuture();
            if (closeIfClientsConnected) {
                ArrayList futures = Lists.newArrayList();
                this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
                this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
                this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
                ((CompletableFuture)FutureUtil.waitForAll((List)futures).thenRun(() -> closeClientFuture.complete(null))).exceptionally(ex -> {
                    log.error("[{}] Error closing clients", (Object)this.topic, ex);
                    this.unfenceTopicToResume();
                    closeClientFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else {
                closeClientFuture.complete(null);
            }
            ((CompletableFuture)closeClientFuture.thenAccept(delete -> {
                if (USAGE_COUNT_UPDATER.get(this) == 0L || closeIfClientsConnected && !failIfHasSubscriptions) {
                    CompletableFuture<SchemaVersion> deleteSchemaFuture = deleteSchema ? this.deleteSchema() : CompletableFuture.completedFuture(null);
                    deleteSchemaFuture.whenComplete((v, ex) -> {
                        if (ex != null) {
                            log.error("[{}] Error deleting topic", (Object)this.topic, ex);
                            this.unfenceTopicToResume();
                            deleteFuture.completeExceptionally((Throwable)ex);
                        } else {
                            this.ledger.asyncDelete(new AsyncCallbacks.DeleteLedgerCallback(){

                                public void deleteLedgerComplete(Object ctx) {
                                    PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic);
                                    PersistentTopic.this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
                                    PersistentTopic.this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
                                    PersistentTopic.this.brokerService.pulsar().getTopicPoliciesService().unregisterListener(TopicName.get((String)PersistentTopic.this.topic), PersistentTopic.this.getPersistentTopic());
                                    log.info("[{}] Topic deleted", (Object)PersistentTopic.this.topic);
                                    deleteFuture.complete(null);
                                }

                                public void deleteLedgerFailed(ManagedLedgerException exception, Object ctx) {
                                    if (exception.getCause() instanceof KeeperException.NoNodeException) {
                                        log.info("[{}] Topic is already deleted {}", (Object)PersistentTopic.this.topic, (Object)exception.getMessage());
                                        this.deleteLedgerComplete(ctx);
                                    } else {
                                        PersistentTopic.this.unfenceTopicToResume();
                                        log.error("[{}] Error deleting topic", (Object)PersistentTopic.this.topic, (Object)exception);
                                        deleteFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                                    }
                                }
                            }, null);
                        }
                    });
                } else {
                    this.unfenceTopicToResume();
                    deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has " + USAGE_COUNT_UPDATER.get(this) + " connected producers/consumers"));
                }
            })).exceptionally(ex -> {
                this.unfenceTopicToResume();
                deleteFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Failed to close clients before deleting topic."));
                return null;
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return deleteFuture;
    }

    public CompletableFuture<Void> close() {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(boolean closeWithoutWaitingClientDisconnect) {
        CompletableFuture<Void> closeFuture;
        block4: {
            closeFuture = new CompletableFuture<Void>();
            this.lock.writeLock().lock();
            try {
                if (!this.isClosingOrDeleting || closeWithoutWaitingClientDisconnect) {
                    this.fenceTopicToCloseOrDelete();
                    break block4;
                }
                log.warn("[{}] Topic is already being closed or deleted", (Object)this.topic);
                closeFuture.completeExceptionally(new BrokerServiceException.TopicFencedException("Topic is already fenced"));
                CompletableFuture<Void> completableFuture = closeFuture;
                return completableFuture;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ArrayList futures = Lists.newArrayList();
        this.replicators.forEach((cluster, replicator) -> futures.add(replicator.disconnect()));
        this.producers.values().forEach(producer -> futures.add(producer.disconnect()));
        this.subscriptions.forEach((s, sub) -> futures.add(sub.disconnect()));
        CompletableFuture clientCloseFuture = closeWithoutWaitingClientDisconnect ? CompletableFuture.completedFuture(null) : FutureUtil.waitForAll((List)futures);
        ((CompletableFuture)clientCloseFuture.thenRun(() -> this.ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeComplete(Object ctx) {
                PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic);
                PersistentTopic.this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
                PersistentTopic.this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
                PersistentTopic.this.subscribeRateLimiter.ifPresent(SubscribeRateLimiter::close);
                PersistentTopic.this.brokerService.pulsar().getTopicPoliciesService().unregisterListener(TopicName.get((String)PersistentTopic.this.topic), PersistentTopic.this.getPersistentTopic());
                log.info("[{}] Topic closed", (Object)PersistentTopic.this.topic);
                closeFuture.complete(null);
            }

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to close managed ledger, proceeding anyway.", (Object)PersistentTopic.this.topic, (Object)exception);
                PersistentTopic.this.brokerService.removeTopicFromCache(PersistentTopic.this.topic);
                closeFuture.complete(null);
            }
        }, null))).exceptionally(exception -> {
            log.error("[{}] Error closing topic", (Object)this.topic, exception);
            this.unfenceTopicToResume();
            closeFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return closeFuture;
    }

    @VisibleForTesting
    CompletableFuture<Void> checkReplicationAndRetryOnFailure() {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.checkReplication().thenAccept(res -> {
            log.info("[{}] Policies updated successfully", (Object)this.topic);
            result.complete(null);
        })).exceptionally(th -> {
            log.error("[{}] Policies update failed {}, scheduled retry in {} seconds", new Object[]{this.topic, th.getMessage(), 60L, th});
            if (!(th.getCause() instanceof BrokerServiceException.TopicFencedException)) {
                this.brokerService.executor().schedule(this::checkReplicationAndRetryOnFailure, 60L, TimeUnit.SECONDS);
            }
            result.completeExceptionally((Throwable)th);
            return null;
        });
        return result;
    }

    public CompletableFuture<Void> checkDeduplicationStatus() {
        return this.messageDeduplication.checkStatus();
    }

    private CompletableFuture<Void> checkPersistencePolicies() {
        TopicName topicName = TopicName.get((String)this.topic);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ((CompletableFuture)this.brokerService.getManagedLedgerConfig(topicName).thenAccept(config -> {
            this.ledger.setConfig(config);
            future.complete(null);
        })).exceptionally(ex -> {
            log.warn("[{}] Failed to update persistence-policies {}", (Object)this.topic, (Object)ex.getMessage());
            future.completeExceptionally((Throwable)ex);
            return null;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> checkReplication() {
        int newMessageTTLinSeconds;
        TopicName name = TopicName.get((String)this.topic);
        if (!name.isGlobal()) {
            return CompletableFuture.completedFuture(null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Checking replication status", (Object)name);
        }
        Policies policies = null;
        try {
            policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
        }
        catch (Exception e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new BrokerServiceException.ServerMetadataException(e));
            return future;
        }
        try {
            newMessageTTLinSeconds = this.getMessageTTL();
        }
        catch (Exception e) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ServerMetadataException(e));
        }
        TreeSet configuredClusters = policies.replication_clusters != null ? Sets.newTreeSet((Iterable)policies.replication_clusters) : Collections.emptySet();
        String localCluster = this.brokerService.pulsar().getConfiguration().getClusterName();
        if (TopicName.get((String)this.topic).isGlobal() && !configuredClusters.contains(localCluster)) {
            log.info("Deleting topic [{}] because local cluster is not part of global namespace repl list {}", (Object)this.topic, (Object)configuredClusters);
            return this.deleteForcefully();
        }
        ArrayList futures = Lists.newArrayList();
        for (String cluster2 : configuredClusters) {
            if (cluster2.equals(localCluster) || this.replicators.containsKey((Object)cluster2)) continue;
            futures.add(this.startReplicator(cluster2));
        }
        this.replicators.forEach((cluster, replicator) -> {
            ((PersistentReplicator)replicator).updateMessageTTL(newMessageTTLinSeconds);
            if (!cluster.equals(localCluster) && !configuredClusters.contains(cluster)) {
                futures.add(this.removeReplicator((String)cluster));
            }
        });
        return FutureUtil.waitForAll((List)futures);
    }

    @Override
    public void checkMessageExpiry() {
        block3: {
            try {
                int message_ttl_in_seconds = this.getMessageTTL();
                if (message_ttl_in_seconds != 0) {
                    this.subscriptions.forEach((subName, sub) -> sub.expireMessages(message_ttl_in_seconds));
                    this.replicators.forEach((region, replicator) -> ((PersistentReplicator)replicator).expireMessages(message_ttl_in_seconds));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @Override
    public void checkMessageDeduplicationInfo() {
        this.messageDeduplication.purgeInactiveProducers();
    }

    public void checkCompaction() {
        TopicName name = TopicName.get((String)this.topic);
        try {
            Long compactionThreshold = Optional.ofNullable(this.getTopicPolicies(name)).map(TopicPolicies::getCompactionThreshold).orElse(null);
            if (compactionThreshold == null) {
                Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
                compactionThreshold = policies.compaction_threshold;
            }
            if (this.isSystemTopic() || compactionThreshold != 0L && this.currentCompaction.isDone()) {
                long backlogEstimate = 0L;
                PersistentSubscription compactionSub = (PersistentSubscription)this.subscriptions.get((Object)"__compaction");
                if (compactionSub != null) {
                    backlogEstimate = compactionSub.estimateBacklogSize();
                } else {
                    long l = backlogEstimate = this.subscriptions.isEmpty() || this.subscriptions.values().stream().noneMatch(sub -> sub.getCursor().isDurable()) ? this.ledger.getTotalSize() : this.ledger.getEstimatedBacklogSize();
                }
                if (backlogEstimate > compactionThreshold) {
                    try {
                        this.triggerCompaction();
                    }
                    catch (BrokerServiceException.AlreadyRunningException are) {
                        log.debug("[{}] Compaction already running, so don't trigger again, even though backlog({}) is over threshold({})", new Object[]{name, backlogEstimate, compactionThreshold});
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("[{}] Error getting policies", (Object)this.topic);
        }
    }

    protected boolean hasCompactionTriggered() {
        return this.subscriptions.containsKey((Object)"__compaction");
    }

    CompletableFuture<Void> startReplicator(final String remoteCluster) {
        log.info("[{}] Starting replicator to remote: {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        this.ledger.asyncOpenCursor(name, new AsyncCallbacks.OpenCursorCallback(){

            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                String localCluster = PersistentTopic.this.brokerService.pulsar().getConfiguration().getClusterName();
                boolean isReplicatorStarted = PersistentTopic.this.addReplicationCluster(remoteCluster, cursor, localCluster);
                if (isReplicatorStarted) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new BrokerServiceException.NamingException(PersistentTopic.this.getName() + " Failed to start replicator " + remoteCluster));
                }
            }

            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null);
        return future;
    }

    protected boolean addReplicationCluster(String remoteCluster, ManagedCursor cursor, String localCluster) {
        AtomicBoolean isReplicatorStarted = new AtomicBoolean(true);
        this.replicators.computeIfAbsent((Object)remoteCluster, r -> {
            try {
                return new PersistentReplicator(this, cursor, localCluster, remoteCluster, this.brokerService);
            }
            catch (BrokerServiceException.NamingException e) {
                isReplicatorStarted.set(false);
                log.error("[{}] Replicator startup failed due to partitioned-topic {}", (Object)this.topic, (Object)remoteCluster);
                return null;
            }
        });
        if (!isReplicatorStarted.get()) {
            this.replicators.remove((Object)remoteCluster);
        }
        return isReplicatorStarted.get();
    }

    CompletableFuture<Void> removeReplicator(final String remoteCluster) {
        log.info("[{}] Removing replicator to {}", (Object)this.topic, (Object)remoteCluster);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        final String name = PersistentReplicator.getReplicatorName(this.replicatorPrefix, remoteCluster);
        ((CompletableFuture)((Replicator)this.replicators.get((Object)remoteCluster)).disconnect().thenRun(() -> this.ledger.asyncDeleteCursor(name, new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
                PersistentTopic.this.replicators.remove((Object)remoteCluster);
                future.complete(null);
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}] Failed to delete cursor {} {}", new Object[]{PersistentTopic.this.topic, name, exception.getMessage(), exception});
                future.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
            }
        }, null))).exceptionally(e -> {
            log.error("[{}] Failed to close replication producer {} {}", new Object[]{this.topic, name, e.getMessage(), e});
            future.completeExceptionally((Throwable)e);
            return null;
        });
        return future;
    }

    public boolean isDeduplicationEnabled() {
        return this.messageDeduplication.isEnabled();
    }

    @Override
    public int getNumberOfConsumers() {
        int count = 0;
        for (PersistentSubscription subscription : this.subscriptions.values()) {
            count += subscription.getConsumers().size();
        }
        return count;
    }

    public ConcurrentOpenHashMap<String, PersistentSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public PersistentSubscription getSubscription(String subscriptionName) {
        return (PersistentSubscription)this.subscriptions.get((Object)subscriptionName);
    }

    public ConcurrentOpenHashMap<String, Replicator> getReplicators() {
        return this.replicators;
    }

    public Replicator getPersistentReplicator(String remoteCluster) {
        return (Replicator)this.replicators.get((Object)remoteCluster);
    }

    public ManagedLedger getManagedLedger() {
        return this.ledger;
    }

    @Override
    public void updateRates(NamespaceStats nsStats, NamespaceBundleStats bundleStats, StatsOutputStream topicStatsStream, ClusterReplicationMetrics replStats, String namespace, boolean hydratePublishers) {
        TopicStatsHelper topicStatsHelper = (TopicStatsHelper)threadLocalTopicStats.get();
        topicStatsHelper.reset();
        this.replicators.forEach((region, replicator) -> replicator.updateRates());
        nsStats.producerCount += this.producers.size();
        bundleStats.producerCount += this.producers.size();
        topicStatsStream.startObject(this.topic);
        topicStatsStream.startList("publishers");
        this.producers.values().forEach(producer -> {
            producer.updateRates();
            PublisherStats publisherStats = producer.getStats();
            topicStatsHelper.aggMsgRateIn += publisherStats.msgRateIn;
            topicStatsHelper.aggMsgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                topicStatsHelper.remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            }
            if (hydratePublishers) {
                StreamingStats.writePublisherStats(topicStatsStream, publisherStats);
            }
        });
        topicStatsStream.endList();
        this.lastUpdatedAvgPublishRateInMsg = topicStatsHelper.aggMsgRateIn > this.lastUpdatedAvgPublishRateInMsg ? topicStatsHelper.aggMsgRateIn : (topicStatsHelper.aggMsgRateIn + this.lastUpdatedAvgPublishRateInMsg) / 2.0;
        this.lastUpdatedAvgPublishRateInByte = topicStatsHelper.aggMsgThroughputIn > this.lastUpdatedAvgPublishRateInByte ? topicStatsHelper.aggMsgThroughputIn : (topicStatsHelper.aggMsgThroughputIn + this.lastUpdatedAvgPublishRateInByte) / 2.0;
        topicStatsStream.startObject("replication");
        nsStats.replicatorCount += topicStatsHelper.remotePublishersStats.size();
        this.replicators.forEach((cluster, replicator) -> {
            try {
                ((PersistentReplicator)replicator).updateCursorState();
            }
            catch (Exception e) {
                log.warn("[{}] Failed to update cursro state ", (Object)this.topic, (Object)e);
            }
            ReplicatorStats rStat = replicator.getStats();
            PublisherStats pubStats = (PublisherStats)topicStatsHelper.remotePublishersStats.get((Object)replicator.getRemoteCluster());
            rStat.msgRateIn = pubStats != null ? pubStats.msgRateIn : 0.0;
            rStat.msgThroughputIn = pubStats != null ? pubStats.msgThroughputIn : 0.0;
            rStat.inboundConnection = pubStats != null ? pubStats.getAddress() : null;
            rStat.inboundConnectedSince = pubStats != null ? pubStats.getConnectedSince() : null;
            topicStatsHelper.aggMsgRateOut += rStat.msgRateOut;
            topicStatsHelper.aggMsgThroughputOut += rStat.msgThroughputOut;
            topicStatsStream.startObject((String)cluster);
            topicStatsStream.writePair("connected", rStat.connected);
            topicStatsStream.writePair("msgRateExpired", rStat.msgRateExpired);
            topicStatsStream.writePair("msgRateIn", rStat.msgRateIn);
            topicStatsStream.writePair("msgRateOut", rStat.msgRateOut);
            topicStatsStream.writePair("msgThroughputIn", rStat.msgThroughputIn);
            topicStatsStream.writePair("msgThroughputOut", rStat.msgThroughputOut);
            topicStatsStream.writePair("replicationBacklog", rStat.replicationBacklog);
            topicStatsStream.writePair("replicationDelayInSeconds", rStat.replicationDelayInSeconds);
            topicStatsStream.writePair("inboundConnection", rStat.inboundConnection);
            topicStatsStream.writePair("inboundConnectedSince", rStat.inboundConnectedSince);
            topicStatsStream.writePair("outboundConnection", rStat.outboundConnection);
            topicStatsStream.writePair("outboundConnectedSince", rStat.outboundConnectedSince);
            topicStatsStream.endObject();
            nsStats.msgReplBacklog += (double)rStat.replicationBacklog;
            if (replStats.isMetricsEnabled()) {
                String namespaceClusterKey = replStats.getKeyName(namespace, (String)cluster);
                ReplicationMetrics replicationMetrics = replStats.get(namespaceClusterKey);
                boolean update = false;
                if (replicationMetrics == null) {
                    replicationMetrics = ReplicationMetrics.get();
                    update = true;
                }
                replicationMetrics.connected = replicationMetrics.connected + (rStat.connected ? 1 : 0);
                replicationMetrics.msgRateOut += rStat.msgRateOut;
                replicationMetrics.msgThroughputOut += rStat.msgThroughputOut;
                replicationMetrics.msgReplBacklog += (double)rStat.replicationBacklog;
                if (update) {
                    replStats.put(namespaceClusterKey, replicationMetrics);
                }
                if ((double)rStat.replicationDelayInSeconds > replicationMetrics.maxMsgReplDelayInSeconds) {
                    replicationMetrics.maxMsgReplDelayInSeconds = rStat.replicationDelayInSeconds;
                }
            }
        });
        topicStatsStream.endObject();
        topicStatsStream.startObject("subscriptions");
        nsStats.subsCount = (int)((long)nsStats.subsCount + this.subscriptions.size());
        this.subscriptions.forEach((subscriptionName, subscription) -> {
            double subMsgRateOut = 0.0;
            double subMsgThroughputOut = 0.0;
            double subMsgRateRedeliver = 0.0;
            try {
                topicStatsStream.startObject((String)subscriptionName);
                topicStatsStream.startList("consumers");
                for (Consumer consumer : subscription.getConsumers()) {
                    ++nsStats.consumerCount;
                    ++bundleStats.consumerCount;
                    consumer.updateRates();
                    ConsumerStats consumerStats = consumer.getStats();
                    subMsgRateOut += consumerStats.msgRateOut;
                    subMsgThroughputOut += consumerStats.msgThroughputOut;
                    subMsgRateRedeliver += consumerStats.msgRateRedeliver;
                    StreamingStats.writeConsumerStats(topicStatsStream, subscription.getType(), consumerStats);
                }
                topicStatsStream.endList();
                topicStatsStream.writePair("msgBacklog", subscription.getNumberOfEntriesInBacklog(true));
                topicStatsStream.writePair("msgRateExpired", subscription.getExpiredMessageRate());
                topicStatsStream.writePair("msgRateOut", subMsgRateOut);
                topicStatsStream.writePair("msgThroughputOut", subMsgThroughputOut);
                topicStatsStream.writePair("msgRateRedeliver", subMsgRateRedeliver);
                topicStatsStream.writePair("numberOfEntriesSinceFirstNotAckedMessage", subscription.getNumberOfEntriesSinceFirstNotAckedMessage());
                topicStatsStream.writePair("totalNonContiguousDeletedMessagesRange", subscription.getTotalNonContiguousDeletedMessagesRange());
                topicStatsStream.writePair("type", subscription.getTypeString());
                if (Subscription.isIndividualAckMode(subscription.getType()) && subscription.getDispatcher() instanceof PersistentDispatcherMultipleConsumers) {
                    PersistentDispatcherMultipleConsumers dispatcher = (PersistentDispatcherMultipleConsumers)subscription.getDispatcher();
                    topicStatsStream.writePair("blockedSubscriptionOnUnackedMsgs", dispatcher.isBlockedDispatcherOnUnackedMsgs());
                    topicStatsStream.writePair("unackedMessages", dispatcher.getTotalUnackedMessages());
                }
                topicStatsStream.endObject();
                topicStatsHelper.aggMsgRateOut += subMsgRateOut;
                topicStatsHelper.aggMsgThroughputOut += subMsgThroughputOut;
                nsStats.msgBacklog += (double)subscription.getNumberOfEntriesInBacklog(false);
            }
            catch (Exception e) {
                log.error("Got exception when creating consumer stats for subscription {}: {}", new Object[]{subscriptionName, e.getMessage(), e});
            }
        });
        topicStatsStream.endObject();
        topicStatsHelper.averageMsgSize = topicStatsHelper.aggMsgRateIn == 0.0 ? 0.0 : topicStatsHelper.aggMsgThroughputIn / topicStatsHelper.aggMsgRateIn;
        topicStatsStream.writePair("producerCount", this.producers.size());
        topicStatsStream.writePair("averageMsgSize", topicStatsHelper.averageMsgSize);
        topicStatsStream.writePair("msgRateIn", topicStatsHelper.aggMsgRateIn);
        topicStatsStream.writePair("msgRateOut", topicStatsHelper.aggMsgRateOut);
        topicStatsStream.writePair("msgInCount", this.getMsgInCounter());
        topicStatsStream.writePair("bytesInCount", this.getBytesInCounter());
        topicStatsStream.writePair("msgOutCount", this.getMsgOutCounter());
        topicStatsStream.writePair("bytesOutCount", this.getBytesOutCounter());
        topicStatsStream.writePair("msgThroughputIn", topicStatsHelper.aggMsgThroughputIn);
        topicStatsStream.writePair("msgThroughputOut", topicStatsHelper.aggMsgThroughputOut);
        topicStatsStream.writePair("storageSize", this.ledger.getTotalSize());
        topicStatsStream.writePair("backlogSize", this.ledger.getEstimatedBacklogSize());
        topicStatsStream.writePair("pendingAddEntriesCount", ((ManagedLedgerImpl)this.ledger).getPendingAddEntriesCount());
        nsStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        nsStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        nsStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        nsStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        nsStats.storageSize += (double)this.ledger.getEstimatedBacklogSize();
        bundleStats.msgRateIn += topicStatsHelper.aggMsgRateIn;
        bundleStats.msgRateOut += topicStatsHelper.aggMsgRateOut;
        bundleStats.msgThroughputIn += topicStatsHelper.aggMsgThroughputIn;
        bundleStats.msgThroughputOut += topicStatsHelper.aggMsgThroughputOut;
        bundleStats.cacheSize += ((ManagedLedgerImpl)this.ledger).getCacheSize();
        topicStatsStream.endObject();
        this.addEntryLatencyStatsUsec.refresh();
        NamespaceStats.add(this.addEntryLatencyStatsUsec.getBuckets(), nsStats.addLatencyBucket);
        this.addEntryLatencyStatsUsec.reset();
    }

    public double getLastUpdatedAvgPublishRateInMsg() {
        return this.lastUpdatedAvgPublishRateInMsg;
    }

    public double getLastUpdatedAvgPublishRateInByte() {
        return this.lastUpdatedAvgPublishRateInByte;
    }

    @Override
    public TopicStats getStats(boolean getPreciseBacklog, boolean subscriptionBacklogSize) {
        TopicStats stats = new TopicStats();
        ObjectObjectHashMap remotePublishersStats = new ObjectObjectHashMap();
        this.producers.values().forEach(producer -> {
            PublisherStats publisherStats = producer.getStats();
            stats.msgRateIn += publisherStats.msgRateIn;
            stats.msgThroughputIn += publisherStats.msgThroughputIn;
            if (producer.isRemote()) {
                remotePublishersStats.put((Object)producer.getRemoteCluster(), (Object)publisherStats);
            } else {
                stats.publishers.add(publisherStats);
            }
        });
        stats.averageMsgSize = stats.msgRateIn == 0.0 ? 0.0 : stats.msgThroughputIn / stats.msgRateIn;
        stats.msgInCounter = this.getMsgInCounter();
        stats.bytesInCounter = this.getBytesInCounter();
        stats.msgChunkPublished = this.msgChunkPublished;
        this.subscriptions.forEach((name, subscription) -> {
            SubscriptionStats subStats = subscription.getStats(getPreciseBacklog, subscriptionBacklogSize);
            stats.msgRateOut += subStats.msgRateOut;
            stats.msgThroughputOut += subStats.msgThroughputOut;
            stats.bytesOutCounter += subStats.bytesOutCounter;
            stats.msgOutCounter += subStats.msgOutCounter;
            stats.subscriptions.put(name, subStats);
            stats.nonContiguousDeletedMessagesRanges += subStats.nonContiguousDeletedMessagesRanges;
            stats.nonContiguousDeletedMessagesRangesSerializedSize += subStats.nonContiguousDeletedMessagesRangesSerializedSize;
        });
        this.replicators.forEach((cluster, replicator) -> {
            ReplicatorStats replicatorStats = replicator.getStats();
            PublisherStats pubStats = (PublisherStats)remotePublishersStats.get((Object)replicator.getRemoteCluster());
            if (pubStats != null) {
                replicatorStats.msgRateIn = pubStats.msgRateIn;
                replicatorStats.msgThroughputIn = pubStats.msgThroughputIn;
                replicatorStats.inboundConnection = pubStats.getAddress();
                replicatorStats.inboundConnectedSince = pubStats.getConnectedSince();
            }
            stats.msgRateOut += replicatorStats.msgRateOut;
            stats.msgThroughputOut += replicatorStats.msgThroughputOut;
            stats.replication.put(replicator.getRemoteCluster(), replicatorStats);
        });
        stats.storageSize = this.ledger.getTotalSize();
        stats.backlogSize = this.ledger.getEstimatedBacklogSize();
        stats.deduplicationStatus = this.messageDeduplication.getStatus().toString();
        stats.offloadedStorageSize = this.ledger.getOffloadedSize();
        return stats;
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStats(boolean includeLedgerMetadata) {
        String schemaId;
        CompletableFuture<PersistentTopicInternalStats> statFuture = new CompletableFuture<PersistentTopicInternalStats>();
        PersistentTopicInternalStats stats = new PersistentTopicInternalStats();
        ManagedLedgerImpl ml = (ManagedLedgerImpl)this.ledger;
        stats.entriesAddedCounter = ml.getEntriesAddedCounter();
        stats.numberOfEntries = ml.getNumberOfEntries();
        stats.totalSize = ml.getTotalSize();
        stats.currentLedgerEntries = ml.getCurrentLedgerEntries();
        stats.currentLedgerSize = ml.getCurrentLedgerSize();
        stats.lastLedgerCreatedTimestamp = DateFormatter.format((long)ml.getLastLedgerCreatedTimestamp());
        if (ml.getLastLedgerCreationFailureTimestamp() != 0L) {
            stats.lastLedgerCreationFailureTimestamp = DateFormatter.format((long)ml.getLastLedgerCreationFailureTimestamp());
        }
        stats.waitingCursorsCount = ml.getWaitingCursorsCount();
        stats.pendingAddEntriesCount = ml.getPendingAddEntriesCount();
        stats.lastConfirmedEntry = ml.getLastConfirmedEntry().toString();
        stats.state = ml.getState();
        stats.ledgers = Lists.newArrayList();
        ArrayList futures = includeLedgerMetadata ? Lists.newArrayList() : null;
        CompletableFuture<Set<String>> availableBookiesFuture = this.brokerService.pulsar().getAvailableBookiesAsync();
        availableBookiesFuture.whenComplete((bookies, e) -> {
            if (e != null) {
                log.error("[{}] Failed to fetch available bookies.", (Object)this.topic, e);
                statFuture.completeExceptionally((Throwable)e);
            } else {
                ml.getLedgersInfo().forEach((id, li) -> {
                    PersistentTopicInternalStats.LedgerInfo info = new PersistentTopicInternalStats.LedgerInfo();
                    info.ledgerId = li.getLedgerId();
                    info.entries = li.getEntries();
                    info.size = li.getSize();
                    info.offloaded = li.hasOffloadContext() && li.getOffloadContext().getComplete();
                    stats.ledgers.add(info);
                    if (futures != null) {
                        futures.add(ml.getLedgerMetadata(li.getLedgerId()).handle((lMetadata, ex) -> {
                            if (ex == null) {
                                info.metadata = lMetadata;
                            }
                            return null;
                        }));
                        futures.add(ml.getEnsemblesAsync(li.getLedgerId()).handle((ensembles, ex) -> {
                            if (ex == null) {
                                info.underReplicated = !bookies.containsAll(ensembles.stream().map(BookieId::toString).collect(Collectors.toList()));
                            }
                            return null;
                        }));
                    }
                });
            }
        });
        PersistentTopicInternalStats.LedgerInfo info = new PersistentTopicInternalStats.LedgerInfo();
        info.ledgerId = -1L;
        info.entries = -1L;
        info.size = -1L;
        try {
            Optional<CompactedTopicImpl.CompactedTopicContext> compactedTopicContext = ((CompactedTopicImpl)this.compactedTopic).getCompactedTopicContext();
            if (compactedTopicContext.isPresent()) {
                CompactedTopicImpl.CompactedTopicContext ledgerContext = compactedTopicContext.get();
                info.ledgerId = ledgerContext.getLedger().getId();
                info.entries = ledgerContext.getLedger().getLastAddConfirmed() + 1L;
                info.size = ledgerContext.getLedger().getLength();
            }
        }
        catch (InterruptedException | ExecutionException e2) {
            log.warn("[{}]Fail to get ledger information for compacted topic.", (Object)this.topic);
        }
        stats.compactedLedger = info;
        stats.cursors = Maps.newTreeMap();
        ml.getCursors().forEach(c -> {
            ManagedCursorImpl cursor = (ManagedCursorImpl)c;
            PersistentTopicInternalStats.CursorStats cs = new PersistentTopicInternalStats.CursorStats();
            cs.markDeletePosition = cursor.getMarkDeletedPosition().toString();
            cs.readPosition = cursor.getReadPosition().toString();
            cs.waitingReadOp = cursor.hasPendingReadRequest();
            cs.pendingReadOps = cursor.getPendingReadOpsCount();
            cs.messagesConsumedCounter = cursor.getMessagesConsumedCounter();
            cs.cursorLedger = cursor.getCursorLedger();
            cs.cursorLedgerLastEntry = cursor.getCursorLedgerLastEntry();
            cs.individuallyDeletedMessages = cursor.getIndividuallyDeletedMessages();
            cs.lastLedgerSwitchTimestamp = DateFormatter.format((long)cursor.getLastLedgerSwitchTimestamp());
            cs.state = cursor.getState();
            cs.numberOfEntriesSinceFirstNotAckedMessage = cursor.getNumberOfEntriesSinceFirstNotAckedMessage();
            cs.totalNonContiguousDeletedMessagesRange = cursor.getTotalNonContiguousDeletedMessagesRange();
            cs.properties = cursor.getProperties();
            stats.cursors.put(cursor.getName(), cs);
        });
        try {
            schemaId = TopicName.get((String)this.topic).getSchemaName();
        }
        catch (Throwable t) {
            statFuture.completeExceptionally(t);
            return statFuture;
        }
        CompletableFuture schemaStoreLedgersFuture = new CompletableFuture();
        stats.schemaLedgers = Collections.synchronizedList(new ArrayList());
        if (this.brokerService.getPulsar().getSchemaStorage() != null && this.brokerService.getPulsar().getSchemaStorage() instanceof BookkeeperSchemaStorage) {
            ((CompletableFuture)((BookkeeperSchemaStorage)this.brokerService.getPulsar().getSchemaStorage()).getStoreLedgerIdsBySchemaId(schemaId).thenAccept(ledgers -> {
                ArrayList getLedgerMetadataFutures = new ArrayList();
                ledgers.forEach(ledgerId -> {
                    CompletableFuture metadataFuture;
                    CompletableFuture<Object> completableFuture;
                    block4: {
                        completableFuture = new CompletableFuture<Object>();
                        getLedgerMetadataFutures.add(completableFuture);
                        metadataFuture = null;
                        try {
                            metadataFuture = this.brokerService.getPulsar().getBookKeeperClient().getLedgerMetadata(ledgerId.longValue());
                        }
                        catch (NullPointerException e2) {
                            if (!log.isDebugEnabled()) break block4;
                            log.debug("{{}} Failed to get ledger metadata for the schema ledger {}", new Object[]{this.topic, ledgerId, e2});
                        }
                    }
                    if (metadataFuture != null) {
                        ((CompletableFuture)metadataFuture.thenAccept(metadata -> {
                            PersistentTopicInternalStats.LedgerInfo schemaLedgerInfo = new PersistentTopicInternalStats.LedgerInfo();
                            schemaLedgerInfo.ledgerId = metadata.getLedgerId();
                            schemaLedgerInfo.entries = metadata.getLastEntryId() + 1L;
                            schemaLedgerInfo.size = metadata.getLength();
                            if (includeLedgerMetadata) {
                                info.metadata = metadata.toSafeString();
                            }
                            stats.schemaLedgers.add(schemaLedgerInfo);
                            completableFuture.complete(null);
                        })).exceptionally(e -> {
                            completableFuture.completeExceptionally((Throwable)e);
                            return null;
                        });
                    } else {
                        completableFuture.complete(null);
                    }
                });
                ((CompletableFuture)FutureUtil.waitForAll(getLedgerMetadataFutures).thenRun(() -> schemaStoreLedgersFuture.complete(null))).exceptionally(e -> {
                    schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                    return null;
                });
            })).exceptionally(e -> {
                schemaStoreLedgersFuture.completeExceptionally((Throwable)e);
                return null;
            });
        } else {
            schemaStoreLedgersFuture.complete(null);
        }
        ((CompletableFuture)schemaStoreLedgersFuture.thenRun(() -> {
            if (futures != null) {
                FutureUtil.waitForAll((List)futures).handle((res, ex) -> {
                    statFuture.complete(stats);
                    return null;
                });
            } else {
                statFuture.complete(stats);
            }
        })).exceptionally(e -> {
            statFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return statFuture;
    }

    public long getBacklogSize() {
        return this.ledger.getEstimatedBacklogSize();
    }

    public boolean isActive(InactiveTopicDeleteMode deleteMode) {
        switch (deleteMode) {
            case delete_when_no_subscriptions: {
                if (this.subscriptions.isEmpty()) break;
                return true;
            }
            case delete_when_subscriptions_caught_up: {
                if (!this.hasBacklogs()) break;
                return true;
            }
        }
        if (TopicName.get((String)this.topic).isGlobal()) {
            return this.hasLocalProducers();
        }
        return USAGE_COUNT_UPDATER.get(this) != 0L;
    }

    private boolean hasBacklogs() {
        return this.subscriptions.values().stream().anyMatch(sub -> sub.getNumberOfEntriesInBacklog(false) > 0L);
    }

    @Override
    public void checkGC() {
        if (!this.isDeleteWhileInactive()) {
            return;
        }
        InactiveTopicDeleteMode deleteMode = this.inactiveTopicPolicies.getInactiveTopicDeleteMode();
        int maxInactiveDurationInSec = this.inactiveTopicPolicies.getMaxInactiveDurationSeconds();
        if (this.isActive(deleteMode)) {
            this.lastActive = System.nanoTime();
        } else {
            if (System.nanoTime() - this.lastActive < TimeUnit.SECONDS.toNanos(maxInactiveDurationInSec)) {
                return;
            }
            if (this.shouldTopicBeRetained()) {
                return;
            }
            CompletableFuture replCloseFuture = new CompletableFuture();
            if (TopicName.get((String)this.topic).isGlobal()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Global topic inactive for {} seconds, closing repl producers.", (Object)this.topic, (Object)maxInactiveDurationInSec);
                }
                ((CompletableFuture)this.closeReplProducersIfNoBacklog().thenRun(() -> {
                    if (this.hasRemoteProducers()) {
                        if (log.isDebugEnabled()) {
                            log.debug("[{}] Global topic has connected remote producers. Not a candidate for GC", (Object)this.topic);
                        }
                        replCloseFuture.completeExceptionally(new BrokerServiceException.TopicBusyException("Topic has connected remote producers"));
                    } else {
                        log.info("[{}] Global topic inactive for {} seconds, closed repl producers", (Object)this.topic, (Object)maxInactiveDurationInSec);
                        replCloseFuture.complete(null);
                    }
                })).exceptionally(e -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Global topic has replication backlog. Not a candidate for GC", (Object)this.topic);
                    }
                    replCloseFuture.completeExceptionally(e.getCause());
                    return null;
                });
            } else {
                replCloseFuture.complete(null);
            }
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)replCloseFuture.thenCompose(v -> this.delete(deleteMode == InactiveTopicDeleteMode.delete_when_no_subscriptions, deleteMode == InactiveTopicDeleteMode.delete_when_subscriptions_caught_up, true))).thenApply(res -> this.tryToDeletePartitionedMetadata())).thenRun(() -> log.info("[{}] Topic deleted successfully due to inactivity", (Object)this.topic))).exceptionally(e -> {
                if (e.getCause() instanceof BrokerServiceException.TopicBusyException) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Did not delete busy topic: {}", (Object)this.topic, (Object)e.getCause().getMessage());
                    }
                } else {
                    log.warn("[{}] Inactive topic deletion failed", (Object)this.topic, e);
                }
                return null;
            });
        }
    }

    private CompletableFuture<Void> tryToDeletePartitionedMetadata() {
        if (TopicName.get((String)this.topic).isPartitioned() && !this.deletePartitionedTopicMetadataWhileInactive()) {
            return CompletableFuture.completedFuture(null);
        }
        TopicName topicName = TopicName.get((String)TopicName.get((String)this.topic).getPartitionedTopicName());
        String path = AdminResource.path("partitioned-topics", topicName.getNamespace(), topicName.getDomain().value(), topicName.getEncodedLocalName());
        try {
            if (topicName.isPartitioned() && !this.getBrokerService().pulsar().getGlobalZkCache().exists(path)) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Void> deleteMetadataFuture = new CompletableFuture<Void>();
            ((CompletableFuture)((CompletableFuture)this.getBrokerService().fetchPartitionedTopicMetadataAsync(TopicName.get((String)topicName.getPartitionedTopicName())).thenAccept(metadata -> {
                String managedPath = String.format("/managed-ledgers/%s/%s", topicName.getNamespace(), topicName.getDomain().value());
                Set cache = null;
                try {
                    cache = this.brokerService.pulsar().getLocalZkCacheService().managedLedgerListCache().get(managedPath);
                }
                catch (Exception e) {
                    deleteMetadataFuture.completeExceptionally(e);
                }
                if (cache == null) {
                    return;
                }
                for (int i = 0; i < metadata.partitions; ++i) {
                    if (!cache.contains(topicName.getPartition(i).getLocalName())) continue;
                    throw new UnsupportedOperationException();
                }
            })).thenAccept(res -> this.getBrokerService().pulsar().getGlobalZkCache().getZooKeeper().delete(path, -1, (rc, s, o) -> {
                if (KeeperException.Code.OK.intValue() == rc || KeeperException.Code.NONODE.intValue() == rc) {
                    this.getBrokerService().pulsar().getGlobalZkCache().invalidate(path);
                    deleteMetadataFuture.complete(null);
                } else {
                    deleteMetadataFuture.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }, null))).exceptionally(e -> {
                if (!(e.getCause() instanceof UnsupportedOperationException)) {
                    log.error("delete metadata fail", e);
                }
                deleteMetadataFuture.complete(null);
                return null;
            });
            return deleteMetadataFuture;
        }
        catch (Exception e2) {
            return FutureUtil.failedFuture((Throwable)e2);
        }
    }

    @Override
    public void checkInactiveSubscriptions() {
        block3: {
            TopicName name = TopicName.get((String)this.topic);
            try {
                Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(() -> new KeeperException.NoNodeException());
                int defaultExpirationTime = this.brokerService.pulsar().getConfiguration().getSubscriptionExpirationTimeMinutes();
                long expirationTimeMillis = TimeUnit.MINUTES.toMillis(policies.subscription_expiration_time_minutes <= 0 && defaultExpirationTime > 0 ? (long)defaultExpirationTime : (long)policies.subscription_expiration_time_minutes);
                if (expirationTimeMillis > 0L) {
                    this.subscriptions.forEach((subName, sub) -> {
                        if (sub.dispatcher != null && sub.dispatcher.isConsumerConnected() || sub.isReplicated()) {
                            return;
                        }
                        if (System.currentTimeMillis() - sub.cursor.getLastActive() > expirationTimeMillis) {
                            sub.delete().thenAccept(v -> log.info("[{}][{}] The subscription was deleted due to expiration", (Object)this.topic, subName));
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
        }
    }

    @Override
    public void checkBackloggedCursors() {
        this.subscriptions.forEach((subName, subscription) -> {
            if (!subscription.getConsumers().isEmpty() && subscription.getCursor().getNumberOfEntries() < this.backloggedCursorThresholdEntries) {
                subscription.getCursor().setActive();
            } else {
                subscription.getCursor().setInactive();
            }
        });
    }

    @Override
    public void checkDeduplicationSnapshot() {
        this.messageDeduplication.takeSnapshot();
    }

    private boolean shouldTopicBeRetained() {
        TopicName name = TopicName.get((String)this.topic);
        RetentionPolicies retentionPolicies = null;
        try {
            retentionPolicies = Optional.ofNullable(this.getTopicPolicies(name)).map(TopicPolicies::getRetentionPolicies).orElse(null);
            if (retentionPolicies == null) {
                retentionPolicies = this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).map(p -> p.retention_policies).orElse(null);
            }
            if (retentionPolicies == null) {
                retentionPolicies = new RetentionPolicies(this.brokerService.pulsar().getConfiguration().getDefaultRetentionTimeInMinutes(), this.brokerService.pulsar().getConfiguration().getDefaultRetentionSizeInMB());
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error getting policies", (Object)this.topic);
            }
            return true;
        }
        long retentionTime = TimeUnit.MINUTES.toNanos(retentionPolicies.getRetentionTimeInMinutes());
        return retentionTime < 0L || System.nanoTime() - this.lastActive < retentionTime;
    }

    @Override
    public CompletableFuture<Void> onPoliciesUpdate(Policies data) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] isEncryptionRequired changes: {} -> {}", new Object[]{this.topic, this.isEncryptionRequired, data.encryption_required});
        }
        if (data.deleted) {
            log.debug("Ignore the update because it has been deleted : {}", (Object)data);
            return CompletableFuture.completedFuture(null);
        }
        this.isEncryptionRequired = data.encryption_required;
        this.setSchemaCompatibilityStrategy(data);
        this.isAllowAutoUpdateSchema = data.is_allow_auto_update_schema;
        this.schemaValidationEnforced = data.schema_validation_enforced;
        this.maxUnackedMessagesOnConsumer = this.unackedMessagesExceededOnConsumer(data);
        this.maxUnackedMessagesOnSubscription = this.unackedMessagesExceededOnSubscription(data);
        this.maxSubscriptionsPerTopic = data.max_subscriptions_per_topic;
        if (data.delayed_delivery_policies != null) {
            this.delayedDeliveryTickTimeMillis = data.delayed_delivery_policies.getTickTime();
            this.delayedDeliveryEnabled = data.delayed_delivery_policies.isActive();
        }
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        if (data.inactive_topic_policies != null) {
            if (topicPolicies == null || !topicPolicies.isInactiveTopicPoliciesSet()) {
                this.inactiveTopicPolicies = data.inactive_topic_policies;
            }
        } else {
            ServiceConfiguration cfg = this.brokerService.getPulsar().getConfiguration();
            this.resetInactiveTopicPolicies(cfg.getBrokerDeleteInactiveTopicsMode(), cfg.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), cfg.isBrokerDeleteInactiveTopicsEnabled());
        }
        this.initializeDispatchRateLimiterIfNeeded(Optional.ofNullable(data));
        this.updateMaxPublishRate(data);
        this.producers.values().forEach(producer -> {
            producer.checkPermissions();
            producer.checkEncryption();
        });
        this.subscriptions.forEach((subName, sub) -> {
            sub.getConsumers().forEach(Consumer::checkPermissions);
            Dispatcher dispatcher = sub.getDispatcher();
            if (!(dispatcher == null || topicPolicies != null && topicPolicies.isSubscriptionDispatchRateSet())) {
                dispatcher.getRateLimiter().ifPresent(rateLimiter -> rateLimiter.onPoliciesUpdate(data));
            }
        });
        this.replicators.forEach((name, replicator) -> replicator.getRateLimiter().ifPresent(rateLimiter -> rateLimiter.onPoliciesUpdate(data)));
        this.checkMessageExpiry();
        CompletableFuture<Void> replicationFuture = this.checkReplicationAndRetryOnFailure();
        CompletableFuture<Void> dedupFuture = this.checkDeduplicationStatus();
        CompletableFuture<Void> persistentPoliciesFuture = this.checkPersistencePolicies();
        if (this.dispatchRateLimiter.isPresent() && (topicPolicies == null || !topicPolicies.isDispatchRateSet())) {
            this.dispatchRateLimiter.get().onPoliciesUpdate(data);
        }
        if (this.subscribeRateLimiter.isPresent()) {
            this.subscribeRateLimiter.get().onPoliciesUpdate(data);
        }
        return CompletableFuture.allOf(replicationFuture, dedupFuture, persistentPoliciesFuture);
    }

    @Override
    public BacklogQuota getBacklogQuota() {
        TopicName topicName = TopicName.get((String)this.getName());
        return this.brokerService.getBacklogQuotaManager().getBacklogQuota(topicName);
    }

    @Override
    public boolean isBacklogQuotaExceeded(String producerName) {
        BacklogQuota backlogQuota = this.getBacklogQuota();
        if (backlogQuota != null) {
            BacklogQuota.RetentionPolicy retentionPolicy = backlogQuota.getPolicy();
            if ((retentionPolicy == BacklogQuota.RetentionPolicy.producer_request_hold || retentionPolicy == BacklogQuota.RetentionPolicy.producer_exception) && this.isBacklogExceeded()) {
                log.info("[{}] Backlog quota exceeded. Cannot create producer [{}]", (Object)this.getName(), (Object)producerName);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isBacklogExceeded() {
        TopicName topicName = TopicName.get((String)this.getName());
        long backlogQuotaLimitInBytes = this.brokerService.getBacklogQuotaManager().getBacklogQuotaLimit(topicName);
        if (backlogQuotaLimitInBytes < 0L) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] - backlog quota limit = [{}]", (Object)this.getName(), (Object)backlogQuotaLimitInBytes);
        }
        long storageSize = this.getBacklogSize();
        if (log.isDebugEnabled()) {
            log.debug("[{}] Storage size = [{}], limit [{}]", new Object[]{this.getName(), storageSize, backlogQuotaLimitInBytes});
        }
        return storageSize >= backlogQuotaLimitInBytes;
    }

    @Override
    public boolean isReplicated() {
        return !this.replicators.isEmpty();
    }

    public CompletableFuture<MessageId> terminate() {
        final CompletableFuture<MessageId> future = new CompletableFuture<MessageId>();
        this.ledger.asyncTerminate(new AsyncCallbacks.TerminateCallback(){

            public void terminateComplete(Position lastCommittedPosition, Object ctx) {
                PersistentTopic.this.producers.values().forEach(Producer::disconnect);
                PersistentTopic.this.subscriptions.forEach((name, sub) -> sub.topicTerminated());
                PositionImpl lastPosition = (PositionImpl)lastCommittedPosition;
                MessageIdImpl messageId = new MessageIdImpl(lastPosition.getLedgerId(), lastPosition.getEntryId(), -1);
                log.info("[{}] Topic terminated at {}", (Object)PersistentTopic.this.getName(), (Object)messageId);
                future.complete(messageId);
            }

            public void terminateFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOldestMessageExpired(ManagedCursor cursor, long messageTTLInSeconds) {
        MessageImpl msg = null;
        Entry entry = null;
        boolean isOldestMessageExpired = false;
        try {
            entry = cursor.getNthEntry(1, ManagedCursor.IndividualDeletedEntries.Include);
            if (entry != null) {
                msg = MessageImpl.deserialize((ByteBuf)entry.getDataBuffer());
                isOldestMessageExpired = messageTTLInSeconds != 0L && System.currentTimeMillis() > msg.getPublishTime() + TimeUnit.SECONDS.toMillis((long)((double)messageTTLInSeconds * 1.5));
            }
        }
        catch (Exception e) {
            log.warn("[{}] Error while getting the oldest message", (Object)this.topic, (Object)e);
        }
        finally {
            if (entry != null) {
                entry.release();
            }
            if (msg != null) {
                msg.recycle();
            }
        }
        return isOldestMessageExpired;
    }

    public CompletableFuture<Void> clearBacklog() {
        log.info("[{}] Clearing backlog on all cursors in the topic.", (Object)this.topic);
        ArrayList futures = Lists.newArrayList();
        List cursors = this.getSubscriptions().keys();
        cursors.addAll(this.getReplicators().keys());
        for (String cursor : cursors) {
            futures.add(this.clearBacklog(cursor));
        }
        return FutureUtil.waitForAll((List)futures);
    }

    public CompletableFuture<Void> clearBacklog(String cursorName) {
        log.info("[{}] Clearing backlog for cursor {} in the topic.", (Object)this.topic, (Object)cursorName);
        PersistentSubscription sub = this.getSubscription(cursorName);
        if (sub != null) {
            return sub.clearBacklog();
        }
        PersistentReplicator repl = (PersistentReplicator)this.getPersistentReplicator(cursorName);
        if (repl != null) {
            return repl.clearBacklog();
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException("Cursor not found"));
    }

    @Override
    public Optional<DispatchRateLimiter> getDispatchRateLimiter() {
        return this.dispatchRateLimiter;
    }

    public Optional<SubscribeRateLimiter> getSubscribeRateLimiter() {
        return this.subscribeRateLimiter;
    }

    public long getLastPublishedSequenceId(String producerName) {
        return this.messageDeduplication.getLastPublishedSequenceId(producerName);
    }

    @Override
    public Position getLastPosition() {
        return this.ledger.getLastConfirmedEntry();
    }

    @Override
    public CompletableFuture<MessageId> getLastMessageId() {
        final CompletableFuture<MessageId> completableFuture = new CompletableFuture<MessageId>();
        final PositionImpl position = (PositionImpl)this.ledger.getLastConfirmedEntry();
        String name = this.getName();
        final int partitionIndex = TopicName.getPartitionIndex((String)name);
        if (log.isDebugEnabled()) {
            log.debug("getLastMessageId {}, partitionIndex{}, position {}", new Object[]{name, partitionIndex, position});
        }
        if (position.getEntryId() == -1L) {
            completableFuture.complete((MessageId)new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
            return completableFuture;
        }
        ManagedLedgerImpl ledgerImpl = (ManagedLedgerImpl)this.ledger;
        if (!ledgerImpl.ledgerExists(position.getLedgerId())) {
            completableFuture.complete(MessageId.earliest);
            return completableFuture;
        }
        ledgerImpl.asyncReadEntry(position, new AsyncCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readEntryComplete(Entry entry, Object ctx) {
                try {
                    PulsarApi.MessageMetadata metadata = Commands.parseMessageMetadata((ByteBuf)entry.getDataBuffer());
                    if (metadata.hasNumMessagesInBatch()) {
                        completableFuture.complete(new BatchMessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex, metadata.getNumMessagesInBatch() - 1));
                    } else {
                        completableFuture.complete(new MessageIdImpl(position.getLedgerId(), position.getEntryId(), partitionIndex));
                    }
                }
                finally {
                    entry.release();
                }
            }

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    public synchronized void triggerCompaction() throws PulsarServerException, BrokerServiceException.AlreadyRunningException {
        if (!this.currentCompaction.isDone()) {
            throw new BrokerServiceException.AlreadyRunningException("Compaction already in progress");
        }
        this.currentCompaction = this.brokerService.pulsar().getCompactor().compact(this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LongRunningProcessStatus compactionStatus() {
        CompletableFuture<Long> current;
        PersistentTopic persistentTopic = this;
        synchronized (persistentTopic) {
            current = this.currentCompaction;
        }
        if (!current.isDone()) {
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (current.join() == -4273917950L) {
                return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return LongRunningProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.SUCCESS);
        }
        catch (CancellationException | CompletionException e) {
            return LongRunningProcessStatus.forError((String)e.getMessage());
        }
    }

    public synchronized void triggerOffload(final MessageIdImpl messageId) throws BrokerServiceException.AlreadyRunningException {
        if (!this.currentOffload.isDone()) {
            throw new BrokerServiceException.AlreadyRunningException("Offload already in progress");
        }
        this.currentOffload = new CompletableFuture();
        final CompletableFuture promise = this.currentOffload;
        log.info("[{}] Starting offload operation at messageId {}", (Object)this.topic, (Object)messageId);
        this.getManagedLedger().asyncOffloadPrefix((Position)PositionImpl.get((long)messageId.getLedgerId(), (long)messageId.getEntryId()), new AsyncCallbacks.OffloadCallback(){

            public void offloadComplete(Position pos, Object ctx) {
                PositionImpl impl = (PositionImpl)pos;
                log.info("[{}] Completed successfully offload operation at messageId {}", (Object)PersistentTopic.this.topic, (Object)messageId);
                promise.complete(new MessageIdImpl(impl.getLedgerId(), impl.getEntryId(), -1));
            }

            public void offloadFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}] Failed offload operation at messageId {}", new Object[]{PersistentTopic.this.topic, messageId, exception});
                promise.completeExceptionally(exception);
            }
        }, null);
    }

    public synchronized OffloadProcessStatus offloadStatus() {
        if (!this.currentOffload.isDone()) {
            return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.RUNNING);
        }
        try {
            if (this.currentOffload.join() == MessageId.earliest) {
                return OffloadProcessStatus.forStatus((LongRunningProcessStatus.Status)LongRunningProcessStatus.Status.NOT_RUN);
            }
            return OffloadProcessStatus.forSuccess((MessageIdImpl)this.currentOffload.join());
        }
        catch (CancellationException | CompletionException e) {
            log.warn("Failed to offload", e.getCause());
            return OffloadProcessStatus.forError((String)e.getMessage());
        }
    }

    private int getMessageTTL() throws Exception {
        TopicName name = TopicName.get((String)this.topic);
        TopicPolicies topicPolicies = this.getTopicPolicies(name);
        Policies policies = (Policies)this.brokerService.pulsar().getConfigurationCache().policiesCache().get(AdminResource.path("policies", name.getNamespace())).orElseThrow(KeeperException.NoNodeException::new);
        if (topicPolicies != null && topicPolicies.isMessageTTLSet()) {
            return topicPolicies.getMessageTTLInSeconds();
        }
        if (policies.message_ttl_in_seconds != null) {
            return policies.message_ttl_in_seconds;
        }
        return this.brokerService.getPulsar().getConfiguration().getTtlDurationDefaultInSeconds();
    }

    @Override
    public CompletableFuture<Void> addSchemaIfIdleOrCheckCompatible(SchemaData schema) {
        return this.hasSchema().thenCompose(hasSchema -> {
            int numActiveConsumers = this.subscriptions.values().stream().mapToInt(subscription -> subscription.getConsumers().size()).sum();
            if (hasSchema.booleanValue() || !this.producers.isEmpty() || numActiveConsumers != 0 || this.ledger.getTotalSize() != 0L) {
                return this.checkSchemaCompatibleForConsumer(schema);
            }
            return this.addSchema(schema).thenCompose(schemaVersion -> CompletableFuture.completedFuture(null));
        });
    }

    private synchronized void checkReplicatedSubscriptionControllerState() {
        AtomicBoolean shouldBeEnabled = new AtomicBoolean(false);
        this.subscriptions.forEach((name, subscription) -> {
            if (subscription.isReplicated()) {
                shouldBeEnabled.set(true);
            }
        });
        if (!shouldBeEnabled.get()) {
            log.info("[{}] There are no replicated subscriptions on the topic", (Object)this.topic);
        }
        this.checkReplicatedSubscriptionControllerState(shouldBeEnabled.get());
    }

    private synchronized void checkReplicatedSubscriptionControllerState(boolean shouldBeEnabled) {
        boolean isCurrentlyEnabled = this.replicatedSubscriptionsController.isPresent();
        boolean isEnableReplicatedSubscriptions = this.brokerService.pulsar().getConfiguration().isEnableReplicatedSubscriptions();
        if (shouldBeEnabled && !isCurrentlyEnabled && isEnableReplicatedSubscriptions) {
            log.info("[{}] Enabling replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController = Optional.of(new ReplicatedSubscriptionsController(this, this.brokerService.pulsar().getConfiguration().getClusterName()));
        } else if (isCurrentlyEnabled && !shouldBeEnabled || !isEnableReplicatedSubscriptions) {
            log.info("[{}] Disabled replicated subscriptions controller", (Object)this.topic);
            this.replicatedSubscriptionsController.ifPresent(ReplicatedSubscriptionsController::close);
            this.replicatedSubscriptionsController = Optional.empty();
        }
    }

    void receivedReplicatedSubscriptionMarker(Position position, int markerType, ByteBuf payload) {
        ReplicatedSubscriptionsController ctrl = this.replicatedSubscriptionsController.orElse(null);
        if (ctrl == null) {
            this.checkReplicatedSubscriptionControllerState(true);
            ctrl = this.replicatedSubscriptionsController.get();
        }
        ctrl.receivedReplicatedSubscriptionMarker(position, markerType, payload);
    }

    Optional<ReplicatedSubscriptionsController> getReplicatedSubscriptionController() {
        return this.replicatedSubscriptionsController;
    }

    public CompactedTopic getCompactedTopic() {
        return this.compactedTopic;
    }

    @Override
    public boolean isSystemTopic() {
        return false;
    }

    private synchronized void fence() {
        int timeout;
        this.isFenced = true;
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if ((monitoringTask == null || monitoringTask.isDone()) && (timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds()) > 0) {
            this.fencedTopicMonitoringTask = this.brokerService.executor().schedule(this::closeFencedTopicForcefully, (long)timeout, TimeUnit.SECONDS);
        }
    }

    private synchronized void unfence() {
        this.isFenced = false;
        ScheduledFuture<?> monitoringTask = this.fencedTopicMonitoringTask;
        if (monitoringTask != null && !monitoringTask.isDone()) {
            monitoringTask.cancel(false);
        }
    }

    private void closeFencedTopicForcefully() {
        if (this.isFenced) {
            int timeout = this.brokerService.pulsar().getConfiguration().getTopicFencingTimeoutSeconds();
            if (this.isClosingOrDeleting) {
                log.warn("[{}] Topic remained fenced for {} seconds and is already closed (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
            } else {
                log.error("[{}] Topic remained fenced for {} seconds, so close it (pendingWriteOps: {})", new Object[]{this.topic, timeout, this.pendingWriteOps.get()});
                this.close();
            }
        }
    }

    private void fenceTopicToCloseOrDelete() {
        this.isClosingOrDeleting = true;
        this.isFenced = true;
    }

    private void unfenceTopicToResume() {
        this.isFenced = false;
        this.isClosingOrDeleting = false;
    }

    @Override
    public CompletableFuture<TransactionBuffer> getTransactionBuffer(boolean createIfMissing) {
        if (this.transactionBuffer == null && createIfMissing) {
            this.transactionBufferLock.lock();
            try {
                if (this.transactionBuffer == null) {
                    this.transactionBuffer = this.brokerService.getPulsar().getTransactionBufferProvider().newTransactionBuffer(this);
                }
            }
            finally {
                this.transactionBufferLock.unlock();
            }
        }
        return this.transactionBuffer;
    }

    @Override
    public void publishTxnMessage(TxnID txnID, ByteBuf headersAndPayload, Topic.PublishContext publishContext) {
        this.pendingWriteOps.incrementAndGet();
        if (this.isFenced) {
            publishContext.completed(new BrokerServiceException.TopicFencedException("fenced"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        if (this.isExceedMaximumMessageSize(headersAndPayload.readableBytes())) {
            publishContext.completed(new BrokerServiceException.NotAllowedException("Exceed maximum message size"), -1L, -1L);
            this.decrementPendingWriteOpsAndCheck();
            return;
        }
        MessageDeduplication.MessageDupStatus status = this.messageDeduplication.isDuplicate(publishContext, headersAndPayload);
        switch (status) {
            case NotDup: {
                ((CompletableFuture)((CompletableFuture)this.getTransactionBuffer(true).thenCompose(txnBuffer -> txnBuffer.appendBufferToTxn(txnID, publishContext.getSequenceId(), headersAndPayload))).thenAccept(position -> {
                    this.decrementPendingWriteOpsAndCheck();
                    publishContext.completed(null, ((PositionImpl)position).getLedgerId(), ((PositionImpl)position).getEntryId());
                })).exceptionally(throwable -> {
                    this.decrementPendingWriteOpsAndCheck();
                    publishContext.completed(new Exception((Throwable)throwable), -1L, -1L);
                    return null;
                });
                break;
            }
            case Dup: {
                publishContext.completed(null, -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
                break;
            }
            default: {
                publishContext.completed(new MessageDeduplication.MessageDupUnknownException(), -1L, -1L);
                this.decrementPendingWriteOpsAndCheck();
            }
        }
    }

    @Override
    public CompletableFuture<Void> endTxn(TxnID txnID, int txnAction, List<PulsarApi.MessageIdData> sendMessageList) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.getTransactionBuffer(false).thenAccept(tb -> {
            CompletableFuture<Object> future = new CompletableFuture();
            if (0 == txnAction) {
                future = tb.commitTxn(txnID, sendMessageList);
            } else if (1 == txnAction) {
                future = tb.abortTxn(txnID, sendMessageList);
            } else {
                future.completeExceptionally(new Exception("Unsupported txnAction " + txnAction));
            }
            future.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return;
                }
                completableFuture.complete(null);
            });
        })).exceptionally(tbThrowable -> {
            completableFuture.completeExceptionally((Throwable)tbThrowable);
            return null;
        });
        return completableFuture;
    }

    public long getDelayedDeliveryTickTimeMillis() {
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        if (topicPolicies != null && topicPolicies.isDelayedDeliveryTickTimeMillisSet()) {
            return topicPolicies.getDelayedDeliveryTickTimeMillis();
        }
        return this.delayedDeliveryTickTimeMillis;
    }

    public int getMaxUnackedMessagesOnConsumer() {
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        if (topicPolicies != null && topicPolicies.isMaxUnackedMessagesOnConsumerSet()) {
            return topicPolicies.getMaxUnackedMessagesOnConsumer();
        }
        return this.maxUnackedMessagesOnConsumer;
    }

    public boolean isDelayedDeliveryEnabled() {
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        if (topicPolicies != null && topicPolicies.isDelayedDeliveryEnabledSet()) {
            return topicPolicies.getDelayedDeliveryEnabled();
        }
        return this.delayedDeliveryEnabled;
    }

    public int getMaxUnackedMessagesOnSubscription() {
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        if (topicPolicies != null && topicPolicies.isMaxUnackedMessagesOnSubscriptionSet()) {
            return topicPolicies.getMaxUnackedMessagesOnSubscription();
        }
        return this.maxUnackedMessagesOnSubscription;
    }

    @Override
    public void onUpdate(TopicPolicies policies) {
        if (log.isDebugEnabled()) {
            log.debug("[{}] update topic policy: {}", (Object)this.topic, (Object)policies);
        }
        if (policies == null) {
            return;
        }
        Optional<Policies> namespacePolicies = this.getNamespacePolicies();
        this.initializeTopicDispatchRateLimiterIfNeeded(policies);
        this.dispatchRateLimiter.ifPresent(limiter -> {
            if (policies.isDispatchRateSet()) {
                this.dispatchRateLimiter.get().updateDispatchRate(policies.getDispatchRate());
            } else {
                this.dispatchRateLimiter.get().updateDispatchRate();
            }
        });
        this.subscriptions.forEach((subName, sub) -> {
            sub.getConsumers().forEach(Consumer::checkPermissions);
            Dispatcher dispatcher = sub.getDispatcher();
            dispatcher.updateRateLimiter(policies.getSubscriptionDispatchRate());
        });
        if (policies.getPublishRate() != null) {
            this.updatePublishDispatcher(policies.getPublishRate());
        } else {
            this.updateMaxPublishRate(namespacePolicies.orElse(null));
        }
        if (policies.isInactiveTopicPoliciesSet()) {
            this.inactiveTopicPolicies = policies.getInactiveTopicPolicies();
        } else if (namespacePolicies.isPresent() && namespacePolicies.get().inactive_topic_policies != null) {
            this.inactiveTopicPolicies = namespacePolicies.get().inactive_topic_policies;
        } else {
            ServiceConfiguration cfg = this.brokerService.getPulsar().getConfiguration();
            this.resetInactiveTopicPolicies(cfg.getBrokerDeleteInactiveTopicsMode(), cfg.getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(), cfg.isBrokerDeleteInactiveTopicsEnabled());
        }
        this.initializeTopicSubscribeRateLimiterIfNeeded(Optional.ofNullable(policies));
        if (this.subscribeRateLimiter.isPresent() && policies != null) {
            this.subscribeRateLimiter.ifPresent(subscribeRateLimiter -> subscribeRateLimiter.onSubscribeRateUpdate(policies.getSubscribeRate()));
        }
    }

    private Optional<Policies> getNamespacePolicies() {
        return DispatchRateLimiter.getPolicies(this.brokerService, this.topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTopicDispatchRateLimiterIfNeeded(TopicPolicies policies) {
        Optional<DispatchRateLimiter> optional = this.dispatchRateLimiter;
        synchronized (optional) {
            if (!this.dispatchRateLimiter.isPresent() && policies.getDispatchRate() != null) {
                this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this, DispatchRateLimiter.Type.TOPIC));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTopicSubscribeRateLimiterIfNeeded(Optional<TopicPolicies> policies) {
        Optional<SubscribeRateLimiter> optional = this.subscribeRateLimiter;
        synchronized (optional) {
            if (!this.subscribeRateLimiter.isPresent() && policies.isPresent() && policies.get().getSubscribeRate() != null) {
                this.subscribeRateLimiter = Optional.of(new SubscribeRateLimiter(this));
            }
        }
    }

    private PersistentTopic getPersistentTopic() {
        return this;
    }

    private void registerTopicPolicyListener() {
        if (this.brokerService.pulsar().getConfig().isSystemTopicEnabled() && this.brokerService.pulsar().getConfig().isTopicLevelPoliciesEnabled()) {
            TopicName topicName;
            TopicName cloneTopicName = topicName = TopicName.get((String)this.topic);
            if (topicName.isPartitioned()) {
                cloneTopicName = TopicName.get((String)topicName.getPartitionedTopicName());
            }
            this.brokerService.getPulsar().getTopicPoliciesService().registerListener(cloneTopicName, this);
        }
    }

    @VisibleForTesting
    public MessageDeduplication getMessageDeduplication() {
        return this.messageDeduplication;
    }

    private boolean checkMaxSubscriptionsPerTopicExceed(String subscriptionName) {
        if (StringUtils.isNotEmpty((CharSequence)subscriptionName) && this.getSubscription(subscriptionName) != null) {
            return false;
        }
        TopicPolicies topicPolicies = this.getTopicPolicies(TopicName.get((String)this.topic));
        Integer maxSubsPerTopic = null;
        if (topicPolicies != null && topicPolicies.isMaxSubscriptionsPerTopicSet()) {
            maxSubsPerTopic = topicPolicies.getMaxSubscriptionsPerTopic();
        }
        if (maxSubsPerTopic == null) {
            maxSubsPerTopic = this.maxSubscriptionsPerTopic;
        }
        if (maxSubsPerTopic == null) {
            maxSubsPerTopic = this.brokerService.pulsar().getConfig().getMaxSubscriptionsPerTopic();
        }
        return maxSubsPerTopic > 0 && this.subscriptions != null && this.subscriptions.size() >= (long)maxSubsPerTopic.intValue();
    }

    private static class TopicStatsHelper {
        public double averageMsgSize;
        public double aggMsgRateIn;
        public double aggMsgThroughputIn;
        public double aggMsgThrottlingFailure;
        public double aggMsgRateOut;
        public double aggMsgThroughputOut;
        public final ObjectObjectHashMap<String, PublisherStats> remotePublishersStats = new ObjectObjectHashMap();

        public TopicStatsHelper() {
            this.reset();
        }

        public void reset() {
            this.averageMsgSize = 0.0;
            this.aggMsgRateIn = 0.0;
            this.aggMsgThroughputIn = 0.0;
            this.aggMsgRateOut = 0.0;
            this.aggMsgThrottlingFailure = 0.0;
            this.aggMsgThroughputOut = 0.0;
            this.remotePublishersStats.clear();
        }
    }
}

